/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.api.TypeDefsEndpoint;
import com.atlan.cache.AbstractMassCache;
import com.atlan.exception.AtlanException;
import com.atlan.exception.AuthenticationException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanTypeCategory;
import com.atlan.model.typedefs.AtlanTagDef;
import com.atlan.model.typedefs.AttributeDef;
import com.atlan.model.typedefs.TypeDefResponse;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlanTagCache
extends AbstractMassCache<AtlanTagDef> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AtlanTagCache.class);
    private Map<String, String> mapIdToSourceTagsAttrId = new ConcurrentHashMap<String, String>();
    private Set<String> deletedIds = ConcurrentHashMap.newKeySet();
    private Set<String> deletedNames = ConcurrentHashMap.newKeySet();
    private final TypeDefsEndpoint typeDefsEndpoint;

    public AtlanTagCache(TypeDefsEndpoint typeDefsEndpoint) {
        this.typeDefsEndpoint = typeDefsEndpoint;
    }

    @Override
    public synchronized void refreshCache() throws AtlanException {
        super.refreshCache();
        log.debug("Refreshing cache of Atlan tags...");
        TypeDefResponse response = this.typeDefsEndpoint.list(List.of(AtlanTypeCategory.ATLAN_TAG, AtlanTypeCategory.STRUCT));
        if (response == null || response.getStructDefs() == null || response.getStructDefs().isEmpty()) {
            throw new AuthenticationException(ErrorCode.EXPIRED_API_TOKEN);
        }
        List<AtlanTagDef> tags = response.getAtlanTagDefs();
        this.mapIdToSourceTagsAttrId = new ConcurrentHashMap<String, String>();
        this.deletedIds = ConcurrentHashMap.newKeySet();
        this.deletedNames = ConcurrentHashMap.newKeySet();
        for (AtlanTagDef clsDef : tags) {
            String typeId = clsDef.getName();
            this.cache(typeId, clsDef.getDisplayName(), clsDef);
            List<AttributeDef> attrs = clsDef.getAttributeDefs();
            String sourceTagsId = "";
            if (attrs != null && !attrs.isEmpty()) {
                for (AttributeDef attr : attrs) {
                    if (!"sourceTagAttachment".equals(attr.getDisplayName())) continue;
                    sourceTagsId = attr.getName();
                }
            }
            this.mapIdToSourceTagsAttrId.put(typeId, sourceTagsId);
        }
    }

    @Override
    public void lookupByName(String name) {
    }

    @Override
    public void lookupById(String id) {
    }

    @Override
    public String getIdForName(String name, boolean allowRefresh) throws AtlanException {
        if (name != null && this.deletedNames.contains(name)) {
            return null;
        }
        try {
            return super.getIdForName(name, allowRefresh);
        }
        catch (NotFoundException e) {
            this.deletedNames.add(name);
            throw e;
        }
    }

    @Override
    public String getNameForId(String id, boolean allowRefresh) throws AtlanException {
        if (id != null && this.deletedIds.contains(id)) {
            return null;
        }
        try {
            return super.getNameForId(id, allowRefresh);
        }
        catch (NotFoundException e) {
            this.deletedIds.add(id);
            throw e;
        }
    }

    public String getSourceTagsAttrId(String id) throws AtlanException {
        return this.getSourceTagsAttrId(id, true);
    }

    public String getSourceTagsAttrId(String id, boolean allowRefresh) throws AtlanException {
        if (id != null && !id.isEmpty()) {
            String attrId = this.mapIdToSourceTagsAttrId.get(id);
            if (attrId == null && !this.deletedIds.contains(id)) {
                if (allowRefresh) {
                    this.refreshCache();
                    attrId = this.mapIdToSourceTagsAttrId.get(id);
                }
                if (attrId == null) {
                    this.deletedIds.add(id);
                    throw new NotFoundException(ErrorCode.ATLAN_TAG_NOT_FOUND_BY_ID, id);
                }
            }
            return attrId;
        }
        throw new InvalidRequestException(ErrorCode.MISSING_ATLAN_TAG_ID);
    }
}

