/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.api.GroupsEndpoint;
import com.atlan.cache.AbstractMassCache;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.admin.AtlanGroup;
import com.atlan.model.admin.GroupResponse;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupCache
extends AbstractMassCache<AtlanGroup> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GroupCache.class);
    private Map<String, String> mapAliasToId = new ConcurrentHashMap<String, String>();
    private final GroupsEndpoint groupsEndpoint;

    public GroupCache(GroupsEndpoint groupsEndpoint) {
        this.groupsEndpoint = groupsEndpoint;
    }

    @Override
    public synchronized void refreshCache() throws AtlanException {
        super.refreshCache();
        log.debug("Refreshing cache of groups...");
        List<AtlanGroup> groups = this.groupsEndpoint.list();
        this.mapAliasToId = new ConcurrentHashMap<String, String>();
        for (AtlanGroup group : groups) {
            String groupId = group.getId();
            String groupName = group.getName();
            this.cache(groupId, groupName, group);
        }
    }

    @Override
    protected void cache(String id, String name, AtlanGroup object) {
        String alias;
        super.cache(id, name, object);
        if (object != null && (alias = object.getAlias()) != null) {
            this.mapAliasToId.put(alias, id);
        }
    }

    public String getIdForAlias(String alias) throws AtlanException {
        return this.getIdForAlias(alias, true);
    }

    public String getIdForAlias(String alias, boolean allowRefresh) throws AtlanException {
        if (alias != null && !alias.isEmpty()) {
            String groupId = this.mapAliasToId.get(alias);
            if (groupId == null && allowRefresh) {
                if (this.bulkRefresh.get()) {
                    this.refreshCache();
                } else {
                    this.lookupByAlias(alias);
                }
                groupId = this.mapAliasToId.get(alias);
            }
            if (groupId == null) {
                throw new NotFoundException(ErrorCode.GROUP_NOT_FOUND_BY_ALIAS, alias);
            }
            return groupId;
        }
        throw new InvalidRequestException(ErrorCode.MISSING_GROUP_ALIAS);
    }

    public String getNameForAlias(String alias) throws AtlanException {
        return this.getNameForAlias(alias, true);
    }

    public String getNameForAlias(String alias, boolean allowRefresh) throws AtlanException {
        String guid = this.getIdForAlias(alias, allowRefresh);
        return this.getNameForId(guid, false);
    }

    @Override
    public void lookupByName(String name) throws AtlanException {
        GroupResponse response = this.groupsEndpoint.list("{\"name\":\"" + name + "\"}");
        this.cacheResponse(response);
    }

    @Override
    public void lookupById(String id) throws AtlanException {
        GroupResponse response = this.groupsEndpoint.list("{\"id\":\"" + id + "\"}");
        this.cacheResponse(response);
    }

    public void lookupByAlias(String alias) throws AtlanException {
        GroupResponse response = this.groupsEndpoint.list("{\"alias\":\"" + alias + "\"}");
        this.cacheResponse(response);
    }

    private void cacheResponse(GroupResponse response) {
        if (response != null && response.getRecords() != null) {
            List<AtlanGroup> groups = response.getRecords();
            for (AtlanGroup group : groups) {
                String groupId = group.getId();
                this.cache(groupId, group.getName(), group);
            }
        }
    }
}

