/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.api.RolesEndpoint;
import com.atlan.cache.AbstractMassCache;
import com.atlan.exception.AtlanException;
import com.atlan.model.admin.AtlanRole;
import com.atlan.model.admin.RoleResponse;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleCache
extends AbstractMassCache<AtlanRole> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RoleCache.class);
    private final RolesEndpoint rolesEndpoint;

    public RoleCache(RolesEndpoint rolesEndpoint) {
        this.rolesEndpoint = rolesEndpoint;
    }

    @Override
    public synchronized void refreshCache() throws AtlanException {
        super.refreshCache();
        log.debug("Refreshing cache of roles...");
        RoleResponse response = this.rolesEndpoint.list("{\"name\":{\"$ilike\":\"$%\"}}");
        this.cacheResponse(response);
    }

    @Override
    public void lookupById(String id) throws AtlanException {
        RoleResponse response = this.rolesEndpoint.list("{\"id\":\"" + id + "\"}");
        this.cacheResponse(response);
    }

    @Override
    public void lookupByName(String name) throws AtlanException {
        RoleResponse response = this.rolesEndpoint.list("{\"name\":\"" + name + "\"}");
        this.cacheResponse(response);
    }

    private void cacheResponse(RoleResponse response) {
        List<Object> roles = response != null ? response.getRecords() : Collections.emptyList();
        for (AtlanRole atlanRole : roles) {
            this.cache(atlanRole.getId(), atlanRole.getName(), atlanRole);
        }
    }
}

