/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.AtlanClient;
import com.atlan.cache.AbstractAssetCache;
import com.atlan.cache.ConnectionCache;
import com.atlan.cache.ObjectName;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Connection;
import com.atlan.model.assets.ITag;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceTagCache
extends AbstractAssetCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SourceTagCache.class);
    private static final List<AtlanField> tagAttributes = List.of(Asset.NAME, ITag.MAPPED_ATLAN_TAG_NAME);
    private final Map<String, Set<String>> atlanTagIdToGuids = new ConcurrentHashMap<String, Set<String>>();

    public SourceTagCache(AtlanClient client) {
        super(client);
    }

    @Override
    protected String cache(Asset asset) {
        ITag tag;
        String tagName;
        String guid = super.cache(asset);
        if (guid != null && asset instanceof ITag && (tagName = (tag = (ITag)((Object)asset)).getMappedAtlanTagName()) != null) {
            try {
                String tagId = this.client.getAtlanTagCache().getIdForName(tagName);
                if (!this.atlanTagIdToGuids.containsKey(tagId)) {
                    this.atlanTagIdToGuids.put(tagId, new HashSet());
                }
                this.atlanTagIdToGuids.get(tagId).add(guid);
            }
            catch (AtlanException e) {
                log.error("Unable to translate tag name to ID: {}", (Object)tagName, (Object)e);
            }
        }
        return guid;
    }

    @Override
    public void lookupByGuid(String guid) throws AtlanException {
        Asset asset;
        Optional<Asset> candidate;
        if (guid != null && !guid.isEmpty() && (candidate = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)this.client.assets.select().where(Asset.SUPER_TYPE_NAMES.eq("Tag"))).where(Asset.GUID.eq(guid))).includesOnResults(tagAttributes)).stream().findFirst()).isPresent() && (asset = candidate.get()) instanceof ITag) {
            ITag tag = (ITag)((Object)asset);
            this.cache((Asset)((Object)tag));
        }
    }

    @Override
    public void lookupByQualifiedName(String sourceTagQN) throws AtlanException {
        Asset asset;
        Optional<Asset> candidate;
        if (sourceTagQN != null && !sourceTagQN.isEmpty() && (candidate = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)this.client.assets.select().where(Asset.SUPER_TYPE_NAMES.eq("Tag"))).where(Asset.QUALIFIED_NAME.eq(sourceTagQN))).includesOnResults(tagAttributes)).stream().findFirst()).isPresent() && (asset = candidate.get()) instanceof ITag) {
            ITag tag = (ITag)((Object)asset);
            this.cache((Asset)((Object)tag));
        }
    }

    @Override
    public void lookupByName(ObjectName name) throws AtlanException {
        if (name instanceof SourceTagName) {
            Asset asset;
            SourceTagName stn = (SourceTagName)name;
            ObjectName connectionName = stn.getConnection();
            String connectionQN = this.client.getConnectionCache().getByName(connectionName).getQualifiedName();
            String sourceTagQN = connectionQN + "/" + stn.getPartialTagName();
            Optional<Asset> candidate = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)this.client.assets.select().where(Asset.SUPER_TYPE_NAMES.eq("Tag"))).where(Asset.QUALIFIED_NAME.eq(sourceTagQN))).includesOnResults(tagAttributes)).stream().findFirst();
            if (candidate.isPresent() && (asset = candidate.get()) instanceof ITag) {
                ITag tag = (ITag)((Object)asset);
                this.cache((Asset)((Object)tag));
            }
        }
    }

    public void lookupByMappedAtlanTag(String internalAtlanTagId) throws AtlanException {
        List<Asset> candidates;
        if (internalAtlanTagId != null && !internalAtlanTagId.isEmpty() && !(candidates = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)this.client.assets.select().where(Asset.SUPER_TYPE_NAMES.eq("Tag"))).where(ITag.MAPPED_ATLAN_TAG_NAME.eq(internalAtlanTagId))).includesOnResults(tagAttributes)).stream().toList()).isEmpty()) {
            for (Asset candidate : candidates) {
                this.cache(candidate);
            }
        }
    }

    public List<ITag> getByMappedAtlanTag(String internalAtlanTagId) throws AtlanException {
        return this.getByMappedAtlanTag(internalAtlanTagId, true);
    }

    public List<ITag> getByMappedAtlanTag(String internalAtlanTagId, boolean allowRefresh) throws AtlanException {
        if (internalAtlanTagId != null && !internalAtlanTagId.isEmpty()) {
            Set<String> found = this.atlanTagIdToGuids.get(internalAtlanTagId);
            if (found == null && allowRefresh) {
                this.lookupByMappedAtlanTag(internalAtlanTagId);
                found = this.atlanTagIdToGuids.get(internalAtlanTagId);
            }
            if (found == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_NAME, "tag", internalAtlanTagId);
            }
            ArrayList<ITag> list = new ArrayList<ITag>();
            for (String guid : found) {
                ITag tag = (ITag)((Object)this.getByGuid(guid, false));
                if (tag == null) continue;
                list.add(tag);
            }
            return list;
        }
        throw new InvalidRequestException(ErrorCode.MISSING_ID);
    }

    @Override
    public ObjectName getName(Asset asset) {
        if (asset instanceof ITag) {
            ITag tag = (ITag)((Object)asset);
            try {
                return new SourceTagName(this.client, tag);
            }
            catch (AtlanException e) {
                log.error("Unable to construct a source tag name for: {}", (Object)asset.getQualifiedName());
                log.debug("Details:", (Throwable)e);
            }
        }
        return null;
    }

    public static final class SourceTagName
    implements ObjectName {
        private static final String CONNECTION_DELIMITER = "@@";
        ObjectName connection;
        String partialTagName;

        public SourceTagName(AtlanClient client, ITag tag) throws AtlanException {
            String sourceTagQN = tag.getQualifiedName();
            String connectionQN = StringUtils.getConnectionQualifiedName(sourceTagQN);
            Connection conn = (Connection)client.getConnectionCache().getByQualifiedName(connectionQN);
            this.connection = new ConnectionCache.ConnectionName(conn);
            this.partialTagName = sourceTagQN.substring(connectionQN.length() + 1);
        }

        public SourceTagName(String identity) {
            String[] tokens;
            if (identity != null && !identity.isEmpty() && (tokens = identity.split(CONNECTION_DELIMITER)).length == 2) {
                this.connection = new ConnectionCache.ConnectionName(tokens[0]);
                this.partialTagName = tokens[1];
            }
        }

        @Override
        public String toString() {
            return this.connection.toString() + CONNECTION_DELIMITER + this.partialTagName;
        }

        @Generated
        public ObjectName getConnection() {
            return this.connection;
        }

        @Generated
        public String getPartialTagName() {
            return this.partialTagName;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SourceTagName)) {
                return false;
            }
            SourceTagName other = (SourceTagName)o;
            ObjectName this$connection = this.getConnection();
            ObjectName other$connection = other.getConnection();
            if (this$connection == null ? other$connection != null : !((Object)this$connection).equals(other$connection)) {
                return false;
            }
            String this$partialTagName = this.getPartialTagName();
            String other$partialTagName = other.getPartialTagName();
            return !(this$partialTagName == null ? other$partialTagName != null : !this$partialTagName.equals(other$partialTagName));
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ObjectName $connection = this.getConnection();
            result = result * 59 + ($connection == null ? 43 : ((Object)$connection).hashCode());
            String $partialTagName = this.getPartialTagName();
            result = result * 59 + ($partialTagName == null ? 43 : $partialTagName.hashCode());
            return result;
        }
    }
}

