/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.api.ApiTokensEndpoint;
import com.atlan.api.UsersEndpoint;
import com.atlan.cache.AbstractMassCache;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.admin.ApiToken;
import com.atlan.model.admin.AtlanUser;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserCache
extends AbstractMassCache<AtlanUser> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserCache.class);
    private Map<String, String> mapEmailToId = new ConcurrentHashMap<String, String>();
    private final UsersEndpoint usersEndpoint;
    private final ApiTokensEndpoint apiTokensEndpoint;

    public UserCache(UsersEndpoint usersEndpoint, ApiTokensEndpoint apiTokensEndpoint) {
        this.usersEndpoint = usersEndpoint;
        this.apiTokensEndpoint = apiTokensEndpoint;
        this.bulkRefresh.set(false);
    }

    @Override
    public synchronized void refreshCache() throws AtlanException {
        super.refreshCache();
        log.debug("Refreshing cache of users...");
        List<AtlanUser> users = this.usersEndpoint.list();
        this.mapEmailToId = new ConcurrentHashMap<String, String>();
        for (AtlanUser user : users) {
            String userId = user.getId();
            String userName = user.getUsername();
            String email = user.getEmail();
            if (userId == null || userName == null || email == null) continue;
            this.cache(userId, userName, user);
        }
    }

    @Override
    protected void cache(String id, String name, AtlanUser object) {
        String email;
        super.cache(id, name, object);
        if (object != null && (email = object.getEmail()) != null) {
            this.mapEmailToId.put(email, id);
        }
    }

    @Override
    public String getIdForName(String username, boolean allowRefresh) throws AtlanException {
        try {
            return super.getIdForName(username, false);
        }
        catch (NotFoundException e) {
            if (username.startsWith("service-account-")) {
                ApiToken token = this.apiTokensEndpoint.getById(username);
                if (token == null) {
                    throw new NotFoundException(ErrorCode.API_TOKEN_NOT_FOUND_BY_NAME, username);
                }
                this.cache(token.getId(), username, (AtlanUser)null);
                return token.getId();
            }
            return super.getIdForName(username, allowRefresh);
        }
    }

    public String getIdForEmail(String email) throws AtlanException {
        return this.getIdForEmail(email, true);
    }

    public String getIdForEmail(String email, boolean allowRefresh) throws AtlanException {
        if (email != null && !email.isEmpty()) {
            String userId = this.mapEmailToId.get(email);
            if (userId == null && allowRefresh) {
                if (this.bulkRefresh.get()) {
                    this.refreshCache();
                } else {
                    this.lookupByEmail(email);
                }
                userId = this.mapEmailToId.get(email);
            }
            if (userId == null) {
                throw new NotFoundException(ErrorCode.USER_NOT_FOUND_BY_EMAIL, email);
            }
            return userId;
        }
        throw new InvalidRequestException(ErrorCode.MISSING_USER_EMAIL);
    }

    @Override
    public String getNameForId(String id, boolean allowRefresh) throws AtlanException {
        try {
            return super.getNameForId(id, false);
        }
        catch (NotFoundException e) {
            ApiToken token = this.apiTokensEndpoint.getByGuid(id);
            if (token != null) {
                String username = token.getApiTokenUsername();
                this.cache(id, username, (AtlanUser)null);
                return username;
            }
            return super.getNameForId(id, allowRefresh);
        }
    }

    @Override
    public void lookupByName(String username) throws AtlanException {
        if (username.startsWith("service-account-")) {
            ApiToken token = this.apiTokensEndpoint.getById(username);
            if (token == null) {
                throw new NotFoundException(ErrorCode.API_TOKEN_NOT_FOUND_BY_NAME, username);
            }
            this.cache(token.getId(), username, (AtlanUser)null);
        } else {
            AtlanUser user = this.usersEndpoint.getByUsername(username);
            if (user != null) {
                this.cache(user.getId(), username, user);
            }
        }
    }

    @Override
    public void lookupById(String id) throws AtlanException {
        block3: {
            try {
                AtlanUser user = this.usersEndpoint.getByGuid(id);
                if (user != null) {
                    this.cache(id, user.getUsername(), user);
                }
            }
            catch (NotFoundException e) {
                ApiToken token = this.apiTokensEndpoint.getByGuid(id);
                if (token == null) break block3;
                this.cache(id, token.getApiTokenUsername(), (AtlanUser)null);
            }
        }
    }

    public void lookupByEmail(String email) throws AtlanException {
        List<AtlanUser> users = this.usersEndpoint.getByEmail(email);
        if (users != null && !users.isEmpty()) {
            for (AtlanUser user : users) {
                this.cache(user.getId(), user.getUsername(), user);
            }
        }
    }
}

