/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.generators;

import com.atlan.generators.AbstractGenerator;
import com.atlan.generators.AssetDocGenerator;
import com.atlan.generators.AssetGenerator;
import com.atlan.generators.EnumGenerator;
import com.atlan.generators.GeneratorConfig;
import com.atlan.generators.StructGenerator;
import com.atlan.model.typedefs.EntityDef;
import com.atlan.model.typedefs.EnumDef;
import com.atlan.model.typedefs.StructDef;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocGenerator
extends AbstractGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocGenerator.class);

    public DocGenerator(GeneratorConfig cfg) {
        super(cfg);
    }

    @Override
    public void generate() throws Exception {
        this.generateAssetDocs();
        this.generateEnumDocs();
        this.generateStructDocs();
        this.generateFullModelDiagram();
    }

    private void generateAssetDocs() throws Exception {
        Template docTemplate = this.ftl.getTemplate("asset_doc.ftl");
        Template propertySnippetTemplate = this.ftl.getTemplate("snippet_properties.ftl");
        Template relationshipSnippetTemplate = this.ftl.getTemplate("snippet_relationships.ftl");
        for (EntityDef entityDef : this.cache.getEntityDefCache().values()) {
            BufferedWriter fs;
            if (!this.cfg.includeTypedef(entityDef)) continue;
            AssetGenerator assetGen = this.cache.getAssetGenerator(entityDef.getName());
            AssetDocGenerator generator = new AssetDocGenerator(assetGen, this.cfg);
            generator.resolveDetails();
            String originalName = generator.getOriginalName().toLowerCase(Locale.ROOT);
            String directory = AssetDocGenerator.DIRECTORY + File.separator + "entities";
            this.createDirectoryIdempotent(directory);
            String filename = directory + File.separator + originalName + ".md";
            try (BufferedWriter fs2 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));){
                docTemplate.process((Object)generator, (Writer)fs2);
            }
            catch (IOException e) {
                log.error("Unable to open file output: {}", (Object)filename, (Object)e);
            }
            String snippets = AssetDocGenerator.DIRECTORY + File.separator + "snippets" + File.separator + "model";
            this.createDirectoryIdempotent(snippets);
            filename = snippets + File.separator + originalName + "-properties.md";
            try {
                fs = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));
                try {
                    propertySnippetTemplate.process((Object)generator, (Writer)fs);
                }
                finally {
                    fs.close();
                }
            }
            catch (IOException e) {
                log.error("Unable to open file output: {}", (Object)filename, (Object)e);
            }
            filename = snippets + File.separator + originalName + "-relationships.md";
            try {
                fs = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));
                try {
                    relationshipSnippetTemplate.process((Object)generator, (Writer)fs);
                }
                finally {
                    fs.close();
                }
            }
            catch (IOException e) {
                log.error("Unable to open file output: {}", (Object)filename, (Object)e);
            }
        }
    }

    private void generateEnumDocs() throws Exception {
        Template docTemplate = this.ftl.getTemplate("enum_doc.ftl");
        for (EnumDef enumDef : this.cache.getEnumDefCache().values()) {
            EnumGenerator enumGen = new EnumGenerator(enumDef, this.cfg);
            String originalName = enumGen.getOriginalName().toLowerCase(Locale.ROOT);
            String directory = AssetDocGenerator.DIRECTORY + File.separator + "enums";
            this.createDirectoryIdempotent(directory);
            String filename = directory + File.separator + originalName + ".md";
            try (BufferedWriter fs = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));){
                docTemplate.process((Object)enumGen, (Writer)fs);
            }
            catch (IOException e) {
                log.error("Unable to open file output: {}", (Object)filename, (Object)e);
            }
        }
    }

    private void generateStructDocs() throws Exception {
        Template docTemplate = this.ftl.getTemplate("struct_doc.ftl");
        Template propertySnippetTemplate = this.ftl.getTemplate("snippet_properties_struct.ftl");
        for (StructDef structDef : this.cache.getStructDefCache().values()) {
            StructGenerator structGen = new StructGenerator(structDef, this.cfg);
            String originalName = structGen.getOriginalName().toLowerCase(Locale.ROOT);
            String directory = AssetDocGenerator.DIRECTORY + File.separator + "structs";
            this.createDirectoryIdempotent(directory);
            String filename = directory + File.separator + originalName + ".md";
            try (BufferedWriter fs = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));){
                docTemplate.process((Object)structGen, (Writer)fs);
            }
            catch (IOException e) {
                log.error("Unable to open file output: {}", (Object)filename, (Object)e);
            }
            String snippets = AssetDocGenerator.DIRECTORY + File.separator + "snippets" + File.separator + "model";
            this.createDirectoryIdempotent(snippets);
            filename = snippets + File.separator + originalName + "-properties.md";
            try (BufferedWriter fs = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));){
                propertySnippetTemplate.process((Object)structGen, (Writer)fs);
            }
            catch (IOException e) {
                log.error("Unable to open file output: {}", (Object)filename, (Object)e);
            }
        }
    }

    private void generateFullModelDiagram() throws Exception {
        Template modelTemplate = this.ftl.getTemplate("full_model.ftl");
        AssetGenerator referenceable = this.cache.getAssetGenerator("Referenceable");
        AssetDocGenerator generator = new AssetDocGenerator(referenceable, this.cfg);
        generator.resolveDetails();
        this.createDirectoryIdempotent(AssetDocGenerator.DIRECTORY);
        String filename = AssetDocGenerator.DIRECTORY + File.separator + "index.md";
        try (BufferedWriter fs = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));){
            modelTemplate.process((Object)generator, (Writer)fs);
        }
        catch (IOException e) {
            log.error("Unable to open file output: {}", (Object)filename, (Object)e);
        }
    }
}

