/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.generators;

import com.atlan.generators.GeneratorConfig;
import com.atlan.generators.TypeGenerator;
import com.atlan.model.typedefs.EnumDef;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumGenerator
extends TypeGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnumGenerator.class);
    public static final String DIRECTORY = "enums";
    private final EnumDef enumDef;
    private List<ValidValue> values;

    public EnumGenerator(EnumDef enumDef, GeneratorConfig cfg) {
        super(enumDef, cfg);
        this.enumDef = enumDef;
        this.resolveClassName();
        this.description = this.cache.getTypeDescription(this.className);
        this.resolveValues();
    }

    @Override
    protected void resolveClassName() {
        this.className = this.cfg.resolveClassName(this.getOriginalName());
    }

    private void resolveValues() {
        this.values = new ArrayList<ValidValue>();
        for (EnumDef.ElementDef elementDef : this.enumDef.getElementDefs()) {
            this.values.add(new ValidValue(elementDef.getValue()));
        }
    }

    @Generated
    public EnumDef getEnumDef() {
        return this.enumDef;
    }

    @Generated
    public List<ValidValue> getValues() {
        return this.values;
    }

    public final class ValidValue {
        private final String actualValue;
        private final String enumeratedValue;

        public ValidValue(String actualValue) {
            this.actualValue = actualValue;
            this.enumeratedValue = this.getEnumName(actualValue);
        }

        private String getEnumName(String text) {
            return EnumGenerator.this.cfg.resolveEnumValue(text);
        }

        @Generated
        public String getActualValue() {
            return this.actualValue;
        }

        @Generated
        public String getEnumeratedValue() {
            return this.enumeratedValue;
        }
    }
}

