/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.generators;

import com.atlan.generators.AbstractGenerator;
import com.atlan.generators.AssetGenerator;
import com.atlan.generators.AssetTestGenerator;
import com.atlan.generators.GeneratorConfig;
import com.atlan.model.typedefs.EntityDef;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestGenerator
extends AbstractGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TestGenerator.class);

    public TestGenerator(GeneratorConfig cfg) {
        super(cfg);
    }

    @Override
    public void generate() throws Exception {
        this.generateAssetTests();
    }

    private void generateAssetTests() throws Exception {
        Template testTemplate = this.ftl.getTemplate("asset_test.ftl");
        for (EntityDef entityDef : this.cache.getEntityDefCache().values()) {
            AssetGenerator assetGen;
            if (!this.cfg.includeTypedef(entityDef) || (assetGen = this.cache.getAssetGenerator(entityDef.getName())).isAbstract()) continue;
            AssetTestGenerator generator = new AssetTestGenerator(assetGen, this.cfg);
            this.createDirectoryIdempotent(this.cfg.getTestPath() + File.separator + "assets");
            String filename = this.cfg.getTestPath() + File.separator + "assets" + File.separator + generator.getClassName() + "Test.java";
            try (BufferedWriter fs = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));){
                generator.resolveDetails();
                testTemplate.process((Object)generator, (Writer)fs);
            }
            catch (IOException e) {
                log.error("Unable to open file output: {}", (Object)filename, (Object)e);
            }
        }
    }
}

