/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.admin;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.admin.AdminEvent;
import com.atlan.model.admin.AdminEventRequest;
import com.atlan.model.core.AtlanObject;
import com.atlan.net.ApiResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;

@JsonSerialize(using=AdminEventResponseSerializer.class)
@JsonDeserialize(using=AdminEventResponseDeserializer.class)
public class AdminEventResponse
extends ApiResource
implements Iterable<AdminEvent> {
    private static final long serialVersionUID = 2L;
    private static final int CHARACTERISTICS = 1296;
    @JsonIgnore
    AtlanClient client;
    @JsonIgnore
    AdminEventRequest request;
    List<AdminEvent> events;

    private AdminEventResponse(List<AdminEvent> events) {
        this.events = events;
    }

    @JsonIgnore
    public AdminEventResponse getNextPage() throws AtlanException {
        int from = this.request.getOffset() < 0 ? 0 : this.request.getOffset();
        int page = this.request.getSize() < 0 ? 100 : this.request.getSize();
        AtlanObject next = ((AdminEventRequest.AdminEventRequestBuilder)this.request.toBuilder().offset(from + page)).build();
        return ((AdminEventRequest)next).search(this.client);
    }

    @Override
    public Iterator<AdminEvent> iterator() {
        return new AdminEventResponseIterator(this);
    }

    public Stream<AdminEvent> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 1296), false);
    }

    @Generated
    public AtlanClient getClient() {
        return this.client;
    }

    @Generated
    public AdminEventRequest getRequest() {
        return this.request;
    }

    @Generated
    public List<AdminEvent> getEvents() {
        return this.events;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdminEventResponse)) {
            return false;
        }
        AdminEventResponse other = (AdminEventResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AtlanClient this$client = this.getClient();
        AtlanClient other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        AdminEventRequest this$request = this.getRequest();
        AdminEventRequest other$request = other.getRequest();
        if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
            return false;
        }
        List<AdminEvent> this$events = this.getEvents();
        List<AdminEvent> other$events = other.getEvents();
        return !(this$events == null ? other$events != null : !((Object)this$events).equals(other$events));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AdminEventResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        AtlanClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        AdminEventRequest $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
        List<AdminEvent> $events = this.getEvents();
        result = result * 59 + ($events == null ? 43 : ((Object)$events).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AdminEventResponse(super=" + super.toString() + ", client=" + this.getClient() + ", request=" + this.getRequest() + ", events=" + this.getEvents() + ")";
    }

    @JsonIgnore
    @Generated
    public void setClient(AtlanClient client) {
        this.client = client;
    }

    @JsonIgnore
    @Generated
    public void setRequest(AdminEventRequest request) {
        this.request = request;
    }

    private static class AdminEventResponseIterator
    implements Iterator<AdminEvent> {
        private AdminEventResponse response;
        private int i;

        public AdminEventResponseIterator(AdminEventResponse response) {
            this.response = response;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.response.getEvents() != null && this.response.getEvents().size() > this.i) {
                return true;
            }
            try {
                this.response = this.response.getNextPage();
                this.i = 0;
                return this.response.getEvents() != null && this.response.getEvents().size() > this.i;
            }
            catch (AtlanException e) {
                throw new RuntimeException("Unable to iterate through all pages of search results.", e);
            }
        }

        @Override
        public AdminEvent next() {
            return this.response.getEvents().get(this.i++);
        }
    }

    public static final class AdminEventResponseSerializer
    extends StdSerializer<AdminEventResponse> {
        private static final long serialVersionUID = 2L;

        public AdminEventResponseSerializer() {
            this(null);
        }

        public AdminEventResponseSerializer(Class<AdminEventResponse> t) {
            super(t);
        }

        public void serialize(AdminEventResponse response, JsonGenerator gen, SerializerProvider sp) throws IOException, JsonProcessingException {
            if (response != null) {
                gen.writeStartArray();
                for (AdminEvent event : response.getEvents()) {
                    gen.writeObject((Object)event);
                }
                gen.writeEndArray();
            }
        }
    }

    public static final class AdminEventResponseDeserializer
    extends StdDeserializer<AdminEventResponse> {
        private static final long serialVersionUID = 2L;

        public AdminEventResponseDeserializer() {
            this(null);
        }

        public AdminEventResponseDeserializer(Class<?> t) {
            super(t);
        }

        public AdminEventResponse deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            List events = (List)parser.getCodec().readValue(parser, (TypeReference)new TypeReference<List<AdminEvent>>(){});
            return new AdminEventResponse(events);
        }
    }
}

