/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.admin;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.admin.UserResponse;
import com.atlan.model.core.AtlanObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import lombok.Generated;

@JsonDeserialize(builder=AtlanGroupBuilderImpl.class)
public class AtlanGroup
extends AtlanObject {
    private static final long serialVersionUID = 2L;
    String alias;
    GroupAttributes attributes;
    @JsonIgnore
    String decentralizedRoles;
    String id;
    String name;
    String path;
    SortedSet<Persona> personas;
    SortedSet<Purpose> purposes;
    SortedSet<String> roles;
    Long userCount;

    @JsonIgnore
    public boolean isDefault() {
        return this.attributes != null && this.attributes.getIsDefault() != null && this.attributes.getIsDefault().contains("true");
    }

    public static AtlanGroupBuilder<?, ?> creator(String alias) {
        return ((AtlanGroupBuilder)AtlanGroup.builder().name(AtlanGroup.generateName(alias))).attributes((GroupAttributes)((GroupAttributes.GroupAttributesBuilder)GroupAttributes.builder().alias(List.of(alias))).build());
    }

    public static AtlanGroupBuilder<?, ?> updater(String id, String path) {
        return ((AtlanGroupBuilder)AtlanGroup.builder().id(id)).path(path);
    }

    public static String generateName(String alias) {
        String internal = alias.toLowerCase(Locale.ROOT);
        return internal.replace(" ", "_");
    }

    public String create() throws AtlanException {
        return this.create(Atlan.getDefaultClient());
    }

    public String create(AtlanClient client) throws AtlanException {
        return client.groups.create(this);
    }

    public void update() throws AtlanException {
        this.update(Atlan.getDefaultClient());
    }

    public void update(AtlanClient client) throws AtlanException {
        if (this.id == null || this.id.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_GROUP_ID);
        }
        client.groups.update(this.id, this);
    }

    public static void delete(String id) throws AtlanException {
        AtlanGroup.delete(Atlan.getDefaultClient(), id);
    }

    public static void delete(AtlanClient client, String id) throws AtlanException {
        client.groups.purge(id);
    }

    public static List<AtlanGroup> list() throws AtlanException {
        return AtlanGroup.list(Atlan.getDefaultClient());
    }

    public static List<AtlanGroup> list(AtlanClient client) throws AtlanException {
        return client.groups.list();
    }

    @JsonIgnore
    public static List<AtlanGroup> get(String alias) throws AtlanException {
        return AtlanGroup.get(Atlan.getDefaultClient(), alias);
    }

    @JsonIgnore
    public static List<AtlanGroup> get(AtlanClient client, String alias) throws AtlanException {
        return client.groups.get(alias);
    }

    public void removeUsers(List<String> userIds) throws AtlanException {
        this.removeUsers(Atlan.getDefaultClient(), userIds);
    }

    public void removeUsers(AtlanClient client, List<String> userIds) throws AtlanException {
        if (this.id == null || this.id.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_GROUP_ID);
        }
        client.groups.removeMembers(this.id, userIds);
    }

    public UserResponse fetchUsers() throws AtlanException {
        return this.fetchUsers(Atlan.getDefaultClient());
    }

    public UserResponse fetchUsers(AtlanClient client) throws AtlanException {
        if (this.id == null || this.id.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_GROUP_ID);
        }
        return client.groups.listMembers(this.id);
    }

    @Generated
    protected AtlanGroup(AtlanGroupBuilder<?, ?> b) {
        super(b);
        this.alias = b.alias;
        this.attributes = b.attributes;
        this.decentralizedRoles = b.decentralizedRoles;
        this.id = b.id;
        this.name = b.name;
        this.path = b.path;
        this.personas = b.personas;
        this.purposes = b.purposes;
        this.roles = b.roles;
        this.userCount = b.userCount;
    }

    @Generated
    public static AtlanGroupBuilder<?, ?> builder() {
        return new AtlanGroupBuilderImpl();
    }

    @Generated
    public AtlanGroupBuilder<?, ?> toBuilder() {
        return new AtlanGroupBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getAlias() {
        return this.alias;
    }

    @Generated
    public GroupAttributes getAttributes() {
        return this.attributes;
    }

    @Generated
    public String getDecentralizedRoles() {
        return this.decentralizedRoles;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public SortedSet<Persona> getPersonas() {
        return this.personas;
    }

    @Generated
    public SortedSet<Purpose> getPurposes() {
        return this.purposes;
    }

    @Generated
    public SortedSet<String> getRoles() {
        return this.roles;
    }

    @Generated
    public Long getUserCount() {
        return this.userCount;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AtlanGroup)) {
            return false;
        }
        AtlanGroup other = (AtlanGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$userCount = this.getUserCount();
        Long other$userCount = other.getUserCount();
        if (this$userCount == null ? other$userCount != null : !((Object)this$userCount).equals(other$userCount)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        GroupAttributes this$attributes = this.getAttributes();
        GroupAttributes other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        String this$decentralizedRoles = this.getDecentralizedRoles();
        String other$decentralizedRoles = other.getDecentralizedRoles();
        if (this$decentralizedRoles == null ? other$decentralizedRoles != null : !this$decentralizedRoles.equals(other$decentralizedRoles)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        SortedSet<Persona> this$personas = this.getPersonas();
        SortedSet<Persona> other$personas = other.getPersonas();
        if (this$personas == null ? other$personas != null : !this$personas.equals(other$personas)) {
            return false;
        }
        SortedSet<Purpose> this$purposes = this.getPurposes();
        SortedSet<Purpose> other$purposes = other.getPurposes();
        if (this$purposes == null ? other$purposes != null : !this$purposes.equals(other$purposes)) {
            return false;
        }
        SortedSet<String> this$roles = this.getRoles();
        SortedSet<String> other$roles = other.getRoles();
        return !(this$roles == null ? other$roles != null : !this$roles.equals(other$roles));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AtlanGroup;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $userCount = this.getUserCount();
        result = result * 59 + ($userCount == null ? 43 : ((Object)$userCount).hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        GroupAttributes $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        String $decentralizedRoles = this.getDecentralizedRoles();
        result = result * 59 + ($decentralizedRoles == null ? 43 : $decentralizedRoles.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        SortedSet<Persona> $personas = this.getPersonas();
        result = result * 59 + ($personas == null ? 43 : $personas.hashCode());
        SortedSet<Purpose> $purposes = this.getPurposes();
        result = result * 59 + ($purposes == null ? 43 : $purposes.hashCode());
        SortedSet<String> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : $roles.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AtlanGroup(super=" + super.toString() + ", alias=" + this.getAlias() + ", attributes=" + this.getAttributes() + ", decentralizedRoles=" + this.getDecentralizedRoles() + ", id=" + this.getId() + ", name=" + this.getName() + ", path=" + this.getPath() + ", personas=" + this.getPersonas() + ", purposes=" + this.getPurposes() + ", roles=" + this.getRoles() + ", userCount=" + this.getUserCount() + ")";
    }

    @JsonDeserialize(builder=GroupAttributesBuilderImpl.class)
    public static final class GroupAttributes
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        List<String> alias;
        List<String> createdAt;
        List<String> createdBy;
        List<String> updatedAt;
        List<String> updatedBy;
        List<String> description;
        List<String> isDefault;
        List<String> channels;

        @Generated
        private static List<String> $default$isDefault() {
            return List.of("false");
        }

        @Generated
        protected GroupAttributes(GroupAttributesBuilder<?, ?> b) {
            super(b);
            this.alias = b.alias;
            this.createdAt = b.createdAt;
            this.createdBy = b.createdBy;
            this.updatedAt = b.updatedAt;
            this.updatedBy = b.updatedBy;
            this.description = b.description;
            this.isDefault = b.isDefault$set ? b.isDefault$value : GroupAttributes.$default$isDefault();
            this.channels = b.channels;
        }

        @Generated
        public static GroupAttributesBuilder<?, ?> builder() {
            return new GroupAttributesBuilderImpl();
        }

        @Generated
        public GroupAttributesBuilder<?, ?> toBuilder() {
            return new GroupAttributesBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public List<String> getAlias() {
            return this.alias;
        }

        @Generated
        public List<String> getCreatedAt() {
            return this.createdAt;
        }

        @Generated
        public List<String> getCreatedBy() {
            return this.createdBy;
        }

        @Generated
        public List<String> getUpdatedAt() {
            return this.updatedAt;
        }

        @Generated
        public List<String> getUpdatedBy() {
            return this.updatedBy;
        }

        @Generated
        public List<String> getDescription() {
            return this.description;
        }

        @Generated
        public List<String> getIsDefault() {
            return this.isDefault;
        }

        @Generated
        public List<String> getChannels() {
            return this.channels;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GroupAttributes)) {
                return false;
            }
            GroupAttributes other = (GroupAttributes)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<String> this$alias = this.getAlias();
            List<String> other$alias = other.getAlias();
            if (this$alias == null ? other$alias != null : !((Object)this$alias).equals(other$alias)) {
                return false;
            }
            List<String> this$createdAt = this.getCreatedAt();
            List<String> other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
                return false;
            }
            List<String> this$createdBy = this.getCreatedBy();
            List<String> other$createdBy = other.getCreatedBy();
            if (this$createdBy == null ? other$createdBy != null : !((Object)this$createdBy).equals(other$createdBy)) {
                return false;
            }
            List<String> this$updatedAt = this.getUpdatedAt();
            List<String> other$updatedAt = other.getUpdatedAt();
            if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
                return false;
            }
            List<String> this$updatedBy = this.getUpdatedBy();
            List<String> other$updatedBy = other.getUpdatedBy();
            if (this$updatedBy == null ? other$updatedBy != null : !((Object)this$updatedBy).equals(other$updatedBy)) {
                return false;
            }
            List<String> this$description = this.getDescription();
            List<String> other$description = other.getDescription();
            if (this$description == null ? other$description != null : !((Object)this$description).equals(other$description)) {
                return false;
            }
            List<String> this$isDefault = this.getIsDefault();
            List<String> other$isDefault = other.getIsDefault();
            if (this$isDefault == null ? other$isDefault != null : !((Object)this$isDefault).equals(other$isDefault)) {
                return false;
            }
            List<String> this$channels = this.getChannels();
            List<String> other$channels = other.getChannels();
            return !(this$channels == null ? other$channels != null : !((Object)this$channels).equals(other$channels));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof GroupAttributes;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<String> $alias = this.getAlias();
            result = result * 59 + ($alias == null ? 43 : ((Object)$alias).hashCode());
            List<String> $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
            List<String> $createdBy = this.getCreatedBy();
            result = result * 59 + ($createdBy == null ? 43 : ((Object)$createdBy).hashCode());
            List<String> $updatedAt = this.getUpdatedAt();
            result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
            List<String> $updatedBy = this.getUpdatedBy();
            result = result * 59 + ($updatedBy == null ? 43 : ((Object)$updatedBy).hashCode());
            List<String> $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
            List<String> $isDefault = this.getIsDefault();
            result = result * 59 + ($isDefault == null ? 43 : ((Object)$isDefault).hashCode());
            List<String> $channels = this.getChannels();
            result = result * 59 + ($channels == null ? 43 : ((Object)$channels).hashCode());
            return result;
        }

        @Override
        @Generated
        public String toString() {
            return "AtlanGroup.GroupAttributes(super=" + super.toString() + ", alias=" + this.getAlias() + ", createdAt=" + this.getCreatedAt() + ", createdBy=" + this.getCreatedBy() + ", updatedAt=" + this.getUpdatedAt() + ", updatedBy=" + this.getUpdatedBy() + ", description=" + this.getDescription() + ", isDefault=" + this.getIsDefault() + ", channels=" + this.getChannels() + ")";
        }

        @Generated
        public static abstract class GroupAttributesBuilder<C extends GroupAttributes, B extends GroupAttributesBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private List<String> alias;
            @Generated
            private List<String> createdAt;
            @Generated
            private List<String> createdBy;
            @Generated
            private List<String> updatedAt;
            @Generated
            private List<String> updatedBy;
            @Generated
            private List<String> description;
            @Generated
            private boolean isDefault$set;
            @Generated
            private List<String> isDefault$value;
            @Generated
            private List<String> channels;

            @Override
            @Generated
            protected B $fillValuesFrom(C instance) {
                super.$fillValuesFrom(instance);
                GroupAttributesBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return (B)this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(GroupAttributes instance, GroupAttributesBuilder<?, ?> b) {
                b.alias(instance.alias);
                b.createdAt(instance.createdAt);
                b.createdBy(instance.createdBy);
                b.updatedAt(instance.updatedAt);
                b.updatedBy(instance.updatedBy);
                b.description(instance.description);
                b.isDefault(instance.isDefault);
                b.channels(instance.channels);
            }

            @Generated
            public B alias(List<String> alias) {
                this.alias = alias;
                return (B)this.self();
            }

            @Generated
            public B createdAt(List<String> createdAt) {
                this.createdAt = createdAt;
                return (B)this.self();
            }

            @Generated
            public B createdBy(List<String> createdBy) {
                this.createdBy = createdBy;
                return (B)this.self();
            }

            @Generated
            public B updatedAt(List<String> updatedAt) {
                this.updatedAt = updatedAt;
                return (B)this.self();
            }

            @Generated
            public B updatedBy(List<String> updatedBy) {
                this.updatedBy = updatedBy;
                return (B)this.self();
            }

            @Generated
            public B description(List<String> description) {
                this.description = description;
                return (B)this.self();
            }

            @Generated
            public B isDefault(List<String> isDefault) {
                this.isDefault$value = isDefault;
                this.isDefault$set = true;
                return (B)this.self();
            }

            @Generated
            public B channels(List<String> channels) {
                this.channels = channels;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "AtlanGroup.GroupAttributes.GroupAttributesBuilder(super=" + super.toString() + ", alias=" + this.alias + ", createdAt=" + this.createdAt + ", createdBy=" + this.createdBy + ", updatedAt=" + this.updatedAt + ", updatedBy=" + this.updatedBy + ", description=" + this.description + ", isDefault$value=" + this.isDefault$value + ", channels=" + this.channels + ")";
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class GroupAttributesBuilderImpl
        extends GroupAttributesBuilder<GroupAttributes, GroupAttributesBuilderImpl> {
            @Generated
            private GroupAttributesBuilderImpl() {
            }

            @Override
            @Generated
            protected GroupAttributesBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public GroupAttributes build() {
                return new GroupAttributes(this);
            }
        }
    }

    @Generated
    public static abstract class AtlanGroupBuilder<C extends AtlanGroup, B extends AtlanGroupBuilder<C, B>>
    extends AtlanObject.AtlanObjectBuilder<C, B> {
        @Generated
        private String alias;
        @Generated
        private GroupAttributes attributes;
        @Generated
        private String decentralizedRoles;
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private String path;
        @Generated
        private SortedSet<Persona> personas;
        @Generated
        private SortedSet<Purpose> purposes;
        @Generated
        private SortedSet<String> roles;
        @Generated
        private Long userCount;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AtlanGroupBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AtlanGroup instance, AtlanGroupBuilder<?, ?> b) {
            b.alias(instance.alias);
            b.attributes(instance.attributes);
            b.decentralizedRoles(instance.decentralizedRoles);
            b.id(instance.id);
            b.name(instance.name);
            b.path(instance.path);
            b.personas(instance.personas);
            b.purposes(instance.purposes);
            b.roles(instance.roles);
            b.userCount(instance.userCount);
        }

        @Generated
        public B alias(String alias) {
            this.alias = alias;
            return (B)this.self();
        }

        @Generated
        public B attributes(GroupAttributes attributes) {
            this.attributes = attributes;
            return (B)this.self();
        }

        @JsonIgnore
        @Generated
        public B decentralizedRoles(String decentralizedRoles) {
            this.decentralizedRoles = decentralizedRoles;
            return (B)this.self();
        }

        @Generated
        public B id(String id) {
            this.id = id;
            return (B)this.self();
        }

        @Generated
        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        @Generated
        public B path(String path) {
            this.path = path;
            return (B)this.self();
        }

        @Generated
        public B personas(SortedSet<Persona> personas) {
            this.personas = personas;
            return (B)this.self();
        }

        @Generated
        public B purposes(SortedSet<Purpose> purposes) {
            this.purposes = purposes;
            return (B)this.self();
        }

        @Generated
        public B roles(SortedSet<String> roles) {
            this.roles = roles;
            return (B)this.self();
        }

        @Generated
        public B userCount(Long userCount) {
            this.userCount = userCount;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AtlanGroup.AtlanGroupBuilder(super=" + super.toString() + ", alias=" + this.alias + ", attributes=" + this.attributes + ", decentralizedRoles=" + this.decentralizedRoles + ", id=" + this.id + ", name=" + this.name + ", path=" + this.path + ", personas=" + this.personas + ", purposes=" + this.purposes + ", roles=" + this.roles + ", userCount=" + this.userCount + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class AtlanGroupBuilderImpl
    extends AtlanGroupBuilder<AtlanGroup, AtlanGroupBuilderImpl> {
        @Generated
        private AtlanGroupBuilderImpl() {
        }

        @Override
        @Generated
        protected AtlanGroupBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AtlanGroup build() {
            return new AtlanGroup(this);
        }
    }

    @JsonDeserialize(builder=PurposeBuilderImpl.class)
    public static final class Purpose
    extends AtlanObject
    implements Comparable<Purpose> {
        private static final long serialVersionUID = 2L;
        private static final Comparator<String> stringComparator = Comparator.nullsFirst(String::compareTo);
        private static final Comparator<Purpose> purposeComparator = Comparator.comparing(Purpose::getGuid, stringComparator);
        String guid;
        String name;
        String qualifiedName;

        @Override
        public int compareTo(Purpose o) {
            return purposeComparator.compare(this, o);
        }

        @Generated
        protected Purpose(PurposeBuilder<?, ?> b) {
            super(b);
            this.guid = b.guid;
            this.name = b.name;
            this.qualifiedName = b.qualifiedName;
        }

        @Generated
        public static PurposeBuilder<?, ?> builder() {
            return new PurposeBuilderImpl();
        }

        @Generated
        public PurposeBuilder<?, ?> toBuilder() {
            return new PurposeBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public String getGuid() {
            return this.guid;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getQualifiedName() {
            return this.qualifiedName;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Purpose)) {
                return false;
            }
            Purpose other = (Purpose)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$guid = this.getGuid();
            String other$guid = other.getGuid();
            if (this$guid == null ? other$guid != null : !this$guid.equals(other$guid)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$qualifiedName = this.getQualifiedName();
            String other$qualifiedName = other.getQualifiedName();
            return !(this$qualifiedName == null ? other$qualifiedName != null : !this$qualifiedName.equals(other$qualifiedName));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Purpose;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $guid = this.getGuid();
            result = result * 59 + ($guid == null ? 43 : $guid.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $qualifiedName = this.getQualifiedName();
            result = result * 59 + ($qualifiedName == null ? 43 : $qualifiedName.hashCode());
            return result;
        }

        @Override
        @Generated
        public String toString() {
            return "AtlanGroup.Purpose(super=" + super.toString() + ", guid=" + this.getGuid() + ", name=" + this.getName() + ", qualifiedName=" + this.getQualifiedName() + ")";
        }

        @Generated
        public static abstract class PurposeBuilder<C extends Purpose, B extends PurposeBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private String guid;
            @Generated
            private String name;
            @Generated
            private String qualifiedName;

            @Override
            @Generated
            protected B $fillValuesFrom(C instance) {
                super.$fillValuesFrom(instance);
                PurposeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return (B)this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(Purpose instance, PurposeBuilder<?, ?> b) {
                b.guid(instance.guid);
                b.name(instance.name);
                b.qualifiedName(instance.qualifiedName);
            }

            @Generated
            public B guid(String guid) {
                this.guid = guid;
                return (B)this.self();
            }

            @Generated
            public B name(String name) {
                this.name = name;
                return (B)this.self();
            }

            @Generated
            public B qualifiedName(String qualifiedName) {
                this.qualifiedName = qualifiedName;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "AtlanGroup.Purpose.PurposeBuilder(super=" + super.toString() + ", guid=" + this.guid + ", name=" + this.name + ", qualifiedName=" + this.qualifiedName + ")";
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class PurposeBuilderImpl
        extends PurposeBuilder<Purpose, PurposeBuilderImpl> {
            @Generated
            private PurposeBuilderImpl() {
            }

            @Override
            @Generated
            protected PurposeBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Purpose build() {
                return new Purpose(this);
            }
        }
    }

    @JsonDeserialize(builder=PersonaBuilderImpl.class)
    public static final class Persona
    extends AtlanObject
    implements Comparable<Persona> {
        private static final long serialVersionUID = 2L;
        private static final Comparator<String> stringComparator = Comparator.nullsFirst(String::compareTo);
        private static final Comparator<Persona> personaComparator = Comparator.comparing(Persona::getId, stringComparator);
        String id;
        String name;
        String displayName;
        String qualifiedName;

        @Override
        public int compareTo(Persona o) {
            return personaComparator.compare(this, o);
        }

        @Generated
        protected Persona(PersonaBuilder<?, ?> b) {
            super(b);
            this.id = b.id;
            this.name = b.name;
            this.displayName = b.displayName;
            this.qualifiedName = b.qualifiedName;
        }

        @Generated
        public static PersonaBuilder<?, ?> builder() {
            return new PersonaBuilderImpl();
        }

        @Generated
        public PersonaBuilder<?, ?> toBuilder() {
            return new PersonaBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public String getQualifiedName() {
            return this.qualifiedName;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Persona)) {
                return false;
            }
            Persona other = (Persona)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                return false;
            }
            String this$qualifiedName = this.getQualifiedName();
            String other$qualifiedName = other.getQualifiedName();
            return !(this$qualifiedName == null ? other$qualifiedName != null : !this$qualifiedName.equals(other$qualifiedName));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Persona;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            String $qualifiedName = this.getQualifiedName();
            result = result * 59 + ($qualifiedName == null ? 43 : $qualifiedName.hashCode());
            return result;
        }

        @Override
        @Generated
        public String toString() {
            return "AtlanGroup.Persona(super=" + super.toString() + ", id=" + this.getId() + ", name=" + this.getName() + ", displayName=" + this.getDisplayName() + ", qualifiedName=" + this.getQualifiedName() + ")";
        }

        @Generated
        public static abstract class PersonaBuilder<C extends Persona, B extends PersonaBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private String id;
            @Generated
            private String name;
            @Generated
            private String displayName;
            @Generated
            private String qualifiedName;

            @Override
            @Generated
            protected B $fillValuesFrom(C instance) {
                super.$fillValuesFrom(instance);
                PersonaBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return (B)this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(Persona instance, PersonaBuilder<?, ?> b) {
                b.id(instance.id);
                b.name(instance.name);
                b.displayName(instance.displayName);
                b.qualifiedName(instance.qualifiedName);
            }

            @Generated
            public B id(String id) {
                this.id = id;
                return (B)this.self();
            }

            @Generated
            public B name(String name) {
                this.name = name;
                return (B)this.self();
            }

            @Generated
            public B displayName(String displayName) {
                this.displayName = displayName;
                return (B)this.self();
            }

            @Generated
            public B qualifiedName(String qualifiedName) {
                this.qualifiedName = qualifiedName;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "AtlanGroup.Persona.PersonaBuilder(super=" + super.toString() + ", id=" + this.id + ", name=" + this.name + ", displayName=" + this.displayName + ", qualifiedName=" + this.qualifiedName + ")";
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class PersonaBuilderImpl
        extends PersonaBuilder<Persona, PersonaBuilderImpl> {
            @Generated
            private PersonaBuilderImpl() {
            }

            @Override
            @Generated
            protected PersonaBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Persona build() {
                return new Persona(this);
            }
        }
    }
}

