/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.admin;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.admin.AtlanRequestResponse;
import com.atlan.model.admin.AtlanTagRequest;
import com.atlan.model.admin.AttributeRequest;
import com.atlan.model.admin.CustomMetadataRequest;
import com.atlan.model.admin.TermLinkRequest;
import com.atlan.model.assets.Asset;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.AtlanRequestStatus;
import com.atlan.serde.AtlanRequestDeserializer;
import com.atlan.serde.AtlanRequestSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

@JsonSerialize(using=AtlanRequestSerializer.class)
@JsonDeserialize(using=AtlanRequestDeserializer.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="requestType")
@JsonSubTypes(value={@JsonSubTypes.Type(value=AttributeRequest.class, name="attribute"), @JsonSubTypes.Type(value=TermLinkRequest.class, name="term_link"), @JsonSubTypes.Type(value=AtlanTagRequest.class, name="attach_classification"), @JsonSubTypes.Type(value=CustomMetadataRequest.class, name="bm_attribute")})
public abstract class AtlanRequest
extends AtlanObject {
    private static final long serialVersionUID = 2L;
    String id;
    String version;
    Boolean isActive;
    final Long createdAt;
    final Long updatedAt;
    String createdBy;
    String tenantId;
    String sourceType;
    String sourceGuid;
    String sourceQualifiedName;
    String sourceAttribute;
    String destinationGuid;
    String destinationQualifiedName;
    String destinationAttribute;
    String destinationValue;
    String destinationValueType;
    @JsonIgnore
    Object destinationValueArray;
    @JsonIgnore
    Object destinationValueObject;
    String entityType;
    String requestType;
    @JsonIgnore
    Object confidenceScore;
    @JsonIgnore
    Object botRunId;
    String approvedBy;
    String rejectedBy;
    AtlanRequestStatus status;
    String message;
    @JsonIgnore
    Object requestsBatch;
    String approvalType;
    @JsonIgnore
    Object assignedApprovers;
    @JsonIgnore
    Object accessStartDate;
    @JsonIgnore
    Object accessEndDate;
    Long hash;
    Boolean isDuplicate;
    String destinationValueAction;
    SortedSet<String> requestApproverUsers;
    SortedSet<String> requestApproverGroups;
    SortedSet<String> requestApproverRoles;
    SortedSet<String> requestDenyUsers;
    SortedSet<String> requestDenyGroups;
    SortedSet<String> requestDenyRoles;
    @JsonIgnore
    Object sourceEntity;
    Asset destinationEntity;

    public void create() throws AtlanException {
        this.create(Atlan.getDefaultClient());
    }

    public void create(AtlanClient client) throws AtlanException {
        client.requests.create(this);
    }

    public static AtlanRequestResponse list() throws AtlanException {
        return AtlanRequest.list(Atlan.getDefaultClient());
    }

    public static AtlanRequestResponse list(AtlanClient client) throws AtlanException {
        return client.requests.list();
    }

    public static AtlanRequest retrieveByGuid(String guid) throws AtlanException {
        return AtlanRequest.retrieveByGuid(Atlan.getDefaultClient(), guid);
    }

    public static AtlanRequest retrieveByGuid(AtlanClient client, String guid) throws AtlanException {
        return client.requests.get(guid);
    }

    public static boolean approve(String guid, String message) throws AtlanException {
        return AtlanRequest.approve(Atlan.getDefaultClient(), guid, message);
    }

    public static boolean approve(AtlanClient client, String guid, String message) throws AtlanException {
        return client.requests.approve(guid, message);
    }

    public static boolean reject(String guid, String message) throws AtlanException {
        return AtlanRequest.reject(Atlan.getDefaultClient(), guid, message);
    }

    public static boolean reject(AtlanClient client, String guid, String message) throws AtlanException {
        return client.requests.reject(guid, message);
    }

    @Generated
    private static String $default$tenantId() {
        return "default";
    }

    @Generated
    private static String $default$approvalType() {
        return "single";
    }

    @Generated
    protected AtlanRequest(AtlanRequestBuilder<?, ?> b) {
        super(b);
        this.id = b.id;
        this.version = b.version;
        this.isActive = b.isActive;
        this.createdAt = b.createdAt;
        this.updatedAt = b.updatedAt;
        this.createdBy = b.createdBy;
        this.tenantId = b.tenantId$set ? b.tenantId$value : AtlanRequest.$default$tenantId();
        this.sourceType = b.sourceType;
        this.sourceGuid = b.sourceGuid;
        this.sourceQualifiedName = b.sourceQualifiedName;
        this.sourceAttribute = b.sourceAttribute;
        this.destinationGuid = b.destinationGuid;
        this.destinationQualifiedName = b.destinationQualifiedName;
        this.destinationAttribute = b.destinationAttribute;
        this.destinationValue = b.destinationValue;
        this.destinationValueType = b.destinationValueType;
        this.destinationValueArray = b.destinationValueArray;
        this.destinationValueObject = b.destinationValueObject;
        this.entityType = b.entityType;
        this.requestType = b.requestType;
        this.confidenceScore = b.confidenceScore;
        this.botRunId = b.botRunId;
        this.approvedBy = b.approvedBy;
        this.rejectedBy = b.rejectedBy;
        this.status = b.status;
        this.message = b.message;
        this.requestsBatch = b.requestsBatch;
        this.approvalType = b.approvalType$set ? b.approvalType$value : AtlanRequest.$default$approvalType();
        this.assignedApprovers = b.assignedApprovers;
        this.accessStartDate = b.accessStartDate;
        this.accessEndDate = b.accessEndDate;
        this.hash = b.hash;
        this.isDuplicate = b.isDuplicate;
        this.destinationValueAction = b.destinationValueAction;
        SortedSet<String> requestApproverUsers = new TreeSet<String>();
        if (b.requestApproverUsers != null) {
            requestApproverUsers.addAll(b.requestApproverUsers);
        }
        requestApproverUsers = Collections.unmodifiableSortedSet(requestApproverUsers);
        this.requestApproverUsers = requestApproverUsers;
        SortedSet<String> requestApproverGroups = new TreeSet<String>();
        if (b.requestApproverGroups != null) {
            requestApproverGroups.addAll(b.requestApproverGroups);
        }
        requestApproverGroups = Collections.unmodifiableSortedSet(requestApproverGroups);
        this.requestApproverGroups = requestApproverGroups;
        SortedSet<String> requestApproverRoles = new TreeSet<String>();
        if (b.requestApproverRoles != null) {
            requestApproverRoles.addAll(b.requestApproverRoles);
        }
        requestApproverRoles = Collections.unmodifiableSortedSet(requestApproverRoles);
        this.requestApproverRoles = requestApproverRoles;
        SortedSet<String> requestDenyUsers = new TreeSet<String>();
        if (b.requestDenyUsers != null) {
            requestDenyUsers.addAll(b.requestDenyUsers);
        }
        requestDenyUsers = Collections.unmodifiableSortedSet(requestDenyUsers);
        this.requestDenyUsers = requestDenyUsers;
        SortedSet<String> requestDenyGroups = new TreeSet<String>();
        if (b.requestDenyGroups != null) {
            requestDenyGroups.addAll(b.requestDenyGroups);
        }
        requestDenyGroups = Collections.unmodifiableSortedSet(requestDenyGroups);
        this.requestDenyGroups = requestDenyGroups;
        SortedSet<String> requestDenyRoles = new TreeSet<String>();
        if (b.requestDenyRoles != null) {
            requestDenyRoles.addAll(b.requestDenyRoles);
        }
        requestDenyRoles = Collections.unmodifiableSortedSet(requestDenyRoles);
        this.requestDenyRoles = requestDenyRoles;
        this.sourceEntity = b.sourceEntity;
        this.destinationEntity = b.destinationEntity;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public Boolean getIsActive() {
        return this.isActive;
    }

    @Generated
    public Long getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getSourceType() {
        return this.sourceType;
    }

    @Generated
    public String getSourceGuid() {
        return this.sourceGuid;
    }

    @Generated
    public String getSourceQualifiedName() {
        return this.sourceQualifiedName;
    }

    @Generated
    public String getSourceAttribute() {
        return this.sourceAttribute;
    }

    @Generated
    public String getDestinationGuid() {
        return this.destinationGuid;
    }

    @Generated
    public String getDestinationQualifiedName() {
        return this.destinationQualifiedName;
    }

    @Generated
    public String getDestinationAttribute() {
        return this.destinationAttribute;
    }

    @Generated
    public String getDestinationValue() {
        return this.destinationValue;
    }

    @Generated
    public String getDestinationValueType() {
        return this.destinationValueType;
    }

    @Generated
    public Object getDestinationValueArray() {
        return this.destinationValueArray;
    }

    @Generated
    public Object getDestinationValueObject() {
        return this.destinationValueObject;
    }

    @Generated
    public String getEntityType() {
        return this.entityType;
    }

    @Generated
    public String getRequestType() {
        return this.requestType;
    }

    @Generated
    public Object getConfidenceScore() {
        return this.confidenceScore;
    }

    @Generated
    public Object getBotRunId() {
        return this.botRunId;
    }

    @Generated
    public String getApprovedBy() {
        return this.approvedBy;
    }

    @Generated
    public String getRejectedBy() {
        return this.rejectedBy;
    }

    @Generated
    public AtlanRequestStatus getStatus() {
        return this.status;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public Object getRequestsBatch() {
        return this.requestsBatch;
    }

    @Generated
    public String getApprovalType() {
        return this.approvalType;
    }

    @Generated
    public Object getAssignedApprovers() {
        return this.assignedApprovers;
    }

    @Generated
    public Object getAccessStartDate() {
        return this.accessStartDate;
    }

    @Generated
    public Object getAccessEndDate() {
        return this.accessEndDate;
    }

    @Generated
    public Long getHash() {
        return this.hash;
    }

    @Generated
    public Boolean getIsDuplicate() {
        return this.isDuplicate;
    }

    @Generated
    public String getDestinationValueAction() {
        return this.destinationValueAction;
    }

    @Generated
    public SortedSet<String> getRequestApproverUsers() {
        return this.requestApproverUsers;
    }

    @Generated
    public SortedSet<String> getRequestApproverGroups() {
        return this.requestApproverGroups;
    }

    @Generated
    public SortedSet<String> getRequestApproverRoles() {
        return this.requestApproverRoles;
    }

    @Generated
    public SortedSet<String> getRequestDenyUsers() {
        return this.requestDenyUsers;
    }

    @Generated
    public SortedSet<String> getRequestDenyGroups() {
        return this.requestDenyGroups;
    }

    @Generated
    public SortedSet<String> getRequestDenyRoles() {
        return this.requestDenyRoles;
    }

    @Generated
    public Object getSourceEntity() {
        return this.sourceEntity;
    }

    @Generated
    public Asset getDestinationEntity() {
        return this.destinationEntity;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AtlanRequest)) {
            return false;
        }
        AtlanRequest other = (AtlanRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isActive = this.getIsActive();
        Boolean other$isActive = other.getIsActive();
        if (this$isActive == null ? other$isActive != null : !((Object)this$isActive).equals(other$isActive)) {
            return false;
        }
        Long this$createdAt = this.getCreatedAt();
        Long other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Long this$updatedAt = this.getUpdatedAt();
        Long other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        Long this$hash = this.getHash();
        Long other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !((Object)this$hash).equals(other$hash)) {
            return false;
        }
        Boolean this$isDuplicate = this.getIsDuplicate();
        Boolean other$isDuplicate = other.getIsDuplicate();
        if (this$isDuplicate == null ? other$isDuplicate != null : !((Object)this$isDuplicate).equals(other$isDuplicate)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$sourceType = this.getSourceType();
        String other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) {
            return false;
        }
        String this$sourceGuid = this.getSourceGuid();
        String other$sourceGuid = other.getSourceGuid();
        if (this$sourceGuid == null ? other$sourceGuid != null : !this$sourceGuid.equals(other$sourceGuid)) {
            return false;
        }
        String this$sourceQualifiedName = this.getSourceQualifiedName();
        String other$sourceQualifiedName = other.getSourceQualifiedName();
        if (this$sourceQualifiedName == null ? other$sourceQualifiedName != null : !this$sourceQualifiedName.equals(other$sourceQualifiedName)) {
            return false;
        }
        String this$sourceAttribute = this.getSourceAttribute();
        String other$sourceAttribute = other.getSourceAttribute();
        if (this$sourceAttribute == null ? other$sourceAttribute != null : !this$sourceAttribute.equals(other$sourceAttribute)) {
            return false;
        }
        String this$destinationGuid = this.getDestinationGuid();
        String other$destinationGuid = other.getDestinationGuid();
        if (this$destinationGuid == null ? other$destinationGuid != null : !this$destinationGuid.equals(other$destinationGuid)) {
            return false;
        }
        String this$destinationQualifiedName = this.getDestinationQualifiedName();
        String other$destinationQualifiedName = other.getDestinationQualifiedName();
        if (this$destinationQualifiedName == null ? other$destinationQualifiedName != null : !this$destinationQualifiedName.equals(other$destinationQualifiedName)) {
            return false;
        }
        String this$destinationAttribute = this.getDestinationAttribute();
        String other$destinationAttribute = other.getDestinationAttribute();
        if (this$destinationAttribute == null ? other$destinationAttribute != null : !this$destinationAttribute.equals(other$destinationAttribute)) {
            return false;
        }
        String this$destinationValue = this.getDestinationValue();
        String other$destinationValue = other.getDestinationValue();
        if (this$destinationValue == null ? other$destinationValue != null : !this$destinationValue.equals(other$destinationValue)) {
            return false;
        }
        String this$destinationValueType = this.getDestinationValueType();
        String other$destinationValueType = other.getDestinationValueType();
        if (this$destinationValueType == null ? other$destinationValueType != null : !this$destinationValueType.equals(other$destinationValueType)) {
            return false;
        }
        Object this$destinationValueArray = this.getDestinationValueArray();
        Object other$destinationValueArray = other.getDestinationValueArray();
        if (this$destinationValueArray == null ? other$destinationValueArray != null : !this$destinationValueArray.equals(other$destinationValueArray)) {
            return false;
        }
        Object this$destinationValueObject = this.getDestinationValueObject();
        Object other$destinationValueObject = other.getDestinationValueObject();
        if (this$destinationValueObject == null ? other$destinationValueObject != null : !this$destinationValueObject.equals(other$destinationValueObject)) {
            return false;
        }
        String this$entityType = this.getEntityType();
        String other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !this$entityType.equals(other$entityType)) {
            return false;
        }
        String this$requestType = this.getRequestType();
        String other$requestType = other.getRequestType();
        if (this$requestType == null ? other$requestType != null : !this$requestType.equals(other$requestType)) {
            return false;
        }
        Object this$confidenceScore = this.getConfidenceScore();
        Object other$confidenceScore = other.getConfidenceScore();
        if (this$confidenceScore == null ? other$confidenceScore != null : !this$confidenceScore.equals(other$confidenceScore)) {
            return false;
        }
        Object this$botRunId = this.getBotRunId();
        Object other$botRunId = other.getBotRunId();
        if (this$botRunId == null ? other$botRunId != null : !this$botRunId.equals(other$botRunId)) {
            return false;
        }
        String this$approvedBy = this.getApprovedBy();
        String other$approvedBy = other.getApprovedBy();
        if (this$approvedBy == null ? other$approvedBy != null : !this$approvedBy.equals(other$approvedBy)) {
            return false;
        }
        String this$rejectedBy = this.getRejectedBy();
        String other$rejectedBy = other.getRejectedBy();
        if (this$rejectedBy == null ? other$rejectedBy != null : !this$rejectedBy.equals(other$rejectedBy)) {
            return false;
        }
        AtlanRequestStatus this$status = this.getStatus();
        AtlanRequestStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Object this$requestsBatch = this.getRequestsBatch();
        Object other$requestsBatch = other.getRequestsBatch();
        if (this$requestsBatch == null ? other$requestsBatch != null : !this$requestsBatch.equals(other$requestsBatch)) {
            return false;
        }
        String this$approvalType = this.getApprovalType();
        String other$approvalType = other.getApprovalType();
        if (this$approvalType == null ? other$approvalType != null : !this$approvalType.equals(other$approvalType)) {
            return false;
        }
        Object this$assignedApprovers = this.getAssignedApprovers();
        Object other$assignedApprovers = other.getAssignedApprovers();
        if (this$assignedApprovers == null ? other$assignedApprovers != null : !this$assignedApprovers.equals(other$assignedApprovers)) {
            return false;
        }
        Object this$accessStartDate = this.getAccessStartDate();
        Object other$accessStartDate = other.getAccessStartDate();
        if (this$accessStartDate == null ? other$accessStartDate != null : !this$accessStartDate.equals(other$accessStartDate)) {
            return false;
        }
        Object this$accessEndDate = this.getAccessEndDate();
        Object other$accessEndDate = other.getAccessEndDate();
        if (this$accessEndDate == null ? other$accessEndDate != null : !this$accessEndDate.equals(other$accessEndDate)) {
            return false;
        }
        String this$destinationValueAction = this.getDestinationValueAction();
        String other$destinationValueAction = other.getDestinationValueAction();
        if (this$destinationValueAction == null ? other$destinationValueAction != null : !this$destinationValueAction.equals(other$destinationValueAction)) {
            return false;
        }
        SortedSet<String> this$requestApproverUsers = this.getRequestApproverUsers();
        SortedSet<String> other$requestApproverUsers = other.getRequestApproverUsers();
        if (this$requestApproverUsers == null ? other$requestApproverUsers != null : !this$requestApproverUsers.equals(other$requestApproverUsers)) {
            return false;
        }
        SortedSet<String> this$requestApproverGroups = this.getRequestApproverGroups();
        SortedSet<String> other$requestApproverGroups = other.getRequestApproverGroups();
        if (this$requestApproverGroups == null ? other$requestApproverGroups != null : !this$requestApproverGroups.equals(other$requestApproverGroups)) {
            return false;
        }
        SortedSet<String> this$requestApproverRoles = this.getRequestApproverRoles();
        SortedSet<String> other$requestApproverRoles = other.getRequestApproverRoles();
        if (this$requestApproverRoles == null ? other$requestApproverRoles != null : !this$requestApproverRoles.equals(other$requestApproverRoles)) {
            return false;
        }
        SortedSet<String> this$requestDenyUsers = this.getRequestDenyUsers();
        SortedSet<String> other$requestDenyUsers = other.getRequestDenyUsers();
        if (this$requestDenyUsers == null ? other$requestDenyUsers != null : !this$requestDenyUsers.equals(other$requestDenyUsers)) {
            return false;
        }
        SortedSet<String> this$requestDenyGroups = this.getRequestDenyGroups();
        SortedSet<String> other$requestDenyGroups = other.getRequestDenyGroups();
        if (this$requestDenyGroups == null ? other$requestDenyGroups != null : !this$requestDenyGroups.equals(other$requestDenyGroups)) {
            return false;
        }
        SortedSet<String> this$requestDenyRoles = this.getRequestDenyRoles();
        SortedSet<String> other$requestDenyRoles = other.getRequestDenyRoles();
        if (this$requestDenyRoles == null ? other$requestDenyRoles != null : !this$requestDenyRoles.equals(other$requestDenyRoles)) {
            return false;
        }
        Object this$sourceEntity = this.getSourceEntity();
        Object other$sourceEntity = other.getSourceEntity();
        if (this$sourceEntity == null ? other$sourceEntity != null : !this$sourceEntity.equals(other$sourceEntity)) {
            return false;
        }
        Asset this$destinationEntity = this.getDestinationEntity();
        Asset other$destinationEntity = other.getDestinationEntity();
        return !(this$destinationEntity == null ? other$destinationEntity != null : !((Object)this$destinationEntity).equals(other$destinationEntity));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AtlanRequest;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isActive = this.getIsActive();
        result = result * 59 + ($isActive == null ? 43 : ((Object)$isActive).hashCode());
        Long $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Long $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        Long $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : ((Object)$hash).hashCode());
        Boolean $isDuplicate = this.getIsDuplicate();
        result = result * 59 + ($isDuplicate == null ? 43 : ((Object)$isDuplicate).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $sourceType = this.getSourceType();
        result = result * 59 + ($sourceType == null ? 43 : $sourceType.hashCode());
        String $sourceGuid = this.getSourceGuid();
        result = result * 59 + ($sourceGuid == null ? 43 : $sourceGuid.hashCode());
        String $sourceQualifiedName = this.getSourceQualifiedName();
        result = result * 59 + ($sourceQualifiedName == null ? 43 : $sourceQualifiedName.hashCode());
        String $sourceAttribute = this.getSourceAttribute();
        result = result * 59 + ($sourceAttribute == null ? 43 : $sourceAttribute.hashCode());
        String $destinationGuid = this.getDestinationGuid();
        result = result * 59 + ($destinationGuid == null ? 43 : $destinationGuid.hashCode());
        String $destinationQualifiedName = this.getDestinationQualifiedName();
        result = result * 59 + ($destinationQualifiedName == null ? 43 : $destinationQualifiedName.hashCode());
        String $destinationAttribute = this.getDestinationAttribute();
        result = result * 59 + ($destinationAttribute == null ? 43 : $destinationAttribute.hashCode());
        String $destinationValue = this.getDestinationValue();
        result = result * 59 + ($destinationValue == null ? 43 : $destinationValue.hashCode());
        String $destinationValueType = this.getDestinationValueType();
        result = result * 59 + ($destinationValueType == null ? 43 : $destinationValueType.hashCode());
        Object $destinationValueArray = this.getDestinationValueArray();
        result = result * 59 + ($destinationValueArray == null ? 43 : $destinationValueArray.hashCode());
        Object $destinationValueObject = this.getDestinationValueObject();
        result = result * 59 + ($destinationValueObject == null ? 43 : $destinationValueObject.hashCode());
        String $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 43 : $entityType.hashCode());
        String $requestType = this.getRequestType();
        result = result * 59 + ($requestType == null ? 43 : $requestType.hashCode());
        Object $confidenceScore = this.getConfidenceScore();
        result = result * 59 + ($confidenceScore == null ? 43 : $confidenceScore.hashCode());
        Object $botRunId = this.getBotRunId();
        result = result * 59 + ($botRunId == null ? 43 : $botRunId.hashCode());
        String $approvedBy = this.getApprovedBy();
        result = result * 59 + ($approvedBy == null ? 43 : $approvedBy.hashCode());
        String $rejectedBy = this.getRejectedBy();
        result = result * 59 + ($rejectedBy == null ? 43 : $rejectedBy.hashCode());
        AtlanRequestStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Object $requestsBatch = this.getRequestsBatch();
        result = result * 59 + ($requestsBatch == null ? 43 : $requestsBatch.hashCode());
        String $approvalType = this.getApprovalType();
        result = result * 59 + ($approvalType == null ? 43 : $approvalType.hashCode());
        Object $assignedApprovers = this.getAssignedApprovers();
        result = result * 59 + ($assignedApprovers == null ? 43 : $assignedApprovers.hashCode());
        Object $accessStartDate = this.getAccessStartDate();
        result = result * 59 + ($accessStartDate == null ? 43 : $accessStartDate.hashCode());
        Object $accessEndDate = this.getAccessEndDate();
        result = result * 59 + ($accessEndDate == null ? 43 : $accessEndDate.hashCode());
        String $destinationValueAction = this.getDestinationValueAction();
        result = result * 59 + ($destinationValueAction == null ? 43 : $destinationValueAction.hashCode());
        SortedSet<String> $requestApproverUsers = this.getRequestApproverUsers();
        result = result * 59 + ($requestApproverUsers == null ? 43 : $requestApproverUsers.hashCode());
        SortedSet<String> $requestApproverGroups = this.getRequestApproverGroups();
        result = result * 59 + ($requestApproverGroups == null ? 43 : $requestApproverGroups.hashCode());
        SortedSet<String> $requestApproverRoles = this.getRequestApproverRoles();
        result = result * 59 + ($requestApproverRoles == null ? 43 : $requestApproverRoles.hashCode());
        SortedSet<String> $requestDenyUsers = this.getRequestDenyUsers();
        result = result * 59 + ($requestDenyUsers == null ? 43 : $requestDenyUsers.hashCode());
        SortedSet<String> $requestDenyGroups = this.getRequestDenyGroups();
        result = result * 59 + ($requestDenyGroups == null ? 43 : $requestDenyGroups.hashCode());
        SortedSet<String> $requestDenyRoles = this.getRequestDenyRoles();
        result = result * 59 + ($requestDenyRoles == null ? 43 : $requestDenyRoles.hashCode());
        Object $sourceEntity = this.getSourceEntity();
        result = result * 59 + ($sourceEntity == null ? 43 : $sourceEntity.hashCode());
        Asset $destinationEntity = this.getDestinationEntity();
        result = result * 59 + ($destinationEntity == null ? 43 : ((Object)$destinationEntity).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AtlanRequest(super=" + super.toString() + ", id=" + this.getId() + ", version=" + this.getVersion() + ", isActive=" + this.getIsActive() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", createdBy=" + this.getCreatedBy() + ", tenantId=" + this.getTenantId() + ", sourceType=" + this.getSourceType() + ", sourceGuid=" + this.getSourceGuid() + ", sourceQualifiedName=" + this.getSourceQualifiedName() + ", sourceAttribute=" + this.getSourceAttribute() + ", destinationGuid=" + this.getDestinationGuid() + ", destinationQualifiedName=" + this.getDestinationQualifiedName() + ", destinationAttribute=" + this.getDestinationAttribute() + ", destinationValue=" + this.getDestinationValue() + ", destinationValueType=" + this.getDestinationValueType() + ", destinationValueArray=" + this.getDestinationValueArray() + ", destinationValueObject=" + this.getDestinationValueObject() + ", entityType=" + this.getEntityType() + ", requestType=" + this.getRequestType() + ", confidenceScore=" + this.getConfidenceScore() + ", botRunId=" + this.getBotRunId() + ", approvedBy=" + this.getApprovedBy() + ", rejectedBy=" + this.getRejectedBy() + ", status=" + this.getStatus() + ", message=" + this.getMessage() + ", requestsBatch=" + this.getRequestsBatch() + ", approvalType=" + this.getApprovalType() + ", assignedApprovers=" + this.getAssignedApprovers() + ", accessStartDate=" + this.getAccessStartDate() + ", accessEndDate=" + this.getAccessEndDate() + ", hash=" + this.getHash() + ", isDuplicate=" + this.getIsDuplicate() + ", destinationValueAction=" + this.getDestinationValueAction() + ", requestApproverUsers=" + this.getRequestApproverUsers() + ", requestApproverGroups=" + this.getRequestApproverGroups() + ", requestApproverRoles=" + this.getRequestApproverRoles() + ", requestDenyUsers=" + this.getRequestDenyUsers() + ", requestDenyGroups=" + this.getRequestDenyGroups() + ", requestDenyRoles=" + this.getRequestDenyRoles() + ", sourceEntity=" + this.getSourceEntity() + ", destinationEntity=" + this.getDestinationEntity() + ")";
    }

    @Generated
    public static abstract class AtlanRequestBuilder<C extends AtlanRequest, B extends AtlanRequestBuilder<C, B>>
    extends AtlanObject.AtlanObjectBuilder<C, B> {
        @Generated
        private String id;
        @Generated
        private String version;
        @Generated
        private Boolean isActive;
        @Generated
        private Long createdAt;
        @Generated
        private Long updatedAt;
        @Generated
        private String createdBy;
        @Generated
        private boolean tenantId$set;
        @Generated
        private String tenantId$value;
        @Generated
        private String sourceType;
        @Generated
        private String sourceGuid;
        @Generated
        private String sourceQualifiedName;
        @Generated
        private String sourceAttribute;
        @Generated
        private String destinationGuid;
        @Generated
        private String destinationQualifiedName;
        @Generated
        private String destinationAttribute;
        @Generated
        private String destinationValue;
        @Generated
        private String destinationValueType;
        @Generated
        private Object destinationValueArray;
        @Generated
        private Object destinationValueObject;
        @Generated
        private String entityType;
        @Generated
        private String requestType;
        @Generated
        private Object confidenceScore;
        @Generated
        private Object botRunId;
        @Generated
        private String approvedBy;
        @Generated
        private String rejectedBy;
        @Generated
        private AtlanRequestStatus status;
        @Generated
        private String message;
        @Generated
        private Object requestsBatch;
        @Generated
        private boolean approvalType$set;
        @Generated
        private String approvalType$value;
        @Generated
        private Object assignedApprovers;
        @Generated
        private Object accessStartDate;
        @Generated
        private Object accessEndDate;
        @Generated
        private Long hash;
        @Generated
        private Boolean isDuplicate;
        @Generated
        private String destinationValueAction;
        @Generated
        private ArrayList<String> requestApproverUsers;
        @Generated
        private ArrayList<String> requestApproverGroups;
        @Generated
        private ArrayList<String> requestApproverRoles;
        @Generated
        private ArrayList<String> requestDenyUsers;
        @Generated
        private ArrayList<String> requestDenyGroups;
        @Generated
        private ArrayList<String> requestDenyRoles;
        @Generated
        private Object sourceEntity;
        @Generated
        private Asset destinationEntity;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AtlanRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AtlanRequest instance, AtlanRequestBuilder<?, ?> b) {
            b.id(instance.id);
            b.version(instance.version);
            b.isActive(instance.isActive);
            b.createdAt(instance.createdAt);
            b.updatedAt(instance.updatedAt);
            b.createdBy(instance.createdBy);
            b.tenantId(instance.tenantId);
            b.sourceType(instance.sourceType);
            b.sourceGuid(instance.sourceGuid);
            b.sourceQualifiedName(instance.sourceQualifiedName);
            b.sourceAttribute(instance.sourceAttribute);
            b.destinationGuid(instance.destinationGuid);
            b.destinationQualifiedName(instance.destinationQualifiedName);
            b.destinationAttribute(instance.destinationAttribute);
            b.destinationValue(instance.destinationValue);
            b.destinationValueType(instance.destinationValueType);
            b.destinationValueArray(instance.destinationValueArray);
            b.destinationValueObject(instance.destinationValueObject);
            b.entityType(instance.entityType);
            b.requestType(instance.requestType);
            b.confidenceScore(instance.confidenceScore);
            b.botRunId(instance.botRunId);
            b.approvedBy(instance.approvedBy);
            b.rejectedBy(instance.rejectedBy);
            b.status(instance.status);
            b.message(instance.message);
            b.requestsBatch(instance.requestsBatch);
            b.approvalType(instance.approvalType);
            b.assignedApprovers(instance.assignedApprovers);
            b.accessStartDate(instance.accessStartDate);
            b.accessEndDate(instance.accessEndDate);
            b.hash(instance.hash);
            b.isDuplicate(instance.isDuplicate);
            b.destinationValueAction(instance.destinationValueAction);
            b.requestApproverUsers(instance.requestApproverUsers == null ? Collections.emptySortedSet() : instance.requestApproverUsers);
            b.requestApproverGroups(instance.requestApproverGroups == null ? Collections.emptySortedSet() : instance.requestApproverGroups);
            b.requestApproverRoles(instance.requestApproverRoles == null ? Collections.emptySortedSet() : instance.requestApproverRoles);
            b.requestDenyUsers(instance.requestDenyUsers == null ? Collections.emptySortedSet() : instance.requestDenyUsers);
            b.requestDenyGroups(instance.requestDenyGroups == null ? Collections.emptySortedSet() : instance.requestDenyGroups);
            b.requestDenyRoles(instance.requestDenyRoles == null ? Collections.emptySortedSet() : instance.requestDenyRoles);
            b.sourceEntity(instance.sourceEntity);
            b.destinationEntity(instance.destinationEntity);
        }

        @Generated
        public B id(String id) {
            this.id = id;
            return (B)this.self();
        }

        @Generated
        public B version(String version) {
            this.version = version;
            return (B)this.self();
        }

        @Generated
        public B isActive(Boolean isActive) {
            this.isActive = isActive;
            return (B)this.self();
        }

        @Generated
        public B createdAt(Long createdAt) {
            this.createdAt = createdAt;
            return (B)this.self();
        }

        @Generated
        public B updatedAt(Long updatedAt) {
            this.updatedAt = updatedAt;
            return (B)this.self();
        }

        @Generated
        public B createdBy(String createdBy) {
            this.createdBy = createdBy;
            return (B)this.self();
        }

        @Generated
        public B tenantId(String tenantId) {
            this.tenantId$value = tenantId;
            this.tenantId$set = true;
            return (B)this.self();
        }

        @Generated
        public B sourceType(String sourceType) {
            this.sourceType = sourceType;
            return (B)this.self();
        }

        @Generated
        public B sourceGuid(String sourceGuid) {
            this.sourceGuid = sourceGuid;
            return (B)this.self();
        }

        @Generated
        public B sourceQualifiedName(String sourceQualifiedName) {
            this.sourceQualifiedName = sourceQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B sourceAttribute(String sourceAttribute) {
            this.sourceAttribute = sourceAttribute;
            return (B)this.self();
        }

        @Generated
        public B destinationGuid(String destinationGuid) {
            this.destinationGuid = destinationGuid;
            return (B)this.self();
        }

        @Generated
        public B destinationQualifiedName(String destinationQualifiedName) {
            this.destinationQualifiedName = destinationQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B destinationAttribute(String destinationAttribute) {
            this.destinationAttribute = destinationAttribute;
            return (B)this.self();
        }

        @Generated
        public B destinationValue(String destinationValue) {
            this.destinationValue = destinationValue;
            return (B)this.self();
        }

        @Generated
        public B destinationValueType(String destinationValueType) {
            this.destinationValueType = destinationValueType;
            return (B)this.self();
        }

        @JsonIgnore
        @Generated
        public B destinationValueArray(Object destinationValueArray) {
            this.destinationValueArray = destinationValueArray;
            return (B)this.self();
        }

        @JsonIgnore
        @Generated
        public B destinationValueObject(Object destinationValueObject) {
            this.destinationValueObject = destinationValueObject;
            return (B)this.self();
        }

        @Generated
        public B entityType(String entityType) {
            this.entityType = entityType;
            return (B)this.self();
        }

        @Generated
        public B requestType(String requestType) {
            this.requestType = requestType;
            return (B)this.self();
        }

        @JsonIgnore
        @Generated
        public B confidenceScore(Object confidenceScore) {
            this.confidenceScore = confidenceScore;
            return (B)this.self();
        }

        @JsonIgnore
        @Generated
        public B botRunId(Object botRunId) {
            this.botRunId = botRunId;
            return (B)this.self();
        }

        @Generated
        public B approvedBy(String approvedBy) {
            this.approvedBy = approvedBy;
            return (B)this.self();
        }

        @Generated
        public B rejectedBy(String rejectedBy) {
            this.rejectedBy = rejectedBy;
            return (B)this.self();
        }

        @Generated
        public B status(AtlanRequestStatus status) {
            this.status = status;
            return (B)this.self();
        }

        @Generated
        public B message(String message) {
            this.message = message;
            return (B)this.self();
        }

        @JsonIgnore
        @Generated
        public B requestsBatch(Object requestsBatch) {
            this.requestsBatch = requestsBatch;
            return (B)this.self();
        }

        @Generated
        public B approvalType(String approvalType) {
            this.approvalType$value = approvalType;
            this.approvalType$set = true;
            return (B)this.self();
        }

        @JsonIgnore
        @Generated
        public B assignedApprovers(Object assignedApprovers) {
            this.assignedApprovers = assignedApprovers;
            return (B)this.self();
        }

        @JsonIgnore
        @Generated
        public B accessStartDate(Object accessStartDate) {
            this.accessStartDate = accessStartDate;
            return (B)this.self();
        }

        @JsonIgnore
        @Generated
        public B accessEndDate(Object accessEndDate) {
            this.accessEndDate = accessEndDate;
            return (B)this.self();
        }

        @Generated
        public B hash(Long hash) {
            this.hash = hash;
            return (B)this.self();
        }

        @Generated
        public B isDuplicate(Boolean isDuplicate) {
            this.isDuplicate = isDuplicate;
            return (B)this.self();
        }

        @Generated
        public B destinationValueAction(String destinationValueAction) {
            this.destinationValueAction = destinationValueAction;
            return (B)this.self();
        }

        @Generated
        public B requestApproverUser(String requestApproverUser) {
            if (this.requestApproverUsers == null) {
                this.requestApproverUsers = new ArrayList();
            }
            this.requestApproverUsers.add(requestApproverUser);
            return (B)this.self();
        }

        @Generated
        public B requestApproverUsers(Collection<? extends String> requestApproverUsers) {
            if (requestApproverUsers == null) {
                throw new NullPointerException("requestApproverUsers cannot be null");
            }
            if (this.requestApproverUsers == null) {
                this.requestApproverUsers = new ArrayList();
            }
            this.requestApproverUsers.addAll(requestApproverUsers);
            return (B)this.self();
        }

        @Generated
        public B clearRequestApproverUsers() {
            if (this.requestApproverUsers != null) {
                this.requestApproverUsers.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B requestApproverGroup(String requestApproverGroup) {
            if (this.requestApproverGroups == null) {
                this.requestApproverGroups = new ArrayList();
            }
            this.requestApproverGroups.add(requestApproverGroup);
            return (B)this.self();
        }

        @Generated
        public B requestApproverGroups(Collection<? extends String> requestApproverGroups) {
            if (requestApproverGroups == null) {
                throw new NullPointerException("requestApproverGroups cannot be null");
            }
            if (this.requestApproverGroups == null) {
                this.requestApproverGroups = new ArrayList();
            }
            this.requestApproverGroups.addAll(requestApproverGroups);
            return (B)this.self();
        }

        @Generated
        public B clearRequestApproverGroups() {
            if (this.requestApproverGroups != null) {
                this.requestApproverGroups.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B requestApproverRole(String requestApproverRole) {
            if (this.requestApproverRoles == null) {
                this.requestApproverRoles = new ArrayList();
            }
            this.requestApproverRoles.add(requestApproverRole);
            return (B)this.self();
        }

        @Generated
        public B requestApproverRoles(Collection<? extends String> requestApproverRoles) {
            if (requestApproverRoles == null) {
                throw new NullPointerException("requestApproverRoles cannot be null");
            }
            if (this.requestApproverRoles == null) {
                this.requestApproverRoles = new ArrayList();
            }
            this.requestApproverRoles.addAll(requestApproverRoles);
            return (B)this.self();
        }

        @Generated
        public B clearRequestApproverRoles() {
            if (this.requestApproverRoles != null) {
                this.requestApproverRoles.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B requestDenyUser(String requestDenyUser) {
            if (this.requestDenyUsers == null) {
                this.requestDenyUsers = new ArrayList();
            }
            this.requestDenyUsers.add(requestDenyUser);
            return (B)this.self();
        }

        @Generated
        public B requestDenyUsers(Collection<? extends String> requestDenyUsers) {
            if (requestDenyUsers == null) {
                throw new NullPointerException("requestDenyUsers cannot be null");
            }
            if (this.requestDenyUsers == null) {
                this.requestDenyUsers = new ArrayList();
            }
            this.requestDenyUsers.addAll(requestDenyUsers);
            return (B)this.self();
        }

        @Generated
        public B clearRequestDenyUsers() {
            if (this.requestDenyUsers != null) {
                this.requestDenyUsers.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B requestDenyGroup(String requestDenyGroup) {
            if (this.requestDenyGroups == null) {
                this.requestDenyGroups = new ArrayList();
            }
            this.requestDenyGroups.add(requestDenyGroup);
            return (B)this.self();
        }

        @Generated
        public B requestDenyGroups(Collection<? extends String> requestDenyGroups) {
            if (requestDenyGroups == null) {
                throw new NullPointerException("requestDenyGroups cannot be null");
            }
            if (this.requestDenyGroups == null) {
                this.requestDenyGroups = new ArrayList();
            }
            this.requestDenyGroups.addAll(requestDenyGroups);
            return (B)this.self();
        }

        @Generated
        public B clearRequestDenyGroups() {
            if (this.requestDenyGroups != null) {
                this.requestDenyGroups.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B requestDenyRole(String requestDenyRole) {
            if (this.requestDenyRoles == null) {
                this.requestDenyRoles = new ArrayList();
            }
            this.requestDenyRoles.add(requestDenyRole);
            return (B)this.self();
        }

        @Generated
        public B requestDenyRoles(Collection<? extends String> requestDenyRoles) {
            if (requestDenyRoles == null) {
                throw new NullPointerException("requestDenyRoles cannot be null");
            }
            if (this.requestDenyRoles == null) {
                this.requestDenyRoles = new ArrayList();
            }
            this.requestDenyRoles.addAll(requestDenyRoles);
            return (B)this.self();
        }

        @Generated
        public B clearRequestDenyRoles() {
            if (this.requestDenyRoles != null) {
                this.requestDenyRoles.clear();
            }
            return (B)this.self();
        }

        @JsonIgnore
        @Generated
        public B sourceEntity(Object sourceEntity) {
            this.sourceEntity = sourceEntity;
            return (B)this.self();
        }

        @Generated
        public B destinationEntity(Asset destinationEntity) {
            this.destinationEntity = destinationEntity;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AtlanRequest.AtlanRequestBuilder(super=" + super.toString() + ", id=" + this.id + ", version=" + this.version + ", isActive=" + this.isActive + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", createdBy=" + this.createdBy + ", tenantId$value=" + this.tenantId$value + ", sourceType=" + this.sourceType + ", sourceGuid=" + this.sourceGuid + ", sourceQualifiedName=" + this.sourceQualifiedName + ", sourceAttribute=" + this.sourceAttribute + ", destinationGuid=" + this.destinationGuid + ", destinationQualifiedName=" + this.destinationQualifiedName + ", destinationAttribute=" + this.destinationAttribute + ", destinationValue=" + this.destinationValue + ", destinationValueType=" + this.destinationValueType + ", destinationValueArray=" + this.destinationValueArray + ", destinationValueObject=" + this.destinationValueObject + ", entityType=" + this.entityType + ", requestType=" + this.requestType + ", confidenceScore=" + this.confidenceScore + ", botRunId=" + this.botRunId + ", approvedBy=" + this.approvedBy + ", rejectedBy=" + this.rejectedBy + ", status=" + this.status + ", message=" + this.message + ", requestsBatch=" + this.requestsBatch + ", approvalType$value=" + this.approvalType$value + ", assignedApprovers=" + this.assignedApprovers + ", accessStartDate=" + this.accessStartDate + ", accessEndDate=" + this.accessEndDate + ", hash=" + this.hash + ", isDuplicate=" + this.isDuplicate + ", destinationValueAction=" + this.destinationValueAction + ", requestApproverUsers=" + this.requestApproverUsers + ", requestApproverGroups=" + this.requestApproverGroups + ", requestApproverRoles=" + this.requestApproverRoles + ", requestDenyUsers=" + this.requestDenyUsers + ", requestDenyGroups=" + this.requestDenyGroups + ", requestDenyRoles=" + this.requestDenyRoles + ", sourceEntity=" + this.sourceEntity + ", destinationEntity=" + this.destinationEntity + ")";
        }
    }
}

