/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.admin;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.admin.CredentialResponse;
import com.atlan.model.admin.CredentialTestResponse;
import com.atlan.model.core.AtlanObject;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;

@JsonDeserialize(builder=CredentialBuilderImpl.class)
public class Credential
extends AtlanObject {
    private static final long serialVersionUID = 2L;
    String id;
    String name;
    String host;
    Integer port;
    String authType;
    String connectorType;
    String username;
    String password;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="extra")
    Map<String, String> extras;
    String connectorConfigName;

    public static CredentialResponse get(String guid) throws AtlanException {
        return Credential.get(Atlan.getDefaultClient(), guid);
    }

    public static CredentialResponse get(AtlanClient client, String guid) throws AtlanException {
        return client.credentials.get(guid);
    }

    public CredentialResponse update() throws AtlanException {
        return this.update(Atlan.getDefaultClient());
    }

    public CredentialResponse update(AtlanClient client) throws AtlanException {
        if (this.id == null || this.id.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_TOKEN_ID);
        }
        CredentialTestResponse test = client.credentials.test(this);
        if (test.isSuccessful()) {
            return client.credentials.update(this.id, this);
        }
        throw new InvalidRequestException(ErrorCode.INVALID_CREDENTIALS, test.getMessage());
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> credential = new HashMap<String, Object>();
        if (this.name != null) {
            credential.put("name", this.name);
        }
        if (this.host != null) {
            credential.put("host", this.host);
        }
        if (this.port != null) {
            credential.put("port", this.port);
        }
        if (this.authType != null) {
            credential.put("authType", this.authType);
        }
        if (this.connectorType != null) {
            credential.put("connectorType", this.connectorType);
        }
        if (this.username != null) {
            credential.put("username", this.username);
        }
        if (this.password != null) {
            credential.put("password", this.password);
        }
        if (this.extras != null) {
            credential.put("extra", this.extras);
        }
        if (this.connectorConfigName != null) {
            credential.put("connectorConfigName", this.connectorConfigName);
        }
        return credential;
    }

    @Generated
    protected Credential(CredentialBuilder<?, ?> b) {
        super(b);
        Map<Object, Object> extras;
        this.id = b.id;
        this.name = b.name;
        this.host = b.host;
        this.port = b.port;
        this.authType = b.authType;
        this.connectorType = b.connectorType;
        this.username = b.username;
        this.password = b.password;
        switch (b.extras$key == null ? 0 : b.extras$key.size()) {
            case 0: {
                extras = Collections.emptyMap();
                break;
            }
            case 1: {
                extras = Collections.singletonMap(b.extras$key.get(0), b.extras$value.get(0));
                break;
            }
            default: {
                extras = new LinkedHashMap(b.extras$key.size() < 0x40000000 ? 1 + b.extras$key.size() + (b.extras$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.extras$key.size(); ++$i) {
                    extras.put(b.extras$key.get($i), b.extras$value.get($i));
                }
                extras = Collections.unmodifiableMap(extras);
            }
        }
        this.extras = extras;
        this.connectorConfigName = b.connectorConfigName;
    }

    @Generated
    public static CredentialBuilder<?, ?> builder() {
        return new CredentialBuilderImpl();
    }

    @Generated
    public CredentialBuilder<?, ?> toBuilder() {
        return new CredentialBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public String getAuthType() {
        return this.authType;
    }

    @Generated
    public String getConnectorType() {
        return this.connectorType;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public Map<String, String> getExtras() {
        return this.extras;
    }

    @Generated
    public String getConnectorConfigName() {
        return this.connectorConfigName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Credential)) {
            return false;
        }
        Credential other = (Credential)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$authType = this.getAuthType();
        String other$authType = other.getAuthType();
        if (this$authType == null ? other$authType != null : !this$authType.equals(other$authType)) {
            return false;
        }
        String this$connectorType = this.getConnectorType();
        String other$connectorType = other.getConnectorType();
        if (this$connectorType == null ? other$connectorType != null : !this$connectorType.equals(other$connectorType)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        Map<String, String> this$extras = this.getExtras();
        Map<String, String> other$extras = other.getExtras();
        if (this$extras == null ? other$extras != null : !((Object)this$extras).equals(other$extras)) {
            return false;
        }
        String this$connectorConfigName = this.getConnectorConfigName();
        String other$connectorConfigName = other.getConnectorConfigName();
        return !(this$connectorConfigName == null ? other$connectorConfigName != null : !this$connectorConfigName.equals(other$connectorConfigName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Credential;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $authType = this.getAuthType();
        result = result * 59 + ($authType == null ? 43 : $authType.hashCode());
        String $connectorType = this.getConnectorType();
        result = result * 59 + ($connectorType == null ? 43 : $connectorType.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        Map<String, String> $extras = this.getExtras();
        result = result * 59 + ($extras == null ? 43 : ((Object)$extras).hashCode());
        String $connectorConfigName = this.getConnectorConfigName();
        result = result * 59 + ($connectorConfigName == null ? 43 : $connectorConfigName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Credential(super=" + super.toString() + ", id=" + this.getId() + ", name=" + this.getName() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", authType=" + this.getAuthType() + ", connectorType=" + this.getConnectorType() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", extras=" + this.getExtras() + ", connectorConfigName=" + this.getConnectorConfigName() + ")";
    }

    @Generated
    public static abstract class CredentialBuilder<C extends Credential, B extends CredentialBuilder<C, B>>
    extends AtlanObject.AtlanObjectBuilder<C, B> {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private String host;
        @Generated
        private Integer port;
        @Generated
        private String authType;
        @Generated
        private String connectorType;
        @Generated
        private String username;
        @Generated
        private String password;
        @Generated
        private ArrayList<String> extras$key;
        @Generated
        private ArrayList<String> extras$value;
        @Generated
        private String connectorConfigName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CredentialBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Credential instance, CredentialBuilder<?, ?> b) {
            b.id(instance.id);
            b.name(instance.name);
            b.host(instance.host);
            b.port(instance.port);
            b.authType(instance.authType);
            b.connectorType(instance.connectorType);
            b.username(instance.username);
            b.password(instance.password);
            b.extras(instance.extras == null ? Collections.emptyMap() : instance.extras);
            b.connectorConfigName(instance.connectorConfigName);
        }

        @Generated
        public B id(String id) {
            this.id = id;
            return (B)this.self();
        }

        @Generated
        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        @Generated
        public B host(String host) {
            this.host = host;
            return (B)this.self();
        }

        @Generated
        public B port(Integer port) {
            this.port = port;
            return (B)this.self();
        }

        @Generated
        public B authType(String authType) {
            this.authType = authType;
            return (B)this.self();
        }

        @Generated
        public B connectorType(String connectorType) {
            this.connectorType = connectorType;
            return (B)this.self();
        }

        @Generated
        public B username(String username) {
            this.username = username;
            return (B)this.self();
        }

        @Generated
        public B password(String password) {
            this.password = password;
            return (B)this.self();
        }

        @Generated
        public B extra(String extraKey, String extraValue) {
            if (this.extras$key == null) {
                this.extras$key = new ArrayList();
                this.extras$value = new ArrayList();
            }
            this.extras$key.add(extraKey);
            this.extras$value.add(extraValue);
            return (B)this.self();
        }

        @JsonProperty(value="extra")
        @Generated
        public B extras(Map<? extends String, ? extends String> extras) {
            if (extras == null) {
                throw new NullPointerException("extras cannot be null");
            }
            if (this.extras$key == null) {
                this.extras$key = new ArrayList();
                this.extras$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : extras.entrySet()) {
                this.extras$key.add($lombokEntry.getKey());
                this.extras$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearExtras() {
            if (this.extras$key != null) {
                this.extras$key.clear();
                this.extras$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B connectorConfigName(String connectorConfigName) {
            this.connectorConfigName = connectorConfigName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Credential.CredentialBuilder(super=" + super.toString() + ", id=" + this.id + ", name=" + this.name + ", host=" + this.host + ", port=" + this.port + ", authType=" + this.authType + ", connectorType=" + this.connectorType + ", username=" + this.username + ", password=" + this.password + ", extras$key=" + this.extras$key + ", extras$value=" + this.extras$value + ", connectorConfigName=" + this.connectorConfigName + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class CredentialBuilderImpl
    extends CredentialBuilder<Credential, CredentialBuilderImpl> {
        @Generated
        private CredentialBuilderImpl() {
        }

        @Override
        @Generated
        protected CredentialBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Credential build() {
            return new Credential(this);
        }
    }
}

