/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.ADLSContainer;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IADLS;
import com.atlan.model.assets.IADLSContainer;
import com.atlan.model.assets.IADLSObject;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IAzure;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.ICloud;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IObjectStore;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.ADLSAccessTier;
import com.atlan.model.enums.ADLSLeaseState;
import com.atlan.model.enums.ADLSLeaseStatus;
import com.atlan.model.enums.ADLSObjectArchiveStatus;
import com.atlan.model.enums.ADLSObjectType;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.AzureTag;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ADLSObject
extends Asset
implements IADLSObject,
IADLS,
IObjectStore,
IAzure,
ICatalog,
IAsset,
IReferenceable,
ICloud {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ADLSObject.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "ADLSObject";
    String typeName;
    @Attribute
    String adlsAccountQualifiedName;
    @Attribute
    String adlsAccountSecondaryLocation;
    @Attribute
    IADLSContainer adlsContainer;
    @Attribute
    String adlsContainerQualifiedName;
    @Attribute
    ADLSAccessTier adlsObjectAccessTier;
    @Attribute
    @Date
    Long adlsObjectAccessTierLastModifiedTime;
    @Attribute
    ADLSObjectArchiveStatus adlsObjectArchiveStatus;
    @Attribute
    String adlsObjectCacheControl;
    @Attribute
    String adlsObjectContentLanguage;
    @Attribute
    String adlsObjectContentMD5Hash;
    @Attribute
    String adlsObjectContentType;
    @Attribute
    ADLSLeaseState adlsObjectLeaseState;
    @Attribute
    ADLSLeaseStatus adlsObjectLeaseStatus;
    @Attribute
    Map<String, String> adlsObjectMetadata;
    @Attribute
    Boolean adlsObjectServerEncrypted;
    @Attribute
    Long adlsObjectSize;
    @Attribute
    ADLSObjectType adlsObjectType;
    @Attribute
    String adlsObjectUrl;
    @Attribute
    String adlsObjectVersionId;
    @Attribute
    Boolean adlsObjectVersionLevelImmutabilitySupport;
    @Attribute
    String azureLocation;
    @Attribute
    String azureResourceId;
    @Attribute
    List<AzureTag> azureTags;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public ADLSObject trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return ADLSObject.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return ADLSObject.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return ADLSObject.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return ADLSObject.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return ADLSObject.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return ADLSObject.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static ADLSObject refByGuid(String guid) {
        return ADLSObject.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static ADLSObject refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((ADLSObjectBuilder)((ADLSObjectBuilder)ADLSObject._internal().guid(guid)).semantic(semantic)).build();
    }

    public static ADLSObject refByQualifiedName(String qualifiedName) {
        return ADLSObject.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static ADLSObject refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((ADLSObjectBuilder)((ADLSObjectBuilder)ADLSObject._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static ADLSObject get(String id) throws AtlanException {
        return ADLSObject.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static ADLSObject get(AtlanClient client, String id) throws AtlanException {
        return ADLSObject.get(client, id, true);
    }

    @JsonIgnore
    public static ADLSObject get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof ADLSObject) {
                return (ADLSObject)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof ADLSObject) {
            return (ADLSObject)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return ADLSObject.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static ADLSObjectBuilder<?, ?> creator(String name, ADLSContainer container) throws InvalidRequestException {
        ADLSObject.validateRelationship("ADLSContainer", Map.of("connectionQualifiedName", container.getConnectionQualifiedName(), "accountQualifiedName", container.getAdlsAccountQualifiedName(), "qualifiedName", container.getQualifiedName()));
        return ADLSObject.creator(name, container.getConnectionQualifiedName(), container.getAdlsAccountQualifiedName(), container.getQualifiedName()).adlsContainer(container.trimToReference());
    }

    public static ADLSObjectBuilder<?, ?> creator(String name, String containerQualifiedName) {
        String accountQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(containerQualifiedName);
        String connectionQualifiedName = StringUtils.getConnectionQualifiedName(containerQualifiedName);
        return ADLSObject.creator(name, connectionQualifiedName, accountQualifiedName, containerQualifiedName);
    }

    public static ADLSObjectBuilder<?, ?> creator(String name, String connectionQualifiedName, String accountQualifiedName, String containerQualifiedName) {
        return (ADLSObjectBuilder)((ADLSObjectBuilder)((Asset.AssetBuilder)((ADLSObjectBuilder)((ADLSObjectBuilder)((ADLSObjectBuilder)((ADLSObjectBuilder)ADLSObject._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(ADLSObject.generateQualifiedName(name, containerQualifiedName))).name(name)).adlsContainer(ADLSContainer.refByQualifiedName(containerQualifiedName))).adlsAccountQualifiedName(accountQualifiedName)).connectionQualifiedName(connectionQualifiedName)).connectorType(AtlanConnectorType.ADLS);
    }

    public static String generateQualifiedName(String name, String containerQualifiedName) {
        return containerQualifiedName + "/" + name;
    }

    public static ADLSObjectBuilder<?, ?> updater(String qualifiedName, String name) {
        return (ADLSObjectBuilder)((ADLSObjectBuilder)((ADLSObjectBuilder)ADLSObject._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public ADLSObjectBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ADLSObject.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return ADLSObject.updater(this.getQualifiedName(), this.getName());
    }

    public static ADLSObject removeDescription(String qualifiedName, String name) throws AtlanException {
        return ADLSObject.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ADLSObject removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ADLSObject)Asset.removeDescription(client, ADLSObject.updater(qualifiedName, name));
    }

    public static ADLSObject removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return ADLSObject.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ADLSObject removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ADLSObject)Asset.removeUserDescription(client, ADLSObject.updater(qualifiedName, name));
    }

    public static ADLSObject removeOwners(String qualifiedName, String name) throws AtlanException {
        return ADLSObject.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ADLSObject removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ADLSObject)Asset.removeOwners(client, ADLSObject.updater(qualifiedName, name));
    }

    public static ADLSObject updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return ADLSObject.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static ADLSObject updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (ADLSObject)Asset.updateCertificate(client, ADLSObject._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static ADLSObject removeCertificate(String qualifiedName, String name) throws AtlanException {
        return ADLSObject.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ADLSObject removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ADLSObject)Asset.removeCertificate(client, ADLSObject.updater(qualifiedName, name));
    }

    public static ADLSObject updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return ADLSObject.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static ADLSObject updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (ADLSObject)Asset.updateAnnouncement(client, ADLSObject._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static ADLSObject removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return ADLSObject.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ADLSObject removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ADLSObject)Asset.removeAnnouncement(client, ADLSObject.updater(qualifiedName, name));
    }

    public static ADLSObject replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return ADLSObject.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static ADLSObject replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (ADLSObject)Asset.replaceTerms(client, ADLSObject.updater(qualifiedName, name), terms);
    }

    public static ADLSObject appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return ADLSObject.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static ADLSObject appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ADLSObject)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static ADLSObject removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return ADLSObject.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static ADLSObject removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ADLSObject)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static ADLSObject appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return ADLSObject.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static ADLSObject appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (ADLSObject)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static ADLSObject appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return ADLSObject.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static ADLSObject appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (ADLSObject)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        ADLSObject.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected ADLSObject(ADLSObjectBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> adlsObjectMetadata;
        this.typeName = b.typeName$set ? b.typeName$value : ADLSObject.$default$typeName();
        this.adlsAccountQualifiedName = b.adlsAccountQualifiedName;
        this.adlsAccountSecondaryLocation = b.adlsAccountSecondaryLocation;
        this.adlsContainer = b.adlsContainer;
        this.adlsContainerQualifiedName = b.adlsContainerQualifiedName;
        this.adlsObjectAccessTier = b.adlsObjectAccessTier;
        this.adlsObjectAccessTierLastModifiedTime = b.adlsObjectAccessTierLastModifiedTime;
        this.adlsObjectArchiveStatus = b.adlsObjectArchiveStatus;
        this.adlsObjectCacheControl = b.adlsObjectCacheControl;
        this.adlsObjectContentLanguage = b.adlsObjectContentLanguage;
        this.adlsObjectContentMD5Hash = b.adlsObjectContentMD5Hash;
        this.adlsObjectContentType = b.adlsObjectContentType;
        this.adlsObjectLeaseState = b.adlsObjectLeaseState;
        this.adlsObjectLeaseStatus = b.adlsObjectLeaseStatus;
        switch (b.adlsObjectMetadata$key == null ? 0 : b.adlsObjectMetadata$key.size()) {
            case 0: {
                adlsObjectMetadata = Collections.emptyMap();
                break;
            }
            case 1: {
                adlsObjectMetadata = Collections.singletonMap(b.adlsObjectMetadata$key.get(0), b.adlsObjectMetadata$value.get(0));
                break;
            }
            default: {
                adlsObjectMetadata = new LinkedHashMap(b.adlsObjectMetadata$key.size() < 0x40000000 ? 1 + b.adlsObjectMetadata$key.size() + (b.adlsObjectMetadata$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.adlsObjectMetadata$key.size(); ++$i) {
                    adlsObjectMetadata.put(b.adlsObjectMetadata$key.get($i), b.adlsObjectMetadata$value.get($i));
                }
                adlsObjectMetadata = Collections.unmodifiableMap(adlsObjectMetadata);
            }
        }
        this.adlsObjectMetadata = adlsObjectMetadata;
        this.adlsObjectServerEncrypted = b.adlsObjectServerEncrypted;
        this.adlsObjectSize = b.adlsObjectSize;
        this.adlsObjectType = b.adlsObjectType;
        this.adlsObjectUrl = b.adlsObjectUrl;
        this.adlsObjectVersionId = b.adlsObjectVersionId;
        this.adlsObjectVersionLevelImmutabilitySupport = b.adlsObjectVersionLevelImmutabilitySupport;
        this.azureLocation = b.azureLocation;
        this.azureResourceId = b.azureResourceId;
        this.azureTags = switch (b.azureTags == null ? 0 : b.azureTags.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.azureTags.get(0));
            default -> Collections.unmodifiableList(new ArrayList<AzureTag>(b.azureTags));
        };
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static ADLSObjectBuilder<?, ?> _internal() {
        return new ADLSObjectBuilderImpl();
    }

    @Generated
    public ADLSObjectBuilder<?, ?> toBuilder() {
        return new ADLSObjectBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getAdlsAccountQualifiedName() {
        return this.adlsAccountQualifiedName;
    }

    @Override
    @Generated
    public String getAdlsAccountSecondaryLocation() {
        return this.adlsAccountSecondaryLocation;
    }

    @Override
    @Generated
    public IADLSContainer getAdlsContainer() {
        return this.adlsContainer;
    }

    @Override
    @Generated
    public String getAdlsContainerQualifiedName() {
        return this.adlsContainerQualifiedName;
    }

    @Override
    @Generated
    public ADLSAccessTier getAdlsObjectAccessTier() {
        return this.adlsObjectAccessTier;
    }

    @Override
    @Generated
    public Long getAdlsObjectAccessTierLastModifiedTime() {
        return this.adlsObjectAccessTierLastModifiedTime;
    }

    @Override
    @Generated
    public ADLSObjectArchiveStatus getAdlsObjectArchiveStatus() {
        return this.adlsObjectArchiveStatus;
    }

    @Override
    @Generated
    public String getAdlsObjectCacheControl() {
        return this.adlsObjectCacheControl;
    }

    @Override
    @Generated
    public String getAdlsObjectContentLanguage() {
        return this.adlsObjectContentLanguage;
    }

    @Override
    @Generated
    public String getAdlsObjectContentMD5Hash() {
        return this.adlsObjectContentMD5Hash;
    }

    @Override
    @Generated
    public String getAdlsObjectContentType() {
        return this.adlsObjectContentType;
    }

    @Override
    @Generated
    public ADLSLeaseState getAdlsObjectLeaseState() {
        return this.adlsObjectLeaseState;
    }

    @Override
    @Generated
    public ADLSLeaseStatus getAdlsObjectLeaseStatus() {
        return this.adlsObjectLeaseStatus;
    }

    @Override
    @Generated
    public Map<String, String> getAdlsObjectMetadata() {
        return this.adlsObjectMetadata;
    }

    @Override
    @Generated
    public Boolean getAdlsObjectServerEncrypted() {
        return this.adlsObjectServerEncrypted;
    }

    @Override
    @Generated
    public Long getAdlsObjectSize() {
        return this.adlsObjectSize;
    }

    @Override
    @Generated
    public ADLSObjectType getAdlsObjectType() {
        return this.adlsObjectType;
    }

    @Override
    @Generated
    public String getAdlsObjectUrl() {
        return this.adlsObjectUrl;
    }

    @Override
    @Generated
    public String getAdlsObjectVersionId() {
        return this.adlsObjectVersionId;
    }

    @Override
    @Generated
    public Boolean getAdlsObjectVersionLevelImmutabilitySupport() {
        return this.adlsObjectVersionLevelImmutabilitySupport;
    }

    @Override
    @Generated
    public String getAzureLocation() {
        return this.azureLocation;
    }

    @Override
    @Generated
    public String getAzureResourceId() {
        return this.azureResourceId;
    }

    @Override
    @Generated
    public List<AzureTag> getAzureTags() {
        return this.azureTags;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ADLSObject)) {
            return false;
        }
        ADLSObject other = (ADLSObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$adlsObjectAccessTierLastModifiedTime = this.getAdlsObjectAccessTierLastModifiedTime();
        Long other$adlsObjectAccessTierLastModifiedTime = other.getAdlsObjectAccessTierLastModifiedTime();
        if (this$adlsObjectAccessTierLastModifiedTime == null ? other$adlsObjectAccessTierLastModifiedTime != null : !((Object)this$adlsObjectAccessTierLastModifiedTime).equals(other$adlsObjectAccessTierLastModifiedTime)) {
            return false;
        }
        Boolean this$adlsObjectServerEncrypted = this.getAdlsObjectServerEncrypted();
        Boolean other$adlsObjectServerEncrypted = other.getAdlsObjectServerEncrypted();
        if (this$adlsObjectServerEncrypted == null ? other$adlsObjectServerEncrypted != null : !((Object)this$adlsObjectServerEncrypted).equals(other$adlsObjectServerEncrypted)) {
            return false;
        }
        Long this$adlsObjectSize = this.getAdlsObjectSize();
        Long other$adlsObjectSize = other.getAdlsObjectSize();
        if (this$adlsObjectSize == null ? other$adlsObjectSize != null : !((Object)this$adlsObjectSize).equals(other$adlsObjectSize)) {
            return false;
        }
        Boolean this$adlsObjectVersionLevelImmutabilitySupport = this.getAdlsObjectVersionLevelImmutabilitySupport();
        Boolean other$adlsObjectVersionLevelImmutabilitySupport = other.getAdlsObjectVersionLevelImmutabilitySupport();
        if (this$adlsObjectVersionLevelImmutabilitySupport == null ? other$adlsObjectVersionLevelImmutabilitySupport != null : !((Object)this$adlsObjectVersionLevelImmutabilitySupport).equals(other$adlsObjectVersionLevelImmutabilitySupport)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$adlsAccountQualifiedName = this.getAdlsAccountQualifiedName();
        String other$adlsAccountQualifiedName = other.getAdlsAccountQualifiedName();
        if (this$adlsAccountQualifiedName == null ? other$adlsAccountQualifiedName != null : !this$adlsAccountQualifiedName.equals(other$adlsAccountQualifiedName)) {
            return false;
        }
        String this$adlsAccountSecondaryLocation = this.getAdlsAccountSecondaryLocation();
        String other$adlsAccountSecondaryLocation = other.getAdlsAccountSecondaryLocation();
        if (this$adlsAccountSecondaryLocation == null ? other$adlsAccountSecondaryLocation != null : !this$adlsAccountSecondaryLocation.equals(other$adlsAccountSecondaryLocation)) {
            return false;
        }
        IADLSContainer this$adlsContainer = this.getAdlsContainer();
        IADLSContainer other$adlsContainer = other.getAdlsContainer();
        if (this$adlsContainer == null ? other$adlsContainer != null : !this$adlsContainer.equals(other$adlsContainer)) {
            return false;
        }
        String this$adlsContainerQualifiedName = this.getAdlsContainerQualifiedName();
        String other$adlsContainerQualifiedName = other.getAdlsContainerQualifiedName();
        if (this$adlsContainerQualifiedName == null ? other$adlsContainerQualifiedName != null : !this$adlsContainerQualifiedName.equals(other$adlsContainerQualifiedName)) {
            return false;
        }
        ADLSAccessTier this$adlsObjectAccessTier = this.getAdlsObjectAccessTier();
        ADLSAccessTier other$adlsObjectAccessTier = other.getAdlsObjectAccessTier();
        if (this$adlsObjectAccessTier == null ? other$adlsObjectAccessTier != null : !this$adlsObjectAccessTier.equals(other$adlsObjectAccessTier)) {
            return false;
        }
        ADLSObjectArchiveStatus this$adlsObjectArchiveStatus = this.getAdlsObjectArchiveStatus();
        ADLSObjectArchiveStatus other$adlsObjectArchiveStatus = other.getAdlsObjectArchiveStatus();
        if (this$adlsObjectArchiveStatus == null ? other$adlsObjectArchiveStatus != null : !this$adlsObjectArchiveStatus.equals(other$adlsObjectArchiveStatus)) {
            return false;
        }
        String this$adlsObjectCacheControl = this.getAdlsObjectCacheControl();
        String other$adlsObjectCacheControl = other.getAdlsObjectCacheControl();
        if (this$adlsObjectCacheControl == null ? other$adlsObjectCacheControl != null : !this$adlsObjectCacheControl.equals(other$adlsObjectCacheControl)) {
            return false;
        }
        String this$adlsObjectContentLanguage = this.getAdlsObjectContentLanguage();
        String other$adlsObjectContentLanguage = other.getAdlsObjectContentLanguage();
        if (this$adlsObjectContentLanguage == null ? other$adlsObjectContentLanguage != null : !this$adlsObjectContentLanguage.equals(other$adlsObjectContentLanguage)) {
            return false;
        }
        String this$adlsObjectContentMD5Hash = this.getAdlsObjectContentMD5Hash();
        String other$adlsObjectContentMD5Hash = other.getAdlsObjectContentMD5Hash();
        if (this$adlsObjectContentMD5Hash == null ? other$adlsObjectContentMD5Hash != null : !this$adlsObjectContentMD5Hash.equals(other$adlsObjectContentMD5Hash)) {
            return false;
        }
        String this$adlsObjectContentType = this.getAdlsObjectContentType();
        String other$adlsObjectContentType = other.getAdlsObjectContentType();
        if (this$adlsObjectContentType == null ? other$adlsObjectContentType != null : !this$adlsObjectContentType.equals(other$adlsObjectContentType)) {
            return false;
        }
        ADLSLeaseState this$adlsObjectLeaseState = this.getAdlsObjectLeaseState();
        ADLSLeaseState other$adlsObjectLeaseState = other.getAdlsObjectLeaseState();
        if (this$adlsObjectLeaseState == null ? other$adlsObjectLeaseState != null : !this$adlsObjectLeaseState.equals(other$adlsObjectLeaseState)) {
            return false;
        }
        ADLSLeaseStatus this$adlsObjectLeaseStatus = this.getAdlsObjectLeaseStatus();
        ADLSLeaseStatus other$adlsObjectLeaseStatus = other.getAdlsObjectLeaseStatus();
        if (this$adlsObjectLeaseStatus == null ? other$adlsObjectLeaseStatus != null : !this$adlsObjectLeaseStatus.equals(other$adlsObjectLeaseStatus)) {
            return false;
        }
        Map<String, String> this$adlsObjectMetadata = this.getAdlsObjectMetadata();
        Map<String, String> other$adlsObjectMetadata = other.getAdlsObjectMetadata();
        if (this$adlsObjectMetadata == null ? other$adlsObjectMetadata != null : !((Object)this$adlsObjectMetadata).equals(other$adlsObjectMetadata)) {
            return false;
        }
        ADLSObjectType this$adlsObjectType = this.getAdlsObjectType();
        ADLSObjectType other$adlsObjectType = other.getAdlsObjectType();
        if (this$adlsObjectType == null ? other$adlsObjectType != null : !this$adlsObjectType.equals(other$adlsObjectType)) {
            return false;
        }
        String this$adlsObjectUrl = this.getAdlsObjectUrl();
        String other$adlsObjectUrl = other.getAdlsObjectUrl();
        if (this$adlsObjectUrl == null ? other$adlsObjectUrl != null : !this$adlsObjectUrl.equals(other$adlsObjectUrl)) {
            return false;
        }
        String this$adlsObjectVersionId = this.getAdlsObjectVersionId();
        String other$adlsObjectVersionId = other.getAdlsObjectVersionId();
        if (this$adlsObjectVersionId == null ? other$adlsObjectVersionId != null : !this$adlsObjectVersionId.equals(other$adlsObjectVersionId)) {
            return false;
        }
        String this$azureLocation = this.getAzureLocation();
        String other$azureLocation = other.getAzureLocation();
        if (this$azureLocation == null ? other$azureLocation != null : !this$azureLocation.equals(other$azureLocation)) {
            return false;
        }
        String this$azureResourceId = this.getAzureResourceId();
        String other$azureResourceId = other.getAzureResourceId();
        if (this$azureResourceId == null ? other$azureResourceId != null : !this$azureResourceId.equals(other$azureResourceId)) {
            return false;
        }
        List<AzureTag> this$azureTags = this.getAzureTags();
        List<AzureTag> other$azureTags = other.getAzureTags();
        if (this$azureTags == null ? other$azureTags != null : !((Object)this$azureTags).equals(other$azureTags)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ADLSObject;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $adlsObjectAccessTierLastModifiedTime = this.getAdlsObjectAccessTierLastModifiedTime();
        result = result * 59 + ($adlsObjectAccessTierLastModifiedTime == null ? 43 : ((Object)$adlsObjectAccessTierLastModifiedTime).hashCode());
        Boolean $adlsObjectServerEncrypted = this.getAdlsObjectServerEncrypted();
        result = result * 59 + ($adlsObjectServerEncrypted == null ? 43 : ((Object)$adlsObjectServerEncrypted).hashCode());
        Long $adlsObjectSize = this.getAdlsObjectSize();
        result = result * 59 + ($adlsObjectSize == null ? 43 : ((Object)$adlsObjectSize).hashCode());
        Boolean $adlsObjectVersionLevelImmutabilitySupport = this.getAdlsObjectVersionLevelImmutabilitySupport();
        result = result * 59 + ($adlsObjectVersionLevelImmutabilitySupport == null ? 43 : ((Object)$adlsObjectVersionLevelImmutabilitySupport).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $adlsAccountQualifiedName = this.getAdlsAccountQualifiedName();
        result = result * 59 + ($adlsAccountQualifiedName == null ? 43 : $adlsAccountQualifiedName.hashCode());
        String $adlsAccountSecondaryLocation = this.getAdlsAccountSecondaryLocation();
        result = result * 59 + ($adlsAccountSecondaryLocation == null ? 43 : $adlsAccountSecondaryLocation.hashCode());
        IADLSContainer $adlsContainer = this.getAdlsContainer();
        result = result * 59 + ($adlsContainer == null ? 43 : $adlsContainer.hashCode());
        String $adlsContainerQualifiedName = this.getAdlsContainerQualifiedName();
        result = result * 59 + ($adlsContainerQualifiedName == null ? 43 : $adlsContainerQualifiedName.hashCode());
        ADLSAccessTier $adlsObjectAccessTier = this.getAdlsObjectAccessTier();
        result = result * 59 + ($adlsObjectAccessTier == null ? 43 : $adlsObjectAccessTier.hashCode());
        ADLSObjectArchiveStatus $adlsObjectArchiveStatus = this.getAdlsObjectArchiveStatus();
        result = result * 59 + ($adlsObjectArchiveStatus == null ? 43 : $adlsObjectArchiveStatus.hashCode());
        String $adlsObjectCacheControl = this.getAdlsObjectCacheControl();
        result = result * 59 + ($adlsObjectCacheControl == null ? 43 : $adlsObjectCacheControl.hashCode());
        String $adlsObjectContentLanguage = this.getAdlsObjectContentLanguage();
        result = result * 59 + ($adlsObjectContentLanguage == null ? 43 : $adlsObjectContentLanguage.hashCode());
        String $adlsObjectContentMD5Hash = this.getAdlsObjectContentMD5Hash();
        result = result * 59 + ($adlsObjectContentMD5Hash == null ? 43 : $adlsObjectContentMD5Hash.hashCode());
        String $adlsObjectContentType = this.getAdlsObjectContentType();
        result = result * 59 + ($adlsObjectContentType == null ? 43 : $adlsObjectContentType.hashCode());
        ADLSLeaseState $adlsObjectLeaseState = this.getAdlsObjectLeaseState();
        result = result * 59 + ($adlsObjectLeaseState == null ? 43 : $adlsObjectLeaseState.hashCode());
        ADLSLeaseStatus $adlsObjectLeaseStatus = this.getAdlsObjectLeaseStatus();
        result = result * 59 + ($adlsObjectLeaseStatus == null ? 43 : $adlsObjectLeaseStatus.hashCode());
        Map<String, String> $adlsObjectMetadata = this.getAdlsObjectMetadata();
        result = result * 59 + ($adlsObjectMetadata == null ? 43 : ((Object)$adlsObjectMetadata).hashCode());
        ADLSObjectType $adlsObjectType = this.getAdlsObjectType();
        result = result * 59 + ($adlsObjectType == null ? 43 : $adlsObjectType.hashCode());
        String $adlsObjectUrl = this.getAdlsObjectUrl();
        result = result * 59 + ($adlsObjectUrl == null ? 43 : $adlsObjectUrl.hashCode());
        String $adlsObjectVersionId = this.getAdlsObjectVersionId();
        result = result * 59 + ($adlsObjectVersionId == null ? 43 : $adlsObjectVersionId.hashCode());
        String $azureLocation = this.getAzureLocation();
        result = result * 59 + ($azureLocation == null ? 43 : $azureLocation.hashCode());
        String $azureResourceId = this.getAzureResourceId();
        result = result * 59 + ($azureResourceId == null ? 43 : $azureResourceId.hashCode());
        List<AzureTag> $azureTags = this.getAzureTags();
        result = result * 59 + ($azureTags == null ? 43 : ((Object)$azureTags).hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ADLSObject(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", adlsAccountQualifiedName=" + this.getAdlsAccountQualifiedName() + ", adlsAccountSecondaryLocation=" + this.getAdlsAccountSecondaryLocation() + ", adlsContainer=" + this.getAdlsContainer() + ", adlsContainerQualifiedName=" + this.getAdlsContainerQualifiedName() + ", adlsObjectAccessTier=" + this.getAdlsObjectAccessTier() + ", adlsObjectAccessTierLastModifiedTime=" + this.getAdlsObjectAccessTierLastModifiedTime() + ", adlsObjectArchiveStatus=" + this.getAdlsObjectArchiveStatus() + ", adlsObjectCacheControl=" + this.getAdlsObjectCacheControl() + ", adlsObjectContentLanguage=" + this.getAdlsObjectContentLanguage() + ", adlsObjectContentMD5Hash=" + this.getAdlsObjectContentMD5Hash() + ", adlsObjectContentType=" + this.getAdlsObjectContentType() + ", adlsObjectLeaseState=" + this.getAdlsObjectLeaseState() + ", adlsObjectLeaseStatus=" + this.getAdlsObjectLeaseStatus() + ", adlsObjectMetadata=" + this.getAdlsObjectMetadata() + ", adlsObjectServerEncrypted=" + this.getAdlsObjectServerEncrypted() + ", adlsObjectSize=" + this.getAdlsObjectSize() + ", adlsObjectType=" + this.getAdlsObjectType() + ", adlsObjectUrl=" + this.getAdlsObjectUrl() + ", adlsObjectVersionId=" + this.getAdlsObjectVersionId() + ", adlsObjectVersionLevelImmutabilitySupport=" + this.getAdlsObjectVersionLevelImmutabilitySupport() + ", azureLocation=" + this.getAzureLocation() + ", azureResourceId=" + this.getAzureResourceId() + ", azureTags=" + this.getAzureTags() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class ADLSObjectBuilder<C extends ADLSObject, B extends ADLSObjectBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String adlsAccountQualifiedName;
        @Generated
        private String adlsAccountSecondaryLocation;
        @Generated
        private IADLSContainer adlsContainer;
        @Generated
        private String adlsContainerQualifiedName;
        @Generated
        private ADLSAccessTier adlsObjectAccessTier;
        @Generated
        private Long adlsObjectAccessTierLastModifiedTime;
        @Generated
        private ADLSObjectArchiveStatus adlsObjectArchiveStatus;
        @Generated
        private String adlsObjectCacheControl;
        @Generated
        private String adlsObjectContentLanguage;
        @Generated
        private String adlsObjectContentMD5Hash;
        @Generated
        private String adlsObjectContentType;
        @Generated
        private ADLSLeaseState adlsObjectLeaseState;
        @Generated
        private ADLSLeaseStatus adlsObjectLeaseStatus;
        @Generated
        private ArrayList<String> adlsObjectMetadata$key;
        @Generated
        private ArrayList<String> adlsObjectMetadata$value;
        @Generated
        private Boolean adlsObjectServerEncrypted;
        @Generated
        private Long adlsObjectSize;
        @Generated
        private ADLSObjectType adlsObjectType;
        @Generated
        private String adlsObjectUrl;
        @Generated
        private String adlsObjectVersionId;
        @Generated
        private Boolean adlsObjectVersionLevelImmutabilitySupport;
        @Generated
        private String azureLocation;
        @Generated
        private String azureResourceId;
        @Generated
        private ArrayList<AzureTag> azureTags;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ADLSObjectBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ADLSObject instance, ADLSObjectBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.adlsAccountQualifiedName(instance.adlsAccountQualifiedName);
            b.adlsAccountSecondaryLocation(instance.adlsAccountSecondaryLocation);
            b.adlsContainer(instance.adlsContainer);
            b.adlsContainerQualifiedName(instance.adlsContainerQualifiedName);
            b.adlsObjectAccessTier(instance.adlsObjectAccessTier);
            b.adlsObjectAccessTierLastModifiedTime(instance.adlsObjectAccessTierLastModifiedTime);
            b.adlsObjectArchiveStatus(instance.adlsObjectArchiveStatus);
            b.adlsObjectCacheControl(instance.adlsObjectCacheControl);
            b.adlsObjectContentLanguage(instance.adlsObjectContentLanguage);
            b.adlsObjectContentMD5Hash(instance.adlsObjectContentMD5Hash);
            b.adlsObjectContentType(instance.adlsObjectContentType);
            b.adlsObjectLeaseState(instance.adlsObjectLeaseState);
            b.adlsObjectLeaseStatus(instance.adlsObjectLeaseStatus);
            b.adlsObjectMetadata(instance.adlsObjectMetadata == null ? Collections.emptyMap() : instance.adlsObjectMetadata);
            b.adlsObjectServerEncrypted(instance.adlsObjectServerEncrypted);
            b.adlsObjectSize(instance.adlsObjectSize);
            b.adlsObjectType(instance.adlsObjectType);
            b.adlsObjectUrl(instance.adlsObjectUrl);
            b.adlsObjectVersionId(instance.adlsObjectVersionId);
            b.adlsObjectVersionLevelImmutabilitySupport(instance.adlsObjectVersionLevelImmutabilitySupport);
            b.azureLocation(instance.azureLocation);
            b.azureResourceId(instance.azureResourceId);
            b.azureTags(instance.azureTags == null ? Collections.emptyList() : instance.azureTags);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B adlsAccountQualifiedName(String adlsAccountQualifiedName) {
            this.adlsAccountQualifiedName = adlsAccountQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B adlsAccountSecondaryLocation(String adlsAccountSecondaryLocation) {
            this.adlsAccountSecondaryLocation = adlsAccountSecondaryLocation;
            return (B)this.self();
        }

        @Generated
        public B adlsContainer(IADLSContainer adlsContainer) {
            this.adlsContainer = adlsContainer;
            return (B)this.self();
        }

        @Generated
        public B adlsContainerQualifiedName(String adlsContainerQualifiedName) {
            this.adlsContainerQualifiedName = adlsContainerQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B adlsObjectAccessTier(ADLSAccessTier adlsObjectAccessTier) {
            this.adlsObjectAccessTier = adlsObjectAccessTier;
            return (B)this.self();
        }

        @Generated
        public B adlsObjectAccessTierLastModifiedTime(Long adlsObjectAccessTierLastModifiedTime) {
            this.adlsObjectAccessTierLastModifiedTime = adlsObjectAccessTierLastModifiedTime;
            return (B)this.self();
        }

        @Generated
        public B adlsObjectArchiveStatus(ADLSObjectArchiveStatus adlsObjectArchiveStatus) {
            this.adlsObjectArchiveStatus = adlsObjectArchiveStatus;
            return (B)this.self();
        }

        @Generated
        public B adlsObjectCacheControl(String adlsObjectCacheControl) {
            this.adlsObjectCacheControl = adlsObjectCacheControl;
            return (B)this.self();
        }

        @Generated
        public B adlsObjectContentLanguage(String adlsObjectContentLanguage) {
            this.adlsObjectContentLanguage = adlsObjectContentLanguage;
            return (B)this.self();
        }

        @Generated
        public B adlsObjectContentMD5Hash(String adlsObjectContentMD5Hash) {
            this.adlsObjectContentMD5Hash = adlsObjectContentMD5Hash;
            return (B)this.self();
        }

        @Generated
        public B adlsObjectContentType(String adlsObjectContentType) {
            this.adlsObjectContentType = adlsObjectContentType;
            return (B)this.self();
        }

        @Generated
        public B adlsObjectLeaseState(ADLSLeaseState adlsObjectLeaseState) {
            this.adlsObjectLeaseState = adlsObjectLeaseState;
            return (B)this.self();
        }

        @Generated
        public B adlsObjectLeaseStatus(ADLSLeaseStatus adlsObjectLeaseStatus) {
            this.adlsObjectLeaseStatus = adlsObjectLeaseStatus;
            return (B)this.self();
        }

        @Generated
        public B putAdlsObjectMetadata(String putAdlsObjectMetadataKey, String putAdlsObjectMetadataValue) {
            if (this.adlsObjectMetadata$key == null) {
                this.adlsObjectMetadata$key = new ArrayList();
                this.adlsObjectMetadata$value = new ArrayList();
            }
            this.adlsObjectMetadata$key.add(putAdlsObjectMetadataKey);
            this.adlsObjectMetadata$value.add(putAdlsObjectMetadataValue);
            return (B)this.self();
        }

        @Generated
        public B adlsObjectMetadata(Map<? extends String, ? extends String> adlsObjectMetadata) {
            if (adlsObjectMetadata == null) {
                throw new NullPointerException("adlsObjectMetadata cannot be null");
            }
            if (this.adlsObjectMetadata$key == null) {
                this.adlsObjectMetadata$key = new ArrayList();
                this.adlsObjectMetadata$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : adlsObjectMetadata.entrySet()) {
                this.adlsObjectMetadata$key.add($lombokEntry.getKey());
                this.adlsObjectMetadata$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearAdlsObjectMetadata() {
            if (this.adlsObjectMetadata$key != null) {
                this.adlsObjectMetadata$key.clear();
                this.adlsObjectMetadata$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B adlsObjectServerEncrypted(Boolean adlsObjectServerEncrypted) {
            this.adlsObjectServerEncrypted = adlsObjectServerEncrypted;
            return (B)this.self();
        }

        @Generated
        public B adlsObjectSize(Long adlsObjectSize) {
            this.adlsObjectSize = adlsObjectSize;
            return (B)this.self();
        }

        @Generated
        public B adlsObjectType(ADLSObjectType adlsObjectType) {
            this.adlsObjectType = adlsObjectType;
            return (B)this.self();
        }

        @Generated
        public B adlsObjectUrl(String adlsObjectUrl) {
            this.adlsObjectUrl = adlsObjectUrl;
            return (B)this.self();
        }

        @Generated
        public B adlsObjectVersionId(String adlsObjectVersionId) {
            this.adlsObjectVersionId = adlsObjectVersionId;
            return (B)this.self();
        }

        @Generated
        public B adlsObjectVersionLevelImmutabilitySupport(Boolean adlsObjectVersionLevelImmutabilitySupport) {
            this.adlsObjectVersionLevelImmutabilitySupport = adlsObjectVersionLevelImmutabilitySupport;
            return (B)this.self();
        }

        @Generated
        public B azureLocation(String azureLocation) {
            this.azureLocation = azureLocation;
            return (B)this.self();
        }

        @Generated
        public B azureResourceId(String azureResourceId) {
            this.azureResourceId = azureResourceId;
            return (B)this.self();
        }

        @Generated
        public B azureTag(AzureTag azureTag) {
            if (this.azureTags == null) {
                this.azureTags = new ArrayList();
            }
            this.azureTags.add(azureTag);
            return (B)this.self();
        }

        @Generated
        public B azureTags(Collection<? extends AzureTag> azureTags) {
            if (azureTags == null) {
                throw new NullPointerException("azureTags cannot be null");
            }
            if (this.azureTags == null) {
                this.azureTags = new ArrayList();
            }
            this.azureTags.addAll(azureTags);
            return (B)this.self();
        }

        @Generated
        public B clearAzureTags() {
            if (this.azureTags != null) {
                this.azureTags.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ADLSObject.ADLSObjectBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", adlsAccountQualifiedName=" + this.adlsAccountQualifiedName + ", adlsAccountSecondaryLocation=" + this.adlsAccountSecondaryLocation + ", adlsContainer=" + this.adlsContainer + ", adlsContainerQualifiedName=" + this.adlsContainerQualifiedName + ", adlsObjectAccessTier=" + this.adlsObjectAccessTier + ", adlsObjectAccessTierLastModifiedTime=" + this.adlsObjectAccessTierLastModifiedTime + ", adlsObjectArchiveStatus=" + this.adlsObjectArchiveStatus + ", adlsObjectCacheControl=" + this.adlsObjectCacheControl + ", adlsObjectContentLanguage=" + this.adlsObjectContentLanguage + ", adlsObjectContentMD5Hash=" + this.adlsObjectContentMD5Hash + ", adlsObjectContentType=" + this.adlsObjectContentType + ", adlsObjectLeaseState=" + this.adlsObjectLeaseState + ", adlsObjectLeaseStatus=" + this.adlsObjectLeaseStatus + ", adlsObjectMetadata$key=" + this.adlsObjectMetadata$key + ", adlsObjectMetadata$value=" + this.adlsObjectMetadata$value + ", adlsObjectServerEncrypted=" + this.adlsObjectServerEncrypted + ", adlsObjectSize=" + this.adlsObjectSize + ", adlsObjectType=" + this.adlsObjectType + ", adlsObjectUrl=" + this.adlsObjectUrl + ", adlsObjectVersionId=" + this.adlsObjectVersionId + ", adlsObjectVersionLevelImmutabilitySupport=" + this.adlsObjectVersionLevelImmutabilitySupport + ", azureLocation=" + this.azureLocation + ", azureResourceId=" + this.azureResourceId + ", azureTags=" + this.azureTags + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }

    @Generated
    private static final class ADLSObjectBuilderImpl
    extends ADLSObjectBuilder<ADLSObject, ADLSObjectBuilderImpl> {
        @Generated
        private ADLSObjectBuilderImpl() {
        }

        @Override
        @Generated
        protected ADLSObjectBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ADLSObject build() {
            return new ADLSObject(this);
        }
    }
}

