/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBusinessPolicy;
import com.atlan.model.assets.IBusinessPolicyException;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessPolicy
extends Asset
implements IBusinessPolicy,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BusinessPolicy.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "BusinessPolicy";
    String typeName;
    @Attribute
    String businessPolicyBaseParentGuid;
    @Attribute
    String businessPolicyFilterDSL;
    @Attribute
    String businessPolicyLongDescription;
    @Attribute
    String businessPolicyReviewPeriod;
    @Attribute
    String businessPolicySelectedApprovalWF;
    @Attribute
    String businessPolicyType;
    @Attribute
    @Date
    Long businessPolicyValidFrom;
    @Attribute
    @Date
    Long businessPolicyValidTill;
    @Attribute
    Integer businessPolicyVersion;
    @Attribute
    SortedSet<IBusinessPolicyException> exceptionsForBusinessPolicy;
    @Attribute
    SortedSet<IBusinessPolicy> relatedBusinessPolicies;

    @Override
    public BusinessPolicy trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return BusinessPolicy.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return BusinessPolicy.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return BusinessPolicy.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return BusinessPolicy.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return BusinessPolicy.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return BusinessPolicy.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static BusinessPolicy refByGuid(String guid) {
        return BusinessPolicy.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static BusinessPolicy refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((BusinessPolicyBuilder)((BusinessPolicyBuilder)BusinessPolicy._internal().guid(guid)).semantic(semantic)).build();
    }

    public static BusinessPolicy refByQualifiedName(String qualifiedName) {
        return BusinessPolicy.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static BusinessPolicy refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((BusinessPolicyBuilder)((BusinessPolicyBuilder)BusinessPolicy._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static BusinessPolicy get(String id) throws AtlanException {
        return BusinessPolicy.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static BusinessPolicy get(AtlanClient client, String id) throws AtlanException {
        return BusinessPolicy.get(client, id, true);
    }

    @JsonIgnore
    public static BusinessPolicy get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof BusinessPolicy) {
                return (BusinessPolicy)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof BusinessPolicy) {
            return (BusinessPolicy)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return BusinessPolicy.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static BusinessPolicyBuilder<?, ?> updater(String qualifiedName, String name) {
        return (BusinessPolicyBuilder)((BusinessPolicyBuilder)((BusinessPolicyBuilder)BusinessPolicy._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public BusinessPolicyBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        BusinessPolicy.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return BusinessPolicy.updater(this.getQualifiedName(), this.getName());
    }

    public static BusinessPolicy removeDescription(String qualifiedName, String name) throws AtlanException {
        return BusinessPolicy.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static BusinessPolicy removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BusinessPolicy)Asset.removeDescription(client, BusinessPolicy.updater(qualifiedName, name));
    }

    public static BusinessPolicy removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return BusinessPolicy.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static BusinessPolicy removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BusinessPolicy)Asset.removeUserDescription(client, BusinessPolicy.updater(qualifiedName, name));
    }

    public static BusinessPolicy removeOwners(String qualifiedName, String name) throws AtlanException {
        return BusinessPolicy.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static BusinessPolicy removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BusinessPolicy)Asset.removeOwners(client, BusinessPolicy.updater(qualifiedName, name));
    }

    public static BusinessPolicy updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return BusinessPolicy.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static BusinessPolicy updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (BusinessPolicy)Asset.updateCertificate(client, BusinessPolicy._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static BusinessPolicy removeCertificate(String qualifiedName, String name) throws AtlanException {
        return BusinessPolicy.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static BusinessPolicy removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BusinessPolicy)Asset.removeCertificate(client, BusinessPolicy.updater(qualifiedName, name));
    }

    public static BusinessPolicy updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return BusinessPolicy.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static BusinessPolicy updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (BusinessPolicy)Asset.updateAnnouncement(client, BusinessPolicy._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static BusinessPolicy removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return BusinessPolicy.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static BusinessPolicy removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BusinessPolicy)Asset.removeAnnouncement(client, BusinessPolicy.updater(qualifiedName, name));
    }

    public static BusinessPolicy replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return BusinessPolicy.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static BusinessPolicy replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (BusinessPolicy)Asset.replaceTerms(client, BusinessPolicy.updater(qualifiedName, name), terms);
    }

    public static BusinessPolicy appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return BusinessPolicy.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static BusinessPolicy appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (BusinessPolicy)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static BusinessPolicy removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return BusinessPolicy.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static BusinessPolicy removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (BusinessPolicy)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static BusinessPolicy appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return BusinessPolicy.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static BusinessPolicy appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (BusinessPolicy)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static BusinessPolicy appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return BusinessPolicy.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static BusinessPolicy appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (BusinessPolicy)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        BusinessPolicy.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected BusinessPolicy(BusinessPolicyBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : BusinessPolicy.$default$typeName();
        this.businessPolicyBaseParentGuid = b.businessPolicyBaseParentGuid;
        this.businessPolicyFilterDSL = b.businessPolicyFilterDSL;
        this.businessPolicyLongDescription = b.businessPolicyLongDescription;
        this.businessPolicyReviewPeriod = b.businessPolicyReviewPeriod;
        this.businessPolicySelectedApprovalWF = b.businessPolicySelectedApprovalWF;
        this.businessPolicyType = b.businessPolicyType;
        this.businessPolicyValidFrom = b.businessPolicyValidFrom;
        this.businessPolicyValidTill = b.businessPolicyValidTill;
        this.businessPolicyVersion = b.businessPolicyVersion;
        SortedSet<IBusinessPolicyException> exceptionsForBusinessPolicy = new TreeSet<IBusinessPolicyException>();
        if (b.exceptionsForBusinessPolicy != null) {
            exceptionsForBusinessPolicy.addAll(b.exceptionsForBusinessPolicy);
        }
        exceptionsForBusinessPolicy = Collections.unmodifiableSortedSet(exceptionsForBusinessPolicy);
        this.exceptionsForBusinessPolicy = exceptionsForBusinessPolicy;
        SortedSet<IBusinessPolicy> relatedBusinessPolicies = new TreeSet<IBusinessPolicy>();
        if (b.relatedBusinessPolicies != null) {
            relatedBusinessPolicies.addAll(b.relatedBusinessPolicies);
        }
        relatedBusinessPolicies = Collections.unmodifiableSortedSet(relatedBusinessPolicies);
        this.relatedBusinessPolicies = relatedBusinessPolicies;
    }

    @Generated
    public static BusinessPolicyBuilder<?, ?> _internal() {
        return new BusinessPolicyBuilderImpl();
    }

    @Generated
    public BusinessPolicyBuilder<?, ?> toBuilder() {
        return new BusinessPolicyBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getBusinessPolicyBaseParentGuid() {
        return this.businessPolicyBaseParentGuid;
    }

    @Override
    @Generated
    public String getBusinessPolicyFilterDSL() {
        return this.businessPolicyFilterDSL;
    }

    @Override
    @Generated
    public String getBusinessPolicyLongDescription() {
        return this.businessPolicyLongDescription;
    }

    @Override
    @Generated
    public String getBusinessPolicyReviewPeriod() {
        return this.businessPolicyReviewPeriod;
    }

    @Override
    @Generated
    public String getBusinessPolicySelectedApprovalWF() {
        return this.businessPolicySelectedApprovalWF;
    }

    @Override
    @Generated
    public String getBusinessPolicyType() {
        return this.businessPolicyType;
    }

    @Override
    @Generated
    public Long getBusinessPolicyValidFrom() {
        return this.businessPolicyValidFrom;
    }

    @Override
    @Generated
    public Long getBusinessPolicyValidTill() {
        return this.businessPolicyValidTill;
    }

    @Override
    @Generated
    public Integer getBusinessPolicyVersion() {
        return this.businessPolicyVersion;
    }

    @Override
    @Generated
    public SortedSet<IBusinessPolicyException> getExceptionsForBusinessPolicy() {
        return this.exceptionsForBusinessPolicy;
    }

    @Override
    @Generated
    public SortedSet<IBusinessPolicy> getRelatedBusinessPolicies() {
        return this.relatedBusinessPolicies;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BusinessPolicy)) {
            return false;
        }
        BusinessPolicy other = (BusinessPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$businessPolicyValidFrom = this.getBusinessPolicyValidFrom();
        Long other$businessPolicyValidFrom = other.getBusinessPolicyValidFrom();
        if (this$businessPolicyValidFrom == null ? other$businessPolicyValidFrom != null : !((Object)this$businessPolicyValidFrom).equals(other$businessPolicyValidFrom)) {
            return false;
        }
        Long this$businessPolicyValidTill = this.getBusinessPolicyValidTill();
        Long other$businessPolicyValidTill = other.getBusinessPolicyValidTill();
        if (this$businessPolicyValidTill == null ? other$businessPolicyValidTill != null : !((Object)this$businessPolicyValidTill).equals(other$businessPolicyValidTill)) {
            return false;
        }
        Integer this$businessPolicyVersion = this.getBusinessPolicyVersion();
        Integer other$businessPolicyVersion = other.getBusinessPolicyVersion();
        if (this$businessPolicyVersion == null ? other$businessPolicyVersion != null : !((Object)this$businessPolicyVersion).equals(other$businessPolicyVersion)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$businessPolicyBaseParentGuid = this.getBusinessPolicyBaseParentGuid();
        String other$businessPolicyBaseParentGuid = other.getBusinessPolicyBaseParentGuid();
        if (this$businessPolicyBaseParentGuid == null ? other$businessPolicyBaseParentGuid != null : !this$businessPolicyBaseParentGuid.equals(other$businessPolicyBaseParentGuid)) {
            return false;
        }
        String this$businessPolicyFilterDSL = this.getBusinessPolicyFilterDSL();
        String other$businessPolicyFilterDSL = other.getBusinessPolicyFilterDSL();
        if (this$businessPolicyFilterDSL == null ? other$businessPolicyFilterDSL != null : !this$businessPolicyFilterDSL.equals(other$businessPolicyFilterDSL)) {
            return false;
        }
        String this$businessPolicyLongDescription = this.getBusinessPolicyLongDescription();
        String other$businessPolicyLongDescription = other.getBusinessPolicyLongDescription();
        if (this$businessPolicyLongDescription == null ? other$businessPolicyLongDescription != null : !this$businessPolicyLongDescription.equals(other$businessPolicyLongDescription)) {
            return false;
        }
        String this$businessPolicyReviewPeriod = this.getBusinessPolicyReviewPeriod();
        String other$businessPolicyReviewPeriod = other.getBusinessPolicyReviewPeriod();
        if (this$businessPolicyReviewPeriod == null ? other$businessPolicyReviewPeriod != null : !this$businessPolicyReviewPeriod.equals(other$businessPolicyReviewPeriod)) {
            return false;
        }
        String this$businessPolicySelectedApprovalWF = this.getBusinessPolicySelectedApprovalWF();
        String other$businessPolicySelectedApprovalWF = other.getBusinessPolicySelectedApprovalWF();
        if (this$businessPolicySelectedApprovalWF == null ? other$businessPolicySelectedApprovalWF != null : !this$businessPolicySelectedApprovalWF.equals(other$businessPolicySelectedApprovalWF)) {
            return false;
        }
        String this$businessPolicyType = this.getBusinessPolicyType();
        String other$businessPolicyType = other.getBusinessPolicyType();
        if (this$businessPolicyType == null ? other$businessPolicyType != null : !this$businessPolicyType.equals(other$businessPolicyType)) {
            return false;
        }
        SortedSet<IBusinessPolicyException> this$exceptionsForBusinessPolicy = this.getExceptionsForBusinessPolicy();
        SortedSet<IBusinessPolicyException> other$exceptionsForBusinessPolicy = other.getExceptionsForBusinessPolicy();
        if (this$exceptionsForBusinessPolicy == null ? other$exceptionsForBusinessPolicy != null : !this$exceptionsForBusinessPolicy.equals(other$exceptionsForBusinessPolicy)) {
            return false;
        }
        SortedSet<IBusinessPolicy> this$relatedBusinessPolicies = this.getRelatedBusinessPolicies();
        SortedSet<IBusinessPolicy> other$relatedBusinessPolicies = other.getRelatedBusinessPolicies();
        return !(this$relatedBusinessPolicies == null ? other$relatedBusinessPolicies != null : !this$relatedBusinessPolicies.equals(other$relatedBusinessPolicies));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BusinessPolicy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $businessPolicyValidFrom = this.getBusinessPolicyValidFrom();
        result = result * 59 + ($businessPolicyValidFrom == null ? 43 : ((Object)$businessPolicyValidFrom).hashCode());
        Long $businessPolicyValidTill = this.getBusinessPolicyValidTill();
        result = result * 59 + ($businessPolicyValidTill == null ? 43 : ((Object)$businessPolicyValidTill).hashCode());
        Integer $businessPolicyVersion = this.getBusinessPolicyVersion();
        result = result * 59 + ($businessPolicyVersion == null ? 43 : ((Object)$businessPolicyVersion).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $businessPolicyBaseParentGuid = this.getBusinessPolicyBaseParentGuid();
        result = result * 59 + ($businessPolicyBaseParentGuid == null ? 43 : $businessPolicyBaseParentGuid.hashCode());
        String $businessPolicyFilterDSL = this.getBusinessPolicyFilterDSL();
        result = result * 59 + ($businessPolicyFilterDSL == null ? 43 : $businessPolicyFilterDSL.hashCode());
        String $businessPolicyLongDescription = this.getBusinessPolicyLongDescription();
        result = result * 59 + ($businessPolicyLongDescription == null ? 43 : $businessPolicyLongDescription.hashCode());
        String $businessPolicyReviewPeriod = this.getBusinessPolicyReviewPeriod();
        result = result * 59 + ($businessPolicyReviewPeriod == null ? 43 : $businessPolicyReviewPeriod.hashCode());
        String $businessPolicySelectedApprovalWF = this.getBusinessPolicySelectedApprovalWF();
        result = result * 59 + ($businessPolicySelectedApprovalWF == null ? 43 : $businessPolicySelectedApprovalWF.hashCode());
        String $businessPolicyType = this.getBusinessPolicyType();
        result = result * 59 + ($businessPolicyType == null ? 43 : $businessPolicyType.hashCode());
        SortedSet<IBusinessPolicyException> $exceptionsForBusinessPolicy = this.getExceptionsForBusinessPolicy();
        result = result * 59 + ($exceptionsForBusinessPolicy == null ? 43 : $exceptionsForBusinessPolicy.hashCode());
        SortedSet<IBusinessPolicy> $relatedBusinessPolicies = this.getRelatedBusinessPolicies();
        result = result * 59 + ($relatedBusinessPolicies == null ? 43 : $relatedBusinessPolicies.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "BusinessPolicy(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", businessPolicyBaseParentGuid=" + this.getBusinessPolicyBaseParentGuid() + ", businessPolicyFilterDSL=" + this.getBusinessPolicyFilterDSL() + ", businessPolicyLongDescription=" + this.getBusinessPolicyLongDescription() + ", businessPolicyReviewPeriod=" + this.getBusinessPolicyReviewPeriod() + ", businessPolicySelectedApprovalWF=" + this.getBusinessPolicySelectedApprovalWF() + ", businessPolicyType=" + this.getBusinessPolicyType() + ", businessPolicyValidFrom=" + this.getBusinessPolicyValidFrom() + ", businessPolicyValidTill=" + this.getBusinessPolicyValidTill() + ", businessPolicyVersion=" + this.getBusinessPolicyVersion() + ", exceptionsForBusinessPolicy=" + this.getExceptionsForBusinessPolicy() + ", relatedBusinessPolicies=" + this.getRelatedBusinessPolicies() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class BusinessPolicyBuilder<C extends BusinessPolicy, B extends BusinessPolicyBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String businessPolicyBaseParentGuid;
        @Generated
        private String businessPolicyFilterDSL;
        @Generated
        private String businessPolicyLongDescription;
        @Generated
        private String businessPolicyReviewPeriod;
        @Generated
        private String businessPolicySelectedApprovalWF;
        @Generated
        private String businessPolicyType;
        @Generated
        private Long businessPolicyValidFrom;
        @Generated
        private Long businessPolicyValidTill;
        @Generated
        private Integer businessPolicyVersion;
        @Generated
        private ArrayList<IBusinessPolicyException> exceptionsForBusinessPolicy;
        @Generated
        private ArrayList<IBusinessPolicy> relatedBusinessPolicies;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            BusinessPolicyBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(BusinessPolicy instance, BusinessPolicyBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.businessPolicyBaseParentGuid(instance.businessPolicyBaseParentGuid);
            b.businessPolicyFilterDSL(instance.businessPolicyFilterDSL);
            b.businessPolicyLongDescription(instance.businessPolicyLongDescription);
            b.businessPolicyReviewPeriod(instance.businessPolicyReviewPeriod);
            b.businessPolicySelectedApprovalWF(instance.businessPolicySelectedApprovalWF);
            b.businessPolicyType(instance.businessPolicyType);
            b.businessPolicyValidFrom(instance.businessPolicyValidFrom);
            b.businessPolicyValidTill(instance.businessPolicyValidTill);
            b.businessPolicyVersion(instance.businessPolicyVersion);
            b.exceptionsForBusinessPolicy(instance.exceptionsForBusinessPolicy == null ? Collections.emptySortedSet() : instance.exceptionsForBusinessPolicy);
            b.relatedBusinessPolicies(instance.relatedBusinessPolicies == null ? Collections.emptySortedSet() : instance.relatedBusinessPolicies);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B businessPolicyBaseParentGuid(String businessPolicyBaseParentGuid) {
            this.businessPolicyBaseParentGuid = businessPolicyBaseParentGuid;
            return (B)this.self();
        }

        @Generated
        public B businessPolicyFilterDSL(String businessPolicyFilterDSL) {
            this.businessPolicyFilterDSL = businessPolicyFilterDSL;
            return (B)this.self();
        }

        @Generated
        public B businessPolicyLongDescription(String businessPolicyLongDescription) {
            this.businessPolicyLongDescription = businessPolicyLongDescription;
            return (B)this.self();
        }

        @Generated
        public B businessPolicyReviewPeriod(String businessPolicyReviewPeriod) {
            this.businessPolicyReviewPeriod = businessPolicyReviewPeriod;
            return (B)this.self();
        }

        @Generated
        public B businessPolicySelectedApprovalWF(String businessPolicySelectedApprovalWF) {
            this.businessPolicySelectedApprovalWF = businessPolicySelectedApprovalWF;
            return (B)this.self();
        }

        @Generated
        public B businessPolicyType(String businessPolicyType) {
            this.businessPolicyType = businessPolicyType;
            return (B)this.self();
        }

        @Generated
        public B businessPolicyValidFrom(Long businessPolicyValidFrom) {
            this.businessPolicyValidFrom = businessPolicyValidFrom;
            return (B)this.self();
        }

        @Generated
        public B businessPolicyValidTill(Long businessPolicyValidTill) {
            this.businessPolicyValidTill = businessPolicyValidTill;
            return (B)this.self();
        }

        @Generated
        public B businessPolicyVersion(Integer businessPolicyVersion) {
            this.businessPolicyVersion = businessPolicyVersion;
            return (B)this.self();
        }

        @Generated
        public B exceptionForBusinessPolicy(IBusinessPolicyException exceptionForBusinessPolicy) {
            if (this.exceptionsForBusinessPolicy == null) {
                this.exceptionsForBusinessPolicy = new ArrayList();
            }
            this.exceptionsForBusinessPolicy.add(exceptionForBusinessPolicy);
            return (B)this.self();
        }

        @Generated
        public B exceptionsForBusinessPolicy(Collection<? extends IBusinessPolicyException> exceptionsForBusinessPolicy) {
            if (exceptionsForBusinessPolicy == null) {
                throw new NullPointerException("exceptionsForBusinessPolicy cannot be null");
            }
            if (this.exceptionsForBusinessPolicy == null) {
                this.exceptionsForBusinessPolicy = new ArrayList();
            }
            this.exceptionsForBusinessPolicy.addAll(exceptionsForBusinessPolicy);
            return (B)this.self();
        }

        @Generated
        public B clearExceptionsForBusinessPolicy() {
            if (this.exceptionsForBusinessPolicy != null) {
                this.exceptionsForBusinessPolicy.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B relatedBusinessPolicy(IBusinessPolicy relatedBusinessPolicy) {
            if (this.relatedBusinessPolicies == null) {
                this.relatedBusinessPolicies = new ArrayList();
            }
            this.relatedBusinessPolicies.add(relatedBusinessPolicy);
            return (B)this.self();
        }

        @Generated
        public B relatedBusinessPolicies(Collection<? extends IBusinessPolicy> relatedBusinessPolicies) {
            if (relatedBusinessPolicies == null) {
                throw new NullPointerException("relatedBusinessPolicies cannot be null");
            }
            if (this.relatedBusinessPolicies == null) {
                this.relatedBusinessPolicies = new ArrayList();
            }
            this.relatedBusinessPolicies.addAll(relatedBusinessPolicies);
            return (B)this.self();
        }

        @Generated
        public B clearRelatedBusinessPolicies() {
            if (this.relatedBusinessPolicies != null) {
                this.relatedBusinessPolicies.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "BusinessPolicy.BusinessPolicyBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", businessPolicyBaseParentGuid=" + this.businessPolicyBaseParentGuid + ", businessPolicyFilterDSL=" + this.businessPolicyFilterDSL + ", businessPolicyLongDescription=" + this.businessPolicyLongDescription + ", businessPolicyReviewPeriod=" + this.businessPolicyReviewPeriod + ", businessPolicySelectedApprovalWF=" + this.businessPolicySelectedApprovalWF + ", businessPolicyType=" + this.businessPolicyType + ", businessPolicyValidFrom=" + this.businessPolicyValidFrom + ", businessPolicyValidTill=" + this.businessPolicyValidTill + ", businessPolicyVersion=" + this.businessPolicyVersion + ", exceptionsForBusinessPolicy=" + this.exceptionsForBusinessPolicy + ", relatedBusinessPolicies=" + this.relatedBusinessPolicies + ")";
        }
    }

    @Generated
    private static final class BusinessPolicyBuilderImpl
    extends BusinessPolicyBuilder<BusinessPolicy, BusinessPolicyBuilderImpl> {
        @Generated
        private BusinessPolicyBuilderImpl() {
        }

        @Override
        @Generated
        protected BusinessPolicyBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public BusinessPolicy build() {
            return new BusinessPolicy(this);
        }
    }
}

