/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.ICognos;
import com.atlan.model.assets.ICognosDashboard;
import com.atlan.model.assets.ICognosExploration;
import com.atlan.model.assets.ICognosFile;
import com.atlan.model.assets.ICognosFolder;
import com.atlan.model.assets.ICognosModule;
import com.atlan.model.assets.ICognosPackage;
import com.atlan.model.assets.ICognosReport;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CognosFolder
extends Asset
implements ICognosFolder,
ICognos,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CognosFolder.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "CognosFolder";
    String typeName;
    @Attribute
    SortedSet<ICognosDashboard> cognosDashboards;
    @Attribute
    String cognosDefaultScreenTip;
    @Attribute
    SortedSet<ICognosExploration> cognosExplorations;
    @Attribute
    SortedSet<ICognosFile> cognosFiles;
    @Attribute
    ICognosFolder cognosFolder;
    @Attribute
    Integer cognosFolderChildObjectsCount;
    @Attribute
    Integer cognosFolderSubFolderCount;
    @Attribute
    String cognosId;
    @Attribute
    Boolean cognosIsDisabled;
    @Attribute
    Boolean cognosIsHidden;
    @Attribute
    SortedSet<ICognosModule> cognosModules;
    @Attribute
    SortedSet<ICognosPackage> cognosPackages;
    @Attribute
    String cognosParentName;
    @Attribute
    String cognosParentQualifiedName;
    @Attribute
    String cognosPath;
    @Attribute
    SortedSet<ICognosReport> cognosReports;
    @Attribute
    SortedSet<ICognosFolder> cognosSubFolders;
    @Attribute
    String cognosType;
    @Attribute
    String cognosVersion;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public CognosFolder trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return CognosFolder.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return CognosFolder.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return CognosFolder.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return CognosFolder.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return CognosFolder.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return CognosFolder.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static CognosFolder refByGuid(String guid) {
        return CognosFolder.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static CognosFolder refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((CognosFolderBuilder)((CognosFolderBuilder)CognosFolder._internal().guid(guid)).semantic(semantic)).build();
    }

    public static CognosFolder refByQualifiedName(String qualifiedName) {
        return CognosFolder.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static CognosFolder refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((CognosFolderBuilder)((CognosFolderBuilder)CognosFolder._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static CognosFolder get(String id) throws AtlanException {
        return CognosFolder.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static CognosFolder get(AtlanClient client, String id) throws AtlanException {
        return CognosFolder.get(client, id, true);
    }

    @JsonIgnore
    public static CognosFolder get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof CognosFolder) {
                return (CognosFolder)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof CognosFolder) {
            return (CognosFolder)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return CognosFolder.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static CognosFolderBuilder<?, ?> updater(String qualifiedName, String name) {
        return (CognosFolderBuilder)((CognosFolderBuilder)((CognosFolderBuilder)CognosFolder._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public CognosFolderBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        CognosFolder.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return CognosFolder.updater(this.getQualifiedName(), this.getName());
    }

    public static CognosFolder removeDescription(String qualifiedName, String name) throws AtlanException {
        return CognosFolder.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static CognosFolder removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CognosFolder)Asset.removeDescription(client, CognosFolder.updater(qualifiedName, name));
    }

    public static CognosFolder removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return CognosFolder.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static CognosFolder removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CognosFolder)Asset.removeUserDescription(client, CognosFolder.updater(qualifiedName, name));
    }

    public static CognosFolder removeOwners(String qualifiedName, String name) throws AtlanException {
        return CognosFolder.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static CognosFolder removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CognosFolder)Asset.removeOwners(client, CognosFolder.updater(qualifiedName, name));
    }

    public static CognosFolder updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return CognosFolder.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static CognosFolder updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (CognosFolder)Asset.updateCertificate(client, CognosFolder._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static CognosFolder removeCertificate(String qualifiedName, String name) throws AtlanException {
        return CognosFolder.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static CognosFolder removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CognosFolder)Asset.removeCertificate(client, CognosFolder.updater(qualifiedName, name));
    }

    public static CognosFolder updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return CognosFolder.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static CognosFolder updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (CognosFolder)Asset.updateAnnouncement(client, CognosFolder._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static CognosFolder removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return CognosFolder.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static CognosFolder removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CognosFolder)Asset.removeAnnouncement(client, CognosFolder.updater(qualifiedName, name));
    }

    public static CognosFolder replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return CognosFolder.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static CognosFolder replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (CognosFolder)Asset.replaceTerms(client, CognosFolder.updater(qualifiedName, name), terms);
    }

    public static CognosFolder appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return CognosFolder.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static CognosFolder appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CognosFolder)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static CognosFolder removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return CognosFolder.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static CognosFolder removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CognosFolder)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static CognosFolder appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return CognosFolder.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static CognosFolder appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (CognosFolder)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static CognosFolder appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return CognosFolder.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static CognosFolder appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (CognosFolder)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        CognosFolder.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected CognosFolder(CognosFolderBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : CognosFolder.$default$typeName();
        SortedSet<ICognosDashboard> cognosDashboards = new TreeSet<ICognosDashboard>();
        if (b.cognosDashboards != null) {
            cognosDashboards.addAll(b.cognosDashboards);
        }
        cognosDashboards = Collections.unmodifiableSortedSet(cognosDashboards);
        this.cognosDashboards = cognosDashboards;
        this.cognosDefaultScreenTip = b.cognosDefaultScreenTip;
        SortedSet<ICognosExploration> cognosExplorations = new TreeSet<ICognosExploration>();
        if (b.cognosExplorations != null) {
            cognosExplorations.addAll(b.cognosExplorations);
        }
        cognosExplorations = Collections.unmodifiableSortedSet(cognosExplorations);
        this.cognosExplorations = cognosExplorations;
        SortedSet<ICognosFile> cognosFiles = new TreeSet<ICognosFile>();
        if (b.cognosFiles != null) {
            cognosFiles.addAll(b.cognosFiles);
        }
        cognosFiles = Collections.unmodifiableSortedSet(cognosFiles);
        this.cognosFiles = cognosFiles;
        this.cognosFolder = b.cognosFolder;
        this.cognosFolderChildObjectsCount = b.cognosFolderChildObjectsCount;
        this.cognosFolderSubFolderCount = b.cognosFolderSubFolderCount;
        this.cognosId = b.cognosId;
        this.cognosIsDisabled = b.cognosIsDisabled;
        this.cognosIsHidden = b.cognosIsHidden;
        SortedSet<ICognosModule> cognosModules = new TreeSet<ICognosModule>();
        if (b.cognosModules != null) {
            cognosModules.addAll(b.cognosModules);
        }
        cognosModules = Collections.unmodifiableSortedSet(cognosModules);
        this.cognosModules = cognosModules;
        SortedSet<ICognosPackage> cognosPackages = new TreeSet<ICognosPackage>();
        if (b.cognosPackages != null) {
            cognosPackages.addAll(b.cognosPackages);
        }
        cognosPackages = Collections.unmodifiableSortedSet(cognosPackages);
        this.cognosPackages = cognosPackages;
        this.cognosParentName = b.cognosParentName;
        this.cognosParentQualifiedName = b.cognosParentQualifiedName;
        this.cognosPath = b.cognosPath;
        SortedSet<ICognosReport> cognosReports = new TreeSet<ICognosReport>();
        if (b.cognosReports != null) {
            cognosReports.addAll(b.cognosReports);
        }
        cognosReports = Collections.unmodifiableSortedSet(cognosReports);
        this.cognosReports = cognosReports;
        SortedSet<ICognosFolder> cognosSubFolders = new TreeSet<ICognosFolder>();
        if (b.cognosSubFolders != null) {
            cognosSubFolders.addAll(b.cognosSubFolders);
        }
        cognosSubFolders = Collections.unmodifiableSortedSet(cognosSubFolders);
        this.cognosSubFolders = cognosSubFolders;
        this.cognosType = b.cognosType;
        this.cognosVersion = b.cognosVersion;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static CognosFolderBuilder<?, ?> _internal() {
        return new CognosFolderBuilderImpl();
    }

    @Generated
    public CognosFolderBuilder<?, ?> toBuilder() {
        return new CognosFolderBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<ICognosDashboard> getCognosDashboards() {
        return this.cognosDashboards;
    }

    @Override
    @Generated
    public String getCognosDefaultScreenTip() {
        return this.cognosDefaultScreenTip;
    }

    @Override
    @Generated
    public SortedSet<ICognosExploration> getCognosExplorations() {
        return this.cognosExplorations;
    }

    @Override
    @Generated
    public SortedSet<ICognosFile> getCognosFiles() {
        return this.cognosFiles;
    }

    @Override
    @Generated
    public ICognosFolder getCognosFolder() {
        return this.cognosFolder;
    }

    @Override
    @Generated
    public Integer getCognosFolderChildObjectsCount() {
        return this.cognosFolderChildObjectsCount;
    }

    @Override
    @Generated
    public Integer getCognosFolderSubFolderCount() {
        return this.cognosFolderSubFolderCount;
    }

    @Override
    @Generated
    public String getCognosId() {
        return this.cognosId;
    }

    @Override
    @Generated
    public Boolean getCognosIsDisabled() {
        return this.cognosIsDisabled;
    }

    @Override
    @Generated
    public Boolean getCognosIsHidden() {
        return this.cognosIsHidden;
    }

    @Override
    @Generated
    public SortedSet<ICognosModule> getCognosModules() {
        return this.cognosModules;
    }

    @Override
    @Generated
    public SortedSet<ICognosPackage> getCognosPackages() {
        return this.cognosPackages;
    }

    @Override
    @Generated
    public String getCognosParentName() {
        return this.cognosParentName;
    }

    @Override
    @Generated
    public String getCognosParentQualifiedName() {
        return this.cognosParentQualifiedName;
    }

    @Override
    @Generated
    public String getCognosPath() {
        return this.cognosPath;
    }

    @Override
    @Generated
    public SortedSet<ICognosReport> getCognosReports() {
        return this.cognosReports;
    }

    @Override
    @Generated
    public SortedSet<ICognosFolder> getCognosSubFolders() {
        return this.cognosSubFolders;
    }

    @Override
    @Generated
    public String getCognosType() {
        return this.cognosType;
    }

    @Override
    @Generated
    public String getCognosVersion() {
        return this.cognosVersion;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CognosFolder)) {
            return false;
        }
        CognosFolder other = (CognosFolder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$cognosFolderChildObjectsCount = this.getCognosFolderChildObjectsCount();
        Integer other$cognosFolderChildObjectsCount = other.getCognosFolderChildObjectsCount();
        if (this$cognosFolderChildObjectsCount == null ? other$cognosFolderChildObjectsCount != null : !((Object)this$cognosFolderChildObjectsCount).equals(other$cognosFolderChildObjectsCount)) {
            return false;
        }
        Integer this$cognosFolderSubFolderCount = this.getCognosFolderSubFolderCount();
        Integer other$cognosFolderSubFolderCount = other.getCognosFolderSubFolderCount();
        if (this$cognosFolderSubFolderCount == null ? other$cognosFolderSubFolderCount != null : !((Object)this$cognosFolderSubFolderCount).equals(other$cognosFolderSubFolderCount)) {
            return false;
        }
        Boolean this$cognosIsDisabled = this.getCognosIsDisabled();
        Boolean other$cognosIsDisabled = other.getCognosIsDisabled();
        if (this$cognosIsDisabled == null ? other$cognosIsDisabled != null : !((Object)this$cognosIsDisabled).equals(other$cognosIsDisabled)) {
            return false;
        }
        Boolean this$cognosIsHidden = this.getCognosIsHidden();
        Boolean other$cognosIsHidden = other.getCognosIsHidden();
        if (this$cognosIsHidden == null ? other$cognosIsHidden != null : !((Object)this$cognosIsHidden).equals(other$cognosIsHidden)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<ICognosDashboard> this$cognosDashboards = this.getCognosDashboards();
        SortedSet<ICognosDashboard> other$cognosDashboards = other.getCognosDashboards();
        if (this$cognosDashboards == null ? other$cognosDashboards != null : !this$cognosDashboards.equals(other$cognosDashboards)) {
            return false;
        }
        String this$cognosDefaultScreenTip = this.getCognosDefaultScreenTip();
        String other$cognosDefaultScreenTip = other.getCognosDefaultScreenTip();
        if (this$cognosDefaultScreenTip == null ? other$cognosDefaultScreenTip != null : !this$cognosDefaultScreenTip.equals(other$cognosDefaultScreenTip)) {
            return false;
        }
        SortedSet<ICognosExploration> this$cognosExplorations = this.getCognosExplorations();
        SortedSet<ICognosExploration> other$cognosExplorations = other.getCognosExplorations();
        if (this$cognosExplorations == null ? other$cognosExplorations != null : !this$cognosExplorations.equals(other$cognosExplorations)) {
            return false;
        }
        SortedSet<ICognosFile> this$cognosFiles = this.getCognosFiles();
        SortedSet<ICognosFile> other$cognosFiles = other.getCognosFiles();
        if (this$cognosFiles == null ? other$cognosFiles != null : !this$cognosFiles.equals(other$cognosFiles)) {
            return false;
        }
        ICognosFolder this$cognosFolder = this.getCognosFolder();
        ICognosFolder other$cognosFolder = other.getCognosFolder();
        if (this$cognosFolder == null ? other$cognosFolder != null : !this$cognosFolder.equals(other$cognosFolder)) {
            return false;
        }
        String this$cognosId = this.getCognosId();
        String other$cognosId = other.getCognosId();
        if (this$cognosId == null ? other$cognosId != null : !this$cognosId.equals(other$cognosId)) {
            return false;
        }
        SortedSet<ICognosModule> this$cognosModules = this.getCognosModules();
        SortedSet<ICognosModule> other$cognosModules = other.getCognosModules();
        if (this$cognosModules == null ? other$cognosModules != null : !this$cognosModules.equals(other$cognosModules)) {
            return false;
        }
        SortedSet<ICognosPackage> this$cognosPackages = this.getCognosPackages();
        SortedSet<ICognosPackage> other$cognosPackages = other.getCognosPackages();
        if (this$cognosPackages == null ? other$cognosPackages != null : !this$cognosPackages.equals(other$cognosPackages)) {
            return false;
        }
        String this$cognosParentName = this.getCognosParentName();
        String other$cognosParentName = other.getCognosParentName();
        if (this$cognosParentName == null ? other$cognosParentName != null : !this$cognosParentName.equals(other$cognosParentName)) {
            return false;
        }
        String this$cognosParentQualifiedName = this.getCognosParentQualifiedName();
        String other$cognosParentQualifiedName = other.getCognosParentQualifiedName();
        if (this$cognosParentQualifiedName == null ? other$cognosParentQualifiedName != null : !this$cognosParentQualifiedName.equals(other$cognosParentQualifiedName)) {
            return false;
        }
        String this$cognosPath = this.getCognosPath();
        String other$cognosPath = other.getCognosPath();
        if (this$cognosPath == null ? other$cognosPath != null : !this$cognosPath.equals(other$cognosPath)) {
            return false;
        }
        SortedSet<ICognosReport> this$cognosReports = this.getCognosReports();
        SortedSet<ICognosReport> other$cognosReports = other.getCognosReports();
        if (this$cognosReports == null ? other$cognosReports != null : !this$cognosReports.equals(other$cognosReports)) {
            return false;
        }
        SortedSet<ICognosFolder> this$cognosSubFolders = this.getCognosSubFolders();
        SortedSet<ICognosFolder> other$cognosSubFolders = other.getCognosSubFolders();
        if (this$cognosSubFolders == null ? other$cognosSubFolders != null : !this$cognosSubFolders.equals(other$cognosSubFolders)) {
            return false;
        }
        String this$cognosType = this.getCognosType();
        String other$cognosType = other.getCognosType();
        if (this$cognosType == null ? other$cognosType != null : !this$cognosType.equals(other$cognosType)) {
            return false;
        }
        String this$cognosVersion = this.getCognosVersion();
        String other$cognosVersion = other.getCognosVersion();
        if (this$cognosVersion == null ? other$cognosVersion != null : !this$cognosVersion.equals(other$cognosVersion)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CognosFolder;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $cognosFolderChildObjectsCount = this.getCognosFolderChildObjectsCount();
        result = result * 59 + ($cognosFolderChildObjectsCount == null ? 43 : ((Object)$cognosFolderChildObjectsCount).hashCode());
        Integer $cognosFolderSubFolderCount = this.getCognosFolderSubFolderCount();
        result = result * 59 + ($cognosFolderSubFolderCount == null ? 43 : ((Object)$cognosFolderSubFolderCount).hashCode());
        Boolean $cognosIsDisabled = this.getCognosIsDisabled();
        result = result * 59 + ($cognosIsDisabled == null ? 43 : ((Object)$cognosIsDisabled).hashCode());
        Boolean $cognosIsHidden = this.getCognosIsHidden();
        result = result * 59 + ($cognosIsHidden == null ? 43 : ((Object)$cognosIsHidden).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<ICognosDashboard> $cognosDashboards = this.getCognosDashboards();
        result = result * 59 + ($cognosDashboards == null ? 43 : $cognosDashboards.hashCode());
        String $cognosDefaultScreenTip = this.getCognosDefaultScreenTip();
        result = result * 59 + ($cognosDefaultScreenTip == null ? 43 : $cognosDefaultScreenTip.hashCode());
        SortedSet<ICognosExploration> $cognosExplorations = this.getCognosExplorations();
        result = result * 59 + ($cognosExplorations == null ? 43 : $cognosExplorations.hashCode());
        SortedSet<ICognosFile> $cognosFiles = this.getCognosFiles();
        result = result * 59 + ($cognosFiles == null ? 43 : $cognosFiles.hashCode());
        ICognosFolder $cognosFolder = this.getCognosFolder();
        result = result * 59 + ($cognosFolder == null ? 43 : $cognosFolder.hashCode());
        String $cognosId = this.getCognosId();
        result = result * 59 + ($cognosId == null ? 43 : $cognosId.hashCode());
        SortedSet<ICognosModule> $cognosModules = this.getCognosModules();
        result = result * 59 + ($cognosModules == null ? 43 : $cognosModules.hashCode());
        SortedSet<ICognosPackage> $cognosPackages = this.getCognosPackages();
        result = result * 59 + ($cognosPackages == null ? 43 : $cognosPackages.hashCode());
        String $cognosParentName = this.getCognosParentName();
        result = result * 59 + ($cognosParentName == null ? 43 : $cognosParentName.hashCode());
        String $cognosParentQualifiedName = this.getCognosParentQualifiedName();
        result = result * 59 + ($cognosParentQualifiedName == null ? 43 : $cognosParentQualifiedName.hashCode());
        String $cognosPath = this.getCognosPath();
        result = result * 59 + ($cognosPath == null ? 43 : $cognosPath.hashCode());
        SortedSet<ICognosReport> $cognosReports = this.getCognosReports();
        result = result * 59 + ($cognosReports == null ? 43 : $cognosReports.hashCode());
        SortedSet<ICognosFolder> $cognosSubFolders = this.getCognosSubFolders();
        result = result * 59 + ($cognosSubFolders == null ? 43 : $cognosSubFolders.hashCode());
        String $cognosType = this.getCognosType();
        result = result * 59 + ($cognosType == null ? 43 : $cognosType.hashCode());
        String $cognosVersion = this.getCognosVersion();
        result = result * 59 + ($cognosVersion == null ? 43 : $cognosVersion.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "CognosFolder(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", cognosDashboards=" + this.getCognosDashboards() + ", cognosDefaultScreenTip=" + this.getCognosDefaultScreenTip() + ", cognosExplorations=" + this.getCognosExplorations() + ", cognosFiles=" + this.getCognosFiles() + ", cognosFolder=" + this.getCognosFolder() + ", cognosFolderChildObjectsCount=" + this.getCognosFolderChildObjectsCount() + ", cognosFolderSubFolderCount=" + this.getCognosFolderSubFolderCount() + ", cognosId=" + this.getCognosId() + ", cognosIsDisabled=" + this.getCognosIsDisabled() + ", cognosIsHidden=" + this.getCognosIsHidden() + ", cognosModules=" + this.getCognosModules() + ", cognosPackages=" + this.getCognosPackages() + ", cognosParentName=" + this.getCognosParentName() + ", cognosParentQualifiedName=" + this.getCognosParentQualifiedName() + ", cognosPath=" + this.getCognosPath() + ", cognosReports=" + this.getCognosReports() + ", cognosSubFolders=" + this.getCognosSubFolders() + ", cognosType=" + this.getCognosType() + ", cognosVersion=" + this.getCognosVersion() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class CognosFolderBuilder<C extends CognosFolder, B extends CognosFolderBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<ICognosDashboard> cognosDashboards;
        @Generated
        private String cognosDefaultScreenTip;
        @Generated
        private ArrayList<ICognosExploration> cognosExplorations;
        @Generated
        private ArrayList<ICognosFile> cognosFiles;
        @Generated
        private ICognosFolder cognosFolder;
        @Generated
        private Integer cognosFolderChildObjectsCount;
        @Generated
        private Integer cognosFolderSubFolderCount;
        @Generated
        private String cognosId;
        @Generated
        private Boolean cognosIsDisabled;
        @Generated
        private Boolean cognosIsHidden;
        @Generated
        private ArrayList<ICognosModule> cognosModules;
        @Generated
        private ArrayList<ICognosPackage> cognosPackages;
        @Generated
        private String cognosParentName;
        @Generated
        private String cognosParentQualifiedName;
        @Generated
        private String cognosPath;
        @Generated
        private ArrayList<ICognosReport> cognosReports;
        @Generated
        private ArrayList<ICognosFolder> cognosSubFolders;
        @Generated
        private String cognosType;
        @Generated
        private String cognosVersion;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CognosFolderBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(CognosFolder instance, CognosFolderBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.cognosDashboards(instance.cognosDashboards == null ? Collections.emptySortedSet() : instance.cognosDashboards);
            b.cognosDefaultScreenTip(instance.cognosDefaultScreenTip);
            b.cognosExplorations(instance.cognosExplorations == null ? Collections.emptySortedSet() : instance.cognosExplorations);
            b.cognosFiles(instance.cognosFiles == null ? Collections.emptySortedSet() : instance.cognosFiles);
            b.cognosFolder(instance.cognosFolder);
            b.cognosFolderChildObjectsCount(instance.cognosFolderChildObjectsCount);
            b.cognosFolderSubFolderCount(instance.cognosFolderSubFolderCount);
            b.cognosId(instance.cognosId);
            b.cognosIsDisabled(instance.cognosIsDisabled);
            b.cognosIsHidden(instance.cognosIsHidden);
            b.cognosModules(instance.cognosModules == null ? Collections.emptySortedSet() : instance.cognosModules);
            b.cognosPackages(instance.cognosPackages == null ? Collections.emptySortedSet() : instance.cognosPackages);
            b.cognosParentName(instance.cognosParentName);
            b.cognosParentQualifiedName(instance.cognosParentQualifiedName);
            b.cognosPath(instance.cognosPath);
            b.cognosReports(instance.cognosReports == null ? Collections.emptySortedSet() : instance.cognosReports);
            b.cognosSubFolders(instance.cognosSubFolders == null ? Collections.emptySortedSet() : instance.cognosSubFolders);
            b.cognosType(instance.cognosType);
            b.cognosVersion(instance.cognosVersion);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B cognosDashboard(ICognosDashboard cognosDashboard) {
            if (this.cognosDashboards == null) {
                this.cognosDashboards = new ArrayList();
            }
            this.cognosDashboards.add(cognosDashboard);
            return (B)this.self();
        }

        @Generated
        public B cognosDashboards(Collection<? extends ICognosDashboard> cognosDashboards) {
            if (cognosDashboards == null) {
                throw new NullPointerException("cognosDashboards cannot be null");
            }
            if (this.cognosDashboards == null) {
                this.cognosDashboards = new ArrayList();
            }
            this.cognosDashboards.addAll(cognosDashboards);
            return (B)this.self();
        }

        @Generated
        public B clearCognosDashboards() {
            if (this.cognosDashboards != null) {
                this.cognosDashboards.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B cognosDefaultScreenTip(String cognosDefaultScreenTip) {
            this.cognosDefaultScreenTip = cognosDefaultScreenTip;
            return (B)this.self();
        }

        @Generated
        public B cognosExploration(ICognosExploration cognosExploration) {
            if (this.cognosExplorations == null) {
                this.cognosExplorations = new ArrayList();
            }
            this.cognosExplorations.add(cognosExploration);
            return (B)this.self();
        }

        @Generated
        public B cognosExplorations(Collection<? extends ICognosExploration> cognosExplorations) {
            if (cognosExplorations == null) {
                throw new NullPointerException("cognosExplorations cannot be null");
            }
            if (this.cognosExplorations == null) {
                this.cognosExplorations = new ArrayList();
            }
            this.cognosExplorations.addAll(cognosExplorations);
            return (B)this.self();
        }

        @Generated
        public B clearCognosExplorations() {
            if (this.cognosExplorations != null) {
                this.cognosExplorations.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B cognosFile(ICognosFile cognosFile) {
            if (this.cognosFiles == null) {
                this.cognosFiles = new ArrayList();
            }
            this.cognosFiles.add(cognosFile);
            return (B)this.self();
        }

        @Generated
        public B cognosFiles(Collection<? extends ICognosFile> cognosFiles) {
            if (cognosFiles == null) {
                throw new NullPointerException("cognosFiles cannot be null");
            }
            if (this.cognosFiles == null) {
                this.cognosFiles = new ArrayList();
            }
            this.cognosFiles.addAll(cognosFiles);
            return (B)this.self();
        }

        @Generated
        public B clearCognosFiles() {
            if (this.cognosFiles != null) {
                this.cognosFiles.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B cognosFolder(ICognosFolder cognosFolder) {
            this.cognosFolder = cognosFolder;
            return (B)this.self();
        }

        @Generated
        public B cognosFolderChildObjectsCount(Integer cognosFolderChildObjectsCount) {
            this.cognosFolderChildObjectsCount = cognosFolderChildObjectsCount;
            return (B)this.self();
        }

        @Generated
        public B cognosFolderSubFolderCount(Integer cognosFolderSubFolderCount) {
            this.cognosFolderSubFolderCount = cognosFolderSubFolderCount;
            return (B)this.self();
        }

        @Generated
        public B cognosId(String cognosId) {
            this.cognosId = cognosId;
            return (B)this.self();
        }

        @Generated
        public B cognosIsDisabled(Boolean cognosIsDisabled) {
            this.cognosIsDisabled = cognosIsDisabled;
            return (B)this.self();
        }

        @Generated
        public B cognosIsHidden(Boolean cognosIsHidden) {
            this.cognosIsHidden = cognosIsHidden;
            return (B)this.self();
        }

        @Generated
        public B cognosModule(ICognosModule cognosModule) {
            if (this.cognosModules == null) {
                this.cognosModules = new ArrayList();
            }
            this.cognosModules.add(cognosModule);
            return (B)this.self();
        }

        @Generated
        public B cognosModules(Collection<? extends ICognosModule> cognosModules) {
            if (cognosModules == null) {
                throw new NullPointerException("cognosModules cannot be null");
            }
            if (this.cognosModules == null) {
                this.cognosModules = new ArrayList();
            }
            this.cognosModules.addAll(cognosModules);
            return (B)this.self();
        }

        @Generated
        public B clearCognosModules() {
            if (this.cognosModules != null) {
                this.cognosModules.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B cognosPackage(ICognosPackage cognosPackage) {
            if (this.cognosPackages == null) {
                this.cognosPackages = new ArrayList();
            }
            this.cognosPackages.add(cognosPackage);
            return (B)this.self();
        }

        @Generated
        public B cognosPackages(Collection<? extends ICognosPackage> cognosPackages) {
            if (cognosPackages == null) {
                throw new NullPointerException("cognosPackages cannot be null");
            }
            if (this.cognosPackages == null) {
                this.cognosPackages = new ArrayList();
            }
            this.cognosPackages.addAll(cognosPackages);
            return (B)this.self();
        }

        @Generated
        public B clearCognosPackages() {
            if (this.cognosPackages != null) {
                this.cognosPackages.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B cognosParentName(String cognosParentName) {
            this.cognosParentName = cognosParentName;
            return (B)this.self();
        }

        @Generated
        public B cognosParentQualifiedName(String cognosParentQualifiedName) {
            this.cognosParentQualifiedName = cognosParentQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B cognosPath(String cognosPath) {
            this.cognosPath = cognosPath;
            return (B)this.self();
        }

        @Generated
        public B cognosReport(ICognosReport cognosReport) {
            if (this.cognosReports == null) {
                this.cognosReports = new ArrayList();
            }
            this.cognosReports.add(cognosReport);
            return (B)this.self();
        }

        @Generated
        public B cognosReports(Collection<? extends ICognosReport> cognosReports) {
            if (cognosReports == null) {
                throw new NullPointerException("cognosReports cannot be null");
            }
            if (this.cognosReports == null) {
                this.cognosReports = new ArrayList();
            }
            this.cognosReports.addAll(cognosReports);
            return (B)this.self();
        }

        @Generated
        public B clearCognosReports() {
            if (this.cognosReports != null) {
                this.cognosReports.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B cognosSubFolder(ICognosFolder cognosSubFolder) {
            if (this.cognosSubFolders == null) {
                this.cognosSubFolders = new ArrayList();
            }
            this.cognosSubFolders.add(cognosSubFolder);
            return (B)this.self();
        }

        @Generated
        public B cognosSubFolders(Collection<? extends ICognosFolder> cognosSubFolders) {
            if (cognosSubFolders == null) {
                throw new NullPointerException("cognosSubFolders cannot be null");
            }
            if (this.cognosSubFolders == null) {
                this.cognosSubFolders = new ArrayList();
            }
            this.cognosSubFolders.addAll(cognosSubFolders);
            return (B)this.self();
        }

        @Generated
        public B clearCognosSubFolders() {
            if (this.cognosSubFolders != null) {
                this.cognosSubFolders.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B cognosType(String cognosType) {
            this.cognosType = cognosType;
            return (B)this.self();
        }

        @Generated
        public B cognosVersion(String cognosVersion) {
            this.cognosVersion = cognosVersion;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "CognosFolder.CognosFolderBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", cognosDashboards=" + this.cognosDashboards + ", cognosDefaultScreenTip=" + this.cognosDefaultScreenTip + ", cognosExplorations=" + this.cognosExplorations + ", cognosFiles=" + this.cognosFiles + ", cognosFolder=" + this.cognosFolder + ", cognosFolderChildObjectsCount=" + this.cognosFolderChildObjectsCount + ", cognosFolderSubFolderCount=" + this.cognosFolderSubFolderCount + ", cognosId=" + this.cognosId + ", cognosIsDisabled=" + this.cognosIsDisabled + ", cognosIsHidden=" + this.cognosIsHidden + ", cognosModules=" + this.cognosModules + ", cognosPackages=" + this.cognosPackages + ", cognosParentName=" + this.cognosParentName + ", cognosParentQualifiedName=" + this.cognosParentQualifiedName + ", cognosPath=" + this.cognosPath + ", cognosReports=" + this.cognosReports + ", cognosSubFolders=" + this.cognosSubFolders + ", cognosType=" + this.cognosType + ", cognosVersion=" + this.cognosVersion + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }

    @Generated
    private static final class CognosFolderBuilderImpl
    extends CognosFolderBuilder<CognosFolder, CognosFolderBuilderImpl> {
        @Generated
        private CognosFolderBuilderImpl() {
        }

        @Override
        @Generated
        protected CognosFolderBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CognosFolder build() {
            return new CognosFolder(this);
        }
    }
}

