/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IConnection;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.core.AssetMutationResponse;
import com.atlan.model.core.AsyncCreationResponse;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectionCategory;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.QueryUsernameStrategy;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection
extends Asset
implements IConnection,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Connection.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Connection";
    String typeName;
    @Attribute
    Boolean allowQuery;
    @Attribute
    Boolean allowQueryPreview;
    @Attribute
    AtlanConnectionCategory category;
    @Attribute
    SortedSet<String> connectionDbtEnvironments;
    @Attribute
    String connectionSSOCredentialGuid;
    @Attribute
    String connectorIcon;
    @Attribute
    String connectorImage;
    @Attribute
    String credentialStrategy;
    @Attribute
    String defaultCredentialGuid;
    @Attribute
    Boolean hasPopularityInsights;
    @Attribute
    String host;
    @Attribute
    Boolean isSampleDataPreviewEnabled;
    @Attribute
    Long objectStorageUploadThreshold;
    @Attribute
    String policyStrategy;
    @Attribute
    String policyStrategyForSamplePreview;
    @Attribute
    Long popularityInsightsTimeframe;
    @Attribute
    Integer port;
    @Attribute
    String previewCredentialStrategy;
    @Attribute
    String queryConfig;
    @Attribute
    Map<String, String> queryPreviewConfig;
    @Attribute
    Long queryTimeout;
    @Attribute
    QueryUsernameStrategy queryUsernameStrategy;
    @Attribute
    Long rowLimit;
    @Attribute
    String sourceLogo;
    @Attribute
    String subCategory;
    @Attribute
    Boolean useObjectStorage;
    @Attribute
    Boolean vectorEmbeddingsEnabled;
    @Attribute
    @Date
    Long vectorEmbeddingsUpdatedAt;

    @Override
    public Connection trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return Connection.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return Connection.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return Connection.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return Connection.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return Connection.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return Connection.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static Connection refByGuid(String guid) {
        return Connection.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static Connection refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((ConnectionBuilder)((ConnectionBuilder)Connection._internal().guid(guid)).semantic(semantic)).build();
    }

    public static Connection refByQualifiedName(String qualifiedName) {
        return Connection.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static Connection refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((ConnectionBuilder)((ConnectionBuilder)Connection._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static Connection get(String id) throws AtlanException {
        return Connection.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static Connection get(AtlanClient client, String id) throws AtlanException {
        return Connection.get(client, id, true);
    }

    @JsonIgnore
    public static Connection get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof Connection) {
                return (Connection)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof Connection) {
            return (Connection)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Connection.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static AtlanConnectorType getConnectorTypeFromQualifiedName(String qualifiedName) {
        return Connection.getConnectorTypeFromQualifiedName(qualifiedName.split("/"));
    }

    public static AtlanConnectorType getConnectorTypeFromQualifiedName(String[] tokens) {
        if (tokens.length > 1) {
            return AtlanConnectorType.fromValue(tokens[1]);
        }
        return null;
    }

    public static ConnectionBuilder<?, ?> creator(String name, AtlanConnectorType connectorType) throws AtlanException {
        AtlanClient client = Atlan.getDefaultClient();
        return Connection.creator(client, name, connectorType, List.of(client.getRoleCache().getIdForName("$admin")), null, null);
    }

    public static ConnectionBuilder<?, ?> creator(String name, AtlanConnectorType connectorType, List<String> adminRoles, List<String> adminGroups, List<String> adminUsers) throws AtlanException {
        return Connection.creator(Atlan.getDefaultClient(), name, connectorType, adminRoles, adminGroups, adminUsers);
    }

    public static ConnectionBuilder<?, ?> creator(AtlanClient client, String name, AtlanConnectorType connectorType, List<String> adminRoles, List<String> adminGroups, List<String> adminUsers) throws AtlanException {
        boolean adminFound = false;
        ConnectionBuilder builder = (ConnectionBuilder)((Asset.AssetBuilder)((ConnectionBuilder)((ConnectionBuilder)((ConnectionBuilder)Connection._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).name(name)).qualifiedName(Connection.generateQualifiedName(connectorType.getValue()))).category(connectorType.getCategory())).connectorType(connectorType);
        if (adminRoles != null && !adminRoles.isEmpty()) {
            for (String roleId : adminRoles) {
                client.getRoleCache().getNameForId(roleId);
            }
            adminFound = true;
            builder.adminRoles(adminRoles);
        } else {
            builder.nullField("adminRoles");
        }
        if (adminGroups != null && !adminGroups.isEmpty()) {
            for (String groupAlias : adminGroups) {
                client.getGroupCache().getIdForName(groupAlias);
            }
            adminFound = true;
            builder.adminGroups(adminGroups);
        } else {
            builder.nullField("adminGroups");
        }
        if (adminUsers != null && !adminUsers.isEmpty()) {
            for (String userName : adminUsers) {
                client.getUserCache().getIdForName(userName);
            }
            adminFound = true;
            builder.adminUsers(adminUsers);
        } else {
            builder.nullField("adminUsers");
        }
        if (adminFound) {
            return builder;
        }
        throw new InvalidRequestException(ErrorCode.NO_CONNECTION_ADMIN);
    }

    @Override
    public AsyncCreationResponse save() throws AtlanException {
        return this.save(Atlan.getDefaultClient());
    }

    @Override
    public AsyncCreationResponse save(AtlanClient client) throws AtlanException {
        if (this.adminRoles != null && !this.adminRoles.isEmpty()) {
            for (String roleId : this.adminRoles) {
                client.getRoleCache().getNameForId(roleId);
            }
        }
        if (this.adminGroups != null && !this.adminGroups.isEmpty()) {
            for (String groupAlias : this.adminGroups) {
                client.getGroupCache().getIdForName(groupAlias);
            }
        }
        if (this.adminUsers != null && !this.adminUsers.isEmpty()) {
            for (String userName : this.adminUsers) {
                client.getUserCache().getIdForName(userName);
            }
        }
        return client.assets.save((Asset)this, false);
    }

    @Override
    public AsyncCreationResponse save(boolean replaceAtlanTags) throws AtlanException {
        return this.save(Atlan.getDefaultClient(), replaceAtlanTags);
    }

    @Override
    public AsyncCreationResponse save(AtlanClient client, boolean replaceAtlanTags) throws AtlanException {
        if (this.adminRoles != null && !this.adminRoles.isEmpty()) {
            for (String roleId : this.adminRoles) {
                client.getRoleCache().getNameForId(roleId);
            }
        }
        if (this.adminGroups != null && !this.adminGroups.isEmpty()) {
            for (String groupAlias : this.adminGroups) {
                client.getGroupCache().getIdForName(groupAlias);
            }
        }
        if (this.adminUsers != null && !this.adminUsers.isEmpty()) {
            for (String userName : this.adminUsers) {
                client.getUserCache().getIdForName(userName);
            }
        }
        return client.assets.save((Asset)this, replaceAtlanTags);
    }

    public AssetMutationResponse addApiTokenAsAdmin(String impersonationToken) throws AtlanException {
        return Asset.addApiTokenAsAdmin(this.getGuid(), impersonationToken);
    }

    public static synchronized String generateQualifiedName(AtlanConnectorType connectorType) {
        return Connection.generateQualifiedName(connectorType.getValue());
    }

    private static synchronized String generateQualifiedName(String connectorType) {
        long now = System.currentTimeMillis() / 1000L;
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            log.warn("Connection qualifiedName construction interrupted - exclusivity cannot be guaranteed.", (Throwable)e);
        }
        return "default/" + connectorType + "/" + now;
    }

    public static ConnectionBuilder<?, ?> updater(String qualifiedName, String name) {
        return (ConnectionBuilder)((ConnectionBuilder)((ConnectionBuilder)Connection._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public ConnectionBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        Connection.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return Connection.updater(this.getQualifiedName(), this.getName());
    }

    @JsonIgnore
    public static String getEpochFromQualifiedName(String qualifiedName) {
        return qualifiedName.substring(qualifiedName.lastIndexOf("/") + 1);
    }

    public static List<Connection> findByName(String name, AtlanConnectorType type) throws AtlanException {
        return Connection.findByName(name, type, (List<AtlanField>)null);
    }

    public static List<Connection> findByName(String name, AtlanConnectorType type, Collection<String> attributes) throws AtlanException {
        return Connection.findByName(Atlan.getDefaultClient(), name, type, attributes);
    }

    public static List<Connection> findByName(String name, AtlanConnectorType type, List<AtlanField> attributes) throws AtlanException {
        return Connection.findByName(Atlan.getDefaultClient(), name, type, attributes);
    }

    public static List<Connection> findByName(AtlanClient client, String name, AtlanConnectorType type) throws AtlanException {
        return Connection.findByName(client, name, type, (List<AtlanField>)null);
    }

    public static List<Connection> findByName(AtlanClient client, String name, AtlanConnectorType type, Collection<String> attributes) throws AtlanException {
        ArrayList<Connection> results = new ArrayList<Connection>();
        ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Connection.select(client).where(NAME.eq(name))).where(CONNECTOR_TYPE.eq(type.getValue())))._includesOnResults(attributes == null ? Collections.emptyList() : attributes)).stream().filter(a -> a instanceof Connection).forEach(c -> results.add((Connection)c));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.CONNECTION_NOT_FOUND_BY_NAME, name, type.getValue());
        }
        return results;
    }

    public static List<Connection> findByName(AtlanClient client, String name, AtlanConnectorType type, List<AtlanField> attributes) throws AtlanException {
        ArrayList<Connection> results = new ArrayList<Connection>();
        ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Connection.select(client).where(NAME.eq(name))).where(CONNECTOR_TYPE.eq(type.getValue()))).includesOnResults(attributes == null ? Collections.emptyList() : attributes)).stream().filter(a -> a instanceof Connection).forEach(c -> results.add((Connection)c));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.CONNECTION_NOT_FOUND_BY_NAME, name, type.getValue());
        }
        return results;
    }

    public static List<String> getAllQualifiedNames() throws AtlanException {
        return Connection.getAllQualifiedNames(Atlan.getDefaultClient());
    }

    public static List<String> getAllQualifiedNames(AtlanClient client) throws AtlanException {
        return ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Connection.select(client).includeOnResults(QUALIFIED_NAME)).pageSize(50)).stream().map(Asset::getQualifiedName).collect(Collectors.toList());
    }

    public static Connection removeDescription(String qualifiedName, String name) throws AtlanException {
        return Connection.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static Connection removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Connection)Asset.removeDescription(client, Connection.updater(qualifiedName, name));
    }

    public static Connection removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return Connection.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static Connection removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Connection)Asset.removeUserDescription(client, Connection.updater(qualifiedName, name));
    }

    public static Connection removeOwners(String qualifiedName, String name) throws AtlanException {
        return Connection.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static Connection removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Connection)Asset.removeOwners(client, Connection.updater(qualifiedName, name));
    }

    public static Connection updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return Connection.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static Connection updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (Connection)Asset.updateCertificate(client, Connection._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static Connection removeCertificate(String qualifiedName, String name) throws AtlanException {
        return Connection.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static Connection removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Connection)Asset.removeCertificate(client, Connection.updater(qualifiedName, name));
    }

    public static Connection updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return Connection.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static Connection updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (Connection)Asset.updateAnnouncement(client, Connection._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static Connection removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return Connection.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static Connection removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Connection)Asset.removeAnnouncement(client, Connection.updater(qualifiedName, name));
    }

    public static Connection replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return Connection.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static Connection replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (Connection)Asset.replaceTerms(client, Connection.updater(qualifiedName, name), terms);
    }

    public static Connection appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return Connection.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static Connection appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (Connection)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static Connection removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return Connection.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static Connection removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (Connection)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static Connection appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return Connection.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static Connection appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (Connection)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static Connection appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return Connection.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static Connection appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (Connection)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        Connection.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected Connection(ConnectionBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> queryPreviewConfig;
        this.typeName = b.typeName$set ? b.typeName$value : Connection.$default$typeName();
        this.allowQuery = b.allowQuery;
        this.allowQueryPreview = b.allowQueryPreview;
        this.category = b.category;
        SortedSet<String> connectionDbtEnvironments = new TreeSet<String>();
        if (b.connectionDbtEnvironments != null) {
            connectionDbtEnvironments.addAll(b.connectionDbtEnvironments);
        }
        connectionDbtEnvironments = Collections.unmodifiableSortedSet(connectionDbtEnvironments);
        this.connectionDbtEnvironments = connectionDbtEnvironments;
        this.connectionSSOCredentialGuid = b.connectionSSOCredentialGuid;
        this.connectorIcon = b.connectorIcon;
        this.connectorImage = b.connectorImage;
        this.credentialStrategy = b.credentialStrategy;
        this.defaultCredentialGuid = b.defaultCredentialGuid;
        this.hasPopularityInsights = b.hasPopularityInsights;
        this.host = b.host;
        this.isSampleDataPreviewEnabled = b.isSampleDataPreviewEnabled;
        this.objectStorageUploadThreshold = b.objectStorageUploadThreshold;
        this.policyStrategy = b.policyStrategy;
        this.policyStrategyForSamplePreview = b.policyStrategyForSamplePreview;
        this.popularityInsightsTimeframe = b.popularityInsightsTimeframe;
        this.port = b.port;
        this.previewCredentialStrategy = b.previewCredentialStrategy;
        this.queryConfig = b.queryConfig;
        switch (b.queryPreviewConfig$key == null ? 0 : b.queryPreviewConfig$key.size()) {
            case 0: {
                queryPreviewConfig = Collections.emptyMap();
                break;
            }
            case 1: {
                queryPreviewConfig = Collections.singletonMap(b.queryPreviewConfig$key.get(0), b.queryPreviewConfig$value.get(0));
                break;
            }
            default: {
                queryPreviewConfig = new LinkedHashMap(b.queryPreviewConfig$key.size() < 0x40000000 ? 1 + b.queryPreviewConfig$key.size() + (b.queryPreviewConfig$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.queryPreviewConfig$key.size(); ++$i) {
                    queryPreviewConfig.put(b.queryPreviewConfig$key.get($i), b.queryPreviewConfig$value.get($i));
                }
                queryPreviewConfig = Collections.unmodifiableMap(queryPreviewConfig);
            }
        }
        this.queryPreviewConfig = queryPreviewConfig;
        this.queryTimeout = b.queryTimeout;
        this.queryUsernameStrategy = b.queryUsernameStrategy;
        this.rowLimit = b.rowLimit;
        this.sourceLogo = b.sourceLogo;
        this.subCategory = b.subCategory;
        this.useObjectStorage = b.useObjectStorage;
        this.vectorEmbeddingsEnabled = b.vectorEmbeddingsEnabled;
        this.vectorEmbeddingsUpdatedAt = b.vectorEmbeddingsUpdatedAt;
    }

    @Generated
    public static ConnectionBuilder<?, ?> _internal() {
        return new ConnectionBuilderImpl();
    }

    @Generated
    public ConnectionBuilder<?, ?> toBuilder() {
        return new ConnectionBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public Boolean getAllowQuery() {
        return this.allowQuery;
    }

    @Override
    @Generated
    public Boolean getAllowQueryPreview() {
        return this.allowQueryPreview;
    }

    @Override
    @Generated
    public AtlanConnectionCategory getCategory() {
        return this.category;
    }

    @Override
    @Generated
    public SortedSet<String> getConnectionDbtEnvironments() {
        return this.connectionDbtEnvironments;
    }

    @Override
    @Generated
    public String getConnectionSSOCredentialGuid() {
        return this.connectionSSOCredentialGuid;
    }

    @Override
    @Generated
    public String getConnectorIcon() {
        return this.connectorIcon;
    }

    @Override
    @Generated
    public String getConnectorImage() {
        return this.connectorImage;
    }

    @Override
    @Generated
    public String getCredentialStrategy() {
        return this.credentialStrategy;
    }

    @Override
    @Generated
    public String getDefaultCredentialGuid() {
        return this.defaultCredentialGuid;
    }

    @Override
    @Generated
    public Boolean getHasPopularityInsights() {
        return this.hasPopularityInsights;
    }

    @Override
    @Generated
    public String getHost() {
        return this.host;
    }

    @Override
    @Generated
    public Boolean getIsSampleDataPreviewEnabled() {
        return this.isSampleDataPreviewEnabled;
    }

    @Override
    @Generated
    public Long getObjectStorageUploadThreshold() {
        return this.objectStorageUploadThreshold;
    }

    @Override
    @Generated
    public String getPolicyStrategy() {
        return this.policyStrategy;
    }

    @Override
    @Generated
    public String getPolicyStrategyForSamplePreview() {
        return this.policyStrategyForSamplePreview;
    }

    @Override
    @Generated
    public Long getPopularityInsightsTimeframe() {
        return this.popularityInsightsTimeframe;
    }

    @Override
    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Override
    @Generated
    public String getPreviewCredentialStrategy() {
        return this.previewCredentialStrategy;
    }

    @Override
    @Generated
    public String getQueryConfig() {
        return this.queryConfig;
    }

    @Override
    @Generated
    public Map<String, String> getQueryPreviewConfig() {
        return this.queryPreviewConfig;
    }

    @Override
    @Generated
    public Long getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    @Generated
    public QueryUsernameStrategy getQueryUsernameStrategy() {
        return this.queryUsernameStrategy;
    }

    @Override
    @Generated
    public Long getRowLimit() {
        return this.rowLimit;
    }

    @Override
    @Generated
    public String getSourceLogo() {
        return this.sourceLogo;
    }

    @Override
    @Generated
    public String getSubCategory() {
        return this.subCategory;
    }

    @Override
    @Generated
    public Boolean getUseObjectStorage() {
        return this.useObjectStorage;
    }

    @Override
    @Generated
    public Boolean getVectorEmbeddingsEnabled() {
        return this.vectorEmbeddingsEnabled;
    }

    @Override
    @Generated
    public Long getVectorEmbeddingsUpdatedAt() {
        return this.vectorEmbeddingsUpdatedAt;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Connection)) {
            return false;
        }
        Connection other = (Connection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$allowQuery = this.getAllowQuery();
        Boolean other$allowQuery = other.getAllowQuery();
        if (this$allowQuery == null ? other$allowQuery != null : !((Object)this$allowQuery).equals(other$allowQuery)) {
            return false;
        }
        Boolean this$allowQueryPreview = this.getAllowQueryPreview();
        Boolean other$allowQueryPreview = other.getAllowQueryPreview();
        if (this$allowQueryPreview == null ? other$allowQueryPreview != null : !((Object)this$allowQueryPreview).equals(other$allowQueryPreview)) {
            return false;
        }
        Boolean this$hasPopularityInsights = this.getHasPopularityInsights();
        Boolean other$hasPopularityInsights = other.getHasPopularityInsights();
        if (this$hasPopularityInsights == null ? other$hasPopularityInsights != null : !((Object)this$hasPopularityInsights).equals(other$hasPopularityInsights)) {
            return false;
        }
        Boolean this$isSampleDataPreviewEnabled = this.getIsSampleDataPreviewEnabled();
        Boolean other$isSampleDataPreviewEnabled = other.getIsSampleDataPreviewEnabled();
        if (this$isSampleDataPreviewEnabled == null ? other$isSampleDataPreviewEnabled != null : !((Object)this$isSampleDataPreviewEnabled).equals(other$isSampleDataPreviewEnabled)) {
            return false;
        }
        Long this$objectStorageUploadThreshold = this.getObjectStorageUploadThreshold();
        Long other$objectStorageUploadThreshold = other.getObjectStorageUploadThreshold();
        if (this$objectStorageUploadThreshold == null ? other$objectStorageUploadThreshold != null : !((Object)this$objectStorageUploadThreshold).equals(other$objectStorageUploadThreshold)) {
            return false;
        }
        Long this$popularityInsightsTimeframe = this.getPopularityInsightsTimeframe();
        Long other$popularityInsightsTimeframe = other.getPopularityInsightsTimeframe();
        if (this$popularityInsightsTimeframe == null ? other$popularityInsightsTimeframe != null : !((Object)this$popularityInsightsTimeframe).equals(other$popularityInsightsTimeframe)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Long this$queryTimeout = this.getQueryTimeout();
        Long other$queryTimeout = other.getQueryTimeout();
        if (this$queryTimeout == null ? other$queryTimeout != null : !((Object)this$queryTimeout).equals(other$queryTimeout)) {
            return false;
        }
        Long this$rowLimit = this.getRowLimit();
        Long other$rowLimit = other.getRowLimit();
        if (this$rowLimit == null ? other$rowLimit != null : !((Object)this$rowLimit).equals(other$rowLimit)) {
            return false;
        }
        Boolean this$useObjectStorage = this.getUseObjectStorage();
        Boolean other$useObjectStorage = other.getUseObjectStorage();
        if (this$useObjectStorage == null ? other$useObjectStorage != null : !((Object)this$useObjectStorage).equals(other$useObjectStorage)) {
            return false;
        }
        Boolean this$vectorEmbeddingsEnabled = this.getVectorEmbeddingsEnabled();
        Boolean other$vectorEmbeddingsEnabled = other.getVectorEmbeddingsEnabled();
        if (this$vectorEmbeddingsEnabled == null ? other$vectorEmbeddingsEnabled != null : !((Object)this$vectorEmbeddingsEnabled).equals(other$vectorEmbeddingsEnabled)) {
            return false;
        }
        Long this$vectorEmbeddingsUpdatedAt = this.getVectorEmbeddingsUpdatedAt();
        Long other$vectorEmbeddingsUpdatedAt = other.getVectorEmbeddingsUpdatedAt();
        if (this$vectorEmbeddingsUpdatedAt == null ? other$vectorEmbeddingsUpdatedAt != null : !((Object)this$vectorEmbeddingsUpdatedAt).equals(other$vectorEmbeddingsUpdatedAt)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        AtlanConnectionCategory this$category = this.getCategory();
        AtlanConnectionCategory other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        SortedSet<String> this$connectionDbtEnvironments = this.getConnectionDbtEnvironments();
        SortedSet<String> other$connectionDbtEnvironments = other.getConnectionDbtEnvironments();
        if (this$connectionDbtEnvironments == null ? other$connectionDbtEnvironments != null : !this$connectionDbtEnvironments.equals(other$connectionDbtEnvironments)) {
            return false;
        }
        String this$connectionSSOCredentialGuid = this.getConnectionSSOCredentialGuid();
        String other$connectionSSOCredentialGuid = other.getConnectionSSOCredentialGuid();
        if (this$connectionSSOCredentialGuid == null ? other$connectionSSOCredentialGuid != null : !this$connectionSSOCredentialGuid.equals(other$connectionSSOCredentialGuid)) {
            return false;
        }
        String this$connectorIcon = this.getConnectorIcon();
        String other$connectorIcon = other.getConnectorIcon();
        if (this$connectorIcon == null ? other$connectorIcon != null : !this$connectorIcon.equals(other$connectorIcon)) {
            return false;
        }
        String this$connectorImage = this.getConnectorImage();
        String other$connectorImage = other.getConnectorImage();
        if (this$connectorImage == null ? other$connectorImage != null : !this$connectorImage.equals(other$connectorImage)) {
            return false;
        }
        String this$credentialStrategy = this.getCredentialStrategy();
        String other$credentialStrategy = other.getCredentialStrategy();
        if (this$credentialStrategy == null ? other$credentialStrategy != null : !this$credentialStrategy.equals(other$credentialStrategy)) {
            return false;
        }
        String this$defaultCredentialGuid = this.getDefaultCredentialGuid();
        String other$defaultCredentialGuid = other.getDefaultCredentialGuid();
        if (this$defaultCredentialGuid == null ? other$defaultCredentialGuid != null : !this$defaultCredentialGuid.equals(other$defaultCredentialGuid)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$policyStrategy = this.getPolicyStrategy();
        String other$policyStrategy = other.getPolicyStrategy();
        if (this$policyStrategy == null ? other$policyStrategy != null : !this$policyStrategy.equals(other$policyStrategy)) {
            return false;
        }
        String this$policyStrategyForSamplePreview = this.getPolicyStrategyForSamplePreview();
        String other$policyStrategyForSamplePreview = other.getPolicyStrategyForSamplePreview();
        if (this$policyStrategyForSamplePreview == null ? other$policyStrategyForSamplePreview != null : !this$policyStrategyForSamplePreview.equals(other$policyStrategyForSamplePreview)) {
            return false;
        }
        String this$previewCredentialStrategy = this.getPreviewCredentialStrategy();
        String other$previewCredentialStrategy = other.getPreviewCredentialStrategy();
        if (this$previewCredentialStrategy == null ? other$previewCredentialStrategy != null : !this$previewCredentialStrategy.equals(other$previewCredentialStrategy)) {
            return false;
        }
        String this$queryConfig = this.getQueryConfig();
        String other$queryConfig = other.getQueryConfig();
        if (this$queryConfig == null ? other$queryConfig != null : !this$queryConfig.equals(other$queryConfig)) {
            return false;
        }
        Map<String, String> this$queryPreviewConfig = this.getQueryPreviewConfig();
        Map<String, String> other$queryPreviewConfig = other.getQueryPreviewConfig();
        if (this$queryPreviewConfig == null ? other$queryPreviewConfig != null : !((Object)this$queryPreviewConfig).equals(other$queryPreviewConfig)) {
            return false;
        }
        QueryUsernameStrategy this$queryUsernameStrategy = this.getQueryUsernameStrategy();
        QueryUsernameStrategy other$queryUsernameStrategy = other.getQueryUsernameStrategy();
        if (this$queryUsernameStrategy == null ? other$queryUsernameStrategy != null : !this$queryUsernameStrategy.equals(other$queryUsernameStrategy)) {
            return false;
        }
        String this$sourceLogo = this.getSourceLogo();
        String other$sourceLogo = other.getSourceLogo();
        if (this$sourceLogo == null ? other$sourceLogo != null : !this$sourceLogo.equals(other$sourceLogo)) {
            return false;
        }
        String this$subCategory = this.getSubCategory();
        String other$subCategory = other.getSubCategory();
        return !(this$subCategory == null ? other$subCategory != null : !this$subCategory.equals(other$subCategory));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Connection;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $allowQuery = this.getAllowQuery();
        result = result * 59 + ($allowQuery == null ? 43 : ((Object)$allowQuery).hashCode());
        Boolean $allowQueryPreview = this.getAllowQueryPreview();
        result = result * 59 + ($allowQueryPreview == null ? 43 : ((Object)$allowQueryPreview).hashCode());
        Boolean $hasPopularityInsights = this.getHasPopularityInsights();
        result = result * 59 + ($hasPopularityInsights == null ? 43 : ((Object)$hasPopularityInsights).hashCode());
        Boolean $isSampleDataPreviewEnabled = this.getIsSampleDataPreviewEnabled();
        result = result * 59 + ($isSampleDataPreviewEnabled == null ? 43 : ((Object)$isSampleDataPreviewEnabled).hashCode());
        Long $objectStorageUploadThreshold = this.getObjectStorageUploadThreshold();
        result = result * 59 + ($objectStorageUploadThreshold == null ? 43 : ((Object)$objectStorageUploadThreshold).hashCode());
        Long $popularityInsightsTimeframe = this.getPopularityInsightsTimeframe();
        result = result * 59 + ($popularityInsightsTimeframe == null ? 43 : ((Object)$popularityInsightsTimeframe).hashCode());
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Long $queryTimeout = this.getQueryTimeout();
        result = result * 59 + ($queryTimeout == null ? 43 : ((Object)$queryTimeout).hashCode());
        Long $rowLimit = this.getRowLimit();
        result = result * 59 + ($rowLimit == null ? 43 : ((Object)$rowLimit).hashCode());
        Boolean $useObjectStorage = this.getUseObjectStorage();
        result = result * 59 + ($useObjectStorage == null ? 43 : ((Object)$useObjectStorage).hashCode());
        Boolean $vectorEmbeddingsEnabled = this.getVectorEmbeddingsEnabled();
        result = result * 59 + ($vectorEmbeddingsEnabled == null ? 43 : ((Object)$vectorEmbeddingsEnabled).hashCode());
        Long $vectorEmbeddingsUpdatedAt = this.getVectorEmbeddingsUpdatedAt();
        result = result * 59 + ($vectorEmbeddingsUpdatedAt == null ? 43 : ((Object)$vectorEmbeddingsUpdatedAt).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        AtlanConnectionCategory $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        SortedSet<String> $connectionDbtEnvironments = this.getConnectionDbtEnvironments();
        result = result * 59 + ($connectionDbtEnvironments == null ? 43 : $connectionDbtEnvironments.hashCode());
        String $connectionSSOCredentialGuid = this.getConnectionSSOCredentialGuid();
        result = result * 59 + ($connectionSSOCredentialGuid == null ? 43 : $connectionSSOCredentialGuid.hashCode());
        String $connectorIcon = this.getConnectorIcon();
        result = result * 59 + ($connectorIcon == null ? 43 : $connectorIcon.hashCode());
        String $connectorImage = this.getConnectorImage();
        result = result * 59 + ($connectorImage == null ? 43 : $connectorImage.hashCode());
        String $credentialStrategy = this.getCredentialStrategy();
        result = result * 59 + ($credentialStrategy == null ? 43 : $credentialStrategy.hashCode());
        String $defaultCredentialGuid = this.getDefaultCredentialGuid();
        result = result * 59 + ($defaultCredentialGuid == null ? 43 : $defaultCredentialGuid.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $policyStrategy = this.getPolicyStrategy();
        result = result * 59 + ($policyStrategy == null ? 43 : $policyStrategy.hashCode());
        String $policyStrategyForSamplePreview = this.getPolicyStrategyForSamplePreview();
        result = result * 59 + ($policyStrategyForSamplePreview == null ? 43 : $policyStrategyForSamplePreview.hashCode());
        String $previewCredentialStrategy = this.getPreviewCredentialStrategy();
        result = result * 59 + ($previewCredentialStrategy == null ? 43 : $previewCredentialStrategy.hashCode());
        String $queryConfig = this.getQueryConfig();
        result = result * 59 + ($queryConfig == null ? 43 : $queryConfig.hashCode());
        Map<String, String> $queryPreviewConfig = this.getQueryPreviewConfig();
        result = result * 59 + ($queryPreviewConfig == null ? 43 : ((Object)$queryPreviewConfig).hashCode());
        QueryUsernameStrategy $queryUsernameStrategy = this.getQueryUsernameStrategy();
        result = result * 59 + ($queryUsernameStrategy == null ? 43 : $queryUsernameStrategy.hashCode());
        String $sourceLogo = this.getSourceLogo();
        result = result * 59 + ($sourceLogo == null ? 43 : $sourceLogo.hashCode());
        String $subCategory = this.getSubCategory();
        result = result * 59 + ($subCategory == null ? 43 : $subCategory.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Connection(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", allowQuery=" + this.getAllowQuery() + ", allowQueryPreview=" + this.getAllowQueryPreview() + ", category=" + this.getCategory() + ", connectionDbtEnvironments=" + this.getConnectionDbtEnvironments() + ", connectionSSOCredentialGuid=" + this.getConnectionSSOCredentialGuid() + ", connectorIcon=" + this.getConnectorIcon() + ", connectorImage=" + this.getConnectorImage() + ", credentialStrategy=" + this.getCredentialStrategy() + ", defaultCredentialGuid=" + this.getDefaultCredentialGuid() + ", hasPopularityInsights=" + this.getHasPopularityInsights() + ", host=" + this.getHost() + ", isSampleDataPreviewEnabled=" + this.getIsSampleDataPreviewEnabled() + ", objectStorageUploadThreshold=" + this.getObjectStorageUploadThreshold() + ", policyStrategy=" + this.getPolicyStrategy() + ", policyStrategyForSamplePreview=" + this.getPolicyStrategyForSamplePreview() + ", popularityInsightsTimeframe=" + this.getPopularityInsightsTimeframe() + ", port=" + this.getPort() + ", previewCredentialStrategy=" + this.getPreviewCredentialStrategy() + ", queryConfig=" + this.getQueryConfig() + ", queryPreviewConfig=" + this.getQueryPreviewConfig() + ", queryTimeout=" + this.getQueryTimeout() + ", queryUsernameStrategy=" + this.getQueryUsernameStrategy() + ", rowLimit=" + this.getRowLimit() + ", sourceLogo=" + this.getSourceLogo() + ", subCategory=" + this.getSubCategory() + ", useObjectStorage=" + this.getUseObjectStorage() + ", vectorEmbeddingsEnabled=" + this.getVectorEmbeddingsEnabled() + ", vectorEmbeddingsUpdatedAt=" + this.getVectorEmbeddingsUpdatedAt() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class ConnectionBuilder<C extends Connection, B extends ConnectionBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private Boolean allowQuery;
        @Generated
        private Boolean allowQueryPreview;
        @Generated
        private AtlanConnectionCategory category;
        @Generated
        private ArrayList<String> connectionDbtEnvironments;
        @Generated
        private String connectionSSOCredentialGuid;
        @Generated
        private String connectorIcon;
        @Generated
        private String connectorImage;
        @Generated
        private String credentialStrategy;
        @Generated
        private String defaultCredentialGuid;
        @Generated
        private Boolean hasPopularityInsights;
        @Generated
        private String host;
        @Generated
        private Boolean isSampleDataPreviewEnabled;
        @Generated
        private Long objectStorageUploadThreshold;
        @Generated
        private String policyStrategy;
        @Generated
        private String policyStrategyForSamplePreview;
        @Generated
        private Long popularityInsightsTimeframe;
        @Generated
        private Integer port;
        @Generated
        private String previewCredentialStrategy;
        @Generated
        private String queryConfig;
        @Generated
        private ArrayList<String> queryPreviewConfig$key;
        @Generated
        private ArrayList<String> queryPreviewConfig$value;
        @Generated
        private Long queryTimeout;
        @Generated
        private QueryUsernameStrategy queryUsernameStrategy;
        @Generated
        private Long rowLimit;
        @Generated
        private String sourceLogo;
        @Generated
        private String subCategory;
        @Generated
        private Boolean useObjectStorage;
        @Generated
        private Boolean vectorEmbeddingsEnabled;
        @Generated
        private Long vectorEmbeddingsUpdatedAt;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ConnectionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Connection instance, ConnectionBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.allowQuery(instance.allowQuery);
            b.allowQueryPreview(instance.allowQueryPreview);
            b.category(instance.category);
            b.connectionDbtEnvironments(instance.connectionDbtEnvironments == null ? Collections.emptySortedSet() : instance.connectionDbtEnvironments);
            b.connectionSSOCredentialGuid(instance.connectionSSOCredentialGuid);
            b.connectorIcon(instance.connectorIcon);
            b.connectorImage(instance.connectorImage);
            b.credentialStrategy(instance.credentialStrategy);
            b.defaultCredentialGuid(instance.defaultCredentialGuid);
            b.hasPopularityInsights(instance.hasPopularityInsights);
            b.host(instance.host);
            b.isSampleDataPreviewEnabled(instance.isSampleDataPreviewEnabled);
            b.objectStorageUploadThreshold(instance.objectStorageUploadThreshold);
            b.policyStrategy(instance.policyStrategy);
            b.policyStrategyForSamplePreview(instance.policyStrategyForSamplePreview);
            b.popularityInsightsTimeframe(instance.popularityInsightsTimeframe);
            b.port(instance.port);
            b.previewCredentialStrategy(instance.previewCredentialStrategy);
            b.queryConfig(instance.queryConfig);
            b.queryPreviewConfig(instance.queryPreviewConfig == null ? Collections.emptyMap() : instance.queryPreviewConfig);
            b.queryTimeout(instance.queryTimeout);
            b.queryUsernameStrategy(instance.queryUsernameStrategy);
            b.rowLimit(instance.rowLimit);
            b.sourceLogo(instance.sourceLogo);
            b.subCategory(instance.subCategory);
            b.useObjectStorage(instance.useObjectStorage);
            b.vectorEmbeddingsEnabled(instance.vectorEmbeddingsEnabled);
            b.vectorEmbeddingsUpdatedAt(instance.vectorEmbeddingsUpdatedAt);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B allowQuery(Boolean allowQuery) {
            this.allowQuery = allowQuery;
            return (B)this.self();
        }

        @Generated
        public B allowQueryPreview(Boolean allowQueryPreview) {
            this.allowQueryPreview = allowQueryPreview;
            return (B)this.self();
        }

        @Generated
        public B category(AtlanConnectionCategory category) {
            this.category = category;
            return (B)this.self();
        }

        @Generated
        public B connectionDbtEnvironment(String connectionDbtEnvironment) {
            if (this.connectionDbtEnvironments == null) {
                this.connectionDbtEnvironments = new ArrayList();
            }
            this.connectionDbtEnvironments.add(connectionDbtEnvironment);
            return (B)this.self();
        }

        @Generated
        public B connectionDbtEnvironments(Collection<? extends String> connectionDbtEnvironments) {
            if (connectionDbtEnvironments == null) {
                throw new NullPointerException("connectionDbtEnvironments cannot be null");
            }
            if (this.connectionDbtEnvironments == null) {
                this.connectionDbtEnvironments = new ArrayList();
            }
            this.connectionDbtEnvironments.addAll(connectionDbtEnvironments);
            return (B)this.self();
        }

        @Generated
        public B clearConnectionDbtEnvironments() {
            if (this.connectionDbtEnvironments != null) {
                this.connectionDbtEnvironments.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B connectionSSOCredentialGuid(String connectionSSOCredentialGuid) {
            this.connectionSSOCredentialGuid = connectionSSOCredentialGuid;
            return (B)this.self();
        }

        @Generated
        public B connectorIcon(String connectorIcon) {
            this.connectorIcon = connectorIcon;
            return (B)this.self();
        }

        @Generated
        public B connectorImage(String connectorImage) {
            this.connectorImage = connectorImage;
            return (B)this.self();
        }

        @Generated
        public B credentialStrategy(String credentialStrategy) {
            this.credentialStrategy = credentialStrategy;
            return (B)this.self();
        }

        @Generated
        public B defaultCredentialGuid(String defaultCredentialGuid) {
            this.defaultCredentialGuid = defaultCredentialGuid;
            return (B)this.self();
        }

        @Generated
        public B hasPopularityInsights(Boolean hasPopularityInsights) {
            this.hasPopularityInsights = hasPopularityInsights;
            return (B)this.self();
        }

        @Generated
        public B host(String host) {
            this.host = host;
            return (B)this.self();
        }

        @Generated
        public B isSampleDataPreviewEnabled(Boolean isSampleDataPreviewEnabled) {
            this.isSampleDataPreviewEnabled = isSampleDataPreviewEnabled;
            return (B)this.self();
        }

        @Generated
        public B objectStorageUploadThreshold(Long objectStorageUploadThreshold) {
            this.objectStorageUploadThreshold = objectStorageUploadThreshold;
            return (B)this.self();
        }

        @Generated
        public B policyStrategy(String policyStrategy) {
            this.policyStrategy = policyStrategy;
            return (B)this.self();
        }

        @Generated
        public B policyStrategyForSamplePreview(String policyStrategyForSamplePreview) {
            this.policyStrategyForSamplePreview = policyStrategyForSamplePreview;
            return (B)this.self();
        }

        @Generated
        public B popularityInsightsTimeframe(Long popularityInsightsTimeframe) {
            this.popularityInsightsTimeframe = popularityInsightsTimeframe;
            return (B)this.self();
        }

        @Generated
        public B port(Integer port) {
            this.port = port;
            return (B)this.self();
        }

        @Generated
        public B previewCredentialStrategy(String previewCredentialStrategy) {
            this.previewCredentialStrategy = previewCredentialStrategy;
            return (B)this.self();
        }

        @Generated
        public B queryConfig(String queryConfig) {
            this.queryConfig = queryConfig;
            return (B)this.self();
        }

        @Generated
        public B putQueryPreviewConfig(String putQueryPreviewConfigKey, String putQueryPreviewConfigValue) {
            if (this.queryPreviewConfig$key == null) {
                this.queryPreviewConfig$key = new ArrayList();
                this.queryPreviewConfig$value = new ArrayList();
            }
            this.queryPreviewConfig$key.add(putQueryPreviewConfigKey);
            this.queryPreviewConfig$value.add(putQueryPreviewConfigValue);
            return (B)this.self();
        }

        @Generated
        public B queryPreviewConfig(Map<? extends String, ? extends String> queryPreviewConfig) {
            if (queryPreviewConfig == null) {
                throw new NullPointerException("queryPreviewConfig cannot be null");
            }
            if (this.queryPreviewConfig$key == null) {
                this.queryPreviewConfig$key = new ArrayList();
                this.queryPreviewConfig$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : queryPreviewConfig.entrySet()) {
                this.queryPreviewConfig$key.add($lombokEntry.getKey());
                this.queryPreviewConfig$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearQueryPreviewConfig() {
            if (this.queryPreviewConfig$key != null) {
                this.queryPreviewConfig$key.clear();
                this.queryPreviewConfig$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B queryTimeout(Long queryTimeout) {
            this.queryTimeout = queryTimeout;
            return (B)this.self();
        }

        @Generated
        public B queryUsernameStrategy(QueryUsernameStrategy queryUsernameStrategy) {
            this.queryUsernameStrategy = queryUsernameStrategy;
            return (B)this.self();
        }

        @Generated
        public B rowLimit(Long rowLimit) {
            this.rowLimit = rowLimit;
            return (B)this.self();
        }

        @Generated
        public B sourceLogo(String sourceLogo) {
            this.sourceLogo = sourceLogo;
            return (B)this.self();
        }

        @Generated
        public B subCategory(String subCategory) {
            this.subCategory = subCategory;
            return (B)this.self();
        }

        @Generated
        public B useObjectStorage(Boolean useObjectStorage) {
            this.useObjectStorage = useObjectStorage;
            return (B)this.self();
        }

        @Generated
        public B vectorEmbeddingsEnabled(Boolean vectorEmbeddingsEnabled) {
            this.vectorEmbeddingsEnabled = vectorEmbeddingsEnabled;
            return (B)this.self();
        }

        @Generated
        public B vectorEmbeddingsUpdatedAt(Long vectorEmbeddingsUpdatedAt) {
            this.vectorEmbeddingsUpdatedAt = vectorEmbeddingsUpdatedAt;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Connection.ConnectionBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", allowQuery=" + this.allowQuery + ", allowQueryPreview=" + this.allowQueryPreview + ", category=" + this.category + ", connectionDbtEnvironments=" + this.connectionDbtEnvironments + ", connectionSSOCredentialGuid=" + this.connectionSSOCredentialGuid + ", connectorIcon=" + this.connectorIcon + ", connectorImage=" + this.connectorImage + ", credentialStrategy=" + this.credentialStrategy + ", defaultCredentialGuid=" + this.defaultCredentialGuid + ", hasPopularityInsights=" + this.hasPopularityInsights + ", host=" + this.host + ", isSampleDataPreviewEnabled=" + this.isSampleDataPreviewEnabled + ", objectStorageUploadThreshold=" + this.objectStorageUploadThreshold + ", policyStrategy=" + this.policyStrategy + ", policyStrategyForSamplePreview=" + this.policyStrategyForSamplePreview + ", popularityInsightsTimeframe=" + this.popularityInsightsTimeframe + ", port=" + this.port + ", previewCredentialStrategy=" + this.previewCredentialStrategy + ", queryConfig=" + this.queryConfig + ", queryPreviewConfig$key=" + this.queryPreviewConfig$key + ", queryPreviewConfig$value=" + this.queryPreviewConfig$value + ", queryTimeout=" + this.queryTimeout + ", queryUsernameStrategy=" + this.queryUsernameStrategy + ", rowLimit=" + this.rowLimit + ", sourceLogo=" + this.sourceLogo + ", subCategory=" + this.subCategory + ", useObjectStorage=" + this.useObjectStorage + ", vectorEmbeddingsEnabled=" + this.vectorEmbeddingsEnabled + ", vectorEmbeddingsUpdatedAt=" + this.vectorEmbeddingsUpdatedAt + ")";
        }
    }

    @Generated
    private static final class ConnectionBuilderImpl
    extends ConnectionBuilder<Connection, ConnectionBuilderImpl> {
        @Generated
        private ConnectionBuilderImpl() {
        }

        @Override
        @Generated
        protected ConnectionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Connection build() {
            return new Connection(this);
        }
    }
}

