/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IDM;
import com.atlan.model.assets.IDMDataModel;
import com.atlan.model.assets.IDMVersion;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMDataModel
extends Asset
implements IDMDataModel,
IDM,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DMDataModel.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DMDataModel";
    String typeName;
    @Attribute
    @Date
    Long dmBusinessDate;
    @Attribute
    String dmDataModelDomain;
    @Attribute
    String dmDataModelName;
    @Attribute
    String dmDataModelNamespace;
    @Attribute
    String dmDataModelQualifiedName;
    @Attribute
    String dmDataModelType;
    @Attribute
    String dmEntityName;
    @Attribute
    String dmEntityQualifiedName;
    @Attribute
    @Date
    Long dmExpiredAtBusinessDate;
    @Attribute
    @Date
    Long dmExpiredAtSystemDate;
    @Attribute
    @Date
    Long dmSystemDate;
    @Attribute
    String dmTool;
    @Attribute
    Long dmVersionCount;
    @Attribute
    String dmVersionName;
    @Attribute
    String dmVersionQualifiedName;
    @Attribute
    SortedSet<IDMVersion> dmVersions;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public DMDataModel trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return DMDataModel.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return DMDataModel.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return DMDataModel.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return DMDataModel.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return DMDataModel.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return DMDataModel.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static DMDataModel refByGuid(String guid) {
        return DMDataModel.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static DMDataModel refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((DMDataModelBuilder)((DMDataModelBuilder)DMDataModel._internal().guid(guid)).semantic(semantic)).build();
    }

    public static DMDataModel refByQualifiedName(String qualifiedName) {
        return DMDataModel.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static DMDataModel refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((DMDataModelBuilder)((DMDataModelBuilder)DMDataModel._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static DMDataModel get(String id) throws AtlanException {
        return DMDataModel.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static DMDataModel get(AtlanClient client, String id) throws AtlanException {
        return DMDataModel.get(client, id, true);
    }

    @JsonIgnore
    public static DMDataModel get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof DMDataModel) {
                return (DMDataModel)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof DMDataModel) {
            return (DMDataModel)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return DMDataModel.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static DMDataModelBuilder<?, ?> updater(String qualifiedName, String name) {
        return (DMDataModelBuilder)((DMDataModelBuilder)((DMDataModelBuilder)DMDataModel._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public DMDataModelBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        DMDataModel.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return DMDataModel.updater(this.getQualifiedName(), this.getName());
    }

    public static DMDataModel removeDescription(String qualifiedName, String name) throws AtlanException {
        return DMDataModel.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DMDataModel removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DMDataModel)Asset.removeDescription(client, DMDataModel.updater(qualifiedName, name));
    }

    public static DMDataModel removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return DMDataModel.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DMDataModel removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DMDataModel)Asset.removeUserDescription(client, DMDataModel.updater(qualifiedName, name));
    }

    public static DMDataModel removeOwners(String qualifiedName, String name) throws AtlanException {
        return DMDataModel.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DMDataModel removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DMDataModel)Asset.removeOwners(client, DMDataModel.updater(qualifiedName, name));
    }

    public static DMDataModel updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return DMDataModel.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static DMDataModel updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (DMDataModel)Asset.updateCertificate(client, DMDataModel._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static DMDataModel removeCertificate(String qualifiedName, String name) throws AtlanException {
        return DMDataModel.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DMDataModel removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DMDataModel)Asset.removeCertificate(client, DMDataModel.updater(qualifiedName, name));
    }

    public static DMDataModel updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return DMDataModel.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static DMDataModel updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DMDataModel)Asset.updateAnnouncement(client, DMDataModel._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static DMDataModel removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return DMDataModel.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DMDataModel removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DMDataModel)Asset.removeAnnouncement(client, DMDataModel.updater(qualifiedName, name));
    }

    public static DMDataModel replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return DMDataModel.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static DMDataModel replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (DMDataModel)Asset.replaceTerms(client, DMDataModel.updater(qualifiedName, name), terms);
    }

    public static DMDataModel appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return DMDataModel.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static DMDataModel appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DMDataModel)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static DMDataModel removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return DMDataModel.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static DMDataModel removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DMDataModel)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static DMDataModel appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return DMDataModel.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static DMDataModel appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (DMDataModel)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static DMDataModel appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return DMDataModel.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static DMDataModel appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (DMDataModel)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        DMDataModel.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected DMDataModel(DMDataModelBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : DMDataModel.$default$typeName();
        this.dmBusinessDate = b.dmBusinessDate;
        this.dmDataModelDomain = b.dmDataModelDomain;
        this.dmDataModelName = b.dmDataModelName;
        this.dmDataModelNamespace = b.dmDataModelNamespace;
        this.dmDataModelQualifiedName = b.dmDataModelQualifiedName;
        this.dmDataModelType = b.dmDataModelType;
        this.dmEntityName = b.dmEntityName;
        this.dmEntityQualifiedName = b.dmEntityQualifiedName;
        this.dmExpiredAtBusinessDate = b.dmExpiredAtBusinessDate;
        this.dmExpiredAtSystemDate = b.dmExpiredAtSystemDate;
        this.dmSystemDate = b.dmSystemDate;
        this.dmTool = b.dmTool;
        this.dmVersionCount = b.dmVersionCount;
        this.dmVersionName = b.dmVersionName;
        this.dmVersionQualifiedName = b.dmVersionQualifiedName;
        SortedSet<IDMVersion> dmVersions = new TreeSet<IDMVersion>();
        if (b.dmVersions != null) {
            dmVersions.addAll(b.dmVersions);
        }
        dmVersions = Collections.unmodifiableSortedSet(dmVersions);
        this.dmVersions = dmVersions;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static DMDataModelBuilder<?, ?> _internal() {
        return new DMDataModelBuilderImpl();
    }

    @Generated
    public DMDataModelBuilder<?, ?> toBuilder() {
        return new DMDataModelBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public Long getDmBusinessDate() {
        return this.dmBusinessDate;
    }

    @Override
    @Generated
    public String getDmDataModelDomain() {
        return this.dmDataModelDomain;
    }

    @Override
    @Generated
    public String getDmDataModelName() {
        return this.dmDataModelName;
    }

    @Override
    @Generated
    public String getDmDataModelNamespace() {
        return this.dmDataModelNamespace;
    }

    @Override
    @Generated
    public String getDmDataModelQualifiedName() {
        return this.dmDataModelQualifiedName;
    }

    @Override
    @Generated
    public String getDmDataModelType() {
        return this.dmDataModelType;
    }

    @Override
    @Generated
    public String getDmEntityName() {
        return this.dmEntityName;
    }

    @Override
    @Generated
    public String getDmEntityQualifiedName() {
        return this.dmEntityQualifiedName;
    }

    @Override
    @Generated
    public Long getDmExpiredAtBusinessDate() {
        return this.dmExpiredAtBusinessDate;
    }

    @Override
    @Generated
    public Long getDmExpiredAtSystemDate() {
        return this.dmExpiredAtSystemDate;
    }

    @Override
    @Generated
    public Long getDmSystemDate() {
        return this.dmSystemDate;
    }

    @Override
    @Generated
    public String getDmTool() {
        return this.dmTool;
    }

    @Override
    @Generated
    public Long getDmVersionCount() {
        return this.dmVersionCount;
    }

    @Override
    @Generated
    public String getDmVersionName() {
        return this.dmVersionName;
    }

    @Override
    @Generated
    public String getDmVersionQualifiedName() {
        return this.dmVersionQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IDMVersion> getDmVersions() {
        return this.dmVersions;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DMDataModel)) {
            return false;
        }
        DMDataModel other = (DMDataModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$dmBusinessDate = this.getDmBusinessDate();
        Long other$dmBusinessDate = other.getDmBusinessDate();
        if (this$dmBusinessDate == null ? other$dmBusinessDate != null : !((Object)this$dmBusinessDate).equals(other$dmBusinessDate)) {
            return false;
        }
        Long this$dmExpiredAtBusinessDate = this.getDmExpiredAtBusinessDate();
        Long other$dmExpiredAtBusinessDate = other.getDmExpiredAtBusinessDate();
        if (this$dmExpiredAtBusinessDate == null ? other$dmExpiredAtBusinessDate != null : !((Object)this$dmExpiredAtBusinessDate).equals(other$dmExpiredAtBusinessDate)) {
            return false;
        }
        Long this$dmExpiredAtSystemDate = this.getDmExpiredAtSystemDate();
        Long other$dmExpiredAtSystemDate = other.getDmExpiredAtSystemDate();
        if (this$dmExpiredAtSystemDate == null ? other$dmExpiredAtSystemDate != null : !((Object)this$dmExpiredAtSystemDate).equals(other$dmExpiredAtSystemDate)) {
            return false;
        }
        Long this$dmSystemDate = this.getDmSystemDate();
        Long other$dmSystemDate = other.getDmSystemDate();
        if (this$dmSystemDate == null ? other$dmSystemDate != null : !((Object)this$dmSystemDate).equals(other$dmSystemDate)) {
            return false;
        }
        Long this$dmVersionCount = this.getDmVersionCount();
        Long other$dmVersionCount = other.getDmVersionCount();
        if (this$dmVersionCount == null ? other$dmVersionCount != null : !((Object)this$dmVersionCount).equals(other$dmVersionCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$dmDataModelDomain = this.getDmDataModelDomain();
        String other$dmDataModelDomain = other.getDmDataModelDomain();
        if (this$dmDataModelDomain == null ? other$dmDataModelDomain != null : !this$dmDataModelDomain.equals(other$dmDataModelDomain)) {
            return false;
        }
        String this$dmDataModelName = this.getDmDataModelName();
        String other$dmDataModelName = other.getDmDataModelName();
        if (this$dmDataModelName == null ? other$dmDataModelName != null : !this$dmDataModelName.equals(other$dmDataModelName)) {
            return false;
        }
        String this$dmDataModelNamespace = this.getDmDataModelNamespace();
        String other$dmDataModelNamespace = other.getDmDataModelNamespace();
        if (this$dmDataModelNamespace == null ? other$dmDataModelNamespace != null : !this$dmDataModelNamespace.equals(other$dmDataModelNamespace)) {
            return false;
        }
        String this$dmDataModelQualifiedName = this.getDmDataModelQualifiedName();
        String other$dmDataModelQualifiedName = other.getDmDataModelQualifiedName();
        if (this$dmDataModelQualifiedName == null ? other$dmDataModelQualifiedName != null : !this$dmDataModelQualifiedName.equals(other$dmDataModelQualifiedName)) {
            return false;
        }
        String this$dmDataModelType = this.getDmDataModelType();
        String other$dmDataModelType = other.getDmDataModelType();
        if (this$dmDataModelType == null ? other$dmDataModelType != null : !this$dmDataModelType.equals(other$dmDataModelType)) {
            return false;
        }
        String this$dmEntityName = this.getDmEntityName();
        String other$dmEntityName = other.getDmEntityName();
        if (this$dmEntityName == null ? other$dmEntityName != null : !this$dmEntityName.equals(other$dmEntityName)) {
            return false;
        }
        String this$dmEntityQualifiedName = this.getDmEntityQualifiedName();
        String other$dmEntityQualifiedName = other.getDmEntityQualifiedName();
        if (this$dmEntityQualifiedName == null ? other$dmEntityQualifiedName != null : !this$dmEntityQualifiedName.equals(other$dmEntityQualifiedName)) {
            return false;
        }
        String this$dmTool = this.getDmTool();
        String other$dmTool = other.getDmTool();
        if (this$dmTool == null ? other$dmTool != null : !this$dmTool.equals(other$dmTool)) {
            return false;
        }
        String this$dmVersionName = this.getDmVersionName();
        String other$dmVersionName = other.getDmVersionName();
        if (this$dmVersionName == null ? other$dmVersionName != null : !this$dmVersionName.equals(other$dmVersionName)) {
            return false;
        }
        String this$dmVersionQualifiedName = this.getDmVersionQualifiedName();
        String other$dmVersionQualifiedName = other.getDmVersionQualifiedName();
        if (this$dmVersionQualifiedName == null ? other$dmVersionQualifiedName != null : !this$dmVersionQualifiedName.equals(other$dmVersionQualifiedName)) {
            return false;
        }
        SortedSet<IDMVersion> this$dmVersions = this.getDmVersions();
        SortedSet<IDMVersion> other$dmVersions = other.getDmVersions();
        if (this$dmVersions == null ? other$dmVersions != null : !this$dmVersions.equals(other$dmVersions)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DMDataModel;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $dmBusinessDate = this.getDmBusinessDate();
        result = result * 59 + ($dmBusinessDate == null ? 43 : ((Object)$dmBusinessDate).hashCode());
        Long $dmExpiredAtBusinessDate = this.getDmExpiredAtBusinessDate();
        result = result * 59 + ($dmExpiredAtBusinessDate == null ? 43 : ((Object)$dmExpiredAtBusinessDate).hashCode());
        Long $dmExpiredAtSystemDate = this.getDmExpiredAtSystemDate();
        result = result * 59 + ($dmExpiredAtSystemDate == null ? 43 : ((Object)$dmExpiredAtSystemDate).hashCode());
        Long $dmSystemDate = this.getDmSystemDate();
        result = result * 59 + ($dmSystemDate == null ? 43 : ((Object)$dmSystemDate).hashCode());
        Long $dmVersionCount = this.getDmVersionCount();
        result = result * 59 + ($dmVersionCount == null ? 43 : ((Object)$dmVersionCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $dmDataModelDomain = this.getDmDataModelDomain();
        result = result * 59 + ($dmDataModelDomain == null ? 43 : $dmDataModelDomain.hashCode());
        String $dmDataModelName = this.getDmDataModelName();
        result = result * 59 + ($dmDataModelName == null ? 43 : $dmDataModelName.hashCode());
        String $dmDataModelNamespace = this.getDmDataModelNamespace();
        result = result * 59 + ($dmDataModelNamespace == null ? 43 : $dmDataModelNamespace.hashCode());
        String $dmDataModelQualifiedName = this.getDmDataModelQualifiedName();
        result = result * 59 + ($dmDataModelQualifiedName == null ? 43 : $dmDataModelQualifiedName.hashCode());
        String $dmDataModelType = this.getDmDataModelType();
        result = result * 59 + ($dmDataModelType == null ? 43 : $dmDataModelType.hashCode());
        String $dmEntityName = this.getDmEntityName();
        result = result * 59 + ($dmEntityName == null ? 43 : $dmEntityName.hashCode());
        String $dmEntityQualifiedName = this.getDmEntityQualifiedName();
        result = result * 59 + ($dmEntityQualifiedName == null ? 43 : $dmEntityQualifiedName.hashCode());
        String $dmTool = this.getDmTool();
        result = result * 59 + ($dmTool == null ? 43 : $dmTool.hashCode());
        String $dmVersionName = this.getDmVersionName();
        result = result * 59 + ($dmVersionName == null ? 43 : $dmVersionName.hashCode());
        String $dmVersionQualifiedName = this.getDmVersionQualifiedName();
        result = result * 59 + ($dmVersionQualifiedName == null ? 43 : $dmVersionQualifiedName.hashCode());
        SortedSet<IDMVersion> $dmVersions = this.getDmVersions();
        result = result * 59 + ($dmVersions == null ? 43 : $dmVersions.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "DMDataModel(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", dmBusinessDate=" + this.getDmBusinessDate() + ", dmDataModelDomain=" + this.getDmDataModelDomain() + ", dmDataModelName=" + this.getDmDataModelName() + ", dmDataModelNamespace=" + this.getDmDataModelNamespace() + ", dmDataModelQualifiedName=" + this.getDmDataModelQualifiedName() + ", dmDataModelType=" + this.getDmDataModelType() + ", dmEntityName=" + this.getDmEntityName() + ", dmEntityQualifiedName=" + this.getDmEntityQualifiedName() + ", dmExpiredAtBusinessDate=" + this.getDmExpiredAtBusinessDate() + ", dmExpiredAtSystemDate=" + this.getDmExpiredAtSystemDate() + ", dmSystemDate=" + this.getDmSystemDate() + ", dmTool=" + this.getDmTool() + ", dmVersionCount=" + this.getDmVersionCount() + ", dmVersionName=" + this.getDmVersionName() + ", dmVersionQualifiedName=" + this.getDmVersionQualifiedName() + ", dmVersions=" + this.getDmVersions() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class DMDataModelBuilder<C extends DMDataModel, B extends DMDataModelBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private Long dmBusinessDate;
        @Generated
        private String dmDataModelDomain;
        @Generated
        private String dmDataModelName;
        @Generated
        private String dmDataModelNamespace;
        @Generated
        private String dmDataModelQualifiedName;
        @Generated
        private String dmDataModelType;
        @Generated
        private String dmEntityName;
        @Generated
        private String dmEntityQualifiedName;
        @Generated
        private Long dmExpiredAtBusinessDate;
        @Generated
        private Long dmExpiredAtSystemDate;
        @Generated
        private Long dmSystemDate;
        @Generated
        private String dmTool;
        @Generated
        private Long dmVersionCount;
        @Generated
        private String dmVersionName;
        @Generated
        private String dmVersionQualifiedName;
        @Generated
        private ArrayList<IDMVersion> dmVersions;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DMDataModelBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(DMDataModel instance, DMDataModelBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dmBusinessDate(instance.dmBusinessDate);
            b.dmDataModelDomain(instance.dmDataModelDomain);
            b.dmDataModelName(instance.dmDataModelName);
            b.dmDataModelNamespace(instance.dmDataModelNamespace);
            b.dmDataModelQualifiedName(instance.dmDataModelQualifiedName);
            b.dmDataModelType(instance.dmDataModelType);
            b.dmEntityName(instance.dmEntityName);
            b.dmEntityQualifiedName(instance.dmEntityQualifiedName);
            b.dmExpiredAtBusinessDate(instance.dmExpiredAtBusinessDate);
            b.dmExpiredAtSystemDate(instance.dmExpiredAtSystemDate);
            b.dmSystemDate(instance.dmSystemDate);
            b.dmTool(instance.dmTool);
            b.dmVersionCount(instance.dmVersionCount);
            b.dmVersionName(instance.dmVersionName);
            b.dmVersionQualifiedName(instance.dmVersionQualifiedName);
            b.dmVersions(instance.dmVersions == null ? Collections.emptySortedSet() : instance.dmVersions);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B dmBusinessDate(Long dmBusinessDate) {
            this.dmBusinessDate = dmBusinessDate;
            return (B)this.self();
        }

        @Generated
        public B dmDataModelDomain(String dmDataModelDomain) {
            this.dmDataModelDomain = dmDataModelDomain;
            return (B)this.self();
        }

        @Generated
        public B dmDataModelName(String dmDataModelName) {
            this.dmDataModelName = dmDataModelName;
            return (B)this.self();
        }

        @Generated
        public B dmDataModelNamespace(String dmDataModelNamespace) {
            this.dmDataModelNamespace = dmDataModelNamespace;
            return (B)this.self();
        }

        @Generated
        public B dmDataModelQualifiedName(String dmDataModelQualifiedName) {
            this.dmDataModelQualifiedName = dmDataModelQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B dmDataModelType(String dmDataModelType) {
            this.dmDataModelType = dmDataModelType;
            return (B)this.self();
        }

        @Generated
        public B dmEntityName(String dmEntityName) {
            this.dmEntityName = dmEntityName;
            return (B)this.self();
        }

        @Generated
        public B dmEntityQualifiedName(String dmEntityQualifiedName) {
            this.dmEntityQualifiedName = dmEntityQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B dmExpiredAtBusinessDate(Long dmExpiredAtBusinessDate) {
            this.dmExpiredAtBusinessDate = dmExpiredAtBusinessDate;
            return (B)this.self();
        }

        @Generated
        public B dmExpiredAtSystemDate(Long dmExpiredAtSystemDate) {
            this.dmExpiredAtSystemDate = dmExpiredAtSystemDate;
            return (B)this.self();
        }

        @Generated
        public B dmSystemDate(Long dmSystemDate) {
            this.dmSystemDate = dmSystemDate;
            return (B)this.self();
        }

        @Generated
        public B dmTool(String dmTool) {
            this.dmTool = dmTool;
            return (B)this.self();
        }

        @Generated
        public B dmVersionCount(Long dmVersionCount) {
            this.dmVersionCount = dmVersionCount;
            return (B)this.self();
        }

        @Generated
        public B dmVersionName(String dmVersionName) {
            this.dmVersionName = dmVersionName;
            return (B)this.self();
        }

        @Generated
        public B dmVersionQualifiedName(String dmVersionQualifiedName) {
            this.dmVersionQualifiedName = dmVersionQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B dmVersion(IDMVersion dmVersion) {
            if (this.dmVersions == null) {
                this.dmVersions = new ArrayList();
            }
            this.dmVersions.add(dmVersion);
            return (B)this.self();
        }

        @Generated
        public B dmVersions(Collection<? extends IDMVersion> dmVersions) {
            if (dmVersions == null) {
                throw new NullPointerException("dmVersions cannot be null");
            }
            if (this.dmVersions == null) {
                this.dmVersions = new ArrayList();
            }
            this.dmVersions.addAll(dmVersions);
            return (B)this.self();
        }

        @Generated
        public B clearDmVersions() {
            if (this.dmVersions != null) {
                this.dmVersions.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "DMDataModel.DMDataModelBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dmBusinessDate=" + this.dmBusinessDate + ", dmDataModelDomain=" + this.dmDataModelDomain + ", dmDataModelName=" + this.dmDataModelName + ", dmDataModelNamespace=" + this.dmDataModelNamespace + ", dmDataModelQualifiedName=" + this.dmDataModelQualifiedName + ", dmDataModelType=" + this.dmDataModelType + ", dmEntityName=" + this.dmEntityName + ", dmEntityQualifiedName=" + this.dmEntityQualifiedName + ", dmExpiredAtBusinessDate=" + this.dmExpiredAtBusinessDate + ", dmExpiredAtSystemDate=" + this.dmExpiredAtSystemDate + ", dmSystemDate=" + this.dmSystemDate + ", dmTool=" + this.dmTool + ", dmVersionCount=" + this.dmVersionCount + ", dmVersionName=" + this.dmVersionName + ", dmVersionQualifiedName=" + this.dmVersionQualifiedName + ", dmVersions=" + this.dmVersions + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }

    @Generated
    private static final class DMDataModelBuilderImpl
    extends DMDataModelBuilder<DMDataModel, DMDataModelBuilderImpl> {
        @Generated
        private DMDataModelBuilderImpl() {
        }

        @Override
        @Generated
        protected DMDataModelBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DMDataModel build() {
            return new DMDataModel(this);
        }
    }
}

