/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IDM;
import com.atlan.model.assets.IDMEntity;
import com.atlan.model.assets.IDMEntityAssociation;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.DMCardinalityType;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMEntityAssociation
extends Asset
implements IDMEntityAssociation,
IDM,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DMEntityAssociation.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DMEntityAssociation";
    String typeName;
    @Attribute
    @Date
    Long dmBusinessDate;
    @Attribute
    DMCardinalityType dmCardinality;
    @Attribute
    String dmDataModelDomain;
    @Attribute
    String dmDataModelName;
    @Attribute
    String dmDataModelNamespace;
    @Attribute
    String dmDataModelQualifiedName;
    @Attribute
    IDMEntity dmEntityFrom;
    @Attribute
    String dmEntityFromQualifiedName;
    @Attribute
    String dmEntityName;
    @Attribute
    String dmEntityQualifiedName;
    @Attribute
    IDMEntity dmEntityTo;
    @Attribute
    String dmEntityToQualifiedName;
    @Attribute
    @Date
    Long dmExpiredAtBusinessDate;
    @Attribute
    @Date
    Long dmExpiredAtSystemDate;
    @Attribute
    String dmLabel;
    @Attribute
    @Date
    Long dmSystemDate;
    @Attribute
    String dmVersionName;
    @Attribute
    String dmVersionQualifiedName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public DMEntityAssociation trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return DMEntityAssociation.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return DMEntityAssociation.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return DMEntityAssociation.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return DMEntityAssociation.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return DMEntityAssociation.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return DMEntityAssociation.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static DMEntityAssociation refByGuid(String guid) {
        return DMEntityAssociation.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static DMEntityAssociation refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((DMEntityAssociationBuilder)((DMEntityAssociationBuilder)DMEntityAssociation._internal().guid(guid)).semantic(semantic)).build();
    }

    public static DMEntityAssociation refByQualifiedName(String qualifiedName) {
        return DMEntityAssociation.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static DMEntityAssociation refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((DMEntityAssociationBuilder)((DMEntityAssociationBuilder)DMEntityAssociation._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static DMEntityAssociation get(String id) throws AtlanException {
        return DMEntityAssociation.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static DMEntityAssociation get(AtlanClient client, String id) throws AtlanException {
        return DMEntityAssociation.get(client, id, true);
    }

    @JsonIgnore
    public static DMEntityAssociation get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof DMEntityAssociation) {
                return (DMEntityAssociation)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof DMEntityAssociation) {
            return (DMEntityAssociation)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return DMEntityAssociation.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static DMEntityAssociationBuilder<?, ?> updater(String qualifiedName, String name) {
        return (DMEntityAssociationBuilder)((DMEntityAssociationBuilder)((DMEntityAssociationBuilder)DMEntityAssociation._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public DMEntityAssociationBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        DMEntityAssociation.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return DMEntityAssociation.updater(this.getQualifiedName(), this.getName());
    }

    public static DMEntityAssociation removeDescription(String qualifiedName, String name) throws AtlanException {
        return DMEntityAssociation.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DMEntityAssociation removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DMEntityAssociation)Asset.removeDescription(client, DMEntityAssociation.updater(qualifiedName, name));
    }

    public static DMEntityAssociation removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return DMEntityAssociation.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DMEntityAssociation removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DMEntityAssociation)Asset.removeUserDescription(client, DMEntityAssociation.updater(qualifiedName, name));
    }

    public static DMEntityAssociation removeOwners(String qualifiedName, String name) throws AtlanException {
        return DMEntityAssociation.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DMEntityAssociation removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DMEntityAssociation)Asset.removeOwners(client, DMEntityAssociation.updater(qualifiedName, name));
    }

    public static DMEntityAssociation updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return DMEntityAssociation.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static DMEntityAssociation updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (DMEntityAssociation)Asset.updateCertificate(client, DMEntityAssociation._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static DMEntityAssociation removeCertificate(String qualifiedName, String name) throws AtlanException {
        return DMEntityAssociation.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DMEntityAssociation removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DMEntityAssociation)Asset.removeCertificate(client, DMEntityAssociation.updater(qualifiedName, name));
    }

    public static DMEntityAssociation updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return DMEntityAssociation.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static DMEntityAssociation updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DMEntityAssociation)Asset.updateAnnouncement(client, DMEntityAssociation._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static DMEntityAssociation removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return DMEntityAssociation.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DMEntityAssociation removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DMEntityAssociation)Asset.removeAnnouncement(client, DMEntityAssociation.updater(qualifiedName, name));
    }

    public static DMEntityAssociation replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return DMEntityAssociation.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static DMEntityAssociation replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (DMEntityAssociation)Asset.replaceTerms(client, DMEntityAssociation.updater(qualifiedName, name), terms);
    }

    public static DMEntityAssociation appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return DMEntityAssociation.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static DMEntityAssociation appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DMEntityAssociation)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static DMEntityAssociation removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return DMEntityAssociation.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static DMEntityAssociation removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DMEntityAssociation)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static DMEntityAssociation appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return DMEntityAssociation.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static DMEntityAssociation appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (DMEntityAssociation)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static DMEntityAssociation appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return DMEntityAssociation.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static DMEntityAssociation appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (DMEntityAssociation)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        DMEntityAssociation.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected DMEntityAssociation(DMEntityAssociationBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : DMEntityAssociation.$default$typeName();
        this.dmBusinessDate = b.dmBusinessDate;
        this.dmCardinality = b.dmCardinality;
        this.dmDataModelDomain = b.dmDataModelDomain;
        this.dmDataModelName = b.dmDataModelName;
        this.dmDataModelNamespace = b.dmDataModelNamespace;
        this.dmDataModelQualifiedName = b.dmDataModelQualifiedName;
        this.dmEntityFrom = b.dmEntityFrom;
        this.dmEntityFromQualifiedName = b.dmEntityFromQualifiedName;
        this.dmEntityName = b.dmEntityName;
        this.dmEntityQualifiedName = b.dmEntityQualifiedName;
        this.dmEntityTo = b.dmEntityTo;
        this.dmEntityToQualifiedName = b.dmEntityToQualifiedName;
        this.dmExpiredAtBusinessDate = b.dmExpiredAtBusinessDate;
        this.dmExpiredAtSystemDate = b.dmExpiredAtSystemDate;
        this.dmLabel = b.dmLabel;
        this.dmSystemDate = b.dmSystemDate;
        this.dmVersionName = b.dmVersionName;
        this.dmVersionQualifiedName = b.dmVersionQualifiedName;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static DMEntityAssociationBuilder<?, ?> _internal() {
        return new DMEntityAssociationBuilderImpl();
    }

    @Generated
    public DMEntityAssociationBuilder<?, ?> toBuilder() {
        return new DMEntityAssociationBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public Long getDmBusinessDate() {
        return this.dmBusinessDate;
    }

    @Override
    @Generated
    public DMCardinalityType getDmCardinality() {
        return this.dmCardinality;
    }

    @Override
    @Generated
    public String getDmDataModelDomain() {
        return this.dmDataModelDomain;
    }

    @Override
    @Generated
    public String getDmDataModelName() {
        return this.dmDataModelName;
    }

    @Override
    @Generated
    public String getDmDataModelNamespace() {
        return this.dmDataModelNamespace;
    }

    @Override
    @Generated
    public String getDmDataModelQualifiedName() {
        return this.dmDataModelQualifiedName;
    }

    @Override
    @Generated
    public IDMEntity getDmEntityFrom() {
        return this.dmEntityFrom;
    }

    @Override
    @Generated
    public String getDmEntityFromQualifiedName() {
        return this.dmEntityFromQualifiedName;
    }

    @Override
    @Generated
    public String getDmEntityName() {
        return this.dmEntityName;
    }

    @Override
    @Generated
    public String getDmEntityQualifiedName() {
        return this.dmEntityQualifiedName;
    }

    @Override
    @Generated
    public IDMEntity getDmEntityTo() {
        return this.dmEntityTo;
    }

    @Override
    @Generated
    public String getDmEntityToQualifiedName() {
        return this.dmEntityToQualifiedName;
    }

    @Override
    @Generated
    public Long getDmExpiredAtBusinessDate() {
        return this.dmExpiredAtBusinessDate;
    }

    @Override
    @Generated
    public Long getDmExpiredAtSystemDate() {
        return this.dmExpiredAtSystemDate;
    }

    @Override
    @Generated
    public String getDmLabel() {
        return this.dmLabel;
    }

    @Override
    @Generated
    public Long getDmSystemDate() {
        return this.dmSystemDate;
    }

    @Override
    @Generated
    public String getDmVersionName() {
        return this.dmVersionName;
    }

    @Override
    @Generated
    public String getDmVersionQualifiedName() {
        return this.dmVersionQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DMEntityAssociation)) {
            return false;
        }
        DMEntityAssociation other = (DMEntityAssociation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$dmBusinessDate = this.getDmBusinessDate();
        Long other$dmBusinessDate = other.getDmBusinessDate();
        if (this$dmBusinessDate == null ? other$dmBusinessDate != null : !((Object)this$dmBusinessDate).equals(other$dmBusinessDate)) {
            return false;
        }
        Long this$dmExpiredAtBusinessDate = this.getDmExpiredAtBusinessDate();
        Long other$dmExpiredAtBusinessDate = other.getDmExpiredAtBusinessDate();
        if (this$dmExpiredAtBusinessDate == null ? other$dmExpiredAtBusinessDate != null : !((Object)this$dmExpiredAtBusinessDate).equals(other$dmExpiredAtBusinessDate)) {
            return false;
        }
        Long this$dmExpiredAtSystemDate = this.getDmExpiredAtSystemDate();
        Long other$dmExpiredAtSystemDate = other.getDmExpiredAtSystemDate();
        if (this$dmExpiredAtSystemDate == null ? other$dmExpiredAtSystemDate != null : !((Object)this$dmExpiredAtSystemDate).equals(other$dmExpiredAtSystemDate)) {
            return false;
        }
        Long this$dmSystemDate = this.getDmSystemDate();
        Long other$dmSystemDate = other.getDmSystemDate();
        if (this$dmSystemDate == null ? other$dmSystemDate != null : !((Object)this$dmSystemDate).equals(other$dmSystemDate)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        DMCardinalityType this$dmCardinality = this.getDmCardinality();
        DMCardinalityType other$dmCardinality = other.getDmCardinality();
        if (this$dmCardinality == null ? other$dmCardinality != null : !this$dmCardinality.equals(other$dmCardinality)) {
            return false;
        }
        String this$dmDataModelDomain = this.getDmDataModelDomain();
        String other$dmDataModelDomain = other.getDmDataModelDomain();
        if (this$dmDataModelDomain == null ? other$dmDataModelDomain != null : !this$dmDataModelDomain.equals(other$dmDataModelDomain)) {
            return false;
        }
        String this$dmDataModelName = this.getDmDataModelName();
        String other$dmDataModelName = other.getDmDataModelName();
        if (this$dmDataModelName == null ? other$dmDataModelName != null : !this$dmDataModelName.equals(other$dmDataModelName)) {
            return false;
        }
        String this$dmDataModelNamespace = this.getDmDataModelNamespace();
        String other$dmDataModelNamespace = other.getDmDataModelNamespace();
        if (this$dmDataModelNamespace == null ? other$dmDataModelNamespace != null : !this$dmDataModelNamespace.equals(other$dmDataModelNamespace)) {
            return false;
        }
        String this$dmDataModelQualifiedName = this.getDmDataModelQualifiedName();
        String other$dmDataModelQualifiedName = other.getDmDataModelQualifiedName();
        if (this$dmDataModelQualifiedName == null ? other$dmDataModelQualifiedName != null : !this$dmDataModelQualifiedName.equals(other$dmDataModelQualifiedName)) {
            return false;
        }
        IDMEntity this$dmEntityFrom = this.getDmEntityFrom();
        IDMEntity other$dmEntityFrom = other.getDmEntityFrom();
        if (this$dmEntityFrom == null ? other$dmEntityFrom != null : !this$dmEntityFrom.equals(other$dmEntityFrom)) {
            return false;
        }
        String this$dmEntityFromQualifiedName = this.getDmEntityFromQualifiedName();
        String other$dmEntityFromQualifiedName = other.getDmEntityFromQualifiedName();
        if (this$dmEntityFromQualifiedName == null ? other$dmEntityFromQualifiedName != null : !this$dmEntityFromQualifiedName.equals(other$dmEntityFromQualifiedName)) {
            return false;
        }
        String this$dmEntityName = this.getDmEntityName();
        String other$dmEntityName = other.getDmEntityName();
        if (this$dmEntityName == null ? other$dmEntityName != null : !this$dmEntityName.equals(other$dmEntityName)) {
            return false;
        }
        String this$dmEntityQualifiedName = this.getDmEntityQualifiedName();
        String other$dmEntityQualifiedName = other.getDmEntityQualifiedName();
        if (this$dmEntityQualifiedName == null ? other$dmEntityQualifiedName != null : !this$dmEntityQualifiedName.equals(other$dmEntityQualifiedName)) {
            return false;
        }
        IDMEntity this$dmEntityTo = this.getDmEntityTo();
        IDMEntity other$dmEntityTo = other.getDmEntityTo();
        if (this$dmEntityTo == null ? other$dmEntityTo != null : !this$dmEntityTo.equals(other$dmEntityTo)) {
            return false;
        }
        String this$dmEntityToQualifiedName = this.getDmEntityToQualifiedName();
        String other$dmEntityToQualifiedName = other.getDmEntityToQualifiedName();
        if (this$dmEntityToQualifiedName == null ? other$dmEntityToQualifiedName != null : !this$dmEntityToQualifiedName.equals(other$dmEntityToQualifiedName)) {
            return false;
        }
        String this$dmLabel = this.getDmLabel();
        String other$dmLabel = other.getDmLabel();
        if (this$dmLabel == null ? other$dmLabel != null : !this$dmLabel.equals(other$dmLabel)) {
            return false;
        }
        String this$dmVersionName = this.getDmVersionName();
        String other$dmVersionName = other.getDmVersionName();
        if (this$dmVersionName == null ? other$dmVersionName != null : !this$dmVersionName.equals(other$dmVersionName)) {
            return false;
        }
        String this$dmVersionQualifiedName = this.getDmVersionQualifiedName();
        String other$dmVersionQualifiedName = other.getDmVersionQualifiedName();
        if (this$dmVersionQualifiedName == null ? other$dmVersionQualifiedName != null : !this$dmVersionQualifiedName.equals(other$dmVersionQualifiedName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DMEntityAssociation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $dmBusinessDate = this.getDmBusinessDate();
        result = result * 59 + ($dmBusinessDate == null ? 43 : ((Object)$dmBusinessDate).hashCode());
        Long $dmExpiredAtBusinessDate = this.getDmExpiredAtBusinessDate();
        result = result * 59 + ($dmExpiredAtBusinessDate == null ? 43 : ((Object)$dmExpiredAtBusinessDate).hashCode());
        Long $dmExpiredAtSystemDate = this.getDmExpiredAtSystemDate();
        result = result * 59 + ($dmExpiredAtSystemDate == null ? 43 : ((Object)$dmExpiredAtSystemDate).hashCode());
        Long $dmSystemDate = this.getDmSystemDate();
        result = result * 59 + ($dmSystemDate == null ? 43 : ((Object)$dmSystemDate).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        DMCardinalityType $dmCardinality = this.getDmCardinality();
        result = result * 59 + ($dmCardinality == null ? 43 : $dmCardinality.hashCode());
        String $dmDataModelDomain = this.getDmDataModelDomain();
        result = result * 59 + ($dmDataModelDomain == null ? 43 : $dmDataModelDomain.hashCode());
        String $dmDataModelName = this.getDmDataModelName();
        result = result * 59 + ($dmDataModelName == null ? 43 : $dmDataModelName.hashCode());
        String $dmDataModelNamespace = this.getDmDataModelNamespace();
        result = result * 59 + ($dmDataModelNamespace == null ? 43 : $dmDataModelNamespace.hashCode());
        String $dmDataModelQualifiedName = this.getDmDataModelQualifiedName();
        result = result * 59 + ($dmDataModelQualifiedName == null ? 43 : $dmDataModelQualifiedName.hashCode());
        IDMEntity $dmEntityFrom = this.getDmEntityFrom();
        result = result * 59 + ($dmEntityFrom == null ? 43 : $dmEntityFrom.hashCode());
        String $dmEntityFromQualifiedName = this.getDmEntityFromQualifiedName();
        result = result * 59 + ($dmEntityFromQualifiedName == null ? 43 : $dmEntityFromQualifiedName.hashCode());
        String $dmEntityName = this.getDmEntityName();
        result = result * 59 + ($dmEntityName == null ? 43 : $dmEntityName.hashCode());
        String $dmEntityQualifiedName = this.getDmEntityQualifiedName();
        result = result * 59 + ($dmEntityQualifiedName == null ? 43 : $dmEntityQualifiedName.hashCode());
        IDMEntity $dmEntityTo = this.getDmEntityTo();
        result = result * 59 + ($dmEntityTo == null ? 43 : $dmEntityTo.hashCode());
        String $dmEntityToQualifiedName = this.getDmEntityToQualifiedName();
        result = result * 59 + ($dmEntityToQualifiedName == null ? 43 : $dmEntityToQualifiedName.hashCode());
        String $dmLabel = this.getDmLabel();
        result = result * 59 + ($dmLabel == null ? 43 : $dmLabel.hashCode());
        String $dmVersionName = this.getDmVersionName();
        result = result * 59 + ($dmVersionName == null ? 43 : $dmVersionName.hashCode());
        String $dmVersionQualifiedName = this.getDmVersionQualifiedName();
        result = result * 59 + ($dmVersionQualifiedName == null ? 43 : $dmVersionQualifiedName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "DMEntityAssociation(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", dmBusinessDate=" + this.getDmBusinessDate() + ", dmCardinality=" + this.getDmCardinality() + ", dmDataModelDomain=" + this.getDmDataModelDomain() + ", dmDataModelName=" + this.getDmDataModelName() + ", dmDataModelNamespace=" + this.getDmDataModelNamespace() + ", dmDataModelQualifiedName=" + this.getDmDataModelQualifiedName() + ", dmEntityFrom=" + this.getDmEntityFrom() + ", dmEntityFromQualifiedName=" + this.getDmEntityFromQualifiedName() + ", dmEntityName=" + this.getDmEntityName() + ", dmEntityQualifiedName=" + this.getDmEntityQualifiedName() + ", dmEntityTo=" + this.getDmEntityTo() + ", dmEntityToQualifiedName=" + this.getDmEntityToQualifiedName() + ", dmExpiredAtBusinessDate=" + this.getDmExpiredAtBusinessDate() + ", dmExpiredAtSystemDate=" + this.getDmExpiredAtSystemDate() + ", dmLabel=" + this.getDmLabel() + ", dmSystemDate=" + this.getDmSystemDate() + ", dmVersionName=" + this.getDmVersionName() + ", dmVersionQualifiedName=" + this.getDmVersionQualifiedName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class DMEntityAssociationBuilder<C extends DMEntityAssociation, B extends DMEntityAssociationBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private Long dmBusinessDate;
        @Generated
        private DMCardinalityType dmCardinality;
        @Generated
        private String dmDataModelDomain;
        @Generated
        private String dmDataModelName;
        @Generated
        private String dmDataModelNamespace;
        @Generated
        private String dmDataModelQualifiedName;
        @Generated
        private IDMEntity dmEntityFrom;
        @Generated
        private String dmEntityFromQualifiedName;
        @Generated
        private String dmEntityName;
        @Generated
        private String dmEntityQualifiedName;
        @Generated
        private IDMEntity dmEntityTo;
        @Generated
        private String dmEntityToQualifiedName;
        @Generated
        private Long dmExpiredAtBusinessDate;
        @Generated
        private Long dmExpiredAtSystemDate;
        @Generated
        private String dmLabel;
        @Generated
        private Long dmSystemDate;
        @Generated
        private String dmVersionName;
        @Generated
        private String dmVersionQualifiedName;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DMEntityAssociationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(DMEntityAssociation instance, DMEntityAssociationBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dmBusinessDate(instance.dmBusinessDate);
            b.dmCardinality(instance.dmCardinality);
            b.dmDataModelDomain(instance.dmDataModelDomain);
            b.dmDataModelName(instance.dmDataModelName);
            b.dmDataModelNamespace(instance.dmDataModelNamespace);
            b.dmDataModelQualifiedName(instance.dmDataModelQualifiedName);
            b.dmEntityFrom(instance.dmEntityFrom);
            b.dmEntityFromQualifiedName(instance.dmEntityFromQualifiedName);
            b.dmEntityName(instance.dmEntityName);
            b.dmEntityQualifiedName(instance.dmEntityQualifiedName);
            b.dmEntityTo(instance.dmEntityTo);
            b.dmEntityToQualifiedName(instance.dmEntityToQualifiedName);
            b.dmExpiredAtBusinessDate(instance.dmExpiredAtBusinessDate);
            b.dmExpiredAtSystemDate(instance.dmExpiredAtSystemDate);
            b.dmLabel(instance.dmLabel);
            b.dmSystemDate(instance.dmSystemDate);
            b.dmVersionName(instance.dmVersionName);
            b.dmVersionQualifiedName(instance.dmVersionQualifiedName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B dmBusinessDate(Long dmBusinessDate) {
            this.dmBusinessDate = dmBusinessDate;
            return (B)this.self();
        }

        @Generated
        public B dmCardinality(DMCardinalityType dmCardinality) {
            this.dmCardinality = dmCardinality;
            return (B)this.self();
        }

        @Generated
        public B dmDataModelDomain(String dmDataModelDomain) {
            this.dmDataModelDomain = dmDataModelDomain;
            return (B)this.self();
        }

        @Generated
        public B dmDataModelName(String dmDataModelName) {
            this.dmDataModelName = dmDataModelName;
            return (B)this.self();
        }

        @Generated
        public B dmDataModelNamespace(String dmDataModelNamespace) {
            this.dmDataModelNamespace = dmDataModelNamespace;
            return (B)this.self();
        }

        @Generated
        public B dmDataModelQualifiedName(String dmDataModelQualifiedName) {
            this.dmDataModelQualifiedName = dmDataModelQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B dmEntityFrom(IDMEntity dmEntityFrom) {
            this.dmEntityFrom = dmEntityFrom;
            return (B)this.self();
        }

        @Generated
        public B dmEntityFromQualifiedName(String dmEntityFromQualifiedName) {
            this.dmEntityFromQualifiedName = dmEntityFromQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B dmEntityName(String dmEntityName) {
            this.dmEntityName = dmEntityName;
            return (B)this.self();
        }

        @Generated
        public B dmEntityQualifiedName(String dmEntityQualifiedName) {
            this.dmEntityQualifiedName = dmEntityQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B dmEntityTo(IDMEntity dmEntityTo) {
            this.dmEntityTo = dmEntityTo;
            return (B)this.self();
        }

        @Generated
        public B dmEntityToQualifiedName(String dmEntityToQualifiedName) {
            this.dmEntityToQualifiedName = dmEntityToQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B dmExpiredAtBusinessDate(Long dmExpiredAtBusinessDate) {
            this.dmExpiredAtBusinessDate = dmExpiredAtBusinessDate;
            return (B)this.self();
        }

        @Generated
        public B dmExpiredAtSystemDate(Long dmExpiredAtSystemDate) {
            this.dmExpiredAtSystemDate = dmExpiredAtSystemDate;
            return (B)this.self();
        }

        @Generated
        public B dmLabel(String dmLabel) {
            this.dmLabel = dmLabel;
            return (B)this.self();
        }

        @Generated
        public B dmSystemDate(Long dmSystemDate) {
            this.dmSystemDate = dmSystemDate;
            return (B)this.self();
        }

        @Generated
        public B dmVersionName(String dmVersionName) {
            this.dmVersionName = dmVersionName;
            return (B)this.self();
        }

        @Generated
        public B dmVersionQualifiedName(String dmVersionQualifiedName) {
            this.dmVersionQualifiedName = dmVersionQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "DMEntityAssociation.DMEntityAssociationBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dmBusinessDate=" + this.dmBusinessDate + ", dmCardinality=" + this.dmCardinality + ", dmDataModelDomain=" + this.dmDataModelDomain + ", dmDataModelName=" + this.dmDataModelName + ", dmDataModelNamespace=" + this.dmDataModelNamespace + ", dmDataModelQualifiedName=" + this.dmDataModelQualifiedName + ", dmEntityFrom=" + this.dmEntityFrom + ", dmEntityFromQualifiedName=" + this.dmEntityFromQualifiedName + ", dmEntityName=" + this.dmEntityName + ", dmEntityQualifiedName=" + this.dmEntityQualifiedName + ", dmEntityTo=" + this.dmEntityTo + ", dmEntityToQualifiedName=" + this.dmEntityToQualifiedName + ", dmExpiredAtBusinessDate=" + this.dmExpiredAtBusinessDate + ", dmExpiredAtSystemDate=" + this.dmExpiredAtSystemDate + ", dmLabel=" + this.dmLabel + ", dmSystemDate=" + this.dmSystemDate + ", dmVersionName=" + this.dmVersionName + ", dmVersionQualifiedName=" + this.dmVersionQualifiedName + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }

    @Generated
    private static final class DMEntityAssociationBuilderImpl
    extends DMEntityAssociationBuilder<DMEntityAssociation, DMEntityAssociationBuilderImpl> {
        @Generated
        private DMEntityAssociationBuilderImpl() {
        }

        @Override
        @Generated
        protected DMEntityAssociationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DMEntityAssociation build() {
            return new DMEntityAssociation(this);
        }
    }
}

