/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IDbt;
import com.atlan.model.assets.IDbtMetric;
import com.atlan.model.assets.IDbtModel;
import com.atlan.model.assets.IDbtModelColumn;
import com.atlan.model.assets.IDbtTest;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISQL;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.DbtJobRun;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbtModel
extends Asset
implements IDbtModel,
IDbt,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DbtModel.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DbtModel";
    String typeName;
    @Attribute
    String dbtAccountName;
    @Attribute
    String dbtAlias;
    @Attribute
    String dbtCompiledSQL;
    @Attribute
    String dbtConnectionContext;
    @Attribute
    String dbtEnvironmentDbtVersion;
    @Attribute
    String dbtEnvironmentName;
    @Attribute
    String dbtError;
    @Attribute
    @Date
    Long dbtJobLastRun;
    @Attribute
    String dbtJobName;
    @Attribute
    @Date
    Long dbtJobNextRun;
    @Attribute
    String dbtJobNextRunHumanized;
    @Attribute
    List<DbtJobRun> dbtJobRuns;
    @Attribute
    String dbtJobSchedule;
    @Attribute
    String dbtJobScheduleCronHumanized;
    @Attribute
    String dbtJobStatus;
    @Attribute
    String dbtMaterializationType;
    @Attribute
    String dbtMeta;
    @Attribute
    SortedSet<IDbtMetric> dbtMetrics;
    @Attribute
    SortedSet<IDbtModelColumn> dbtModelColumns;
    @Attribute
    @Date
    Long dbtModelCompileCompletedAt;
    @Attribute
    @Date
    Long dbtModelCompileStartedAt;
    @Attribute
    @Date
    Long dbtModelExecuteCompletedAt;
    @Attribute
    @Date
    Long dbtModelExecuteStartedAt;
    @Attribute
    Double dbtModelExecutionTime;
    @Attribute
    Double dbtModelRunElapsedTime;
    @Attribute
    @Date
    Long dbtModelRunGeneratedAt;
    @Attribute
    SortedSet<ISQL> dbtModelSqlAssets;
    @Attribute
    String dbtPackageName;
    @Attribute
    String dbtProjectName;
    @Attribute
    String dbtRawSQL;
    @Attribute
    String dbtSemanticLayerProxyUrl;
    @Attribute
    String dbtStats;
    @Attribute
    String dbtStatus;
    @Attribute
    SortedSet<String> dbtTags;
    @Attribute
    SortedSet<IDbtTest> dbtTests;
    @Attribute
    String dbtUniqueId;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    @JsonProperty(value="sqlAsset")
    ISQL primarySqlAsset;

    @Override
    public DbtModel trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return DbtModel.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return DbtModel.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return DbtModel.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return DbtModel.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return DbtModel.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return DbtModel.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static DbtModel refByGuid(String guid) {
        return DbtModel.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static DbtModel refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((DbtModelBuilder)((DbtModelBuilder)DbtModel._internal().guid(guid)).semantic(semantic)).build();
    }

    public static DbtModel refByQualifiedName(String qualifiedName) {
        return DbtModel.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static DbtModel refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((DbtModelBuilder)((DbtModelBuilder)DbtModel._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static DbtModel get(String id) throws AtlanException {
        return DbtModel.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static DbtModel get(AtlanClient client, String id) throws AtlanException {
        return DbtModel.get(client, id, true);
    }

    @JsonIgnore
    public static DbtModel get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof DbtModel) {
                return (DbtModel)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof DbtModel) {
            return (DbtModel)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return DbtModel.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static DbtModelBuilder<?, ?> updater(String qualifiedName, String name) {
        return (DbtModelBuilder)((DbtModelBuilder)((DbtModelBuilder)DbtModel._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public DbtModelBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        DbtModel.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return DbtModel.updater(this.getQualifiedName(), this.getName());
    }

    public static DbtModel removeDescription(String qualifiedName, String name) throws AtlanException {
        return DbtModel.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DbtModel removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtModel)Asset.removeDescription(client, DbtModel.updater(qualifiedName, name));
    }

    public static DbtModel removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return DbtModel.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DbtModel removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtModel)Asset.removeUserDescription(client, DbtModel.updater(qualifiedName, name));
    }

    public static DbtModel removeOwners(String qualifiedName, String name) throws AtlanException {
        return DbtModel.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DbtModel removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtModel)Asset.removeOwners(client, DbtModel.updater(qualifiedName, name));
    }

    public static DbtModel updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return DbtModel.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static DbtModel updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (DbtModel)Asset.updateCertificate(client, DbtModel._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static DbtModel removeCertificate(String qualifiedName, String name) throws AtlanException {
        return DbtModel.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DbtModel removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtModel)Asset.removeCertificate(client, DbtModel.updater(qualifiedName, name));
    }

    public static DbtModel updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return DbtModel.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static DbtModel updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DbtModel)Asset.updateAnnouncement(client, DbtModel._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static DbtModel removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return DbtModel.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DbtModel removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtModel)Asset.removeAnnouncement(client, DbtModel.updater(qualifiedName, name));
    }

    public static DbtModel replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return DbtModel.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static DbtModel replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (DbtModel)Asset.replaceTerms(client, DbtModel.updater(qualifiedName, name), terms);
    }

    public static DbtModel appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return DbtModel.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static DbtModel appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DbtModel)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static DbtModel removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return DbtModel.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static DbtModel removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DbtModel)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static DbtModel appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return DbtModel.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static DbtModel appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (DbtModel)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static DbtModel appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return DbtModel.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static DbtModel appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (DbtModel)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        DbtModel.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected DbtModel(DbtModelBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : DbtModel.$default$typeName();
        this.dbtAccountName = b.dbtAccountName;
        this.dbtAlias = b.dbtAlias;
        this.dbtCompiledSQL = b.dbtCompiledSQL;
        this.dbtConnectionContext = b.dbtConnectionContext;
        this.dbtEnvironmentDbtVersion = b.dbtEnvironmentDbtVersion;
        this.dbtEnvironmentName = b.dbtEnvironmentName;
        this.dbtError = b.dbtError;
        this.dbtJobLastRun = b.dbtJobLastRun;
        this.dbtJobName = b.dbtJobName;
        this.dbtJobNextRun = b.dbtJobNextRun;
        this.dbtJobNextRunHumanized = b.dbtJobNextRunHumanized;
        this.dbtJobRuns = switch (b.dbtJobRuns == null ? 0 : b.dbtJobRuns.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.dbtJobRuns.get(0));
            default -> Collections.unmodifiableList(new ArrayList<DbtJobRun>(b.dbtJobRuns));
        };
        this.dbtJobSchedule = b.dbtJobSchedule;
        this.dbtJobScheduleCronHumanized = b.dbtJobScheduleCronHumanized;
        this.dbtJobStatus = b.dbtJobStatus;
        this.dbtMaterializationType = b.dbtMaterializationType;
        this.dbtMeta = b.dbtMeta;
        SortedSet<IDbtMetric> dbtMetrics = new TreeSet<IDbtMetric>();
        if (b.dbtMetrics != null) {
            dbtMetrics.addAll(b.dbtMetrics);
        }
        dbtMetrics = Collections.unmodifiableSortedSet(dbtMetrics);
        this.dbtMetrics = dbtMetrics;
        SortedSet<IDbtModelColumn> dbtModelColumns = new TreeSet<IDbtModelColumn>();
        if (b.dbtModelColumns != null) {
            dbtModelColumns.addAll(b.dbtModelColumns);
        }
        dbtModelColumns = Collections.unmodifiableSortedSet(dbtModelColumns);
        this.dbtModelColumns = dbtModelColumns;
        this.dbtModelCompileCompletedAt = b.dbtModelCompileCompletedAt;
        this.dbtModelCompileStartedAt = b.dbtModelCompileStartedAt;
        this.dbtModelExecuteCompletedAt = b.dbtModelExecuteCompletedAt;
        this.dbtModelExecuteStartedAt = b.dbtModelExecuteStartedAt;
        this.dbtModelExecutionTime = b.dbtModelExecutionTime;
        this.dbtModelRunElapsedTime = b.dbtModelRunElapsedTime;
        this.dbtModelRunGeneratedAt = b.dbtModelRunGeneratedAt;
        SortedSet<ISQL> dbtModelSqlAssets = new TreeSet<ISQL>();
        if (b.dbtModelSqlAssets != null) {
            dbtModelSqlAssets.addAll(b.dbtModelSqlAssets);
        }
        dbtModelSqlAssets = Collections.unmodifiableSortedSet(dbtModelSqlAssets);
        this.dbtModelSqlAssets = dbtModelSqlAssets;
        this.dbtPackageName = b.dbtPackageName;
        this.dbtProjectName = b.dbtProjectName;
        this.dbtRawSQL = b.dbtRawSQL;
        this.dbtSemanticLayerProxyUrl = b.dbtSemanticLayerProxyUrl;
        this.dbtStats = b.dbtStats;
        this.dbtStatus = b.dbtStatus;
        SortedSet<String> dbtTags = new TreeSet<String>();
        if (b.dbtTags != null) {
            dbtTags.addAll(b.dbtTags);
        }
        dbtTags = Collections.unmodifiableSortedSet(dbtTags);
        this.dbtTags = dbtTags;
        SortedSet<IDbtTest> dbtTests = new TreeSet<IDbtTest>();
        if (b.dbtTests != null) {
            dbtTests.addAll(b.dbtTests);
        }
        dbtTests = Collections.unmodifiableSortedSet(dbtTests);
        this.dbtTests = dbtTests;
        this.dbtUniqueId = b.dbtUniqueId;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.primarySqlAsset = b.primarySqlAsset;
    }

    @Generated
    public static DbtModelBuilder<?, ?> _internal() {
        return new DbtModelBuilderImpl();
    }

    @Generated
    public DbtModelBuilder<?, ?> toBuilder() {
        return new DbtModelBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getDbtAccountName() {
        return this.dbtAccountName;
    }

    @Override
    @Generated
    public String getDbtAlias() {
        return this.dbtAlias;
    }

    @Override
    @Generated
    public String getDbtCompiledSQL() {
        return this.dbtCompiledSQL;
    }

    @Override
    @Generated
    public String getDbtConnectionContext() {
        return this.dbtConnectionContext;
    }

    @Override
    @Generated
    public String getDbtEnvironmentDbtVersion() {
        return this.dbtEnvironmentDbtVersion;
    }

    @Override
    @Generated
    public String getDbtEnvironmentName() {
        return this.dbtEnvironmentName;
    }

    @Override
    @Generated
    public String getDbtError() {
        return this.dbtError;
    }

    @Override
    @Generated
    public Long getDbtJobLastRun() {
        return this.dbtJobLastRun;
    }

    @Override
    @Generated
    public String getDbtJobName() {
        return this.dbtJobName;
    }

    @Override
    @Generated
    public Long getDbtJobNextRun() {
        return this.dbtJobNextRun;
    }

    @Override
    @Generated
    public String getDbtJobNextRunHumanized() {
        return this.dbtJobNextRunHumanized;
    }

    @Override
    @Generated
    public List<DbtJobRun> getDbtJobRuns() {
        return this.dbtJobRuns;
    }

    @Override
    @Generated
    public String getDbtJobSchedule() {
        return this.dbtJobSchedule;
    }

    @Override
    @Generated
    public String getDbtJobScheduleCronHumanized() {
        return this.dbtJobScheduleCronHumanized;
    }

    @Override
    @Generated
    public String getDbtJobStatus() {
        return this.dbtJobStatus;
    }

    @Override
    @Generated
    public String getDbtMaterializationType() {
        return this.dbtMaterializationType;
    }

    @Override
    @Generated
    public String getDbtMeta() {
        return this.dbtMeta;
    }

    @Override
    @Generated
    public SortedSet<IDbtMetric> getDbtMetrics() {
        return this.dbtMetrics;
    }

    @Override
    @Generated
    public SortedSet<IDbtModelColumn> getDbtModelColumns() {
        return this.dbtModelColumns;
    }

    @Override
    @Generated
    public Long getDbtModelCompileCompletedAt() {
        return this.dbtModelCompileCompletedAt;
    }

    @Override
    @Generated
    public Long getDbtModelCompileStartedAt() {
        return this.dbtModelCompileStartedAt;
    }

    @Override
    @Generated
    public Long getDbtModelExecuteCompletedAt() {
        return this.dbtModelExecuteCompletedAt;
    }

    @Override
    @Generated
    public Long getDbtModelExecuteStartedAt() {
        return this.dbtModelExecuteStartedAt;
    }

    @Override
    @Generated
    public Double getDbtModelExecutionTime() {
        return this.dbtModelExecutionTime;
    }

    @Override
    @Generated
    public Double getDbtModelRunElapsedTime() {
        return this.dbtModelRunElapsedTime;
    }

    @Override
    @Generated
    public Long getDbtModelRunGeneratedAt() {
        return this.dbtModelRunGeneratedAt;
    }

    @Override
    @Generated
    public SortedSet<ISQL> getDbtModelSqlAssets() {
        return this.dbtModelSqlAssets;
    }

    @Override
    @Generated
    public String getDbtPackageName() {
        return this.dbtPackageName;
    }

    @Override
    @Generated
    public String getDbtProjectName() {
        return this.dbtProjectName;
    }

    @Override
    @Generated
    public String getDbtRawSQL() {
        return this.dbtRawSQL;
    }

    @Override
    @Generated
    public String getDbtSemanticLayerProxyUrl() {
        return this.dbtSemanticLayerProxyUrl;
    }

    @Override
    @Generated
    public String getDbtStats() {
        return this.dbtStats;
    }

    @Override
    @Generated
    public String getDbtStatus() {
        return this.dbtStatus;
    }

    @Override
    @Generated
    public SortedSet<String> getDbtTags() {
        return this.dbtTags;
    }

    @Override
    @Generated
    public SortedSet<IDbtTest> getDbtTests() {
        return this.dbtTests;
    }

    @Override
    @Generated
    public String getDbtUniqueId() {
        return this.dbtUniqueId;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public ISQL getPrimarySqlAsset() {
        return this.primarySqlAsset;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DbtModel)) {
            return false;
        }
        DbtModel other = (DbtModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$dbtJobLastRun = this.getDbtJobLastRun();
        Long other$dbtJobLastRun = other.getDbtJobLastRun();
        if (this$dbtJobLastRun == null ? other$dbtJobLastRun != null : !((Object)this$dbtJobLastRun).equals(other$dbtJobLastRun)) {
            return false;
        }
        Long this$dbtJobNextRun = this.getDbtJobNextRun();
        Long other$dbtJobNextRun = other.getDbtJobNextRun();
        if (this$dbtJobNextRun == null ? other$dbtJobNextRun != null : !((Object)this$dbtJobNextRun).equals(other$dbtJobNextRun)) {
            return false;
        }
        Long this$dbtModelCompileCompletedAt = this.getDbtModelCompileCompletedAt();
        Long other$dbtModelCompileCompletedAt = other.getDbtModelCompileCompletedAt();
        if (this$dbtModelCompileCompletedAt == null ? other$dbtModelCompileCompletedAt != null : !((Object)this$dbtModelCompileCompletedAt).equals(other$dbtModelCompileCompletedAt)) {
            return false;
        }
        Long this$dbtModelCompileStartedAt = this.getDbtModelCompileStartedAt();
        Long other$dbtModelCompileStartedAt = other.getDbtModelCompileStartedAt();
        if (this$dbtModelCompileStartedAt == null ? other$dbtModelCompileStartedAt != null : !((Object)this$dbtModelCompileStartedAt).equals(other$dbtModelCompileStartedAt)) {
            return false;
        }
        Long this$dbtModelExecuteCompletedAt = this.getDbtModelExecuteCompletedAt();
        Long other$dbtModelExecuteCompletedAt = other.getDbtModelExecuteCompletedAt();
        if (this$dbtModelExecuteCompletedAt == null ? other$dbtModelExecuteCompletedAt != null : !((Object)this$dbtModelExecuteCompletedAt).equals(other$dbtModelExecuteCompletedAt)) {
            return false;
        }
        Long this$dbtModelExecuteStartedAt = this.getDbtModelExecuteStartedAt();
        Long other$dbtModelExecuteStartedAt = other.getDbtModelExecuteStartedAt();
        if (this$dbtModelExecuteStartedAt == null ? other$dbtModelExecuteStartedAt != null : !((Object)this$dbtModelExecuteStartedAt).equals(other$dbtModelExecuteStartedAt)) {
            return false;
        }
        Double this$dbtModelExecutionTime = this.getDbtModelExecutionTime();
        Double other$dbtModelExecutionTime = other.getDbtModelExecutionTime();
        if (this$dbtModelExecutionTime == null ? other$dbtModelExecutionTime != null : !((Object)this$dbtModelExecutionTime).equals(other$dbtModelExecutionTime)) {
            return false;
        }
        Double this$dbtModelRunElapsedTime = this.getDbtModelRunElapsedTime();
        Double other$dbtModelRunElapsedTime = other.getDbtModelRunElapsedTime();
        if (this$dbtModelRunElapsedTime == null ? other$dbtModelRunElapsedTime != null : !((Object)this$dbtModelRunElapsedTime).equals(other$dbtModelRunElapsedTime)) {
            return false;
        }
        Long this$dbtModelRunGeneratedAt = this.getDbtModelRunGeneratedAt();
        Long other$dbtModelRunGeneratedAt = other.getDbtModelRunGeneratedAt();
        if (this$dbtModelRunGeneratedAt == null ? other$dbtModelRunGeneratedAt != null : !((Object)this$dbtModelRunGeneratedAt).equals(other$dbtModelRunGeneratedAt)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$dbtAccountName = this.getDbtAccountName();
        String other$dbtAccountName = other.getDbtAccountName();
        if (this$dbtAccountName == null ? other$dbtAccountName != null : !this$dbtAccountName.equals(other$dbtAccountName)) {
            return false;
        }
        String this$dbtAlias = this.getDbtAlias();
        String other$dbtAlias = other.getDbtAlias();
        if (this$dbtAlias == null ? other$dbtAlias != null : !this$dbtAlias.equals(other$dbtAlias)) {
            return false;
        }
        String this$dbtCompiledSQL = this.getDbtCompiledSQL();
        String other$dbtCompiledSQL = other.getDbtCompiledSQL();
        if (this$dbtCompiledSQL == null ? other$dbtCompiledSQL != null : !this$dbtCompiledSQL.equals(other$dbtCompiledSQL)) {
            return false;
        }
        String this$dbtConnectionContext = this.getDbtConnectionContext();
        String other$dbtConnectionContext = other.getDbtConnectionContext();
        if (this$dbtConnectionContext == null ? other$dbtConnectionContext != null : !this$dbtConnectionContext.equals(other$dbtConnectionContext)) {
            return false;
        }
        String this$dbtEnvironmentDbtVersion = this.getDbtEnvironmentDbtVersion();
        String other$dbtEnvironmentDbtVersion = other.getDbtEnvironmentDbtVersion();
        if (this$dbtEnvironmentDbtVersion == null ? other$dbtEnvironmentDbtVersion != null : !this$dbtEnvironmentDbtVersion.equals(other$dbtEnvironmentDbtVersion)) {
            return false;
        }
        String this$dbtEnvironmentName = this.getDbtEnvironmentName();
        String other$dbtEnvironmentName = other.getDbtEnvironmentName();
        if (this$dbtEnvironmentName == null ? other$dbtEnvironmentName != null : !this$dbtEnvironmentName.equals(other$dbtEnvironmentName)) {
            return false;
        }
        String this$dbtError = this.getDbtError();
        String other$dbtError = other.getDbtError();
        if (this$dbtError == null ? other$dbtError != null : !this$dbtError.equals(other$dbtError)) {
            return false;
        }
        String this$dbtJobName = this.getDbtJobName();
        String other$dbtJobName = other.getDbtJobName();
        if (this$dbtJobName == null ? other$dbtJobName != null : !this$dbtJobName.equals(other$dbtJobName)) {
            return false;
        }
        String this$dbtJobNextRunHumanized = this.getDbtJobNextRunHumanized();
        String other$dbtJobNextRunHumanized = other.getDbtJobNextRunHumanized();
        if (this$dbtJobNextRunHumanized == null ? other$dbtJobNextRunHumanized != null : !this$dbtJobNextRunHumanized.equals(other$dbtJobNextRunHumanized)) {
            return false;
        }
        List<DbtJobRun> this$dbtJobRuns = this.getDbtJobRuns();
        List<DbtJobRun> other$dbtJobRuns = other.getDbtJobRuns();
        if (this$dbtJobRuns == null ? other$dbtJobRuns != null : !((Object)this$dbtJobRuns).equals(other$dbtJobRuns)) {
            return false;
        }
        String this$dbtJobSchedule = this.getDbtJobSchedule();
        String other$dbtJobSchedule = other.getDbtJobSchedule();
        if (this$dbtJobSchedule == null ? other$dbtJobSchedule != null : !this$dbtJobSchedule.equals(other$dbtJobSchedule)) {
            return false;
        }
        String this$dbtJobScheduleCronHumanized = this.getDbtJobScheduleCronHumanized();
        String other$dbtJobScheduleCronHumanized = other.getDbtJobScheduleCronHumanized();
        if (this$dbtJobScheduleCronHumanized == null ? other$dbtJobScheduleCronHumanized != null : !this$dbtJobScheduleCronHumanized.equals(other$dbtJobScheduleCronHumanized)) {
            return false;
        }
        String this$dbtJobStatus = this.getDbtJobStatus();
        String other$dbtJobStatus = other.getDbtJobStatus();
        if (this$dbtJobStatus == null ? other$dbtJobStatus != null : !this$dbtJobStatus.equals(other$dbtJobStatus)) {
            return false;
        }
        String this$dbtMaterializationType = this.getDbtMaterializationType();
        String other$dbtMaterializationType = other.getDbtMaterializationType();
        if (this$dbtMaterializationType == null ? other$dbtMaterializationType != null : !this$dbtMaterializationType.equals(other$dbtMaterializationType)) {
            return false;
        }
        String this$dbtMeta = this.getDbtMeta();
        String other$dbtMeta = other.getDbtMeta();
        if (this$dbtMeta == null ? other$dbtMeta != null : !this$dbtMeta.equals(other$dbtMeta)) {
            return false;
        }
        SortedSet<IDbtMetric> this$dbtMetrics = this.getDbtMetrics();
        SortedSet<IDbtMetric> other$dbtMetrics = other.getDbtMetrics();
        if (this$dbtMetrics == null ? other$dbtMetrics != null : !this$dbtMetrics.equals(other$dbtMetrics)) {
            return false;
        }
        SortedSet<IDbtModelColumn> this$dbtModelColumns = this.getDbtModelColumns();
        SortedSet<IDbtModelColumn> other$dbtModelColumns = other.getDbtModelColumns();
        if (this$dbtModelColumns == null ? other$dbtModelColumns != null : !this$dbtModelColumns.equals(other$dbtModelColumns)) {
            return false;
        }
        SortedSet<ISQL> this$dbtModelSqlAssets = this.getDbtModelSqlAssets();
        SortedSet<ISQL> other$dbtModelSqlAssets = other.getDbtModelSqlAssets();
        if (this$dbtModelSqlAssets == null ? other$dbtModelSqlAssets != null : !this$dbtModelSqlAssets.equals(other$dbtModelSqlAssets)) {
            return false;
        }
        String this$dbtPackageName = this.getDbtPackageName();
        String other$dbtPackageName = other.getDbtPackageName();
        if (this$dbtPackageName == null ? other$dbtPackageName != null : !this$dbtPackageName.equals(other$dbtPackageName)) {
            return false;
        }
        String this$dbtProjectName = this.getDbtProjectName();
        String other$dbtProjectName = other.getDbtProjectName();
        if (this$dbtProjectName == null ? other$dbtProjectName != null : !this$dbtProjectName.equals(other$dbtProjectName)) {
            return false;
        }
        String this$dbtRawSQL = this.getDbtRawSQL();
        String other$dbtRawSQL = other.getDbtRawSQL();
        if (this$dbtRawSQL == null ? other$dbtRawSQL != null : !this$dbtRawSQL.equals(other$dbtRawSQL)) {
            return false;
        }
        String this$dbtSemanticLayerProxyUrl = this.getDbtSemanticLayerProxyUrl();
        String other$dbtSemanticLayerProxyUrl = other.getDbtSemanticLayerProxyUrl();
        if (this$dbtSemanticLayerProxyUrl == null ? other$dbtSemanticLayerProxyUrl != null : !this$dbtSemanticLayerProxyUrl.equals(other$dbtSemanticLayerProxyUrl)) {
            return false;
        }
        String this$dbtStats = this.getDbtStats();
        String other$dbtStats = other.getDbtStats();
        if (this$dbtStats == null ? other$dbtStats != null : !this$dbtStats.equals(other$dbtStats)) {
            return false;
        }
        String this$dbtStatus = this.getDbtStatus();
        String other$dbtStatus = other.getDbtStatus();
        if (this$dbtStatus == null ? other$dbtStatus != null : !this$dbtStatus.equals(other$dbtStatus)) {
            return false;
        }
        SortedSet<String> this$dbtTags = this.getDbtTags();
        SortedSet<String> other$dbtTags = other.getDbtTags();
        if (this$dbtTags == null ? other$dbtTags != null : !this$dbtTags.equals(other$dbtTags)) {
            return false;
        }
        SortedSet<IDbtTest> this$dbtTests = this.getDbtTests();
        SortedSet<IDbtTest> other$dbtTests = other.getDbtTests();
        if (this$dbtTests == null ? other$dbtTests != null : !this$dbtTests.equals(other$dbtTests)) {
            return false;
        }
        String this$dbtUniqueId = this.getDbtUniqueId();
        String other$dbtUniqueId = other.getDbtUniqueId();
        if (this$dbtUniqueId == null ? other$dbtUniqueId != null : !this$dbtUniqueId.equals(other$dbtUniqueId)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        ISQL this$primarySqlAsset = this.getPrimarySqlAsset();
        ISQL other$primarySqlAsset = other.getPrimarySqlAsset();
        return !(this$primarySqlAsset == null ? other$primarySqlAsset != null : !this$primarySqlAsset.equals(other$primarySqlAsset));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DbtModel;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $dbtJobLastRun = this.getDbtJobLastRun();
        result = result * 59 + ($dbtJobLastRun == null ? 43 : ((Object)$dbtJobLastRun).hashCode());
        Long $dbtJobNextRun = this.getDbtJobNextRun();
        result = result * 59 + ($dbtJobNextRun == null ? 43 : ((Object)$dbtJobNextRun).hashCode());
        Long $dbtModelCompileCompletedAt = this.getDbtModelCompileCompletedAt();
        result = result * 59 + ($dbtModelCompileCompletedAt == null ? 43 : ((Object)$dbtModelCompileCompletedAt).hashCode());
        Long $dbtModelCompileStartedAt = this.getDbtModelCompileStartedAt();
        result = result * 59 + ($dbtModelCompileStartedAt == null ? 43 : ((Object)$dbtModelCompileStartedAt).hashCode());
        Long $dbtModelExecuteCompletedAt = this.getDbtModelExecuteCompletedAt();
        result = result * 59 + ($dbtModelExecuteCompletedAt == null ? 43 : ((Object)$dbtModelExecuteCompletedAt).hashCode());
        Long $dbtModelExecuteStartedAt = this.getDbtModelExecuteStartedAt();
        result = result * 59 + ($dbtModelExecuteStartedAt == null ? 43 : ((Object)$dbtModelExecuteStartedAt).hashCode());
        Double $dbtModelExecutionTime = this.getDbtModelExecutionTime();
        result = result * 59 + ($dbtModelExecutionTime == null ? 43 : ((Object)$dbtModelExecutionTime).hashCode());
        Double $dbtModelRunElapsedTime = this.getDbtModelRunElapsedTime();
        result = result * 59 + ($dbtModelRunElapsedTime == null ? 43 : ((Object)$dbtModelRunElapsedTime).hashCode());
        Long $dbtModelRunGeneratedAt = this.getDbtModelRunGeneratedAt();
        result = result * 59 + ($dbtModelRunGeneratedAt == null ? 43 : ((Object)$dbtModelRunGeneratedAt).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $dbtAccountName = this.getDbtAccountName();
        result = result * 59 + ($dbtAccountName == null ? 43 : $dbtAccountName.hashCode());
        String $dbtAlias = this.getDbtAlias();
        result = result * 59 + ($dbtAlias == null ? 43 : $dbtAlias.hashCode());
        String $dbtCompiledSQL = this.getDbtCompiledSQL();
        result = result * 59 + ($dbtCompiledSQL == null ? 43 : $dbtCompiledSQL.hashCode());
        String $dbtConnectionContext = this.getDbtConnectionContext();
        result = result * 59 + ($dbtConnectionContext == null ? 43 : $dbtConnectionContext.hashCode());
        String $dbtEnvironmentDbtVersion = this.getDbtEnvironmentDbtVersion();
        result = result * 59 + ($dbtEnvironmentDbtVersion == null ? 43 : $dbtEnvironmentDbtVersion.hashCode());
        String $dbtEnvironmentName = this.getDbtEnvironmentName();
        result = result * 59 + ($dbtEnvironmentName == null ? 43 : $dbtEnvironmentName.hashCode());
        String $dbtError = this.getDbtError();
        result = result * 59 + ($dbtError == null ? 43 : $dbtError.hashCode());
        String $dbtJobName = this.getDbtJobName();
        result = result * 59 + ($dbtJobName == null ? 43 : $dbtJobName.hashCode());
        String $dbtJobNextRunHumanized = this.getDbtJobNextRunHumanized();
        result = result * 59 + ($dbtJobNextRunHumanized == null ? 43 : $dbtJobNextRunHumanized.hashCode());
        List<DbtJobRun> $dbtJobRuns = this.getDbtJobRuns();
        result = result * 59 + ($dbtJobRuns == null ? 43 : ((Object)$dbtJobRuns).hashCode());
        String $dbtJobSchedule = this.getDbtJobSchedule();
        result = result * 59 + ($dbtJobSchedule == null ? 43 : $dbtJobSchedule.hashCode());
        String $dbtJobScheduleCronHumanized = this.getDbtJobScheduleCronHumanized();
        result = result * 59 + ($dbtJobScheduleCronHumanized == null ? 43 : $dbtJobScheduleCronHumanized.hashCode());
        String $dbtJobStatus = this.getDbtJobStatus();
        result = result * 59 + ($dbtJobStatus == null ? 43 : $dbtJobStatus.hashCode());
        String $dbtMaterializationType = this.getDbtMaterializationType();
        result = result * 59 + ($dbtMaterializationType == null ? 43 : $dbtMaterializationType.hashCode());
        String $dbtMeta = this.getDbtMeta();
        result = result * 59 + ($dbtMeta == null ? 43 : $dbtMeta.hashCode());
        SortedSet<IDbtMetric> $dbtMetrics = this.getDbtMetrics();
        result = result * 59 + ($dbtMetrics == null ? 43 : $dbtMetrics.hashCode());
        SortedSet<IDbtModelColumn> $dbtModelColumns = this.getDbtModelColumns();
        result = result * 59 + ($dbtModelColumns == null ? 43 : $dbtModelColumns.hashCode());
        SortedSet<ISQL> $dbtModelSqlAssets = this.getDbtModelSqlAssets();
        result = result * 59 + ($dbtModelSqlAssets == null ? 43 : $dbtModelSqlAssets.hashCode());
        String $dbtPackageName = this.getDbtPackageName();
        result = result * 59 + ($dbtPackageName == null ? 43 : $dbtPackageName.hashCode());
        String $dbtProjectName = this.getDbtProjectName();
        result = result * 59 + ($dbtProjectName == null ? 43 : $dbtProjectName.hashCode());
        String $dbtRawSQL = this.getDbtRawSQL();
        result = result * 59 + ($dbtRawSQL == null ? 43 : $dbtRawSQL.hashCode());
        String $dbtSemanticLayerProxyUrl = this.getDbtSemanticLayerProxyUrl();
        result = result * 59 + ($dbtSemanticLayerProxyUrl == null ? 43 : $dbtSemanticLayerProxyUrl.hashCode());
        String $dbtStats = this.getDbtStats();
        result = result * 59 + ($dbtStats == null ? 43 : $dbtStats.hashCode());
        String $dbtStatus = this.getDbtStatus();
        result = result * 59 + ($dbtStatus == null ? 43 : $dbtStatus.hashCode());
        SortedSet<String> $dbtTags = this.getDbtTags();
        result = result * 59 + ($dbtTags == null ? 43 : $dbtTags.hashCode());
        SortedSet<IDbtTest> $dbtTests = this.getDbtTests();
        result = result * 59 + ($dbtTests == null ? 43 : $dbtTests.hashCode());
        String $dbtUniqueId = this.getDbtUniqueId();
        result = result * 59 + ($dbtUniqueId == null ? 43 : $dbtUniqueId.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        ISQL $primarySqlAsset = this.getPrimarySqlAsset();
        result = result * 59 + ($primarySqlAsset == null ? 43 : $primarySqlAsset.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "DbtModel(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", dbtAccountName=" + this.getDbtAccountName() + ", dbtAlias=" + this.getDbtAlias() + ", dbtCompiledSQL=" + this.getDbtCompiledSQL() + ", dbtConnectionContext=" + this.getDbtConnectionContext() + ", dbtEnvironmentDbtVersion=" + this.getDbtEnvironmentDbtVersion() + ", dbtEnvironmentName=" + this.getDbtEnvironmentName() + ", dbtError=" + this.getDbtError() + ", dbtJobLastRun=" + this.getDbtJobLastRun() + ", dbtJobName=" + this.getDbtJobName() + ", dbtJobNextRun=" + this.getDbtJobNextRun() + ", dbtJobNextRunHumanized=" + this.getDbtJobNextRunHumanized() + ", dbtJobRuns=" + this.getDbtJobRuns() + ", dbtJobSchedule=" + this.getDbtJobSchedule() + ", dbtJobScheduleCronHumanized=" + this.getDbtJobScheduleCronHumanized() + ", dbtJobStatus=" + this.getDbtJobStatus() + ", dbtMaterializationType=" + this.getDbtMaterializationType() + ", dbtMeta=" + this.getDbtMeta() + ", dbtMetrics=" + this.getDbtMetrics() + ", dbtModelColumns=" + this.getDbtModelColumns() + ", dbtModelCompileCompletedAt=" + this.getDbtModelCompileCompletedAt() + ", dbtModelCompileStartedAt=" + this.getDbtModelCompileStartedAt() + ", dbtModelExecuteCompletedAt=" + this.getDbtModelExecuteCompletedAt() + ", dbtModelExecuteStartedAt=" + this.getDbtModelExecuteStartedAt() + ", dbtModelExecutionTime=" + this.getDbtModelExecutionTime() + ", dbtModelRunElapsedTime=" + this.getDbtModelRunElapsedTime() + ", dbtModelRunGeneratedAt=" + this.getDbtModelRunGeneratedAt() + ", dbtModelSqlAssets=" + this.getDbtModelSqlAssets() + ", dbtPackageName=" + this.getDbtPackageName() + ", dbtProjectName=" + this.getDbtProjectName() + ", dbtRawSQL=" + this.getDbtRawSQL() + ", dbtSemanticLayerProxyUrl=" + this.getDbtSemanticLayerProxyUrl() + ", dbtStats=" + this.getDbtStats() + ", dbtStatus=" + this.getDbtStatus() + ", dbtTags=" + this.getDbtTags() + ", dbtTests=" + this.getDbtTests() + ", dbtUniqueId=" + this.getDbtUniqueId() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", primarySqlAsset=" + this.getPrimarySqlAsset() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class DbtModelBuilder<C extends DbtModel, B extends DbtModelBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String dbtAccountName;
        @Generated
        private String dbtAlias;
        @Generated
        private String dbtCompiledSQL;
        @Generated
        private String dbtConnectionContext;
        @Generated
        private String dbtEnvironmentDbtVersion;
        @Generated
        private String dbtEnvironmentName;
        @Generated
        private String dbtError;
        @Generated
        private Long dbtJobLastRun;
        @Generated
        private String dbtJobName;
        @Generated
        private Long dbtJobNextRun;
        @Generated
        private String dbtJobNextRunHumanized;
        @Generated
        private ArrayList<DbtJobRun> dbtJobRuns;
        @Generated
        private String dbtJobSchedule;
        @Generated
        private String dbtJobScheduleCronHumanized;
        @Generated
        private String dbtJobStatus;
        @Generated
        private String dbtMaterializationType;
        @Generated
        private String dbtMeta;
        @Generated
        private ArrayList<IDbtMetric> dbtMetrics;
        @Generated
        private ArrayList<IDbtModelColumn> dbtModelColumns;
        @Generated
        private Long dbtModelCompileCompletedAt;
        @Generated
        private Long dbtModelCompileStartedAt;
        @Generated
        private Long dbtModelExecuteCompletedAt;
        @Generated
        private Long dbtModelExecuteStartedAt;
        @Generated
        private Double dbtModelExecutionTime;
        @Generated
        private Double dbtModelRunElapsedTime;
        @Generated
        private Long dbtModelRunGeneratedAt;
        @Generated
        private ArrayList<ISQL> dbtModelSqlAssets;
        @Generated
        private String dbtPackageName;
        @Generated
        private String dbtProjectName;
        @Generated
        private String dbtRawSQL;
        @Generated
        private String dbtSemanticLayerProxyUrl;
        @Generated
        private String dbtStats;
        @Generated
        private String dbtStatus;
        @Generated
        private ArrayList<String> dbtTags;
        @Generated
        private ArrayList<IDbtTest> dbtTests;
        @Generated
        private String dbtUniqueId;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private ISQL primarySqlAsset;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DbtModelBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(DbtModel instance, DbtModelBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dbtAccountName(instance.dbtAccountName);
            b.dbtAlias(instance.dbtAlias);
            b.dbtCompiledSQL(instance.dbtCompiledSQL);
            b.dbtConnectionContext(instance.dbtConnectionContext);
            b.dbtEnvironmentDbtVersion(instance.dbtEnvironmentDbtVersion);
            b.dbtEnvironmentName(instance.dbtEnvironmentName);
            b.dbtError(instance.dbtError);
            b.dbtJobLastRun(instance.dbtJobLastRun);
            b.dbtJobName(instance.dbtJobName);
            b.dbtJobNextRun(instance.dbtJobNextRun);
            b.dbtJobNextRunHumanized(instance.dbtJobNextRunHumanized);
            b.dbtJobRuns(instance.dbtJobRuns == null ? Collections.emptyList() : instance.dbtJobRuns);
            b.dbtJobSchedule(instance.dbtJobSchedule);
            b.dbtJobScheduleCronHumanized(instance.dbtJobScheduleCronHumanized);
            b.dbtJobStatus(instance.dbtJobStatus);
            b.dbtMaterializationType(instance.dbtMaterializationType);
            b.dbtMeta(instance.dbtMeta);
            b.dbtMetrics(instance.dbtMetrics == null ? Collections.emptySortedSet() : instance.dbtMetrics);
            b.dbtModelColumns(instance.dbtModelColumns == null ? Collections.emptySortedSet() : instance.dbtModelColumns);
            b.dbtModelCompileCompletedAt(instance.dbtModelCompileCompletedAt);
            b.dbtModelCompileStartedAt(instance.dbtModelCompileStartedAt);
            b.dbtModelExecuteCompletedAt(instance.dbtModelExecuteCompletedAt);
            b.dbtModelExecuteStartedAt(instance.dbtModelExecuteStartedAt);
            b.dbtModelExecutionTime(instance.dbtModelExecutionTime);
            b.dbtModelRunElapsedTime(instance.dbtModelRunElapsedTime);
            b.dbtModelRunGeneratedAt(instance.dbtModelRunGeneratedAt);
            b.dbtModelSqlAssets(instance.dbtModelSqlAssets == null ? Collections.emptySortedSet() : instance.dbtModelSqlAssets);
            b.dbtPackageName(instance.dbtPackageName);
            b.dbtProjectName(instance.dbtProjectName);
            b.dbtRawSQL(instance.dbtRawSQL);
            b.dbtSemanticLayerProxyUrl(instance.dbtSemanticLayerProxyUrl);
            b.dbtStats(instance.dbtStats);
            b.dbtStatus(instance.dbtStatus);
            b.dbtTags(instance.dbtTags == null ? Collections.emptySortedSet() : instance.dbtTags);
            b.dbtTests(instance.dbtTests == null ? Collections.emptySortedSet() : instance.dbtTests);
            b.dbtUniqueId(instance.dbtUniqueId);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.primarySqlAsset(instance.primarySqlAsset);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B dbtAccountName(String dbtAccountName) {
            this.dbtAccountName = dbtAccountName;
            return (B)this.self();
        }

        @Generated
        public B dbtAlias(String dbtAlias) {
            this.dbtAlias = dbtAlias;
            return (B)this.self();
        }

        @Generated
        public B dbtCompiledSQL(String dbtCompiledSQL) {
            this.dbtCompiledSQL = dbtCompiledSQL;
            return (B)this.self();
        }

        @Generated
        public B dbtConnectionContext(String dbtConnectionContext) {
            this.dbtConnectionContext = dbtConnectionContext;
            return (B)this.self();
        }

        @Generated
        public B dbtEnvironmentDbtVersion(String dbtEnvironmentDbtVersion) {
            this.dbtEnvironmentDbtVersion = dbtEnvironmentDbtVersion;
            return (B)this.self();
        }

        @Generated
        public B dbtEnvironmentName(String dbtEnvironmentName) {
            this.dbtEnvironmentName = dbtEnvironmentName;
            return (B)this.self();
        }

        @Generated
        public B dbtError(String dbtError) {
            this.dbtError = dbtError;
            return (B)this.self();
        }

        @Generated
        public B dbtJobLastRun(Long dbtJobLastRun) {
            this.dbtJobLastRun = dbtJobLastRun;
            return (B)this.self();
        }

        @Generated
        public B dbtJobName(String dbtJobName) {
            this.dbtJobName = dbtJobName;
            return (B)this.self();
        }

        @Generated
        public B dbtJobNextRun(Long dbtJobNextRun) {
            this.dbtJobNextRun = dbtJobNextRun;
            return (B)this.self();
        }

        @Generated
        public B dbtJobNextRunHumanized(String dbtJobNextRunHumanized) {
            this.dbtJobNextRunHumanized = dbtJobNextRunHumanized;
            return (B)this.self();
        }

        @Generated
        public B dbtJobRun(DbtJobRun dbtJobRun) {
            if (this.dbtJobRuns == null) {
                this.dbtJobRuns = new ArrayList();
            }
            this.dbtJobRuns.add(dbtJobRun);
            return (B)this.self();
        }

        @Generated
        public B dbtJobRuns(Collection<? extends DbtJobRun> dbtJobRuns) {
            if (dbtJobRuns == null) {
                throw new NullPointerException("dbtJobRuns cannot be null");
            }
            if (this.dbtJobRuns == null) {
                this.dbtJobRuns = new ArrayList();
            }
            this.dbtJobRuns.addAll(dbtJobRuns);
            return (B)this.self();
        }

        @Generated
        public B clearDbtJobRuns() {
            if (this.dbtJobRuns != null) {
                this.dbtJobRuns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtJobSchedule(String dbtJobSchedule) {
            this.dbtJobSchedule = dbtJobSchedule;
            return (B)this.self();
        }

        @Generated
        public B dbtJobScheduleCronHumanized(String dbtJobScheduleCronHumanized) {
            this.dbtJobScheduleCronHumanized = dbtJobScheduleCronHumanized;
            return (B)this.self();
        }

        @Generated
        public B dbtJobStatus(String dbtJobStatus) {
            this.dbtJobStatus = dbtJobStatus;
            return (B)this.self();
        }

        @Generated
        public B dbtMaterializationType(String dbtMaterializationType) {
            this.dbtMaterializationType = dbtMaterializationType;
            return (B)this.self();
        }

        @Generated
        public B dbtMeta(String dbtMeta) {
            this.dbtMeta = dbtMeta;
            return (B)this.self();
        }

        @Generated
        public B dbtMetric(IDbtMetric dbtMetric) {
            if (this.dbtMetrics == null) {
                this.dbtMetrics = new ArrayList();
            }
            this.dbtMetrics.add(dbtMetric);
            return (B)this.self();
        }

        @Generated
        public B dbtMetrics(Collection<? extends IDbtMetric> dbtMetrics) {
            if (dbtMetrics == null) {
                throw new NullPointerException("dbtMetrics cannot be null");
            }
            if (this.dbtMetrics == null) {
                this.dbtMetrics = new ArrayList();
            }
            this.dbtMetrics.addAll(dbtMetrics);
            return (B)this.self();
        }

        @Generated
        public B clearDbtMetrics() {
            if (this.dbtMetrics != null) {
                this.dbtMetrics.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtModelColumn(IDbtModelColumn dbtModelColumn) {
            if (this.dbtModelColumns == null) {
                this.dbtModelColumns = new ArrayList();
            }
            this.dbtModelColumns.add(dbtModelColumn);
            return (B)this.self();
        }

        @Generated
        public B dbtModelColumns(Collection<? extends IDbtModelColumn> dbtModelColumns) {
            if (dbtModelColumns == null) {
                throw new NullPointerException("dbtModelColumns cannot be null");
            }
            if (this.dbtModelColumns == null) {
                this.dbtModelColumns = new ArrayList();
            }
            this.dbtModelColumns.addAll(dbtModelColumns);
            return (B)this.self();
        }

        @Generated
        public B clearDbtModelColumns() {
            if (this.dbtModelColumns != null) {
                this.dbtModelColumns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtModelCompileCompletedAt(Long dbtModelCompileCompletedAt) {
            this.dbtModelCompileCompletedAt = dbtModelCompileCompletedAt;
            return (B)this.self();
        }

        @Generated
        public B dbtModelCompileStartedAt(Long dbtModelCompileStartedAt) {
            this.dbtModelCompileStartedAt = dbtModelCompileStartedAt;
            return (B)this.self();
        }

        @Generated
        public B dbtModelExecuteCompletedAt(Long dbtModelExecuteCompletedAt) {
            this.dbtModelExecuteCompletedAt = dbtModelExecuteCompletedAt;
            return (B)this.self();
        }

        @Generated
        public B dbtModelExecuteStartedAt(Long dbtModelExecuteStartedAt) {
            this.dbtModelExecuteStartedAt = dbtModelExecuteStartedAt;
            return (B)this.self();
        }

        @Generated
        public B dbtModelExecutionTime(Double dbtModelExecutionTime) {
            this.dbtModelExecutionTime = dbtModelExecutionTime;
            return (B)this.self();
        }

        @Generated
        public B dbtModelRunElapsedTime(Double dbtModelRunElapsedTime) {
            this.dbtModelRunElapsedTime = dbtModelRunElapsedTime;
            return (B)this.self();
        }

        @Generated
        public B dbtModelRunGeneratedAt(Long dbtModelRunGeneratedAt) {
            this.dbtModelRunGeneratedAt = dbtModelRunGeneratedAt;
            return (B)this.self();
        }

        @Generated
        public B dbtModelSqlAsset(ISQL dbtModelSqlAsset) {
            if (this.dbtModelSqlAssets == null) {
                this.dbtModelSqlAssets = new ArrayList();
            }
            this.dbtModelSqlAssets.add(dbtModelSqlAsset);
            return (B)this.self();
        }

        @Generated
        public B dbtModelSqlAssets(Collection<? extends ISQL> dbtModelSqlAssets) {
            if (dbtModelSqlAssets == null) {
                throw new NullPointerException("dbtModelSqlAssets cannot be null");
            }
            if (this.dbtModelSqlAssets == null) {
                this.dbtModelSqlAssets = new ArrayList();
            }
            this.dbtModelSqlAssets.addAll(dbtModelSqlAssets);
            return (B)this.self();
        }

        @Generated
        public B clearDbtModelSqlAssets() {
            if (this.dbtModelSqlAssets != null) {
                this.dbtModelSqlAssets.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtPackageName(String dbtPackageName) {
            this.dbtPackageName = dbtPackageName;
            return (B)this.self();
        }

        @Generated
        public B dbtProjectName(String dbtProjectName) {
            this.dbtProjectName = dbtProjectName;
            return (B)this.self();
        }

        @Generated
        public B dbtRawSQL(String dbtRawSQL) {
            this.dbtRawSQL = dbtRawSQL;
            return (B)this.self();
        }

        @Generated
        public B dbtSemanticLayerProxyUrl(String dbtSemanticLayerProxyUrl) {
            this.dbtSemanticLayerProxyUrl = dbtSemanticLayerProxyUrl;
            return (B)this.self();
        }

        @Generated
        public B dbtStats(String dbtStats) {
            this.dbtStats = dbtStats;
            return (B)this.self();
        }

        @Generated
        public B dbtStatus(String dbtStatus) {
            this.dbtStatus = dbtStatus;
            return (B)this.self();
        }

        @Generated
        public B dbtTag(String dbtTag) {
            if (this.dbtTags == null) {
                this.dbtTags = new ArrayList();
            }
            this.dbtTags.add(dbtTag);
            return (B)this.self();
        }

        @Generated
        public B dbtTags(Collection<? extends String> dbtTags) {
            if (dbtTags == null) {
                throw new NullPointerException("dbtTags cannot be null");
            }
            if (this.dbtTags == null) {
                this.dbtTags = new ArrayList();
            }
            this.dbtTags.addAll(dbtTags);
            return (B)this.self();
        }

        @Generated
        public B clearDbtTags() {
            if (this.dbtTags != null) {
                this.dbtTags.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtTest(IDbtTest dbtTest) {
            if (this.dbtTests == null) {
                this.dbtTests = new ArrayList();
            }
            this.dbtTests.add(dbtTest);
            return (B)this.self();
        }

        @Generated
        public B dbtTests(Collection<? extends IDbtTest> dbtTests) {
            if (dbtTests == null) {
                throw new NullPointerException("dbtTests cannot be null");
            }
            if (this.dbtTests == null) {
                this.dbtTests = new ArrayList();
            }
            this.dbtTests.addAll(dbtTests);
            return (B)this.self();
        }

        @Generated
        public B clearDbtTests() {
            if (this.dbtTests != null) {
                this.dbtTests.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtUniqueId(String dbtUniqueId) {
            this.dbtUniqueId = dbtUniqueId;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @JsonProperty(value="sqlAsset")
        @Generated
        public B primarySqlAsset(ISQL primarySqlAsset) {
            this.primarySqlAsset = primarySqlAsset;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "DbtModel.DbtModelBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dbtAccountName=" + this.dbtAccountName + ", dbtAlias=" + this.dbtAlias + ", dbtCompiledSQL=" + this.dbtCompiledSQL + ", dbtConnectionContext=" + this.dbtConnectionContext + ", dbtEnvironmentDbtVersion=" + this.dbtEnvironmentDbtVersion + ", dbtEnvironmentName=" + this.dbtEnvironmentName + ", dbtError=" + this.dbtError + ", dbtJobLastRun=" + this.dbtJobLastRun + ", dbtJobName=" + this.dbtJobName + ", dbtJobNextRun=" + this.dbtJobNextRun + ", dbtJobNextRunHumanized=" + this.dbtJobNextRunHumanized + ", dbtJobRuns=" + this.dbtJobRuns + ", dbtJobSchedule=" + this.dbtJobSchedule + ", dbtJobScheduleCronHumanized=" + this.dbtJobScheduleCronHumanized + ", dbtJobStatus=" + this.dbtJobStatus + ", dbtMaterializationType=" + this.dbtMaterializationType + ", dbtMeta=" + this.dbtMeta + ", dbtMetrics=" + this.dbtMetrics + ", dbtModelColumns=" + this.dbtModelColumns + ", dbtModelCompileCompletedAt=" + this.dbtModelCompileCompletedAt + ", dbtModelCompileStartedAt=" + this.dbtModelCompileStartedAt + ", dbtModelExecuteCompletedAt=" + this.dbtModelExecuteCompletedAt + ", dbtModelExecuteStartedAt=" + this.dbtModelExecuteStartedAt + ", dbtModelExecutionTime=" + this.dbtModelExecutionTime + ", dbtModelRunElapsedTime=" + this.dbtModelRunElapsedTime + ", dbtModelRunGeneratedAt=" + this.dbtModelRunGeneratedAt + ", dbtModelSqlAssets=" + this.dbtModelSqlAssets + ", dbtPackageName=" + this.dbtPackageName + ", dbtProjectName=" + this.dbtProjectName + ", dbtRawSQL=" + this.dbtRawSQL + ", dbtSemanticLayerProxyUrl=" + this.dbtSemanticLayerProxyUrl + ", dbtStats=" + this.dbtStats + ", dbtStatus=" + this.dbtStatus + ", dbtTags=" + this.dbtTags + ", dbtTests=" + this.dbtTests + ", dbtUniqueId=" + this.dbtUniqueId + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", primarySqlAsset=" + this.primarySqlAsset + ")";
        }
    }

    @Generated
    private static final class DbtModelBuilderImpl
    extends DbtModelBuilder<DbtModel, DbtModelBuilderImpl> {
        @Generated
        private DbtModelBuilderImpl() {
        }

        @Override
        @Generated
        protected DbtModelBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DbtModel build() {
            return new DbtModel(this);
        }
    }
}

