/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IMode;
import com.atlan.model.assets.IModeCollection;
import com.atlan.model.assets.IModeWorkspace;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModeWorkspace
extends Asset
implements IModeWorkspace,
IMode,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModeWorkspace.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "ModeWorkspace";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    Long modeCollectionCount;
    @Attribute
    SortedSet<IModeCollection> modeCollections;
    @Attribute
    String modeId;
    @Attribute
    String modeQueryName;
    @Attribute
    String modeQueryQualifiedName;
    @Attribute
    String modeReportName;
    @Attribute
    String modeReportQualifiedName;
    @Attribute
    String modeToken;
    @Attribute
    String modeWorkspaceName;
    @Attribute
    String modeWorkspaceQualifiedName;
    @Attribute
    String modeWorkspaceUsername;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public ModeWorkspace trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return ModeWorkspace.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return ModeWorkspace.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return ModeWorkspace.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return ModeWorkspace.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return ModeWorkspace.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return ModeWorkspace.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static ModeWorkspace refByGuid(String guid) {
        return ModeWorkspace.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static ModeWorkspace refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((ModeWorkspaceBuilder)((ModeWorkspaceBuilder)ModeWorkspace._internal().guid(guid)).semantic(semantic)).build();
    }

    public static ModeWorkspace refByQualifiedName(String qualifiedName) {
        return ModeWorkspace.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static ModeWorkspace refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((ModeWorkspaceBuilder)((ModeWorkspaceBuilder)ModeWorkspace._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static ModeWorkspace get(String id) throws AtlanException {
        return ModeWorkspace.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static ModeWorkspace get(AtlanClient client, String id) throws AtlanException {
        return ModeWorkspace.get(client, id, true);
    }

    @JsonIgnore
    public static ModeWorkspace get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof ModeWorkspace) {
                return (ModeWorkspace)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof ModeWorkspace) {
            return (ModeWorkspace)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return ModeWorkspace.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static ModeWorkspaceBuilder<?, ?> updater(String qualifiedName, String name) {
        return (ModeWorkspaceBuilder)((ModeWorkspaceBuilder)((ModeWorkspaceBuilder)ModeWorkspace._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public ModeWorkspaceBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ModeWorkspace.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return ModeWorkspace.updater(this.getQualifiedName(), this.getName());
    }

    public static ModeWorkspace removeDescription(String qualifiedName, String name) throws AtlanException {
        return ModeWorkspace.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ModeWorkspace removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModeWorkspace)Asset.removeDescription(client, ModeWorkspace.updater(qualifiedName, name));
    }

    public static ModeWorkspace removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return ModeWorkspace.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ModeWorkspace removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModeWorkspace)Asset.removeUserDescription(client, ModeWorkspace.updater(qualifiedName, name));
    }

    public static ModeWorkspace removeOwners(String qualifiedName, String name) throws AtlanException {
        return ModeWorkspace.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ModeWorkspace removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModeWorkspace)Asset.removeOwners(client, ModeWorkspace.updater(qualifiedName, name));
    }

    public static ModeWorkspace updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return ModeWorkspace.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static ModeWorkspace updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (ModeWorkspace)Asset.updateCertificate(client, ModeWorkspace._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static ModeWorkspace removeCertificate(String qualifiedName, String name) throws AtlanException {
        return ModeWorkspace.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ModeWorkspace removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModeWorkspace)Asset.removeCertificate(client, ModeWorkspace.updater(qualifiedName, name));
    }

    public static ModeWorkspace updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return ModeWorkspace.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static ModeWorkspace updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (ModeWorkspace)Asset.updateAnnouncement(client, ModeWorkspace._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static ModeWorkspace removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return ModeWorkspace.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ModeWorkspace removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModeWorkspace)Asset.removeAnnouncement(client, ModeWorkspace.updater(qualifiedName, name));
    }

    public static ModeWorkspace replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return ModeWorkspace.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static ModeWorkspace replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (ModeWorkspace)Asset.replaceTerms(client, ModeWorkspace.updater(qualifiedName, name), terms);
    }

    public static ModeWorkspace appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return ModeWorkspace.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static ModeWorkspace appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ModeWorkspace)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static ModeWorkspace removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return ModeWorkspace.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static ModeWorkspace removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ModeWorkspace)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static ModeWorkspace appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return ModeWorkspace.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static ModeWorkspace appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (ModeWorkspace)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static ModeWorkspace appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return ModeWorkspace.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static ModeWorkspace appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (ModeWorkspace)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        ModeWorkspace.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected ModeWorkspace(ModeWorkspaceBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : ModeWorkspace.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.modeCollectionCount = b.modeCollectionCount;
        SortedSet<IModeCollection> modeCollections = new TreeSet<IModeCollection>();
        if (b.modeCollections != null) {
            modeCollections.addAll(b.modeCollections);
        }
        modeCollections = Collections.unmodifiableSortedSet(modeCollections);
        this.modeCollections = modeCollections;
        this.modeId = b.modeId;
        this.modeQueryName = b.modeQueryName;
        this.modeQueryQualifiedName = b.modeQueryQualifiedName;
        this.modeReportName = b.modeReportName;
        this.modeReportQualifiedName = b.modeReportQualifiedName;
        this.modeToken = b.modeToken;
        this.modeWorkspaceName = b.modeWorkspaceName;
        this.modeWorkspaceQualifiedName = b.modeWorkspaceQualifiedName;
        this.modeWorkspaceUsername = b.modeWorkspaceUsername;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static ModeWorkspaceBuilder<?, ?> _internal() {
        return new ModeWorkspaceBuilderImpl();
    }

    @Generated
    public ModeWorkspaceBuilder<?, ?> toBuilder() {
        return new ModeWorkspaceBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public Long getModeCollectionCount() {
        return this.modeCollectionCount;
    }

    @Override
    @Generated
    public SortedSet<IModeCollection> getModeCollections() {
        return this.modeCollections;
    }

    @Override
    @Generated
    public String getModeId() {
        return this.modeId;
    }

    @Override
    @Generated
    public String getModeQueryName() {
        return this.modeQueryName;
    }

    @Override
    @Generated
    public String getModeQueryQualifiedName() {
        return this.modeQueryQualifiedName;
    }

    @Override
    @Generated
    public String getModeReportName() {
        return this.modeReportName;
    }

    @Override
    @Generated
    public String getModeReportQualifiedName() {
        return this.modeReportQualifiedName;
    }

    @Override
    @Generated
    public String getModeToken() {
        return this.modeToken;
    }

    @Override
    @Generated
    public String getModeWorkspaceName() {
        return this.modeWorkspaceName;
    }

    @Override
    @Generated
    public String getModeWorkspaceQualifiedName() {
        return this.modeWorkspaceQualifiedName;
    }

    @Override
    @Generated
    public String getModeWorkspaceUsername() {
        return this.modeWorkspaceUsername;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModeWorkspace)) {
            return false;
        }
        ModeWorkspace other = (ModeWorkspace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$modeCollectionCount = this.getModeCollectionCount();
        Long other$modeCollectionCount = other.getModeCollectionCount();
        if (this$modeCollectionCount == null ? other$modeCollectionCount != null : !((Object)this$modeCollectionCount).equals(other$modeCollectionCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModeCollection> this$modeCollections = this.getModeCollections();
        SortedSet<IModeCollection> other$modeCollections = other.getModeCollections();
        if (this$modeCollections == null ? other$modeCollections != null : !this$modeCollections.equals(other$modeCollections)) {
            return false;
        }
        String this$modeId = this.getModeId();
        String other$modeId = other.getModeId();
        if (this$modeId == null ? other$modeId != null : !this$modeId.equals(other$modeId)) {
            return false;
        }
        String this$modeQueryName = this.getModeQueryName();
        String other$modeQueryName = other.getModeQueryName();
        if (this$modeQueryName == null ? other$modeQueryName != null : !this$modeQueryName.equals(other$modeQueryName)) {
            return false;
        }
        String this$modeQueryQualifiedName = this.getModeQueryQualifiedName();
        String other$modeQueryQualifiedName = other.getModeQueryQualifiedName();
        if (this$modeQueryQualifiedName == null ? other$modeQueryQualifiedName != null : !this$modeQueryQualifiedName.equals(other$modeQueryQualifiedName)) {
            return false;
        }
        String this$modeReportName = this.getModeReportName();
        String other$modeReportName = other.getModeReportName();
        if (this$modeReportName == null ? other$modeReportName != null : !this$modeReportName.equals(other$modeReportName)) {
            return false;
        }
        String this$modeReportQualifiedName = this.getModeReportQualifiedName();
        String other$modeReportQualifiedName = other.getModeReportQualifiedName();
        if (this$modeReportQualifiedName == null ? other$modeReportQualifiedName != null : !this$modeReportQualifiedName.equals(other$modeReportQualifiedName)) {
            return false;
        }
        String this$modeToken = this.getModeToken();
        String other$modeToken = other.getModeToken();
        if (this$modeToken == null ? other$modeToken != null : !this$modeToken.equals(other$modeToken)) {
            return false;
        }
        String this$modeWorkspaceName = this.getModeWorkspaceName();
        String other$modeWorkspaceName = other.getModeWorkspaceName();
        if (this$modeWorkspaceName == null ? other$modeWorkspaceName != null : !this$modeWorkspaceName.equals(other$modeWorkspaceName)) {
            return false;
        }
        String this$modeWorkspaceQualifiedName = this.getModeWorkspaceQualifiedName();
        String other$modeWorkspaceQualifiedName = other.getModeWorkspaceQualifiedName();
        if (this$modeWorkspaceQualifiedName == null ? other$modeWorkspaceQualifiedName != null : !this$modeWorkspaceQualifiedName.equals(other$modeWorkspaceQualifiedName)) {
            return false;
        }
        String this$modeWorkspaceUsername = this.getModeWorkspaceUsername();
        String other$modeWorkspaceUsername = other.getModeWorkspaceUsername();
        if (this$modeWorkspaceUsername == null ? other$modeWorkspaceUsername != null : !this$modeWorkspaceUsername.equals(other$modeWorkspaceUsername)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ModeWorkspace;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $modeCollectionCount = this.getModeCollectionCount();
        result = result * 59 + ($modeCollectionCount == null ? 43 : ((Object)$modeCollectionCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModeCollection> $modeCollections = this.getModeCollections();
        result = result * 59 + ($modeCollections == null ? 43 : $modeCollections.hashCode());
        String $modeId = this.getModeId();
        result = result * 59 + ($modeId == null ? 43 : $modeId.hashCode());
        String $modeQueryName = this.getModeQueryName();
        result = result * 59 + ($modeQueryName == null ? 43 : $modeQueryName.hashCode());
        String $modeQueryQualifiedName = this.getModeQueryQualifiedName();
        result = result * 59 + ($modeQueryQualifiedName == null ? 43 : $modeQueryQualifiedName.hashCode());
        String $modeReportName = this.getModeReportName();
        result = result * 59 + ($modeReportName == null ? 43 : $modeReportName.hashCode());
        String $modeReportQualifiedName = this.getModeReportQualifiedName();
        result = result * 59 + ($modeReportQualifiedName == null ? 43 : $modeReportQualifiedName.hashCode());
        String $modeToken = this.getModeToken();
        result = result * 59 + ($modeToken == null ? 43 : $modeToken.hashCode());
        String $modeWorkspaceName = this.getModeWorkspaceName();
        result = result * 59 + ($modeWorkspaceName == null ? 43 : $modeWorkspaceName.hashCode());
        String $modeWorkspaceQualifiedName = this.getModeWorkspaceQualifiedName();
        result = result * 59 + ($modeWorkspaceQualifiedName == null ? 43 : $modeWorkspaceQualifiedName.hashCode());
        String $modeWorkspaceUsername = this.getModeWorkspaceUsername();
        result = result * 59 + ($modeWorkspaceUsername == null ? 43 : $modeWorkspaceUsername.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ModeWorkspace(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", modeCollectionCount=" + this.getModeCollectionCount() + ", modeCollections=" + this.getModeCollections() + ", modeId=" + this.getModeId() + ", modeQueryName=" + this.getModeQueryName() + ", modeQueryQualifiedName=" + this.getModeQueryQualifiedName() + ", modeReportName=" + this.getModeReportName() + ", modeReportQualifiedName=" + this.getModeReportQualifiedName() + ", modeToken=" + this.getModeToken() + ", modeWorkspaceName=" + this.getModeWorkspaceName() + ", modeWorkspaceQualifiedName=" + this.getModeWorkspaceQualifiedName() + ", modeWorkspaceUsername=" + this.getModeWorkspaceUsername() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class ModeWorkspaceBuilder<C extends ModeWorkspace, B extends ModeWorkspaceBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private Long modeCollectionCount;
        @Generated
        private ArrayList<IModeCollection> modeCollections;
        @Generated
        private String modeId;
        @Generated
        private String modeQueryName;
        @Generated
        private String modeQueryQualifiedName;
        @Generated
        private String modeReportName;
        @Generated
        private String modeReportQualifiedName;
        @Generated
        private String modeToken;
        @Generated
        private String modeWorkspaceName;
        @Generated
        private String modeWorkspaceQualifiedName;
        @Generated
        private String modeWorkspaceUsername;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ModeWorkspaceBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ModeWorkspace instance, ModeWorkspaceBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modeCollectionCount(instance.modeCollectionCount);
            b.modeCollections(instance.modeCollections == null ? Collections.emptySortedSet() : instance.modeCollections);
            b.modeId(instance.modeId);
            b.modeQueryName(instance.modeQueryName);
            b.modeQueryQualifiedName(instance.modeQueryQualifiedName);
            b.modeReportName(instance.modeReportName);
            b.modeReportQualifiedName(instance.modeReportQualifiedName);
            b.modeToken(instance.modeToken);
            b.modeWorkspaceName(instance.modeWorkspaceName);
            b.modeWorkspaceQualifiedName(instance.modeWorkspaceQualifiedName);
            b.modeWorkspaceUsername(instance.modeWorkspaceUsername);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modeCollectionCount(Long modeCollectionCount) {
            this.modeCollectionCount = modeCollectionCount;
            return (B)this.self();
        }

        @Generated
        public B modeCollection(IModeCollection modeCollection) {
            if (this.modeCollections == null) {
                this.modeCollections = new ArrayList();
            }
            this.modeCollections.add(modeCollection);
            return (B)this.self();
        }

        @Generated
        public B modeCollections(Collection<? extends IModeCollection> modeCollections) {
            if (modeCollections == null) {
                throw new NullPointerException("modeCollections cannot be null");
            }
            if (this.modeCollections == null) {
                this.modeCollections = new ArrayList();
            }
            this.modeCollections.addAll(modeCollections);
            return (B)this.self();
        }

        @Generated
        public B clearModeCollections() {
            if (this.modeCollections != null) {
                this.modeCollections.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modeId(String modeId) {
            this.modeId = modeId;
            return (B)this.self();
        }

        @Generated
        public B modeQueryName(String modeQueryName) {
            this.modeQueryName = modeQueryName;
            return (B)this.self();
        }

        @Generated
        public B modeQueryQualifiedName(String modeQueryQualifiedName) {
            this.modeQueryQualifiedName = modeQueryQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B modeReportName(String modeReportName) {
            this.modeReportName = modeReportName;
            return (B)this.self();
        }

        @Generated
        public B modeReportQualifiedName(String modeReportQualifiedName) {
            this.modeReportQualifiedName = modeReportQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B modeToken(String modeToken) {
            this.modeToken = modeToken;
            return (B)this.self();
        }

        @Generated
        public B modeWorkspaceName(String modeWorkspaceName) {
            this.modeWorkspaceName = modeWorkspaceName;
            return (B)this.self();
        }

        @Generated
        public B modeWorkspaceQualifiedName(String modeWorkspaceQualifiedName) {
            this.modeWorkspaceQualifiedName = modeWorkspaceQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B modeWorkspaceUsername(String modeWorkspaceUsername) {
            this.modeWorkspaceUsername = modeWorkspaceUsername;
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ModeWorkspace.ModeWorkspaceBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", modeCollectionCount=" + this.modeCollectionCount + ", modeCollections=" + this.modeCollections + ", modeId=" + this.modeId + ", modeQueryName=" + this.modeQueryName + ", modeQueryQualifiedName=" + this.modeQueryQualifiedName + ", modeReportName=" + this.modeReportName + ", modeReportQualifiedName=" + this.modeReportQualifiedName + ", modeToken=" + this.modeToken + ", modeWorkspaceName=" + this.modeWorkspaceName + ", modeWorkspaceQualifiedName=" + this.modeWorkspaceQualifiedName + ", modeWorkspaceUsername=" + this.modeWorkspaceUsername + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }

    @Generated
    private static final class ModeWorkspaceBuilderImpl
    extends ModeWorkspaceBuilder<ModeWorkspace, ModeWorkspaceBuilderImpl> {
        @Generated
        private ModeWorkspaceBuilderImpl() {
        }

        @Override
        @Generated
        protected ModeWorkspaceBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ModeWorkspace build() {
            return new ModeWorkspace(this);
        }
    }
}

