/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IPowerBI;
import com.atlan.model.assets.IPowerBIColumn;
import com.atlan.model.assets.IPowerBIDataflow;
import com.atlan.model.assets.IPowerBIDataset;
import com.atlan.model.assets.IPowerBIMeasure;
import com.atlan.model.assets.IPowerBITable;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.PowerBIEndorsementType;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerBITable
extends Asset
implements IPowerBITable,
IPowerBI,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PowerBITable.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "PowerBITable";
    String typeName;
    @Attribute
    SortedSet<IPowerBIColumn> columns;
    @Attribute
    SortedSet<String> dataflowQualifiedNames;
    @Attribute
    SortedSet<IPowerBIDataflow> dataflows;
    @Attribute
    IPowerBIDataset dataset;
    @Attribute
    String datasetQualifiedName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IPowerBIMeasure> measures;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    PowerBIEndorsementType powerBIEndorsement;
    @Attribute
    String powerBIFormatString;
    @Attribute
    Boolean powerBIIsHidden;
    @Attribute
    Long powerBITableColumnCount;
    @Attribute
    Long powerBITableMeasureCount;
    @Attribute
    String powerBITableQualifiedName;
    @Attribute
    SortedSet<String> powerBITableSourceExpressions;
    @Attribute
    String workspaceQualifiedName;

    @Override
    public PowerBITable trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return PowerBITable.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return PowerBITable.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return PowerBITable.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return PowerBITable.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return PowerBITable.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return PowerBITable.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static PowerBITable refByGuid(String guid) {
        return PowerBITable.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static PowerBITable refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((PowerBITableBuilder)((PowerBITableBuilder)PowerBITable._internal().guid(guid)).semantic(semantic)).build();
    }

    public static PowerBITable refByQualifiedName(String qualifiedName) {
        return PowerBITable.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static PowerBITable refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((PowerBITableBuilder)((PowerBITableBuilder)PowerBITable._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static PowerBITable get(String id) throws AtlanException {
        return PowerBITable.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static PowerBITable get(AtlanClient client, String id) throws AtlanException {
        return PowerBITable.get(client, id, true);
    }

    @JsonIgnore
    public static PowerBITable get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof PowerBITable) {
                return (PowerBITable)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof PowerBITable) {
            return (PowerBITable)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return PowerBITable.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static PowerBITableBuilder<?, ?> updater(String qualifiedName, String name) {
        return (PowerBITableBuilder)((PowerBITableBuilder)((PowerBITableBuilder)PowerBITable._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public PowerBITableBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        PowerBITable.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return PowerBITable.updater(this.getQualifiedName(), this.getName());
    }

    public static PowerBITable removeDescription(String qualifiedName, String name) throws AtlanException {
        return PowerBITable.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static PowerBITable removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBITable)Asset.removeDescription(client, PowerBITable.updater(qualifiedName, name));
    }

    public static PowerBITable removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return PowerBITable.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static PowerBITable removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBITable)Asset.removeUserDescription(client, PowerBITable.updater(qualifiedName, name));
    }

    public static PowerBITable removeOwners(String qualifiedName, String name) throws AtlanException {
        return PowerBITable.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static PowerBITable removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBITable)Asset.removeOwners(client, PowerBITable.updater(qualifiedName, name));
    }

    public static PowerBITable updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return PowerBITable.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static PowerBITable updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (PowerBITable)Asset.updateCertificate(client, PowerBITable._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static PowerBITable removeCertificate(String qualifiedName, String name) throws AtlanException {
        return PowerBITable.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static PowerBITable removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBITable)Asset.removeCertificate(client, PowerBITable.updater(qualifiedName, name));
    }

    public static PowerBITable updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return PowerBITable.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static PowerBITable updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (PowerBITable)Asset.updateAnnouncement(client, PowerBITable._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static PowerBITable removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return PowerBITable.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static PowerBITable removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBITable)Asset.removeAnnouncement(client, PowerBITable.updater(qualifiedName, name));
    }

    public static PowerBITable replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return PowerBITable.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static PowerBITable replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (PowerBITable)Asset.replaceTerms(client, PowerBITable.updater(qualifiedName, name), terms);
    }

    public static PowerBITable appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return PowerBITable.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static PowerBITable appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (PowerBITable)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static PowerBITable removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return PowerBITable.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static PowerBITable removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (PowerBITable)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static PowerBITable appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return PowerBITable.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static PowerBITable appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (PowerBITable)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static PowerBITable appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return PowerBITable.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static PowerBITable appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (PowerBITable)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        PowerBITable.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected PowerBITable(PowerBITableBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : PowerBITable.$default$typeName();
        SortedSet<IPowerBIColumn> columns = new TreeSet<IPowerBIColumn>();
        if (b.columns != null) {
            columns.addAll(b.columns);
        }
        columns = Collections.unmodifiableSortedSet(columns);
        this.columns = columns;
        SortedSet<String> dataflowQualifiedNames = new TreeSet<String>();
        if (b.dataflowQualifiedNames != null) {
            dataflowQualifiedNames.addAll(b.dataflowQualifiedNames);
        }
        dataflowQualifiedNames = Collections.unmodifiableSortedSet(dataflowQualifiedNames);
        this.dataflowQualifiedNames = dataflowQualifiedNames;
        SortedSet<IPowerBIDataflow> dataflows = new TreeSet<IPowerBIDataflow>();
        if (b.dataflows != null) {
            dataflows.addAll(b.dataflows);
        }
        dataflows = Collections.unmodifiableSortedSet(dataflows);
        this.dataflows = dataflows;
        this.dataset = b.dataset;
        this.datasetQualifiedName = b.datasetQualifiedName;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IPowerBIMeasure> measures = new TreeSet<IPowerBIMeasure>();
        if (b.measures != null) {
            measures.addAll(b.measures);
        }
        measures = Collections.unmodifiableSortedSet(measures);
        this.measures = measures;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.powerBIEndorsement = b.powerBIEndorsement;
        this.powerBIFormatString = b.powerBIFormatString;
        this.powerBIIsHidden = b.powerBIIsHidden;
        this.powerBITableColumnCount = b.powerBITableColumnCount;
        this.powerBITableMeasureCount = b.powerBITableMeasureCount;
        this.powerBITableQualifiedName = b.powerBITableQualifiedName;
        SortedSet<String> powerBITableSourceExpressions = new TreeSet<String>();
        if (b.powerBITableSourceExpressions != null) {
            powerBITableSourceExpressions.addAll(b.powerBITableSourceExpressions);
        }
        powerBITableSourceExpressions = Collections.unmodifiableSortedSet(powerBITableSourceExpressions);
        this.powerBITableSourceExpressions = powerBITableSourceExpressions;
        this.workspaceQualifiedName = b.workspaceQualifiedName;
    }

    @Generated
    public static PowerBITableBuilder<?, ?> _internal() {
        return new PowerBITableBuilderImpl();
    }

    @Generated
    public PowerBITableBuilder<?, ?> toBuilder() {
        return new PowerBITableBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IPowerBIColumn> getColumns() {
        return this.columns;
    }

    @Override
    @Generated
    public SortedSet<String> getDataflowQualifiedNames() {
        return this.dataflowQualifiedNames;
    }

    @Override
    @Generated
    public SortedSet<IPowerBIDataflow> getDataflows() {
        return this.dataflows;
    }

    @Override
    @Generated
    public IPowerBIDataset getDataset() {
        return this.dataset;
    }

    @Override
    @Generated
    public String getDatasetQualifiedName() {
        return this.datasetQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IPowerBIMeasure> getMeasures() {
        return this.measures;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public PowerBIEndorsementType getPowerBIEndorsement() {
        return this.powerBIEndorsement;
    }

    @Override
    @Generated
    public String getPowerBIFormatString() {
        return this.powerBIFormatString;
    }

    @Override
    @Generated
    public Boolean getPowerBIIsHidden() {
        return this.powerBIIsHidden;
    }

    @Override
    @Generated
    public Long getPowerBITableColumnCount() {
        return this.powerBITableColumnCount;
    }

    @Override
    @Generated
    public Long getPowerBITableMeasureCount() {
        return this.powerBITableMeasureCount;
    }

    @Override
    @Generated
    public String getPowerBITableQualifiedName() {
        return this.powerBITableQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<String> getPowerBITableSourceExpressions() {
        return this.powerBITableSourceExpressions;
    }

    @Override
    @Generated
    public String getWorkspaceQualifiedName() {
        return this.workspaceQualifiedName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PowerBITable)) {
            return false;
        }
        PowerBITable other = (PowerBITable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$powerBIIsHidden = this.getPowerBIIsHidden();
        Boolean other$powerBIIsHidden = other.getPowerBIIsHidden();
        if (this$powerBIIsHidden == null ? other$powerBIIsHidden != null : !((Object)this$powerBIIsHidden).equals(other$powerBIIsHidden)) {
            return false;
        }
        Long this$powerBITableColumnCount = this.getPowerBITableColumnCount();
        Long other$powerBITableColumnCount = other.getPowerBITableColumnCount();
        if (this$powerBITableColumnCount == null ? other$powerBITableColumnCount != null : !((Object)this$powerBITableColumnCount).equals(other$powerBITableColumnCount)) {
            return false;
        }
        Long this$powerBITableMeasureCount = this.getPowerBITableMeasureCount();
        Long other$powerBITableMeasureCount = other.getPowerBITableMeasureCount();
        if (this$powerBITableMeasureCount == null ? other$powerBITableMeasureCount != null : !((Object)this$powerBITableMeasureCount).equals(other$powerBITableMeasureCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IPowerBIColumn> this$columns = this.getColumns();
        SortedSet<IPowerBIColumn> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !this$columns.equals(other$columns)) {
            return false;
        }
        SortedSet<String> this$dataflowQualifiedNames = this.getDataflowQualifiedNames();
        SortedSet<String> other$dataflowQualifiedNames = other.getDataflowQualifiedNames();
        if (this$dataflowQualifiedNames == null ? other$dataflowQualifiedNames != null : !this$dataflowQualifiedNames.equals(other$dataflowQualifiedNames)) {
            return false;
        }
        SortedSet<IPowerBIDataflow> this$dataflows = this.getDataflows();
        SortedSet<IPowerBIDataflow> other$dataflows = other.getDataflows();
        if (this$dataflows == null ? other$dataflows != null : !this$dataflows.equals(other$dataflows)) {
            return false;
        }
        IPowerBIDataset this$dataset = this.getDataset();
        IPowerBIDataset other$dataset = other.getDataset();
        if (this$dataset == null ? other$dataset != null : !this$dataset.equals(other$dataset)) {
            return false;
        }
        String this$datasetQualifiedName = this.getDatasetQualifiedName();
        String other$datasetQualifiedName = other.getDatasetQualifiedName();
        if (this$datasetQualifiedName == null ? other$datasetQualifiedName != null : !this$datasetQualifiedName.equals(other$datasetQualifiedName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IPowerBIMeasure> this$measures = this.getMeasures();
        SortedSet<IPowerBIMeasure> other$measures = other.getMeasures();
        if (this$measures == null ? other$measures != null : !this$measures.equals(other$measures)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        PowerBIEndorsementType this$powerBIEndorsement = this.getPowerBIEndorsement();
        PowerBIEndorsementType other$powerBIEndorsement = other.getPowerBIEndorsement();
        if (this$powerBIEndorsement == null ? other$powerBIEndorsement != null : !this$powerBIEndorsement.equals(other$powerBIEndorsement)) {
            return false;
        }
        String this$powerBIFormatString = this.getPowerBIFormatString();
        String other$powerBIFormatString = other.getPowerBIFormatString();
        if (this$powerBIFormatString == null ? other$powerBIFormatString != null : !this$powerBIFormatString.equals(other$powerBIFormatString)) {
            return false;
        }
        String this$powerBITableQualifiedName = this.getPowerBITableQualifiedName();
        String other$powerBITableQualifiedName = other.getPowerBITableQualifiedName();
        if (this$powerBITableQualifiedName == null ? other$powerBITableQualifiedName != null : !this$powerBITableQualifiedName.equals(other$powerBITableQualifiedName)) {
            return false;
        }
        SortedSet<String> this$powerBITableSourceExpressions = this.getPowerBITableSourceExpressions();
        SortedSet<String> other$powerBITableSourceExpressions = other.getPowerBITableSourceExpressions();
        if (this$powerBITableSourceExpressions == null ? other$powerBITableSourceExpressions != null : !this$powerBITableSourceExpressions.equals(other$powerBITableSourceExpressions)) {
            return false;
        }
        String this$workspaceQualifiedName = this.getWorkspaceQualifiedName();
        String other$workspaceQualifiedName = other.getWorkspaceQualifiedName();
        return !(this$workspaceQualifiedName == null ? other$workspaceQualifiedName != null : !this$workspaceQualifiedName.equals(other$workspaceQualifiedName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PowerBITable;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $powerBIIsHidden = this.getPowerBIIsHidden();
        result = result * 59 + ($powerBIIsHidden == null ? 43 : ((Object)$powerBIIsHidden).hashCode());
        Long $powerBITableColumnCount = this.getPowerBITableColumnCount();
        result = result * 59 + ($powerBITableColumnCount == null ? 43 : ((Object)$powerBITableColumnCount).hashCode());
        Long $powerBITableMeasureCount = this.getPowerBITableMeasureCount();
        result = result * 59 + ($powerBITableMeasureCount == null ? 43 : ((Object)$powerBITableMeasureCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IPowerBIColumn> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : $columns.hashCode());
        SortedSet<String> $dataflowQualifiedNames = this.getDataflowQualifiedNames();
        result = result * 59 + ($dataflowQualifiedNames == null ? 43 : $dataflowQualifiedNames.hashCode());
        SortedSet<IPowerBIDataflow> $dataflows = this.getDataflows();
        result = result * 59 + ($dataflows == null ? 43 : $dataflows.hashCode());
        IPowerBIDataset $dataset = this.getDataset();
        result = result * 59 + ($dataset == null ? 43 : $dataset.hashCode());
        String $datasetQualifiedName = this.getDatasetQualifiedName();
        result = result * 59 + ($datasetQualifiedName == null ? 43 : $datasetQualifiedName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IPowerBIMeasure> $measures = this.getMeasures();
        result = result * 59 + ($measures == null ? 43 : $measures.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        PowerBIEndorsementType $powerBIEndorsement = this.getPowerBIEndorsement();
        result = result * 59 + ($powerBIEndorsement == null ? 43 : $powerBIEndorsement.hashCode());
        String $powerBIFormatString = this.getPowerBIFormatString();
        result = result * 59 + ($powerBIFormatString == null ? 43 : $powerBIFormatString.hashCode());
        String $powerBITableQualifiedName = this.getPowerBITableQualifiedName();
        result = result * 59 + ($powerBITableQualifiedName == null ? 43 : $powerBITableQualifiedName.hashCode());
        SortedSet<String> $powerBITableSourceExpressions = this.getPowerBITableSourceExpressions();
        result = result * 59 + ($powerBITableSourceExpressions == null ? 43 : $powerBITableSourceExpressions.hashCode());
        String $workspaceQualifiedName = this.getWorkspaceQualifiedName();
        result = result * 59 + ($workspaceQualifiedName == null ? 43 : $workspaceQualifiedName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "PowerBITable(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", columns=" + this.getColumns() + ", dataflowQualifiedNames=" + this.getDataflowQualifiedNames() + ", dataflows=" + this.getDataflows() + ", dataset=" + this.getDataset() + ", datasetQualifiedName=" + this.getDatasetQualifiedName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", measures=" + this.getMeasures() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", powerBIEndorsement=" + this.getPowerBIEndorsement() + ", powerBIFormatString=" + this.getPowerBIFormatString() + ", powerBIIsHidden=" + this.getPowerBIIsHidden() + ", powerBITableColumnCount=" + this.getPowerBITableColumnCount() + ", powerBITableMeasureCount=" + this.getPowerBITableMeasureCount() + ", powerBITableQualifiedName=" + this.getPowerBITableQualifiedName() + ", powerBITableSourceExpressions=" + this.getPowerBITableSourceExpressions() + ", workspaceQualifiedName=" + this.getWorkspaceQualifiedName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class PowerBITableBuilder<C extends PowerBITable, B extends PowerBITableBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IPowerBIColumn> columns;
        @Generated
        private ArrayList<String> dataflowQualifiedNames;
        @Generated
        private ArrayList<IPowerBIDataflow> dataflows;
        @Generated
        private IPowerBIDataset dataset;
        @Generated
        private String datasetQualifiedName;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IPowerBIMeasure> measures;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private PowerBIEndorsementType powerBIEndorsement;
        @Generated
        private String powerBIFormatString;
        @Generated
        private Boolean powerBIIsHidden;
        @Generated
        private Long powerBITableColumnCount;
        @Generated
        private Long powerBITableMeasureCount;
        @Generated
        private String powerBITableQualifiedName;
        @Generated
        private ArrayList<String> powerBITableSourceExpressions;
        @Generated
        private String workspaceQualifiedName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PowerBITableBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PowerBITable instance, PowerBITableBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.columns(instance.columns == null ? Collections.emptySortedSet() : instance.columns);
            b.dataflowQualifiedNames(instance.dataflowQualifiedNames == null ? Collections.emptySortedSet() : instance.dataflowQualifiedNames);
            b.dataflows(instance.dataflows == null ? Collections.emptySortedSet() : instance.dataflows);
            b.dataset(instance.dataset);
            b.datasetQualifiedName(instance.datasetQualifiedName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.measures(instance.measures == null ? Collections.emptySortedSet() : instance.measures);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.powerBIEndorsement(instance.powerBIEndorsement);
            b.powerBIFormatString(instance.powerBIFormatString);
            b.powerBIIsHidden(instance.powerBIIsHidden);
            b.powerBITableColumnCount(instance.powerBITableColumnCount);
            b.powerBITableMeasureCount(instance.powerBITableMeasureCount);
            b.powerBITableQualifiedName(instance.powerBITableQualifiedName);
            b.powerBITableSourceExpressions(instance.powerBITableSourceExpressions == null ? Collections.emptySortedSet() : instance.powerBITableSourceExpressions);
            b.workspaceQualifiedName(instance.workspaceQualifiedName);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B column(IPowerBIColumn column) {
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.add(column);
            return (B)this.self();
        }

        @Generated
        public B columns(Collection<? extends IPowerBIColumn> columns) {
            if (columns == null) {
                throw new NullPointerException("columns cannot be null");
            }
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.addAll(columns);
            return (B)this.self();
        }

        @Generated
        public B clearColumns() {
            if (this.columns != null) {
                this.columns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dataflowQualifiedName(String dataflowQualifiedName) {
            if (this.dataflowQualifiedNames == null) {
                this.dataflowQualifiedNames = new ArrayList();
            }
            this.dataflowQualifiedNames.add(dataflowQualifiedName);
            return (B)this.self();
        }

        @Generated
        public B dataflowQualifiedNames(Collection<? extends String> dataflowQualifiedNames) {
            if (dataflowQualifiedNames == null) {
                throw new NullPointerException("dataflowQualifiedNames cannot be null");
            }
            if (this.dataflowQualifiedNames == null) {
                this.dataflowQualifiedNames = new ArrayList();
            }
            this.dataflowQualifiedNames.addAll(dataflowQualifiedNames);
            return (B)this.self();
        }

        @Generated
        public B clearDataflowQualifiedNames() {
            if (this.dataflowQualifiedNames != null) {
                this.dataflowQualifiedNames.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dataflow(IPowerBIDataflow dataflow) {
            if (this.dataflows == null) {
                this.dataflows = new ArrayList();
            }
            this.dataflows.add(dataflow);
            return (B)this.self();
        }

        @Generated
        public B dataflows(Collection<? extends IPowerBIDataflow> dataflows) {
            if (dataflows == null) {
                throw new NullPointerException("dataflows cannot be null");
            }
            if (this.dataflows == null) {
                this.dataflows = new ArrayList();
            }
            this.dataflows.addAll(dataflows);
            return (B)this.self();
        }

        @Generated
        public B clearDataflows() {
            if (this.dataflows != null) {
                this.dataflows.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dataset(IPowerBIDataset dataset) {
            this.dataset = dataset;
            return (B)this.self();
        }

        @Generated
        public B datasetQualifiedName(String datasetQualifiedName) {
            this.datasetQualifiedName = datasetQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B measure(IPowerBIMeasure measure) {
            if (this.measures == null) {
                this.measures = new ArrayList();
            }
            this.measures.add(measure);
            return (B)this.self();
        }

        @Generated
        public B measures(Collection<? extends IPowerBIMeasure> measures) {
            if (measures == null) {
                throw new NullPointerException("measures cannot be null");
            }
            if (this.measures == null) {
                this.measures = new ArrayList();
            }
            this.measures.addAll(measures);
            return (B)this.self();
        }

        @Generated
        public B clearMeasures() {
            if (this.measures != null) {
                this.measures.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B powerBIEndorsement(PowerBIEndorsementType powerBIEndorsement) {
            this.powerBIEndorsement = powerBIEndorsement;
            return (B)this.self();
        }

        @Generated
        public B powerBIFormatString(String powerBIFormatString) {
            this.powerBIFormatString = powerBIFormatString;
            return (B)this.self();
        }

        @Generated
        public B powerBIIsHidden(Boolean powerBIIsHidden) {
            this.powerBIIsHidden = powerBIIsHidden;
            return (B)this.self();
        }

        @Generated
        public B powerBITableColumnCount(Long powerBITableColumnCount) {
            this.powerBITableColumnCount = powerBITableColumnCount;
            return (B)this.self();
        }

        @Generated
        public B powerBITableMeasureCount(Long powerBITableMeasureCount) {
            this.powerBITableMeasureCount = powerBITableMeasureCount;
            return (B)this.self();
        }

        @Generated
        public B powerBITableQualifiedName(String powerBITableQualifiedName) {
            this.powerBITableQualifiedName = powerBITableQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B powerBITableSourceExpression(String powerBITableSourceExpression) {
            if (this.powerBITableSourceExpressions == null) {
                this.powerBITableSourceExpressions = new ArrayList();
            }
            this.powerBITableSourceExpressions.add(powerBITableSourceExpression);
            return (B)this.self();
        }

        @Generated
        public B powerBITableSourceExpressions(Collection<? extends String> powerBITableSourceExpressions) {
            if (powerBITableSourceExpressions == null) {
                throw new NullPointerException("powerBITableSourceExpressions cannot be null");
            }
            if (this.powerBITableSourceExpressions == null) {
                this.powerBITableSourceExpressions = new ArrayList();
            }
            this.powerBITableSourceExpressions.addAll(powerBITableSourceExpressions);
            return (B)this.self();
        }

        @Generated
        public B clearPowerBITableSourceExpressions() {
            if (this.powerBITableSourceExpressions != null) {
                this.powerBITableSourceExpressions.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B workspaceQualifiedName(String workspaceQualifiedName) {
            this.workspaceQualifiedName = workspaceQualifiedName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "PowerBITable.PowerBITableBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", columns=" + this.columns + ", dataflowQualifiedNames=" + this.dataflowQualifiedNames + ", dataflows=" + this.dataflows + ", dataset=" + this.dataset + ", datasetQualifiedName=" + this.datasetQualifiedName + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", measures=" + this.measures + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", powerBIEndorsement=" + this.powerBIEndorsement + ", powerBIFormatString=" + this.powerBIFormatString + ", powerBIIsHidden=" + this.powerBIIsHidden + ", powerBITableColumnCount=" + this.powerBITableColumnCount + ", powerBITableMeasureCount=" + this.powerBITableMeasureCount + ", powerBITableQualifiedName=" + this.powerBITableQualifiedName + ", powerBITableSourceExpressions=" + this.powerBITableSourceExpressions + ", workspaceQualifiedName=" + this.workspaceQualifiedName + ")";
        }
    }

    @Generated
    private static final class PowerBITableBuilderImpl
    extends PowerBITableBuilder<PowerBITable, PowerBITableBuilderImpl> {
        @Generated
        private PowerBITableBuilderImpl() {
        }

        @Override
        @Generated
        protected PowerBITableBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PowerBITable build() {
            return new PowerBITable(this);
        }
    }
}

