/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Connection;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IPreset;
import com.atlan.model.assets.IPresetChart;
import com.atlan.model.assets.IPresetDashboard;
import com.atlan.model.assets.IPresetDataset;
import com.atlan.model.assets.IPresetWorkspace;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.assets.PresetWorkspace;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PresetDashboard
extends Asset
implements IPresetDashboard,
IPreset,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PresetDashboard.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "PresetDashboard";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    SortedSet<IPresetChart> presetCharts;
    @Attribute
    String presetDashboardChangedByName;
    @Attribute
    String presetDashboardChangedByURL;
    @Attribute
    Long presetDashboardChartCount;
    @Attribute
    Long presetDashboardId;
    @Attribute
    Boolean presetDashboardIsManagedExternally;
    @Attribute
    Boolean presetDashboardIsPublished;
    @Attribute
    String presetDashboardQualifiedName;
    @Attribute
    String presetDashboardThumbnailURL;
    @Attribute
    SortedSet<IPresetDataset> presetDatasets;
    @Attribute
    IPresetWorkspace presetWorkspace;
    @Attribute
    Long presetWorkspaceId;
    @Attribute
    String presetWorkspaceQualifiedName;

    @Override
    public PresetDashboard trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return PresetDashboard.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return PresetDashboard.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return PresetDashboard.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return PresetDashboard.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return PresetDashboard.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return PresetDashboard.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static PresetDashboard refByGuid(String guid) {
        return PresetDashboard.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static PresetDashboard refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((PresetDashboardBuilder)((PresetDashboardBuilder)PresetDashboard._internal().guid(guid)).semantic(semantic)).build();
    }

    public static PresetDashboard refByQualifiedName(String qualifiedName) {
        return PresetDashboard.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static PresetDashboard refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((PresetDashboardBuilder)((PresetDashboardBuilder)PresetDashboard._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static PresetDashboard get(String id) throws AtlanException {
        return PresetDashboard.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static PresetDashboard get(AtlanClient client, String id) throws AtlanException {
        return PresetDashboard.get(client, id, true);
    }

    @JsonIgnore
    public static PresetDashboard get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof PresetDashboard) {
                return (PresetDashboard)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof PresetDashboard) {
            return (PresetDashboard)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return PresetDashboard.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static PresetDashboardBuilder<?, ?> creator(String name, PresetWorkspace workspace) throws InvalidRequestException {
        PresetDashboard.validateRelationship("PresetWorkspace", Map.of("connectionQualifiedName", workspace.getConnectionQualifiedName(), "qualifiedName", workspace.getQualifiedName()));
        return PresetDashboard.creator(name, workspace.getConnectionQualifiedName(), workspace.getQualifiedName()).presetWorkspace(workspace.trimToReference());
    }

    public static PresetDashboardBuilder<?, ?> creator(String name, String workspaceQualifiedName) {
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(workspaceQualifiedName);
        return PresetDashboard.creator(name, connectionQualifiedName, workspaceQualifiedName);
    }

    public static PresetDashboardBuilder<?, ?> creator(String name, String connectionQualifiedName, String workspaceQualifiedName) {
        AtlanConnectorType connectorType = Connection.getConnectorTypeFromQualifiedName(connectionQualifiedName);
        return (PresetDashboardBuilder)((Asset.AssetBuilder)((PresetDashboardBuilder)((PresetDashboardBuilder)((PresetDashboardBuilder)((PresetDashboardBuilder)((PresetDashboardBuilder)PresetDashboard._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).name(name)).qualifiedName(workspaceQualifiedName + "/" + name)).connectorType(connectorType)).presetWorkspaceQualifiedName(workspaceQualifiedName)).presetWorkspace(PresetWorkspace.refByQualifiedName(workspaceQualifiedName))).connectionQualifiedName(connectionQualifiedName);
    }

    public static PresetDashboardBuilder<?, ?> updater(String qualifiedName, String name) {
        return (PresetDashboardBuilder)((PresetDashboardBuilder)((PresetDashboardBuilder)PresetDashboard._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public PresetDashboardBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        PresetDashboard.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return PresetDashboard.updater(this.getQualifiedName(), this.getName());
    }

    public static PresetDashboard removeDescription(String qualifiedName, String name) throws AtlanException {
        return PresetDashboard.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static PresetDashboard removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PresetDashboard)Asset.removeDescription(client, PresetDashboard.updater(qualifiedName, name));
    }

    public static PresetDashboard removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return PresetDashboard.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static PresetDashboard removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PresetDashboard)Asset.removeUserDescription(client, PresetDashboard.updater(qualifiedName, name));
    }

    public static PresetDashboard removeOwners(String qualifiedName, String name) throws AtlanException {
        return PresetDashboard.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static PresetDashboard removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PresetDashboard)Asset.removeOwners(client, PresetDashboard.updater(qualifiedName, name));
    }

    public static PresetDashboard updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return PresetDashboard.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static PresetDashboard updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (PresetDashboard)Asset.updateCertificate(client, PresetDashboard._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static PresetDashboard removeCertificate(String qualifiedName, String name) throws AtlanException {
        return PresetDashboard.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static PresetDashboard removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PresetDashboard)Asset.removeCertificate(client, PresetDashboard.updater(qualifiedName, name));
    }

    public static PresetDashboard updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return PresetDashboard.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static PresetDashboard updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (PresetDashboard)Asset.updateAnnouncement(client, PresetDashboard._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static PresetDashboard removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return PresetDashboard.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static PresetDashboard removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PresetDashboard)Asset.removeAnnouncement(client, PresetDashboard.updater(qualifiedName, name));
    }

    public static PresetDashboard replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return PresetDashboard.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static PresetDashboard replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (PresetDashboard)Asset.replaceTerms(client, PresetDashboard.updater(qualifiedName, name), terms);
    }

    public static PresetDashboard appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return PresetDashboard.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static PresetDashboard appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (PresetDashboard)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static PresetDashboard removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return PresetDashboard.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static PresetDashboard removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (PresetDashboard)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static PresetDashboard appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return PresetDashboard.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static PresetDashboard appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (PresetDashboard)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static PresetDashboard appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return PresetDashboard.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static PresetDashboard appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (PresetDashboard)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        PresetDashboard.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected PresetDashboard(PresetDashboardBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : PresetDashboard.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        SortedSet<IPresetChart> presetCharts = new TreeSet<IPresetChart>();
        if (b.presetCharts != null) {
            presetCharts.addAll(b.presetCharts);
        }
        presetCharts = Collections.unmodifiableSortedSet(presetCharts);
        this.presetCharts = presetCharts;
        this.presetDashboardChangedByName = b.presetDashboardChangedByName;
        this.presetDashboardChangedByURL = b.presetDashboardChangedByURL;
        this.presetDashboardChartCount = b.presetDashboardChartCount;
        this.presetDashboardId = b.presetDashboardId;
        this.presetDashboardIsManagedExternally = b.presetDashboardIsManagedExternally;
        this.presetDashboardIsPublished = b.presetDashboardIsPublished;
        this.presetDashboardQualifiedName = b.presetDashboardQualifiedName;
        this.presetDashboardThumbnailURL = b.presetDashboardThumbnailURL;
        SortedSet<IPresetDataset> presetDatasets = new TreeSet<IPresetDataset>();
        if (b.presetDatasets != null) {
            presetDatasets.addAll(b.presetDatasets);
        }
        presetDatasets = Collections.unmodifiableSortedSet(presetDatasets);
        this.presetDatasets = presetDatasets;
        this.presetWorkspace = b.presetWorkspace;
        this.presetWorkspaceId = b.presetWorkspaceId;
        this.presetWorkspaceQualifiedName = b.presetWorkspaceQualifiedName;
    }

    @Generated
    public static PresetDashboardBuilder<?, ?> _internal() {
        return new PresetDashboardBuilderImpl();
    }

    @Generated
    public PresetDashboardBuilder<?, ?> toBuilder() {
        return new PresetDashboardBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IPresetChart> getPresetCharts() {
        return this.presetCharts;
    }

    @Override
    @Generated
    public String getPresetDashboardChangedByName() {
        return this.presetDashboardChangedByName;
    }

    @Override
    @Generated
    public String getPresetDashboardChangedByURL() {
        return this.presetDashboardChangedByURL;
    }

    @Override
    @Generated
    public Long getPresetDashboardChartCount() {
        return this.presetDashboardChartCount;
    }

    @Override
    @Generated
    public Long getPresetDashboardId() {
        return this.presetDashboardId;
    }

    @Override
    @Generated
    public Boolean getPresetDashboardIsManagedExternally() {
        return this.presetDashboardIsManagedExternally;
    }

    @Override
    @Generated
    public Boolean getPresetDashboardIsPublished() {
        return this.presetDashboardIsPublished;
    }

    @Override
    @Generated
    public String getPresetDashboardQualifiedName() {
        return this.presetDashboardQualifiedName;
    }

    @Override
    @Generated
    public String getPresetDashboardThumbnailURL() {
        return this.presetDashboardThumbnailURL;
    }

    @Override
    @Generated
    public SortedSet<IPresetDataset> getPresetDatasets() {
        return this.presetDatasets;
    }

    @Override
    @Generated
    public IPresetWorkspace getPresetWorkspace() {
        return this.presetWorkspace;
    }

    @Override
    @Generated
    public Long getPresetWorkspaceId() {
        return this.presetWorkspaceId;
    }

    @Override
    @Generated
    public String getPresetWorkspaceQualifiedName() {
        return this.presetWorkspaceQualifiedName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PresetDashboard)) {
            return false;
        }
        PresetDashboard other = (PresetDashboard)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$presetDashboardChartCount = this.getPresetDashboardChartCount();
        Long other$presetDashboardChartCount = other.getPresetDashboardChartCount();
        if (this$presetDashboardChartCount == null ? other$presetDashboardChartCount != null : !((Object)this$presetDashboardChartCount).equals(other$presetDashboardChartCount)) {
            return false;
        }
        Long this$presetDashboardId = this.getPresetDashboardId();
        Long other$presetDashboardId = other.getPresetDashboardId();
        if (this$presetDashboardId == null ? other$presetDashboardId != null : !((Object)this$presetDashboardId).equals(other$presetDashboardId)) {
            return false;
        }
        Boolean this$presetDashboardIsManagedExternally = this.getPresetDashboardIsManagedExternally();
        Boolean other$presetDashboardIsManagedExternally = other.getPresetDashboardIsManagedExternally();
        if (this$presetDashboardIsManagedExternally == null ? other$presetDashboardIsManagedExternally != null : !((Object)this$presetDashboardIsManagedExternally).equals(other$presetDashboardIsManagedExternally)) {
            return false;
        }
        Boolean this$presetDashboardIsPublished = this.getPresetDashboardIsPublished();
        Boolean other$presetDashboardIsPublished = other.getPresetDashboardIsPublished();
        if (this$presetDashboardIsPublished == null ? other$presetDashboardIsPublished != null : !((Object)this$presetDashboardIsPublished).equals(other$presetDashboardIsPublished)) {
            return false;
        }
        Long this$presetWorkspaceId = this.getPresetWorkspaceId();
        Long other$presetWorkspaceId = other.getPresetWorkspaceId();
        if (this$presetWorkspaceId == null ? other$presetWorkspaceId != null : !((Object)this$presetWorkspaceId).equals(other$presetWorkspaceId)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        SortedSet<IPresetChart> this$presetCharts = this.getPresetCharts();
        SortedSet<IPresetChart> other$presetCharts = other.getPresetCharts();
        if (this$presetCharts == null ? other$presetCharts != null : !this$presetCharts.equals(other$presetCharts)) {
            return false;
        }
        String this$presetDashboardChangedByName = this.getPresetDashboardChangedByName();
        String other$presetDashboardChangedByName = other.getPresetDashboardChangedByName();
        if (this$presetDashboardChangedByName == null ? other$presetDashboardChangedByName != null : !this$presetDashboardChangedByName.equals(other$presetDashboardChangedByName)) {
            return false;
        }
        String this$presetDashboardChangedByURL = this.getPresetDashboardChangedByURL();
        String other$presetDashboardChangedByURL = other.getPresetDashboardChangedByURL();
        if (this$presetDashboardChangedByURL == null ? other$presetDashboardChangedByURL != null : !this$presetDashboardChangedByURL.equals(other$presetDashboardChangedByURL)) {
            return false;
        }
        String this$presetDashboardQualifiedName = this.getPresetDashboardQualifiedName();
        String other$presetDashboardQualifiedName = other.getPresetDashboardQualifiedName();
        if (this$presetDashboardQualifiedName == null ? other$presetDashboardQualifiedName != null : !this$presetDashboardQualifiedName.equals(other$presetDashboardQualifiedName)) {
            return false;
        }
        String this$presetDashboardThumbnailURL = this.getPresetDashboardThumbnailURL();
        String other$presetDashboardThumbnailURL = other.getPresetDashboardThumbnailURL();
        if (this$presetDashboardThumbnailURL == null ? other$presetDashboardThumbnailURL != null : !this$presetDashboardThumbnailURL.equals(other$presetDashboardThumbnailURL)) {
            return false;
        }
        SortedSet<IPresetDataset> this$presetDatasets = this.getPresetDatasets();
        SortedSet<IPresetDataset> other$presetDatasets = other.getPresetDatasets();
        if (this$presetDatasets == null ? other$presetDatasets != null : !this$presetDatasets.equals(other$presetDatasets)) {
            return false;
        }
        IPresetWorkspace this$presetWorkspace = this.getPresetWorkspace();
        IPresetWorkspace other$presetWorkspace = other.getPresetWorkspace();
        if (this$presetWorkspace == null ? other$presetWorkspace != null : !this$presetWorkspace.equals(other$presetWorkspace)) {
            return false;
        }
        String this$presetWorkspaceQualifiedName = this.getPresetWorkspaceQualifiedName();
        String other$presetWorkspaceQualifiedName = other.getPresetWorkspaceQualifiedName();
        return !(this$presetWorkspaceQualifiedName == null ? other$presetWorkspaceQualifiedName != null : !this$presetWorkspaceQualifiedName.equals(other$presetWorkspaceQualifiedName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PresetDashboard;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $presetDashboardChartCount = this.getPresetDashboardChartCount();
        result = result * 59 + ($presetDashboardChartCount == null ? 43 : ((Object)$presetDashboardChartCount).hashCode());
        Long $presetDashboardId = this.getPresetDashboardId();
        result = result * 59 + ($presetDashboardId == null ? 43 : ((Object)$presetDashboardId).hashCode());
        Boolean $presetDashboardIsManagedExternally = this.getPresetDashboardIsManagedExternally();
        result = result * 59 + ($presetDashboardIsManagedExternally == null ? 43 : ((Object)$presetDashboardIsManagedExternally).hashCode());
        Boolean $presetDashboardIsPublished = this.getPresetDashboardIsPublished();
        result = result * 59 + ($presetDashboardIsPublished == null ? 43 : ((Object)$presetDashboardIsPublished).hashCode());
        Long $presetWorkspaceId = this.getPresetWorkspaceId();
        result = result * 59 + ($presetWorkspaceId == null ? 43 : ((Object)$presetWorkspaceId).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        SortedSet<IPresetChart> $presetCharts = this.getPresetCharts();
        result = result * 59 + ($presetCharts == null ? 43 : $presetCharts.hashCode());
        String $presetDashboardChangedByName = this.getPresetDashboardChangedByName();
        result = result * 59 + ($presetDashboardChangedByName == null ? 43 : $presetDashboardChangedByName.hashCode());
        String $presetDashboardChangedByURL = this.getPresetDashboardChangedByURL();
        result = result * 59 + ($presetDashboardChangedByURL == null ? 43 : $presetDashboardChangedByURL.hashCode());
        String $presetDashboardQualifiedName = this.getPresetDashboardQualifiedName();
        result = result * 59 + ($presetDashboardQualifiedName == null ? 43 : $presetDashboardQualifiedName.hashCode());
        String $presetDashboardThumbnailURL = this.getPresetDashboardThumbnailURL();
        result = result * 59 + ($presetDashboardThumbnailURL == null ? 43 : $presetDashboardThumbnailURL.hashCode());
        SortedSet<IPresetDataset> $presetDatasets = this.getPresetDatasets();
        result = result * 59 + ($presetDatasets == null ? 43 : $presetDatasets.hashCode());
        IPresetWorkspace $presetWorkspace = this.getPresetWorkspace();
        result = result * 59 + ($presetWorkspace == null ? 43 : $presetWorkspace.hashCode());
        String $presetWorkspaceQualifiedName = this.getPresetWorkspaceQualifiedName();
        result = result * 59 + ($presetWorkspaceQualifiedName == null ? 43 : $presetWorkspaceQualifiedName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "PresetDashboard(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", presetCharts=" + this.getPresetCharts() + ", presetDashboardChangedByName=" + this.getPresetDashboardChangedByName() + ", presetDashboardChangedByURL=" + this.getPresetDashboardChangedByURL() + ", presetDashboardChartCount=" + this.getPresetDashboardChartCount() + ", presetDashboardId=" + this.getPresetDashboardId() + ", presetDashboardIsManagedExternally=" + this.getPresetDashboardIsManagedExternally() + ", presetDashboardIsPublished=" + this.getPresetDashboardIsPublished() + ", presetDashboardQualifiedName=" + this.getPresetDashboardQualifiedName() + ", presetDashboardThumbnailURL=" + this.getPresetDashboardThumbnailURL() + ", presetDatasets=" + this.getPresetDatasets() + ", presetWorkspace=" + this.getPresetWorkspace() + ", presetWorkspaceId=" + this.getPresetWorkspaceId() + ", presetWorkspaceQualifiedName=" + this.getPresetWorkspaceQualifiedName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class PresetDashboardBuilder<C extends PresetDashboard, B extends PresetDashboardBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private ArrayList<IPresetChart> presetCharts;
        @Generated
        private String presetDashboardChangedByName;
        @Generated
        private String presetDashboardChangedByURL;
        @Generated
        private Long presetDashboardChartCount;
        @Generated
        private Long presetDashboardId;
        @Generated
        private Boolean presetDashboardIsManagedExternally;
        @Generated
        private Boolean presetDashboardIsPublished;
        @Generated
        private String presetDashboardQualifiedName;
        @Generated
        private String presetDashboardThumbnailURL;
        @Generated
        private ArrayList<IPresetDataset> presetDatasets;
        @Generated
        private IPresetWorkspace presetWorkspace;
        @Generated
        private Long presetWorkspaceId;
        @Generated
        private String presetWorkspaceQualifiedName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PresetDashboardBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PresetDashboard instance, PresetDashboardBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.presetCharts(instance.presetCharts == null ? Collections.emptySortedSet() : instance.presetCharts);
            b.presetDashboardChangedByName(instance.presetDashboardChangedByName);
            b.presetDashboardChangedByURL(instance.presetDashboardChangedByURL);
            b.presetDashboardChartCount(instance.presetDashboardChartCount);
            b.presetDashboardId(instance.presetDashboardId);
            b.presetDashboardIsManagedExternally(instance.presetDashboardIsManagedExternally);
            b.presetDashboardIsPublished(instance.presetDashboardIsPublished);
            b.presetDashboardQualifiedName(instance.presetDashboardQualifiedName);
            b.presetDashboardThumbnailURL(instance.presetDashboardThumbnailURL);
            b.presetDatasets(instance.presetDatasets == null ? Collections.emptySortedSet() : instance.presetDatasets);
            b.presetWorkspace(instance.presetWorkspace);
            b.presetWorkspaceId(instance.presetWorkspaceId);
            b.presetWorkspaceQualifiedName(instance.presetWorkspaceQualifiedName);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B presetChart(IPresetChart presetChart) {
            if (this.presetCharts == null) {
                this.presetCharts = new ArrayList();
            }
            this.presetCharts.add(presetChart);
            return (B)this.self();
        }

        @Generated
        public B presetCharts(Collection<? extends IPresetChart> presetCharts) {
            if (presetCharts == null) {
                throw new NullPointerException("presetCharts cannot be null");
            }
            if (this.presetCharts == null) {
                this.presetCharts = new ArrayList();
            }
            this.presetCharts.addAll(presetCharts);
            return (B)this.self();
        }

        @Generated
        public B clearPresetCharts() {
            if (this.presetCharts != null) {
                this.presetCharts.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B presetDashboardChangedByName(String presetDashboardChangedByName) {
            this.presetDashboardChangedByName = presetDashboardChangedByName;
            return (B)this.self();
        }

        @Generated
        public B presetDashboardChangedByURL(String presetDashboardChangedByURL) {
            this.presetDashboardChangedByURL = presetDashboardChangedByURL;
            return (B)this.self();
        }

        @Generated
        public B presetDashboardChartCount(Long presetDashboardChartCount) {
            this.presetDashboardChartCount = presetDashboardChartCount;
            return (B)this.self();
        }

        @Generated
        public B presetDashboardId(Long presetDashboardId) {
            this.presetDashboardId = presetDashboardId;
            return (B)this.self();
        }

        @Generated
        public B presetDashboardIsManagedExternally(Boolean presetDashboardIsManagedExternally) {
            this.presetDashboardIsManagedExternally = presetDashboardIsManagedExternally;
            return (B)this.self();
        }

        @Generated
        public B presetDashboardIsPublished(Boolean presetDashboardIsPublished) {
            this.presetDashboardIsPublished = presetDashboardIsPublished;
            return (B)this.self();
        }

        @Generated
        public B presetDashboardQualifiedName(String presetDashboardQualifiedName) {
            this.presetDashboardQualifiedName = presetDashboardQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B presetDashboardThumbnailURL(String presetDashboardThumbnailURL) {
            this.presetDashboardThumbnailURL = presetDashboardThumbnailURL;
            return (B)this.self();
        }

        @Generated
        public B presetDataset(IPresetDataset presetDataset) {
            if (this.presetDatasets == null) {
                this.presetDatasets = new ArrayList();
            }
            this.presetDatasets.add(presetDataset);
            return (B)this.self();
        }

        @Generated
        public B presetDatasets(Collection<? extends IPresetDataset> presetDatasets) {
            if (presetDatasets == null) {
                throw new NullPointerException("presetDatasets cannot be null");
            }
            if (this.presetDatasets == null) {
                this.presetDatasets = new ArrayList();
            }
            this.presetDatasets.addAll(presetDatasets);
            return (B)this.self();
        }

        @Generated
        public B clearPresetDatasets() {
            if (this.presetDatasets != null) {
                this.presetDatasets.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B presetWorkspace(IPresetWorkspace presetWorkspace) {
            this.presetWorkspace = presetWorkspace;
            return (B)this.self();
        }

        @Generated
        public B presetWorkspaceId(Long presetWorkspaceId) {
            this.presetWorkspaceId = presetWorkspaceId;
            return (B)this.self();
        }

        @Generated
        public B presetWorkspaceQualifiedName(String presetWorkspaceQualifiedName) {
            this.presetWorkspaceQualifiedName = presetWorkspaceQualifiedName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "PresetDashboard.PresetDashboardBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", presetCharts=" + this.presetCharts + ", presetDashboardChangedByName=" + this.presetDashboardChangedByName + ", presetDashboardChangedByURL=" + this.presetDashboardChangedByURL + ", presetDashboardChartCount=" + this.presetDashboardChartCount + ", presetDashboardId=" + this.presetDashboardId + ", presetDashboardIsManagedExternally=" + this.presetDashboardIsManagedExternally + ", presetDashboardIsPublished=" + this.presetDashboardIsPublished + ", presetDashboardQualifiedName=" + this.presetDashboardQualifiedName + ", presetDashboardThumbnailURL=" + this.presetDashboardThumbnailURL + ", presetDatasets=" + this.presetDatasets + ", presetWorkspace=" + this.presetWorkspace + ", presetWorkspaceId=" + this.presetWorkspaceId + ", presetWorkspaceQualifiedName=" + this.presetWorkspaceQualifiedName + ")";
        }
    }

    @Generated
    private static final class PresetDashboardBuilderImpl
    extends PresetDashboardBuilder<PresetDashboard, PresetDashboardBuilderImpl> {
        @Generated
        private PresetDashboardBuilderImpl() {
        }

        @Override
        @Generated
        protected PresetDashboardBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PresetDashboard build() {
            return new PresetDashboard(this);
        }
    }
}

