/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IQlik;
import com.atlan.model.assets.IQlikApp;
import com.atlan.model.assets.IQlikDataset;
import com.atlan.model.assets.IQlikSpace;
import com.atlan.model.assets.IQlikStream;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QlikStream
extends Asset
implements IQlikStream,
IQlikSpace,
IQlik,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QlikStream.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "QlikStream";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    String qlikAppId;
    @Attribute
    String qlikAppQualifiedName;
    @Attribute
    SortedSet<IQlikApp> qlikApps;
    @Attribute
    SortedSet<IQlikDataset> qlikDatasets;
    @Attribute
    String qlikId;
    @Attribute
    Boolean qlikIsPublished;
    @Attribute
    String qlikOwnerId;
    @Attribute
    String qlikQRI;
    @Attribute
    String qlikSpaceId;
    @Attribute
    String qlikSpaceQualifiedName;
    @Attribute
    String qlikSpaceType;

    @Override
    public QlikStream trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return QlikStream.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return QlikStream.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return QlikStream.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return QlikStream.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return QlikStream.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return QlikStream.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static QlikStream refByGuid(String guid) {
        return QlikStream.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static QlikStream refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((QlikStreamBuilder)((QlikStreamBuilder)QlikStream._internal().guid(guid)).semantic(semantic)).build();
    }

    public static QlikStream refByQualifiedName(String qualifiedName) {
        return QlikStream.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static QlikStream refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((QlikStreamBuilder)((QlikStreamBuilder)QlikStream._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static QlikStream get(String id) throws AtlanException {
        return QlikStream.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static QlikStream get(AtlanClient client, String id) throws AtlanException {
        return QlikStream.get(client, id, true);
    }

    @JsonIgnore
    public static QlikStream get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof QlikStream) {
                return (QlikStream)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof QlikStream) {
            return (QlikStream)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return QlikStream.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static QlikStreamBuilder<?, ?> updater(String qualifiedName, String name) {
        return (QlikStreamBuilder)((QlikStreamBuilder)((QlikStreamBuilder)QlikStream._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public QlikStreamBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        QlikStream.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return QlikStream.updater(this.getQualifiedName(), this.getName());
    }

    public static QlikStream removeDescription(String qualifiedName, String name) throws AtlanException {
        return QlikStream.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static QlikStream removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QlikStream)Asset.removeDescription(client, QlikStream.updater(qualifiedName, name));
    }

    public static QlikStream removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return QlikStream.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static QlikStream removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QlikStream)Asset.removeUserDescription(client, QlikStream.updater(qualifiedName, name));
    }

    public static QlikStream removeOwners(String qualifiedName, String name) throws AtlanException {
        return QlikStream.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static QlikStream removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QlikStream)Asset.removeOwners(client, QlikStream.updater(qualifiedName, name));
    }

    public static QlikStream updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return QlikStream.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static QlikStream updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (QlikStream)Asset.updateCertificate(client, QlikStream._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static QlikStream removeCertificate(String qualifiedName, String name) throws AtlanException {
        return QlikStream.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static QlikStream removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QlikStream)Asset.removeCertificate(client, QlikStream.updater(qualifiedName, name));
    }

    public static QlikStream updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return QlikStream.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static QlikStream updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (QlikStream)Asset.updateAnnouncement(client, QlikStream._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static QlikStream removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return QlikStream.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static QlikStream removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QlikStream)Asset.removeAnnouncement(client, QlikStream.updater(qualifiedName, name));
    }

    public static QlikStream replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return QlikStream.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static QlikStream replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (QlikStream)Asset.replaceTerms(client, QlikStream.updater(qualifiedName, name), terms);
    }

    public static QlikStream appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return QlikStream.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static QlikStream appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (QlikStream)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static QlikStream removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return QlikStream.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static QlikStream removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (QlikStream)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static QlikStream appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return QlikStream.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static QlikStream appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (QlikStream)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static QlikStream appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return QlikStream.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static QlikStream appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (QlikStream)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        QlikStream.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected QlikStream(QlikStreamBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : QlikStream.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.qlikAppId = b.qlikAppId;
        this.qlikAppQualifiedName = b.qlikAppQualifiedName;
        SortedSet<IQlikApp> qlikApps = new TreeSet<IQlikApp>();
        if (b.qlikApps != null) {
            qlikApps.addAll(b.qlikApps);
        }
        qlikApps = Collections.unmodifiableSortedSet(qlikApps);
        this.qlikApps = qlikApps;
        SortedSet<IQlikDataset> qlikDatasets = new TreeSet<IQlikDataset>();
        if (b.qlikDatasets != null) {
            qlikDatasets.addAll(b.qlikDatasets);
        }
        qlikDatasets = Collections.unmodifiableSortedSet(qlikDatasets);
        this.qlikDatasets = qlikDatasets;
        this.qlikId = b.qlikId;
        this.qlikIsPublished = b.qlikIsPublished;
        this.qlikOwnerId = b.qlikOwnerId;
        this.qlikQRI = b.qlikQRI;
        this.qlikSpaceId = b.qlikSpaceId;
        this.qlikSpaceQualifiedName = b.qlikSpaceQualifiedName;
        this.qlikSpaceType = b.qlikSpaceType;
    }

    @Generated
    public static QlikStreamBuilder<?, ?> _internal() {
        return new QlikStreamBuilderImpl();
    }

    @Generated
    public QlikStreamBuilder<?, ?> toBuilder() {
        return new QlikStreamBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public String getQlikAppId() {
        return this.qlikAppId;
    }

    @Override
    @Generated
    public String getQlikAppQualifiedName() {
        return this.qlikAppQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IQlikApp> getQlikApps() {
        return this.qlikApps;
    }

    @Override
    @Generated
    public SortedSet<IQlikDataset> getQlikDatasets() {
        return this.qlikDatasets;
    }

    @Override
    @Generated
    public String getQlikId() {
        return this.qlikId;
    }

    @Override
    @Generated
    public Boolean getQlikIsPublished() {
        return this.qlikIsPublished;
    }

    @Override
    @Generated
    public String getQlikOwnerId() {
        return this.qlikOwnerId;
    }

    @Override
    @Generated
    public String getQlikQRI() {
        return this.qlikQRI;
    }

    @Override
    @Generated
    public String getQlikSpaceId() {
        return this.qlikSpaceId;
    }

    @Override
    @Generated
    public String getQlikSpaceQualifiedName() {
        return this.qlikSpaceQualifiedName;
    }

    @Override
    @Generated
    public String getQlikSpaceType() {
        return this.qlikSpaceType;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QlikStream)) {
            return false;
        }
        QlikStream other = (QlikStream)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$qlikIsPublished = this.getQlikIsPublished();
        Boolean other$qlikIsPublished = other.getQlikIsPublished();
        if (this$qlikIsPublished == null ? other$qlikIsPublished != null : !((Object)this$qlikIsPublished).equals(other$qlikIsPublished)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        String this$qlikAppId = this.getQlikAppId();
        String other$qlikAppId = other.getQlikAppId();
        if (this$qlikAppId == null ? other$qlikAppId != null : !this$qlikAppId.equals(other$qlikAppId)) {
            return false;
        }
        String this$qlikAppQualifiedName = this.getQlikAppQualifiedName();
        String other$qlikAppQualifiedName = other.getQlikAppQualifiedName();
        if (this$qlikAppQualifiedName == null ? other$qlikAppQualifiedName != null : !this$qlikAppQualifiedName.equals(other$qlikAppQualifiedName)) {
            return false;
        }
        SortedSet<IQlikApp> this$qlikApps = this.getQlikApps();
        SortedSet<IQlikApp> other$qlikApps = other.getQlikApps();
        if (this$qlikApps == null ? other$qlikApps != null : !this$qlikApps.equals(other$qlikApps)) {
            return false;
        }
        SortedSet<IQlikDataset> this$qlikDatasets = this.getQlikDatasets();
        SortedSet<IQlikDataset> other$qlikDatasets = other.getQlikDatasets();
        if (this$qlikDatasets == null ? other$qlikDatasets != null : !this$qlikDatasets.equals(other$qlikDatasets)) {
            return false;
        }
        String this$qlikId = this.getQlikId();
        String other$qlikId = other.getQlikId();
        if (this$qlikId == null ? other$qlikId != null : !this$qlikId.equals(other$qlikId)) {
            return false;
        }
        String this$qlikOwnerId = this.getQlikOwnerId();
        String other$qlikOwnerId = other.getQlikOwnerId();
        if (this$qlikOwnerId == null ? other$qlikOwnerId != null : !this$qlikOwnerId.equals(other$qlikOwnerId)) {
            return false;
        }
        String this$qlikQRI = this.getQlikQRI();
        String other$qlikQRI = other.getQlikQRI();
        if (this$qlikQRI == null ? other$qlikQRI != null : !this$qlikQRI.equals(other$qlikQRI)) {
            return false;
        }
        String this$qlikSpaceId = this.getQlikSpaceId();
        String other$qlikSpaceId = other.getQlikSpaceId();
        if (this$qlikSpaceId == null ? other$qlikSpaceId != null : !this$qlikSpaceId.equals(other$qlikSpaceId)) {
            return false;
        }
        String this$qlikSpaceQualifiedName = this.getQlikSpaceQualifiedName();
        String other$qlikSpaceQualifiedName = other.getQlikSpaceQualifiedName();
        if (this$qlikSpaceQualifiedName == null ? other$qlikSpaceQualifiedName != null : !this$qlikSpaceQualifiedName.equals(other$qlikSpaceQualifiedName)) {
            return false;
        }
        String this$qlikSpaceType = this.getQlikSpaceType();
        String other$qlikSpaceType = other.getQlikSpaceType();
        return !(this$qlikSpaceType == null ? other$qlikSpaceType != null : !this$qlikSpaceType.equals(other$qlikSpaceType));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QlikStream;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $qlikIsPublished = this.getQlikIsPublished();
        result = result * 59 + ($qlikIsPublished == null ? 43 : ((Object)$qlikIsPublished).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        String $qlikAppId = this.getQlikAppId();
        result = result * 59 + ($qlikAppId == null ? 43 : $qlikAppId.hashCode());
        String $qlikAppQualifiedName = this.getQlikAppQualifiedName();
        result = result * 59 + ($qlikAppQualifiedName == null ? 43 : $qlikAppQualifiedName.hashCode());
        SortedSet<IQlikApp> $qlikApps = this.getQlikApps();
        result = result * 59 + ($qlikApps == null ? 43 : $qlikApps.hashCode());
        SortedSet<IQlikDataset> $qlikDatasets = this.getQlikDatasets();
        result = result * 59 + ($qlikDatasets == null ? 43 : $qlikDatasets.hashCode());
        String $qlikId = this.getQlikId();
        result = result * 59 + ($qlikId == null ? 43 : $qlikId.hashCode());
        String $qlikOwnerId = this.getQlikOwnerId();
        result = result * 59 + ($qlikOwnerId == null ? 43 : $qlikOwnerId.hashCode());
        String $qlikQRI = this.getQlikQRI();
        result = result * 59 + ($qlikQRI == null ? 43 : $qlikQRI.hashCode());
        String $qlikSpaceId = this.getQlikSpaceId();
        result = result * 59 + ($qlikSpaceId == null ? 43 : $qlikSpaceId.hashCode());
        String $qlikSpaceQualifiedName = this.getQlikSpaceQualifiedName();
        result = result * 59 + ($qlikSpaceQualifiedName == null ? 43 : $qlikSpaceQualifiedName.hashCode());
        String $qlikSpaceType = this.getQlikSpaceType();
        result = result * 59 + ($qlikSpaceType == null ? 43 : $qlikSpaceType.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "QlikStream(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", qlikAppId=" + this.getQlikAppId() + ", qlikAppQualifiedName=" + this.getQlikAppQualifiedName() + ", qlikApps=" + this.getQlikApps() + ", qlikDatasets=" + this.getQlikDatasets() + ", qlikId=" + this.getQlikId() + ", qlikIsPublished=" + this.getQlikIsPublished() + ", qlikOwnerId=" + this.getQlikOwnerId() + ", qlikQRI=" + this.getQlikQRI() + ", qlikSpaceId=" + this.getQlikSpaceId() + ", qlikSpaceQualifiedName=" + this.getQlikSpaceQualifiedName() + ", qlikSpaceType=" + this.getQlikSpaceType() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class QlikStreamBuilder<C extends QlikStream, B extends QlikStreamBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private String qlikAppId;
        @Generated
        private String qlikAppQualifiedName;
        @Generated
        private ArrayList<IQlikApp> qlikApps;
        @Generated
        private ArrayList<IQlikDataset> qlikDatasets;
        @Generated
        private String qlikId;
        @Generated
        private Boolean qlikIsPublished;
        @Generated
        private String qlikOwnerId;
        @Generated
        private String qlikQRI;
        @Generated
        private String qlikSpaceId;
        @Generated
        private String qlikSpaceQualifiedName;
        @Generated
        private String qlikSpaceType;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            QlikStreamBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(QlikStream instance, QlikStreamBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.qlikAppId(instance.qlikAppId);
            b.qlikAppQualifiedName(instance.qlikAppQualifiedName);
            b.qlikApps(instance.qlikApps == null ? Collections.emptySortedSet() : instance.qlikApps);
            b.qlikDatasets(instance.qlikDatasets == null ? Collections.emptySortedSet() : instance.qlikDatasets);
            b.qlikId(instance.qlikId);
            b.qlikIsPublished(instance.qlikIsPublished);
            b.qlikOwnerId(instance.qlikOwnerId);
            b.qlikQRI(instance.qlikQRI);
            b.qlikSpaceId(instance.qlikSpaceId);
            b.qlikSpaceQualifiedName(instance.qlikSpaceQualifiedName);
            b.qlikSpaceType(instance.qlikSpaceType);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B qlikAppId(String qlikAppId) {
            this.qlikAppId = qlikAppId;
            return (B)this.self();
        }

        @Generated
        public B qlikAppQualifiedName(String qlikAppQualifiedName) {
            this.qlikAppQualifiedName = qlikAppQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B qlikApp(IQlikApp qlikApp) {
            if (this.qlikApps == null) {
                this.qlikApps = new ArrayList();
            }
            this.qlikApps.add(qlikApp);
            return (B)this.self();
        }

        @Generated
        public B qlikApps(Collection<? extends IQlikApp> qlikApps) {
            if (qlikApps == null) {
                throw new NullPointerException("qlikApps cannot be null");
            }
            if (this.qlikApps == null) {
                this.qlikApps = new ArrayList();
            }
            this.qlikApps.addAll(qlikApps);
            return (B)this.self();
        }

        @Generated
        public B clearQlikApps() {
            if (this.qlikApps != null) {
                this.qlikApps.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B qlikDataset(IQlikDataset qlikDataset) {
            if (this.qlikDatasets == null) {
                this.qlikDatasets = new ArrayList();
            }
            this.qlikDatasets.add(qlikDataset);
            return (B)this.self();
        }

        @Generated
        public B qlikDatasets(Collection<? extends IQlikDataset> qlikDatasets) {
            if (qlikDatasets == null) {
                throw new NullPointerException("qlikDatasets cannot be null");
            }
            if (this.qlikDatasets == null) {
                this.qlikDatasets = new ArrayList();
            }
            this.qlikDatasets.addAll(qlikDatasets);
            return (B)this.self();
        }

        @Generated
        public B clearQlikDatasets() {
            if (this.qlikDatasets != null) {
                this.qlikDatasets.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B qlikId(String qlikId) {
            this.qlikId = qlikId;
            return (B)this.self();
        }

        @Generated
        public B qlikIsPublished(Boolean qlikIsPublished) {
            this.qlikIsPublished = qlikIsPublished;
            return (B)this.self();
        }

        @Generated
        public B qlikOwnerId(String qlikOwnerId) {
            this.qlikOwnerId = qlikOwnerId;
            return (B)this.self();
        }

        @Generated
        public B qlikQRI(String qlikQRI) {
            this.qlikQRI = qlikQRI;
            return (B)this.self();
        }

        @Generated
        public B qlikSpaceId(String qlikSpaceId) {
            this.qlikSpaceId = qlikSpaceId;
            return (B)this.self();
        }

        @Generated
        public B qlikSpaceQualifiedName(String qlikSpaceQualifiedName) {
            this.qlikSpaceQualifiedName = qlikSpaceQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B qlikSpaceType(String qlikSpaceType) {
            this.qlikSpaceType = qlikSpaceType;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "QlikStream.QlikStreamBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", qlikAppId=" + this.qlikAppId + ", qlikAppQualifiedName=" + this.qlikAppQualifiedName + ", qlikApps=" + this.qlikApps + ", qlikDatasets=" + this.qlikDatasets + ", qlikId=" + this.qlikId + ", qlikIsPublished=" + this.qlikIsPublished + ", qlikOwnerId=" + this.qlikOwnerId + ", qlikQRI=" + this.qlikQRI + ", qlikSpaceId=" + this.qlikSpaceId + ", qlikSpaceQualifiedName=" + this.qlikSpaceQualifiedName + ", qlikSpaceType=" + this.qlikSpaceType + ")";
        }
    }

    @Generated
    private static final class QlikStreamBuilderImpl
    extends QlikStreamBuilder<QlikStream, QlikStreamBuilderImpl> {
        @Generated
        private QlikStreamBuilderImpl() {
        }

        @Override
        @Generated
        protected QlikStreamBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public QlikStream build() {
            return new QlikStream(this);
        }
    }
}

