/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IQuickSight;
import com.atlan.model.assets.IQuickSightAnalysis;
import com.atlan.model.assets.IQuickSightDashboard;
import com.atlan.model.assets.IQuickSightDataset;
import com.atlan.model.assets.IQuickSightFolder;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.QuickSightFolderType;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickSightFolder
extends Asset
implements IQuickSightFolder,
IQuickSight,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QuickSightFolder.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "QuickSightFolder";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    SortedSet<IQuickSightAnalysis> quickSightAnalyses;
    @Attribute
    SortedSet<IQuickSightDashboard> quickSightDashboards;
    @Attribute
    SortedSet<IQuickSightDataset> quickSightDatasets;
    @Attribute
    List<Map<String, String>> quickSightFolderHierarchy;
    @Attribute
    QuickSightFolderType quickSightFolderType;
    @Attribute
    String quickSightId;
    @Attribute
    String quickSightSheetId;
    @Attribute
    String quickSightSheetName;

    @Override
    public QuickSightFolder trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return QuickSightFolder.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return QuickSightFolder.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return QuickSightFolder.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return QuickSightFolder.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return QuickSightFolder.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return QuickSightFolder.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static QuickSightFolder refByGuid(String guid) {
        return QuickSightFolder.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static QuickSightFolder refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((QuickSightFolderBuilder)((QuickSightFolderBuilder)QuickSightFolder._internal().guid(guid)).semantic(semantic)).build();
    }

    public static QuickSightFolder refByQualifiedName(String qualifiedName) {
        return QuickSightFolder.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static QuickSightFolder refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((QuickSightFolderBuilder)((QuickSightFolderBuilder)QuickSightFolder._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static QuickSightFolder get(String id) throws AtlanException {
        return QuickSightFolder.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static QuickSightFolder get(AtlanClient client, String id) throws AtlanException {
        return QuickSightFolder.get(client, id, true);
    }

    @JsonIgnore
    public static QuickSightFolder get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof QuickSightFolder) {
                return (QuickSightFolder)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof QuickSightFolder) {
            return (QuickSightFolder)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return QuickSightFolder.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static QuickSightFolderBuilder<?, ?> updater(String qualifiedName, String name) {
        return (QuickSightFolderBuilder)((QuickSightFolderBuilder)((QuickSightFolderBuilder)QuickSightFolder._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public QuickSightFolderBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        QuickSightFolder.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return QuickSightFolder.updater(this.getQualifiedName(), this.getName());
    }

    public static QuickSightFolder removeDescription(String qualifiedName, String name) throws AtlanException {
        return QuickSightFolder.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static QuickSightFolder removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightFolder)Asset.removeDescription(client, QuickSightFolder.updater(qualifiedName, name));
    }

    public static QuickSightFolder removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return QuickSightFolder.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static QuickSightFolder removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightFolder)Asset.removeUserDescription(client, QuickSightFolder.updater(qualifiedName, name));
    }

    public static QuickSightFolder removeOwners(String qualifiedName, String name) throws AtlanException {
        return QuickSightFolder.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static QuickSightFolder removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightFolder)Asset.removeOwners(client, QuickSightFolder.updater(qualifiedName, name));
    }

    public static QuickSightFolder updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return QuickSightFolder.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static QuickSightFolder updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (QuickSightFolder)Asset.updateCertificate(client, QuickSightFolder._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static QuickSightFolder removeCertificate(String qualifiedName, String name) throws AtlanException {
        return QuickSightFolder.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static QuickSightFolder removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightFolder)Asset.removeCertificate(client, QuickSightFolder.updater(qualifiedName, name));
    }

    public static QuickSightFolder updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return QuickSightFolder.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static QuickSightFolder updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (QuickSightFolder)Asset.updateAnnouncement(client, QuickSightFolder._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static QuickSightFolder removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return QuickSightFolder.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static QuickSightFolder removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightFolder)Asset.removeAnnouncement(client, QuickSightFolder.updater(qualifiedName, name));
    }

    public static QuickSightFolder replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return QuickSightFolder.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static QuickSightFolder replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (QuickSightFolder)Asset.replaceTerms(client, QuickSightFolder.updater(qualifiedName, name), terms);
    }

    public static QuickSightFolder appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return QuickSightFolder.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static QuickSightFolder appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (QuickSightFolder)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static QuickSightFolder removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return QuickSightFolder.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static QuickSightFolder removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (QuickSightFolder)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static QuickSightFolder appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return QuickSightFolder.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static QuickSightFolder appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (QuickSightFolder)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static QuickSightFolder appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return QuickSightFolder.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static QuickSightFolder appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (QuickSightFolder)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        QuickSightFolder.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected QuickSightFolder(QuickSightFolderBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : QuickSightFolder.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        SortedSet<IQuickSightAnalysis> quickSightAnalyses = new TreeSet<IQuickSightAnalysis>();
        if (b.quickSightAnalyses != null) {
            quickSightAnalyses.addAll(b.quickSightAnalyses);
        }
        quickSightAnalyses = Collections.unmodifiableSortedSet(quickSightAnalyses);
        this.quickSightAnalyses = quickSightAnalyses;
        SortedSet<IQuickSightDashboard> quickSightDashboards = new TreeSet<IQuickSightDashboard>();
        if (b.quickSightDashboards != null) {
            quickSightDashboards.addAll(b.quickSightDashboards);
        }
        quickSightDashboards = Collections.unmodifiableSortedSet(quickSightDashboards);
        this.quickSightDashboards = quickSightDashboards;
        SortedSet<IQuickSightDataset> quickSightDatasets = new TreeSet<IQuickSightDataset>();
        if (b.quickSightDatasets != null) {
            quickSightDatasets.addAll(b.quickSightDatasets);
        }
        quickSightDatasets = Collections.unmodifiableSortedSet(quickSightDatasets);
        this.quickSightDatasets = quickSightDatasets;
        this.quickSightFolderHierarchy = switch (b.quickSightFolderHierarchy == null ? 0 : b.quickSightFolderHierarchy.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.quickSightFolderHierarchy.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.quickSightFolderHierarchy));
        };
        this.quickSightFolderType = b.quickSightFolderType;
        this.quickSightId = b.quickSightId;
        this.quickSightSheetId = b.quickSightSheetId;
        this.quickSightSheetName = b.quickSightSheetName;
    }

    @Generated
    public static QuickSightFolderBuilder<?, ?> _internal() {
        return new QuickSightFolderBuilderImpl();
    }

    @Generated
    public QuickSightFolderBuilder<?, ?> toBuilder() {
        return new QuickSightFolderBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IQuickSightAnalysis> getQuickSightAnalyses() {
        return this.quickSightAnalyses;
    }

    @Override
    @Generated
    public SortedSet<IQuickSightDashboard> getQuickSightDashboards() {
        return this.quickSightDashboards;
    }

    @Override
    @Generated
    public SortedSet<IQuickSightDataset> getQuickSightDatasets() {
        return this.quickSightDatasets;
    }

    @Override
    @Generated
    public List<Map<String, String>> getQuickSightFolderHierarchy() {
        return this.quickSightFolderHierarchy;
    }

    @Override
    @Generated
    public QuickSightFolderType getQuickSightFolderType() {
        return this.quickSightFolderType;
    }

    @Override
    @Generated
    public String getQuickSightId() {
        return this.quickSightId;
    }

    @Override
    @Generated
    public String getQuickSightSheetId() {
        return this.quickSightSheetId;
    }

    @Override
    @Generated
    public String getQuickSightSheetName() {
        return this.quickSightSheetName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuickSightFolder)) {
            return false;
        }
        QuickSightFolder other = (QuickSightFolder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        SortedSet<IQuickSightAnalysis> this$quickSightAnalyses = this.getQuickSightAnalyses();
        SortedSet<IQuickSightAnalysis> other$quickSightAnalyses = other.getQuickSightAnalyses();
        if (this$quickSightAnalyses == null ? other$quickSightAnalyses != null : !this$quickSightAnalyses.equals(other$quickSightAnalyses)) {
            return false;
        }
        SortedSet<IQuickSightDashboard> this$quickSightDashboards = this.getQuickSightDashboards();
        SortedSet<IQuickSightDashboard> other$quickSightDashboards = other.getQuickSightDashboards();
        if (this$quickSightDashboards == null ? other$quickSightDashboards != null : !this$quickSightDashboards.equals(other$quickSightDashboards)) {
            return false;
        }
        SortedSet<IQuickSightDataset> this$quickSightDatasets = this.getQuickSightDatasets();
        SortedSet<IQuickSightDataset> other$quickSightDatasets = other.getQuickSightDatasets();
        if (this$quickSightDatasets == null ? other$quickSightDatasets != null : !this$quickSightDatasets.equals(other$quickSightDatasets)) {
            return false;
        }
        List<Map<String, String>> this$quickSightFolderHierarchy = this.getQuickSightFolderHierarchy();
        List<Map<String, String>> other$quickSightFolderHierarchy = other.getQuickSightFolderHierarchy();
        if (this$quickSightFolderHierarchy == null ? other$quickSightFolderHierarchy != null : !((Object)this$quickSightFolderHierarchy).equals(other$quickSightFolderHierarchy)) {
            return false;
        }
        QuickSightFolderType this$quickSightFolderType = this.getQuickSightFolderType();
        QuickSightFolderType other$quickSightFolderType = other.getQuickSightFolderType();
        if (this$quickSightFolderType == null ? other$quickSightFolderType != null : !this$quickSightFolderType.equals(other$quickSightFolderType)) {
            return false;
        }
        String this$quickSightId = this.getQuickSightId();
        String other$quickSightId = other.getQuickSightId();
        if (this$quickSightId == null ? other$quickSightId != null : !this$quickSightId.equals(other$quickSightId)) {
            return false;
        }
        String this$quickSightSheetId = this.getQuickSightSheetId();
        String other$quickSightSheetId = other.getQuickSightSheetId();
        if (this$quickSightSheetId == null ? other$quickSightSheetId != null : !this$quickSightSheetId.equals(other$quickSightSheetId)) {
            return false;
        }
        String this$quickSightSheetName = this.getQuickSightSheetName();
        String other$quickSightSheetName = other.getQuickSightSheetName();
        return !(this$quickSightSheetName == null ? other$quickSightSheetName != null : !this$quickSightSheetName.equals(other$quickSightSheetName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QuickSightFolder;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        SortedSet<IQuickSightAnalysis> $quickSightAnalyses = this.getQuickSightAnalyses();
        result = result * 59 + ($quickSightAnalyses == null ? 43 : $quickSightAnalyses.hashCode());
        SortedSet<IQuickSightDashboard> $quickSightDashboards = this.getQuickSightDashboards();
        result = result * 59 + ($quickSightDashboards == null ? 43 : $quickSightDashboards.hashCode());
        SortedSet<IQuickSightDataset> $quickSightDatasets = this.getQuickSightDatasets();
        result = result * 59 + ($quickSightDatasets == null ? 43 : $quickSightDatasets.hashCode());
        List<Map<String, String>> $quickSightFolderHierarchy = this.getQuickSightFolderHierarchy();
        result = result * 59 + ($quickSightFolderHierarchy == null ? 43 : ((Object)$quickSightFolderHierarchy).hashCode());
        QuickSightFolderType $quickSightFolderType = this.getQuickSightFolderType();
        result = result * 59 + ($quickSightFolderType == null ? 43 : $quickSightFolderType.hashCode());
        String $quickSightId = this.getQuickSightId();
        result = result * 59 + ($quickSightId == null ? 43 : $quickSightId.hashCode());
        String $quickSightSheetId = this.getQuickSightSheetId();
        result = result * 59 + ($quickSightSheetId == null ? 43 : $quickSightSheetId.hashCode());
        String $quickSightSheetName = this.getQuickSightSheetName();
        result = result * 59 + ($quickSightSheetName == null ? 43 : $quickSightSheetName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "QuickSightFolder(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", quickSightAnalyses=" + this.getQuickSightAnalyses() + ", quickSightDashboards=" + this.getQuickSightDashboards() + ", quickSightDatasets=" + this.getQuickSightDatasets() + ", quickSightFolderHierarchy=" + this.getQuickSightFolderHierarchy() + ", quickSightFolderType=" + this.getQuickSightFolderType() + ", quickSightId=" + this.getQuickSightId() + ", quickSightSheetId=" + this.getQuickSightSheetId() + ", quickSightSheetName=" + this.getQuickSightSheetName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class QuickSightFolderBuilder<C extends QuickSightFolder, B extends QuickSightFolderBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private ArrayList<IQuickSightAnalysis> quickSightAnalyses;
        @Generated
        private ArrayList<IQuickSightDashboard> quickSightDashboards;
        @Generated
        private ArrayList<IQuickSightDataset> quickSightDatasets;
        @Generated
        private ArrayList<Map<String, String>> quickSightFolderHierarchy;
        @Generated
        private QuickSightFolderType quickSightFolderType;
        @Generated
        private String quickSightId;
        @Generated
        private String quickSightSheetId;
        @Generated
        private String quickSightSheetName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            QuickSightFolderBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(QuickSightFolder instance, QuickSightFolderBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.quickSightAnalyses(instance.quickSightAnalyses == null ? Collections.emptySortedSet() : instance.quickSightAnalyses);
            b.quickSightDashboards(instance.quickSightDashboards == null ? Collections.emptySortedSet() : instance.quickSightDashboards);
            b.quickSightDatasets(instance.quickSightDatasets == null ? Collections.emptySortedSet() : instance.quickSightDatasets);
            b.quickSightFolderHierarchy(instance.quickSightFolderHierarchy == null ? Collections.emptyList() : instance.quickSightFolderHierarchy);
            b.quickSightFolderType(instance.quickSightFolderType);
            b.quickSightId(instance.quickSightId);
            b.quickSightSheetId(instance.quickSightSheetId);
            b.quickSightSheetName(instance.quickSightSheetName);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B quickSightAnalysis(IQuickSightAnalysis quickSightAnalysis) {
            if (this.quickSightAnalyses == null) {
                this.quickSightAnalyses = new ArrayList();
            }
            this.quickSightAnalyses.add(quickSightAnalysis);
            return (B)this.self();
        }

        @Generated
        public B quickSightAnalyses(Collection<? extends IQuickSightAnalysis> quickSightAnalyses) {
            if (quickSightAnalyses == null) {
                throw new NullPointerException("quickSightAnalyses cannot be null");
            }
            if (this.quickSightAnalyses == null) {
                this.quickSightAnalyses = new ArrayList();
            }
            this.quickSightAnalyses.addAll(quickSightAnalyses);
            return (B)this.self();
        }

        @Generated
        public B clearQuickSightAnalyses() {
            if (this.quickSightAnalyses != null) {
                this.quickSightAnalyses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B quickSightDashboard(IQuickSightDashboard quickSightDashboard) {
            if (this.quickSightDashboards == null) {
                this.quickSightDashboards = new ArrayList();
            }
            this.quickSightDashboards.add(quickSightDashboard);
            return (B)this.self();
        }

        @Generated
        public B quickSightDashboards(Collection<? extends IQuickSightDashboard> quickSightDashboards) {
            if (quickSightDashboards == null) {
                throw new NullPointerException("quickSightDashboards cannot be null");
            }
            if (this.quickSightDashboards == null) {
                this.quickSightDashboards = new ArrayList();
            }
            this.quickSightDashboards.addAll(quickSightDashboards);
            return (B)this.self();
        }

        @Generated
        public B clearQuickSightDashboards() {
            if (this.quickSightDashboards != null) {
                this.quickSightDashboards.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B quickSightDataset(IQuickSightDataset quickSightDataset) {
            if (this.quickSightDatasets == null) {
                this.quickSightDatasets = new ArrayList();
            }
            this.quickSightDatasets.add(quickSightDataset);
            return (B)this.self();
        }

        @Generated
        public B quickSightDatasets(Collection<? extends IQuickSightDataset> quickSightDatasets) {
            if (quickSightDatasets == null) {
                throw new NullPointerException("quickSightDatasets cannot be null");
            }
            if (this.quickSightDatasets == null) {
                this.quickSightDatasets = new ArrayList();
            }
            this.quickSightDatasets.addAll(quickSightDatasets);
            return (B)this.self();
        }

        @Generated
        public B clearQuickSightDatasets() {
            if (this.quickSightDatasets != null) {
                this.quickSightDatasets.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B addQuickSightFolderHierarchy(Map<String, String> addQuickSightFolderHierarchy) {
            if (this.quickSightFolderHierarchy == null) {
                this.quickSightFolderHierarchy = new ArrayList();
            }
            this.quickSightFolderHierarchy.add(addQuickSightFolderHierarchy);
            return (B)this.self();
        }

        @Generated
        public B quickSightFolderHierarchy(Collection<? extends Map<String, String>> quickSightFolderHierarchy) {
            if (quickSightFolderHierarchy == null) {
                throw new NullPointerException("quickSightFolderHierarchy cannot be null");
            }
            if (this.quickSightFolderHierarchy == null) {
                this.quickSightFolderHierarchy = new ArrayList();
            }
            this.quickSightFolderHierarchy.addAll(quickSightFolderHierarchy);
            return (B)this.self();
        }

        @Generated
        public B clearQuickSightFolderHierarchy() {
            if (this.quickSightFolderHierarchy != null) {
                this.quickSightFolderHierarchy.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B quickSightFolderType(QuickSightFolderType quickSightFolderType) {
            this.quickSightFolderType = quickSightFolderType;
            return (B)this.self();
        }

        @Generated
        public B quickSightId(String quickSightId) {
            this.quickSightId = quickSightId;
            return (B)this.self();
        }

        @Generated
        public B quickSightSheetId(String quickSightSheetId) {
            this.quickSightSheetId = quickSightSheetId;
            return (B)this.self();
        }

        @Generated
        public B quickSightSheetName(String quickSightSheetName) {
            this.quickSightSheetName = quickSightSheetName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "QuickSightFolder.QuickSightFolderBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", quickSightAnalyses=" + this.quickSightAnalyses + ", quickSightDashboards=" + this.quickSightDashboards + ", quickSightDatasets=" + this.quickSightDatasets + ", quickSightFolderHierarchy=" + this.quickSightFolderHierarchy + ", quickSightFolderType=" + this.quickSightFolderType + ", quickSightId=" + this.quickSightId + ", quickSightSheetId=" + this.quickSightSheetId + ", quickSightSheetName=" + this.quickSightSheetName + ")";
        }
    }

    @Generated
    private static final class QuickSightFolderBuilderImpl
    extends QuickSightFolderBuilder<QuickSightFolder, QuickSightFolderBuilderImpl> {
        @Generated
        private QuickSightFolderBuilderImpl() {
        }

        @Override
        @Generated
        protected QuickSightFolderBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public QuickSightFolder build() {
            return new QuickSightFolder(this);
        }
    }
}

