/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IReadme;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.IResource;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Readme
extends Asset
implements IReadme,
IResource,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Readme.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Readme";
    String typeName;
    @Attribute
    IAsset asset;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    Boolean isGlobal;
    @Attribute
    String link;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    String reference;
    @Attribute
    Map<String, String> resourceMetadata;
    @Attribute
    SortedSet<IReadme> seeAlso;

    @Override
    public Readme trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return Readme.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return Readme.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return Readme.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return Readme.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return Readme.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return Readme.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static Readme refByGuid(String guid) {
        return Readme.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static Readme refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((ReadmeBuilder)((ReadmeBuilder)Readme._internal().guid(guid)).semantic(semantic)).build();
    }

    public static Readme refByQualifiedName(String qualifiedName) {
        return Readme.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static Readme refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((ReadmeBuilder)((ReadmeBuilder)Readme._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static Readme get(String id) throws AtlanException {
        return Readme.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static Readme get(AtlanClient client, String id) throws AtlanException {
        return Readme.get(client, id, true);
    }

    @JsonIgnore
    public static Readme get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof Readme) {
                return (Readme)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof Readme) {
            return (Readme)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Readme.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static ReadmeBuilder<?, ?> creator(Asset asset, String content) throws InvalidRequestException {
        Readme.validateRelationship(asset.getTypeName(), Map.of("guid", asset.getGuid(), "name", asset.getName()));
        return Readme.creator(asset.trimToReference(), asset.getName(), content);
    }

    public static ReadmeBuilder<?, ?> creator(Asset reference, String assetName, String content) {
        return ((ReadmeBuilder)((ReadmeBuilder)((ReadmeBuilder)((ReadmeBuilder)Readme._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(Readme.generateQualifiedName(reference.getGuid()))).name(Readme.generateName(assetName))).description(content)).asset(reference);
    }

    public static ReadmeBuilder<?, ?> updater(String assetGuid, String assetName) {
        return (ReadmeBuilder)((ReadmeBuilder)((ReadmeBuilder)Readme._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(Readme.generateQualifiedName(assetGuid))).name(Readme.generateName(assetName));
    }

    public ReadmeBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        Readme.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return Readme.updater(this.getQualifiedName(), this.getName());
    }

    private static String generateQualifiedName(String assetGuid) {
        return assetGuid + "/readme";
    }

    private static String generateName(String assetName) {
        return assetName + " Readme";
    }

    public static Readme removeDescription(String qualifiedName, String name) throws AtlanException {
        return Readme.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static Readme removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Readme)Asset.removeDescription(client, Readme.updater(qualifiedName, name));
    }

    public static Readme removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return Readme.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static Readme removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Readme)Asset.removeUserDescription(client, Readme.updater(qualifiedName, name));
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected Readme(ReadmeBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> resourceMetadata;
        this.typeName = b.typeName$set ? b.typeName$value : Readme.$default$typeName();
        this.asset = b.asset;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.isGlobal = b.isGlobal;
        this.link = b.link;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.reference = b.reference;
        switch (b.resourceMetadata$key == null ? 0 : b.resourceMetadata$key.size()) {
            case 0: {
                resourceMetadata = Collections.emptyMap();
                break;
            }
            case 1: {
                resourceMetadata = Collections.singletonMap(b.resourceMetadata$key.get(0), b.resourceMetadata$value.get(0));
                break;
            }
            default: {
                resourceMetadata = new LinkedHashMap(b.resourceMetadata$key.size() < 0x40000000 ? 1 + b.resourceMetadata$key.size() + (b.resourceMetadata$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.resourceMetadata$key.size(); ++$i) {
                    resourceMetadata.put(b.resourceMetadata$key.get($i), b.resourceMetadata$value.get($i));
                }
                resourceMetadata = Collections.unmodifiableMap(resourceMetadata);
            }
        }
        this.resourceMetadata = resourceMetadata;
        SortedSet<IReadme> seeAlso = new TreeSet<IReadme>();
        if (b.seeAlso != null) {
            seeAlso.addAll(b.seeAlso);
        }
        seeAlso = Collections.unmodifiableSortedSet(seeAlso);
        this.seeAlso = seeAlso;
    }

    @Generated
    public static ReadmeBuilder<?, ?> _internal() {
        return new ReadmeBuilderImpl();
    }

    @Generated
    public ReadmeBuilder<?, ?> toBuilder() {
        return new ReadmeBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public IAsset getAsset() {
        return this.asset;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public Boolean getIsGlobal() {
        return this.isGlobal;
    }

    @Override
    @Generated
    public String getLink() {
        return this.link;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public String getReference() {
        return this.reference;
    }

    @Override
    @Generated
    public Map<String, String> getResourceMetadata() {
        return this.resourceMetadata;
    }

    @Override
    @Generated
    public SortedSet<IReadme> getSeeAlso() {
        return this.seeAlso;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Readme)) {
            return false;
        }
        Readme other = (Readme)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isGlobal = this.getIsGlobal();
        Boolean other$isGlobal = other.getIsGlobal();
        if (this$isGlobal == null ? other$isGlobal != null : !((Object)this$isGlobal).equals(other$isGlobal)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        IAsset this$asset = this.getAsset();
        IAsset other$asset = other.getAsset();
        if (this$asset == null ? other$asset != null : !this$asset.equals(other$asset)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        String this$link = this.getLink();
        String other$link = other.getLink();
        if (this$link == null ? other$link != null : !this$link.equals(other$link)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        String this$reference = this.getReference();
        String other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
            return false;
        }
        Map<String, String> this$resourceMetadata = this.getResourceMetadata();
        Map<String, String> other$resourceMetadata = other.getResourceMetadata();
        if (this$resourceMetadata == null ? other$resourceMetadata != null : !((Object)this$resourceMetadata).equals(other$resourceMetadata)) {
            return false;
        }
        SortedSet<IReadme> this$seeAlso = this.getSeeAlso();
        SortedSet<IReadme> other$seeAlso = other.getSeeAlso();
        return !(this$seeAlso == null ? other$seeAlso != null : !this$seeAlso.equals(other$seeAlso));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Readme;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isGlobal = this.getIsGlobal();
        result = result * 59 + ($isGlobal == null ? 43 : ((Object)$isGlobal).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        IAsset $asset = this.getAsset();
        result = result * 59 + ($asset == null ? 43 : $asset.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        String $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : $link.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        String $reference = this.getReference();
        result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
        Map<String, String> $resourceMetadata = this.getResourceMetadata();
        result = result * 59 + ($resourceMetadata == null ? 43 : ((Object)$resourceMetadata).hashCode());
        SortedSet<IReadme> $seeAlso = this.getSeeAlso();
        result = result * 59 + ($seeAlso == null ? 43 : $seeAlso.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Readme(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", asset=" + this.getAsset() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", isGlobal=" + this.getIsGlobal() + ", link=" + this.getLink() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", reference=" + this.getReference() + ", resourceMetadata=" + this.getResourceMetadata() + ", seeAlso=" + this.getSeeAlso() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class ReadmeBuilder<C extends Readme, B extends ReadmeBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private IAsset asset;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private Boolean isGlobal;
        @Generated
        private String link;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private String reference;
        @Generated
        private ArrayList<String> resourceMetadata$key;
        @Generated
        private ArrayList<String> resourceMetadata$value;
        @Generated
        private ArrayList<IReadme> seeAlso;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ReadmeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Readme instance, ReadmeBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.asset(instance.asset);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.isGlobal(instance.isGlobal);
            b.link(instance.link);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.reference(instance.reference);
            b.resourceMetadata(instance.resourceMetadata == null ? Collections.emptyMap() : instance.resourceMetadata);
            b.seeAlso(instance.seeAlso == null ? Collections.emptySortedSet() : instance.seeAlso);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B asset(IAsset asset) {
            this.asset = asset;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B isGlobal(Boolean isGlobal) {
            this.isGlobal = isGlobal;
            return (B)this.self();
        }

        @Generated
        public B link(String link) {
            this.link = link;
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B reference(String reference) {
            this.reference = reference;
            return (B)this.self();
        }

        @Generated
        public B putResourceMetadata(String putResourceMetadataKey, String putResourceMetadataValue) {
            if (this.resourceMetadata$key == null) {
                this.resourceMetadata$key = new ArrayList();
                this.resourceMetadata$value = new ArrayList();
            }
            this.resourceMetadata$key.add(putResourceMetadataKey);
            this.resourceMetadata$value.add(putResourceMetadataValue);
            return (B)this.self();
        }

        @Generated
        public B resourceMetadata(Map<? extends String, ? extends String> resourceMetadata) {
            if (resourceMetadata == null) {
                throw new NullPointerException("resourceMetadata cannot be null");
            }
            if (this.resourceMetadata$key == null) {
                this.resourceMetadata$key = new ArrayList();
                this.resourceMetadata$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : resourceMetadata.entrySet()) {
                this.resourceMetadata$key.add($lombokEntry.getKey());
                this.resourceMetadata$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearResourceMetadata() {
            if (this.resourceMetadata$key != null) {
                this.resourceMetadata$key.clear();
                this.resourceMetadata$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B seeAlsoOne(IReadme seeAlsoOne) {
            if (this.seeAlso == null) {
                this.seeAlso = new ArrayList();
            }
            this.seeAlso.add(seeAlsoOne);
            return (B)this.self();
        }

        @Generated
        public B seeAlso(Collection<? extends IReadme> seeAlso) {
            if (seeAlso == null) {
                throw new NullPointerException("seeAlso cannot be null");
            }
            if (this.seeAlso == null) {
                this.seeAlso = new ArrayList();
            }
            this.seeAlso.addAll(seeAlso);
            return (B)this.self();
        }

        @Generated
        public B clearSeeAlso() {
            if (this.seeAlso != null) {
                this.seeAlso.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Readme.ReadmeBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", asset=" + this.asset + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", isGlobal=" + this.isGlobal + ", link=" + this.link + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", reference=" + this.reference + ", resourceMetadata$key=" + this.resourceMetadata$key + ", resourceMetadata$value=" + this.resourceMetadata$value + ", seeAlso=" + this.seeAlso + ")";
        }
    }

    @Generated
    private static final class ReadmeBuilderImpl
    extends ReadmeBuilder<Readme, ReadmeBuilderImpl> {
        @Generated
        private ReadmeBuilderImpl() {
        }

        @Override
        @Generated
        protected ReadmeBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Readme build() {
            return new Readme(this);
        }
    }
}

