/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISisense;
import com.atlan.model.assets.ISisenseDashboard;
import com.atlan.model.assets.ISisenseDatamodel;
import com.atlan.model.assets.ISisenseFolder;
import com.atlan.model.assets.ISisenseWidget;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SisenseDashboard
extends Asset
implements ISisenseDashboard,
ISisense,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SisenseDashboard.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SisenseDashboard";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    String sisenseDashboardFolderQualifiedName;
    @Attribute
    Long sisenseDashboardWidgetCount;
    @Attribute
    SortedSet<ISisenseDatamodel> sisenseDatamodels;
    @Attribute
    ISisenseFolder sisenseFolder;
    @Attribute
    SortedSet<ISisenseWidget> sisenseWidgets;

    @Override
    public SisenseDashboard trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return SisenseDashboard.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return SisenseDashboard.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return SisenseDashboard.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return SisenseDashboard.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return SisenseDashboard.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return SisenseDashboard.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static SisenseDashboard refByGuid(String guid) {
        return SisenseDashboard.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static SisenseDashboard refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((SisenseDashboardBuilder)((SisenseDashboardBuilder)SisenseDashboard._internal().guid(guid)).semantic(semantic)).build();
    }

    public static SisenseDashboard refByQualifiedName(String qualifiedName) {
        return SisenseDashboard.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static SisenseDashboard refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((SisenseDashboardBuilder)((SisenseDashboardBuilder)SisenseDashboard._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static SisenseDashboard get(String id) throws AtlanException {
        return SisenseDashboard.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static SisenseDashboard get(AtlanClient client, String id) throws AtlanException {
        return SisenseDashboard.get(client, id, true);
    }

    @JsonIgnore
    public static SisenseDashboard get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof SisenseDashboard) {
                return (SisenseDashboard)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof SisenseDashboard) {
            return (SisenseDashboard)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return SisenseDashboard.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static SisenseDashboardBuilder<?, ?> updater(String qualifiedName, String name) {
        return (SisenseDashboardBuilder)((SisenseDashboardBuilder)((SisenseDashboardBuilder)SisenseDashboard._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public SisenseDashboardBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        SisenseDashboard.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return SisenseDashboard.updater(this.getQualifiedName(), this.getName());
    }

    public static SisenseDashboard removeDescription(String qualifiedName, String name) throws AtlanException {
        return SisenseDashboard.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SisenseDashboard removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseDashboard)Asset.removeDescription(client, SisenseDashboard.updater(qualifiedName, name));
    }

    public static SisenseDashboard removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return SisenseDashboard.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SisenseDashboard removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseDashboard)Asset.removeUserDescription(client, SisenseDashboard.updater(qualifiedName, name));
    }

    public static SisenseDashboard removeOwners(String qualifiedName, String name) throws AtlanException {
        return SisenseDashboard.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SisenseDashboard removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseDashboard)Asset.removeOwners(client, SisenseDashboard.updater(qualifiedName, name));
    }

    public static SisenseDashboard updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return SisenseDashboard.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static SisenseDashboard updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (SisenseDashboard)Asset.updateCertificate(client, SisenseDashboard._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static SisenseDashboard removeCertificate(String qualifiedName, String name) throws AtlanException {
        return SisenseDashboard.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SisenseDashboard removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseDashboard)Asset.removeCertificate(client, SisenseDashboard.updater(qualifiedName, name));
    }

    public static SisenseDashboard updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return SisenseDashboard.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static SisenseDashboard updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SisenseDashboard)Asset.updateAnnouncement(client, SisenseDashboard._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static SisenseDashboard removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return SisenseDashboard.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SisenseDashboard removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseDashboard)Asset.removeAnnouncement(client, SisenseDashboard.updater(qualifiedName, name));
    }

    public static SisenseDashboard replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return SisenseDashboard.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static SisenseDashboard replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (SisenseDashboard)Asset.replaceTerms(client, SisenseDashboard.updater(qualifiedName, name), terms);
    }

    public static SisenseDashboard appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return SisenseDashboard.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static SisenseDashboard appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SisenseDashboard)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static SisenseDashboard removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return SisenseDashboard.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static SisenseDashboard removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SisenseDashboard)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static SisenseDashboard appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return SisenseDashboard.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static SisenseDashboard appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (SisenseDashboard)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static SisenseDashboard appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return SisenseDashboard.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static SisenseDashboard appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (SisenseDashboard)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        SisenseDashboard.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected SisenseDashboard(SisenseDashboardBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : SisenseDashboard.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.sisenseDashboardFolderQualifiedName = b.sisenseDashboardFolderQualifiedName;
        this.sisenseDashboardWidgetCount = b.sisenseDashboardWidgetCount;
        SortedSet<ISisenseDatamodel> sisenseDatamodels = new TreeSet<ISisenseDatamodel>();
        if (b.sisenseDatamodels != null) {
            sisenseDatamodels.addAll(b.sisenseDatamodels);
        }
        sisenseDatamodels = Collections.unmodifiableSortedSet(sisenseDatamodels);
        this.sisenseDatamodels = sisenseDatamodels;
        this.sisenseFolder = b.sisenseFolder;
        SortedSet<ISisenseWidget> sisenseWidgets = new TreeSet<ISisenseWidget>();
        if (b.sisenseWidgets != null) {
            sisenseWidgets.addAll(b.sisenseWidgets);
        }
        sisenseWidgets = Collections.unmodifiableSortedSet(sisenseWidgets);
        this.sisenseWidgets = sisenseWidgets;
    }

    @Generated
    public static SisenseDashboardBuilder<?, ?> _internal() {
        return new SisenseDashboardBuilderImpl();
    }

    @Generated
    public SisenseDashboardBuilder<?, ?> toBuilder() {
        return new SisenseDashboardBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public String getSisenseDashboardFolderQualifiedName() {
        return this.sisenseDashboardFolderQualifiedName;
    }

    @Override
    @Generated
    public Long getSisenseDashboardWidgetCount() {
        return this.sisenseDashboardWidgetCount;
    }

    @Override
    @Generated
    public SortedSet<ISisenseDatamodel> getSisenseDatamodels() {
        return this.sisenseDatamodels;
    }

    @Override
    @Generated
    public ISisenseFolder getSisenseFolder() {
        return this.sisenseFolder;
    }

    @Override
    @Generated
    public SortedSet<ISisenseWidget> getSisenseWidgets() {
        return this.sisenseWidgets;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SisenseDashboard)) {
            return false;
        }
        SisenseDashboard other = (SisenseDashboard)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$sisenseDashboardWidgetCount = this.getSisenseDashboardWidgetCount();
        Long other$sisenseDashboardWidgetCount = other.getSisenseDashboardWidgetCount();
        if (this$sisenseDashboardWidgetCount == null ? other$sisenseDashboardWidgetCount != null : !((Object)this$sisenseDashboardWidgetCount).equals(other$sisenseDashboardWidgetCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        String this$sisenseDashboardFolderQualifiedName = this.getSisenseDashboardFolderQualifiedName();
        String other$sisenseDashboardFolderQualifiedName = other.getSisenseDashboardFolderQualifiedName();
        if (this$sisenseDashboardFolderQualifiedName == null ? other$sisenseDashboardFolderQualifiedName != null : !this$sisenseDashboardFolderQualifiedName.equals(other$sisenseDashboardFolderQualifiedName)) {
            return false;
        }
        SortedSet<ISisenseDatamodel> this$sisenseDatamodels = this.getSisenseDatamodels();
        SortedSet<ISisenseDatamodel> other$sisenseDatamodels = other.getSisenseDatamodels();
        if (this$sisenseDatamodels == null ? other$sisenseDatamodels != null : !this$sisenseDatamodels.equals(other$sisenseDatamodels)) {
            return false;
        }
        ISisenseFolder this$sisenseFolder = this.getSisenseFolder();
        ISisenseFolder other$sisenseFolder = other.getSisenseFolder();
        if (this$sisenseFolder == null ? other$sisenseFolder != null : !this$sisenseFolder.equals(other$sisenseFolder)) {
            return false;
        }
        SortedSet<ISisenseWidget> this$sisenseWidgets = this.getSisenseWidgets();
        SortedSet<ISisenseWidget> other$sisenseWidgets = other.getSisenseWidgets();
        return !(this$sisenseWidgets == null ? other$sisenseWidgets != null : !this$sisenseWidgets.equals(other$sisenseWidgets));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SisenseDashboard;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $sisenseDashboardWidgetCount = this.getSisenseDashboardWidgetCount();
        result = result * 59 + ($sisenseDashboardWidgetCount == null ? 43 : ((Object)$sisenseDashboardWidgetCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        String $sisenseDashboardFolderQualifiedName = this.getSisenseDashboardFolderQualifiedName();
        result = result * 59 + ($sisenseDashboardFolderQualifiedName == null ? 43 : $sisenseDashboardFolderQualifiedName.hashCode());
        SortedSet<ISisenseDatamodel> $sisenseDatamodels = this.getSisenseDatamodels();
        result = result * 59 + ($sisenseDatamodels == null ? 43 : $sisenseDatamodels.hashCode());
        ISisenseFolder $sisenseFolder = this.getSisenseFolder();
        result = result * 59 + ($sisenseFolder == null ? 43 : $sisenseFolder.hashCode());
        SortedSet<ISisenseWidget> $sisenseWidgets = this.getSisenseWidgets();
        result = result * 59 + ($sisenseWidgets == null ? 43 : $sisenseWidgets.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SisenseDashboard(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", sisenseDashboardFolderQualifiedName=" + this.getSisenseDashboardFolderQualifiedName() + ", sisenseDashboardWidgetCount=" + this.getSisenseDashboardWidgetCount() + ", sisenseDatamodels=" + this.getSisenseDatamodels() + ", sisenseFolder=" + this.getSisenseFolder() + ", sisenseWidgets=" + this.getSisenseWidgets() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class SisenseDashboardBuilder<C extends SisenseDashboard, B extends SisenseDashboardBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private String sisenseDashboardFolderQualifiedName;
        @Generated
        private Long sisenseDashboardWidgetCount;
        @Generated
        private ArrayList<ISisenseDatamodel> sisenseDatamodels;
        @Generated
        private ISisenseFolder sisenseFolder;
        @Generated
        private ArrayList<ISisenseWidget> sisenseWidgets;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SisenseDashboardBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SisenseDashboard instance, SisenseDashboardBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.sisenseDashboardFolderQualifiedName(instance.sisenseDashboardFolderQualifiedName);
            b.sisenseDashboardWidgetCount(instance.sisenseDashboardWidgetCount);
            b.sisenseDatamodels(instance.sisenseDatamodels == null ? Collections.emptySortedSet() : instance.sisenseDatamodels);
            b.sisenseFolder(instance.sisenseFolder);
            b.sisenseWidgets(instance.sisenseWidgets == null ? Collections.emptySortedSet() : instance.sisenseWidgets);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sisenseDashboardFolderQualifiedName(String sisenseDashboardFolderQualifiedName) {
            this.sisenseDashboardFolderQualifiedName = sisenseDashboardFolderQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B sisenseDashboardWidgetCount(Long sisenseDashboardWidgetCount) {
            this.sisenseDashboardWidgetCount = sisenseDashboardWidgetCount;
            return (B)this.self();
        }

        @Generated
        public B sisenseDatamodel(ISisenseDatamodel sisenseDatamodel) {
            if (this.sisenseDatamodels == null) {
                this.sisenseDatamodels = new ArrayList();
            }
            this.sisenseDatamodels.add(sisenseDatamodel);
            return (B)this.self();
        }

        @Generated
        public B sisenseDatamodels(Collection<? extends ISisenseDatamodel> sisenseDatamodels) {
            if (sisenseDatamodels == null) {
                throw new NullPointerException("sisenseDatamodels cannot be null");
            }
            if (this.sisenseDatamodels == null) {
                this.sisenseDatamodels = new ArrayList();
            }
            this.sisenseDatamodels.addAll(sisenseDatamodels);
            return (B)this.self();
        }

        @Generated
        public B clearSisenseDatamodels() {
            if (this.sisenseDatamodels != null) {
                this.sisenseDatamodels.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sisenseFolder(ISisenseFolder sisenseFolder) {
            this.sisenseFolder = sisenseFolder;
            return (B)this.self();
        }

        @Generated
        public B sisenseWidget(ISisenseWidget sisenseWidget) {
            if (this.sisenseWidgets == null) {
                this.sisenseWidgets = new ArrayList();
            }
            this.sisenseWidgets.add(sisenseWidget);
            return (B)this.self();
        }

        @Generated
        public B sisenseWidgets(Collection<? extends ISisenseWidget> sisenseWidgets) {
            if (sisenseWidgets == null) {
                throw new NullPointerException("sisenseWidgets cannot be null");
            }
            if (this.sisenseWidgets == null) {
                this.sisenseWidgets = new ArrayList();
            }
            this.sisenseWidgets.addAll(sisenseWidgets);
            return (B)this.self();
        }

        @Generated
        public B clearSisenseWidgets() {
            if (this.sisenseWidgets != null) {
                this.sisenseWidgets.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SisenseDashboard.SisenseDashboardBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", sisenseDashboardFolderQualifiedName=" + this.sisenseDashboardFolderQualifiedName + ", sisenseDashboardWidgetCount=" + this.sisenseDashboardWidgetCount + ", sisenseDatamodels=" + this.sisenseDatamodels + ", sisenseFolder=" + this.sisenseFolder + ", sisenseWidgets=" + this.sisenseWidgets + ")";
        }
    }

    @Generated
    private static final class SisenseDashboardBuilderImpl
    extends SisenseDashboardBuilder<SisenseDashboard, SisenseDashboardBuilderImpl> {
        @Generated
        private SisenseDashboardBuilderImpl() {
        }

        @Override
        @Generated
        protected SisenseDashboardBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SisenseDashboard build() {
            return new SisenseDashboard(this);
        }
    }
}

