/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.lineage;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.assets.Asset;
import com.atlan.model.enums.AtlanLineageDirection;
import com.atlan.model.enums.AtlanStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.fields.CustomMetadataField;
import com.atlan.model.fields.IInternalSearchable;
import com.atlan.model.fields.SearchableField;
import com.atlan.model.lineage.EntityFilter;
import com.atlan.model.lineage.FilterList;
import com.atlan.model.lineage.LineageFilter;
import com.atlan.model.lineage.LineageListRequest;
import com.atlan.model.relations.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class FluentLineage {
    public static final LineageFilter ACTIVE = Asset.STATUS.inLineage.eq(AtlanStatus.ACTIVE);
    AtlanClient client;
    String startingGuid;
    AtlanLineageDirection direction;
    Integer pageSize;
    Integer depth;
    List<LineageFilter> whereAssets;
    FilterList.Condition assetsCondition;
    List<LineageFilter> whereRelationships;
    FilterList.Condition relationshipsCondition;
    List<LineageFilter> includesInResults;
    FilterList.Condition includesCondition;
    List<AtlanField> includesOnResults;
    List<String> _includesOnResults;
    List<AtlanField> includesOnRelations;
    List<String> _includesOnRelations;

    public static FluentLineageBuilder builder(AtlanClient client, Reference startingFrom) {
        return FluentLineage.builder(client, startingFrom.getGuid());
    }

    public static FluentLineageBuilder builder(AtlanClient client, String startingGuid) {
        return FluentLineage._internal().client(client).startingGuid(startingGuid);
    }

    protected LineageListRequest.LineageListRequestBuilder<?, ?> _requestBuilder() {
        String attrName;
        Object entities;
        Object request = LineageListRequest.builder(this.startingGuid).direction(this.direction);
        if (this.pageSize != null) {
            ((LineageListRequest.LineageListRequestBuilder)request).size(this.pageSize);
        }
        if (this.depth != null) {
            ((LineageListRequest.LineageListRequestBuilder)request).depth(this.depth);
        }
        if (this.whereAssets != null) {
            entities = FilterList.builder().condition(this.assetsCondition);
            for (LineageFilter asset : this.whereAssets) {
                attrName = this.getInternalAtlanName(asset.getField());
                ((FilterList.FilterListBuilder)entities).criterion((EntityFilter)((EntityFilter.EntityFilterBuilder)((EntityFilter.EntityFilterBuilder)((EntityFilter.EntityFilterBuilder)EntityFilter.builder().attributeName(attrName)).operator(asset.getOperator())).attributeValue(asset.getValue())).build());
            }
            ((LineageListRequest.LineageListRequestBuilder)request).entityTraversalFilters((FilterList)((FilterList.FilterListBuilder)entities).build());
        }
        if (this.whereRelationships != null) {
            Object relationships = FilterList.builder().condition(this.relationshipsCondition);
            for (LineageFilter relationship : this.whereRelationships) {
                attrName = this.getInternalAtlanName(relationship.getField());
                ((FilterList.FilterListBuilder)relationships).criterion((EntityFilter)((EntityFilter.EntityFilterBuilder)((EntityFilter.EntityFilterBuilder)((EntityFilter.EntityFilterBuilder)EntityFilter.builder().attributeName(attrName)).operator(relationship.getOperator())).attributeValue(relationship.getValue())).build());
            }
            ((LineageListRequest.LineageListRequestBuilder)request).relationshipTraversalFilters((FilterList)((FilterList.FilterListBuilder)relationships).build());
        }
        if (this.includesInResults != null) {
            entities = FilterList.builder().condition(this.includesCondition);
            for (LineageFilter asset : this.includesInResults) {
                attrName = this.getInternalAtlanName(asset.getField());
                ((FilterList.FilterListBuilder)entities).criterion((EntityFilter)((EntityFilter.EntityFilterBuilder)((EntityFilter.EntityFilterBuilder)((EntityFilter.EntityFilterBuilder)EntityFilter.builder().attributeName(attrName)).operator(asset.getOperator())).attributeValue(asset.getValue())).build());
            }
            ((LineageListRequest.LineageListRequestBuilder)request).entityFilters((FilterList)((FilterList.FilterListBuilder)entities).build());
        }
        if (this._includesOnResults != null) {
            ((LineageListRequest.LineageListRequestBuilder)request).attributes(this._includesOnResults);
        }
        if (this.includesOnResults != null) {
            ((LineageListRequest.LineageListRequestBuilder)request).attributes(this.includesOnResults.stream().map(AtlanField::getAtlanFieldName).collect(Collectors.toList()));
        }
        if (this._includesOnRelations != null) {
            ((LineageListRequest.LineageListRequestBuilder)request).relationAttributes(this._includesOnRelations);
        }
        if (this.includesOnRelations != null) {
            ((LineageListRequest.LineageListRequestBuilder)request).relationAttributes(this.includesOnRelations.stream().map(AtlanField::getAtlanFieldName).collect(Collectors.toList()));
        }
        return request;
    }

    private String getInternalAtlanName(SearchableField candidate) {
        String attrName = "";
        if (candidate instanceof IInternalSearchable) {
            attrName = ((IInternalSearchable)((Object)candidate)).getInternalFieldName();
        } else if (candidate != null && !(candidate instanceof CustomMetadataField)) {
            attrName = candidate.getAtlanFieldName();
        }
        return attrName;
    }

    @Generated
    private static AtlanLineageDirection $default$direction() {
        return AtlanLineageDirection.DOWNSTREAM;
    }

    @Generated
    private static Integer $default$pageSize() {
        return 1000;
    }

    @Generated
    private static FilterList.Condition $default$assetsCondition() {
        return FilterList.Condition.AND;
    }

    @Generated
    private static FilterList.Condition $default$relationshipsCondition() {
        return FilterList.Condition.AND;
    }

    @Generated
    private static FilterList.Condition $default$includesCondition() {
        return FilterList.Condition.AND;
    }

    @Generated
    FluentLineage(AtlanClient client, String startingGuid, AtlanLineageDirection direction, Integer pageSize, Integer depth, List<LineageFilter> whereAssets, FilterList.Condition assetsCondition, List<LineageFilter> whereRelationships, FilterList.Condition relationshipsCondition, List<LineageFilter> includesInResults, FilterList.Condition includesCondition, List<AtlanField> includesOnResults, List<String> _includesOnResults, List<AtlanField> includesOnRelations, List<String> _includesOnRelations) {
        this.client = client;
        this.startingGuid = startingGuid;
        this.direction = direction;
        this.pageSize = pageSize;
        this.depth = depth;
        this.whereAssets = whereAssets;
        this.assetsCondition = assetsCondition;
        this.whereRelationships = whereRelationships;
        this.relationshipsCondition = relationshipsCondition;
        this.includesInResults = includesInResults;
        this.includesCondition = includesCondition;
        this.includesOnResults = includesOnResults;
        this._includesOnResults = _includesOnResults;
        this.includesOnRelations = includesOnRelations;
        this._includesOnRelations = _includesOnRelations;
    }

    @Generated
    public static FluentLineageBuilder _internal() {
        return new FluentLineageBuilder();
    }

    public static class FluentLineageBuilder {
        @Generated
        private AtlanClient client;
        @Generated
        private String startingGuid;
        @Generated
        private boolean direction$set;
        @Generated
        private AtlanLineageDirection direction$value;
        @Generated
        private boolean pageSize$set;
        @Generated
        private Integer pageSize$value;
        @Generated
        private Integer depth;
        @Generated
        private ArrayList<LineageFilter> whereAssets;
        @Generated
        private boolean assetsCondition$set;
        @Generated
        private FilterList.Condition assetsCondition$value;
        @Generated
        private ArrayList<LineageFilter> whereRelationships;
        @Generated
        private boolean relationshipsCondition$set;
        @Generated
        private FilterList.Condition relationshipsCondition$value;
        @Generated
        private ArrayList<LineageFilter> includesInResults;
        @Generated
        private boolean includesCondition$set;
        @Generated
        private FilterList.Condition includesCondition$value;
        @Generated
        private ArrayList<AtlanField> includesOnResults;
        @Generated
        private ArrayList<String> _includesOnResults;
        @Generated
        private ArrayList<AtlanField> includesOnRelations;
        @Generated
        private ArrayList<String> _includesOnRelations;

        public LineageListRequest.LineageListRequestBuilder<?, ?> toRequestBuilder() {
            return this.build()._requestBuilder();
        }

        public LineageListRequest toRequest() {
            return this.toRequestBuilder().build();
        }

        public Stream<Asset> stream() throws AtlanException {
            if (this.client == null) {
                throw new InvalidRequestException(ErrorCode.NO_ATLAN_CLIENT);
            }
            LineageListRequest request = this.toRequest();
            return request.fetch(this.client).stream();
        }

        @Generated
        FluentLineageBuilder() {
        }

        @Generated
        public FluentLineageBuilder client(AtlanClient client) {
            this.client = client;
            return this;
        }

        @Generated
        public FluentLineageBuilder startingGuid(String startingGuid) {
            this.startingGuid = startingGuid;
            return this;
        }

        @Generated
        public FluentLineageBuilder direction(AtlanLineageDirection direction) {
            this.direction$value = direction;
            this.direction$set = true;
            return this;
        }

        @Generated
        public FluentLineageBuilder pageSize(Integer pageSize) {
            this.pageSize$value = pageSize;
            this.pageSize$set = true;
            return this;
        }

        @Generated
        public FluentLineageBuilder depth(Integer depth) {
            this.depth = depth;
            return this;
        }

        @Generated
        public FluentLineageBuilder whereAsset(LineageFilter whereAsset) {
            if (this.whereAssets == null) {
                this.whereAssets = new ArrayList();
            }
            this.whereAssets.add(whereAsset);
            return this;
        }

        @Generated
        public FluentLineageBuilder whereAssets(Collection<? extends LineageFilter> whereAssets) {
            if (whereAssets == null) {
                throw new NullPointerException("whereAssets cannot be null");
            }
            if (this.whereAssets == null) {
                this.whereAssets = new ArrayList();
            }
            this.whereAssets.addAll(whereAssets);
            return this;
        }

        @Generated
        public FluentLineageBuilder clearWhereAssets() {
            if (this.whereAssets != null) {
                this.whereAssets.clear();
            }
            return this;
        }

        @Generated
        public FluentLineageBuilder assetsCondition(FilterList.Condition assetsCondition) {
            this.assetsCondition$value = assetsCondition;
            this.assetsCondition$set = true;
            return this;
        }

        @Generated
        public FluentLineageBuilder whereRelationship(LineageFilter whereRelationship) {
            if (this.whereRelationships == null) {
                this.whereRelationships = new ArrayList();
            }
            this.whereRelationships.add(whereRelationship);
            return this;
        }

        @Generated
        public FluentLineageBuilder whereRelationships(Collection<? extends LineageFilter> whereRelationships) {
            if (whereRelationships == null) {
                throw new NullPointerException("whereRelationships cannot be null");
            }
            if (this.whereRelationships == null) {
                this.whereRelationships = new ArrayList();
            }
            this.whereRelationships.addAll(whereRelationships);
            return this;
        }

        @Generated
        public FluentLineageBuilder clearWhereRelationships() {
            if (this.whereRelationships != null) {
                this.whereRelationships.clear();
            }
            return this;
        }

        @Generated
        public FluentLineageBuilder relationshipsCondition(FilterList.Condition relationshipsCondition) {
            this.relationshipsCondition$value = relationshipsCondition;
            this.relationshipsCondition$set = true;
            return this;
        }

        @Generated
        public FluentLineageBuilder includeInResults(LineageFilter includeInResults) {
            if (this.includesInResults == null) {
                this.includesInResults = new ArrayList();
            }
            this.includesInResults.add(includeInResults);
            return this;
        }

        @Generated
        public FluentLineageBuilder includesInResults(Collection<? extends LineageFilter> includesInResults) {
            if (includesInResults == null) {
                throw new NullPointerException("includesInResults cannot be null");
            }
            if (this.includesInResults == null) {
                this.includesInResults = new ArrayList();
            }
            this.includesInResults.addAll(includesInResults);
            return this;
        }

        @Generated
        public FluentLineageBuilder clearIncludesInResults() {
            if (this.includesInResults != null) {
                this.includesInResults.clear();
            }
            return this;
        }

        @Generated
        public FluentLineageBuilder includesCondition(FilterList.Condition includesCondition) {
            this.includesCondition$value = includesCondition;
            this.includesCondition$set = true;
            return this;
        }

        @Generated
        public FluentLineageBuilder includeOnResults(AtlanField includeOnResults) {
            if (this.includesOnResults == null) {
                this.includesOnResults = new ArrayList();
            }
            this.includesOnResults.add(includeOnResults);
            return this;
        }

        @Generated
        public FluentLineageBuilder includesOnResults(Collection<? extends AtlanField> includesOnResults) {
            if (includesOnResults == null) {
                throw new NullPointerException("includesOnResults cannot be null");
            }
            if (this.includesOnResults == null) {
                this.includesOnResults = new ArrayList();
            }
            this.includesOnResults.addAll(includesOnResults);
            return this;
        }

        @Generated
        public FluentLineageBuilder clearIncludesOnResults() {
            if (this.includesOnResults != null) {
                this.includesOnResults.clear();
            }
            return this;
        }

        @Generated
        public FluentLineageBuilder _includeOnResults(String _includeOnResults) {
            if (this._includesOnResults == null) {
                this._includesOnResults = new ArrayList();
            }
            this._includesOnResults.add(_includeOnResults);
            return this;
        }

        @Generated
        public FluentLineageBuilder _includesOnResults(Collection<? extends String> _includesOnResults) {
            if (_includesOnResults == null) {
                throw new NullPointerException("_includesOnResults cannot be null");
            }
            if (this._includesOnResults == null) {
                this._includesOnResults = new ArrayList();
            }
            this._includesOnResults.addAll(_includesOnResults);
            return this;
        }

        @Generated
        public FluentLineageBuilder clear_includesOnResults() {
            if (this._includesOnResults != null) {
                this._includesOnResults.clear();
            }
            return this;
        }

        @Generated
        public FluentLineageBuilder includeOnRelations(AtlanField includeOnRelations) {
            if (this.includesOnRelations == null) {
                this.includesOnRelations = new ArrayList();
            }
            this.includesOnRelations.add(includeOnRelations);
            return this;
        }

        @Generated
        public FluentLineageBuilder includesOnRelations(Collection<? extends AtlanField> includesOnRelations) {
            if (includesOnRelations == null) {
                throw new NullPointerException("includesOnRelations cannot be null");
            }
            if (this.includesOnRelations == null) {
                this.includesOnRelations = new ArrayList();
            }
            this.includesOnRelations.addAll(includesOnRelations);
            return this;
        }

        @Generated
        public FluentLineageBuilder clearIncludesOnRelations() {
            if (this.includesOnRelations != null) {
                this.includesOnRelations.clear();
            }
            return this;
        }

        @Generated
        public FluentLineageBuilder _includeOnRelations(String _includeOnRelations) {
            if (this._includesOnRelations == null) {
                this._includesOnRelations = new ArrayList();
            }
            this._includesOnRelations.add(_includeOnRelations);
            return this;
        }

        @Generated
        public FluentLineageBuilder _includesOnRelations(Collection<? extends String> _includesOnRelations) {
            if (_includesOnRelations == null) {
                throw new NullPointerException("_includesOnRelations cannot be null");
            }
            if (this._includesOnRelations == null) {
                this._includesOnRelations = new ArrayList();
            }
            this._includesOnRelations.addAll(_includesOnRelations);
            return this;
        }

        @Generated
        public FluentLineageBuilder clear_includesOnRelations() {
            if (this._includesOnRelations != null) {
                this._includesOnRelations.clear();
            }
            return this;
        }

        @Generated
        public FluentLineage build() {
            List<LineageFilter> whereAssets = switch (this.whereAssets == null ? 0 : this.whereAssets.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.whereAssets.get(0));
                default -> Collections.unmodifiableList(new ArrayList<LineageFilter>(this.whereAssets));
            };
            List<LineageFilter> whereRelationships = switch (this.whereRelationships == null ? 0 : this.whereRelationships.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.whereRelationships.get(0));
                default -> Collections.unmodifiableList(new ArrayList<LineageFilter>(this.whereRelationships));
            };
            List<LineageFilter> includesInResults = switch (this.includesInResults == null ? 0 : this.includesInResults.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.includesInResults.get(0));
                default -> Collections.unmodifiableList(new ArrayList<LineageFilter>(this.includesInResults));
            };
            List<AtlanField> includesOnResults = switch (this.includesOnResults == null ? 0 : this.includesOnResults.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.includesOnResults.get(0));
                default -> Collections.unmodifiableList(new ArrayList<AtlanField>(this.includesOnResults));
            };
            List<String> _includesOnResults = switch (this._includesOnResults == null ? 0 : this._includesOnResults.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this._includesOnResults.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(this._includesOnResults));
            };
            List<AtlanField> includesOnRelations = switch (this.includesOnRelations == null ? 0 : this.includesOnRelations.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.includesOnRelations.get(0));
                default -> Collections.unmodifiableList(new ArrayList<AtlanField>(this.includesOnRelations));
            };
            List<String> _includesOnRelations = switch (this._includesOnRelations == null ? 0 : this._includesOnRelations.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this._includesOnRelations.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(this._includesOnRelations));
            };
            AtlanLineageDirection direction$value = this.direction$value;
            if (!this.direction$set) {
                direction$value = FluentLineage.$default$direction();
            }
            Integer pageSize$value = this.pageSize$value;
            if (!this.pageSize$set) {
                pageSize$value = FluentLineage.$default$pageSize();
            }
            FilterList.Condition assetsCondition$value = this.assetsCondition$value;
            if (!this.assetsCondition$set) {
                assetsCondition$value = FluentLineage.$default$assetsCondition();
            }
            FilterList.Condition relationshipsCondition$value = this.relationshipsCondition$value;
            if (!this.relationshipsCondition$set) {
                relationshipsCondition$value = FluentLineage.$default$relationshipsCondition();
            }
            FilterList.Condition includesCondition$value = this.includesCondition$value;
            if (!this.includesCondition$set) {
                includesCondition$value = FluentLineage.$default$includesCondition();
            }
            return new FluentLineage(this.client, this.startingGuid, direction$value, pageSize$value, this.depth, whereAssets, assetsCondition$value, whereRelationships, relationshipsCondition$value, includesInResults, includesCondition$value, includesOnResults, _includesOnResults, includesOnRelations, _includesOnRelations);
        }

        @Generated
        public String toString() {
            return "FluentLineage.FluentLineageBuilder(client=" + this.client + ", startingGuid=" + this.startingGuid + ", direction$value=" + this.direction$value + ", pageSize$value=" + this.pageSize$value + ", depth=" + this.depth + ", whereAssets=" + this.whereAssets + ", assetsCondition$value=" + this.assetsCondition$value + ", whereRelationships=" + this.whereRelationships + ", relationshipsCondition$value=" + this.relationshipsCondition$value + ", includesInResults=" + this.includesInResults + ", includesCondition$value=" + this.includesCondition$value + ", includesOnResults=" + this.includesOnResults + ", _includesOnResults=" + this._includesOnResults + ", includesOnRelations=" + this.includesOnRelations + ", _includesOnRelations=" + this._includesOnRelations + ")";
        }
    }
}

