/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.packages;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.admin.Credential;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Connection;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.packages.AbstractPackage;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public abstract class AbstractCrawler
extends AbstractPackage {
    @JsonIgnore
    public static Connection getConnection(AtlanClient client, String connectionName, AtlanConnectorType connectionType, List<String> roles, List<String> groups, List<String> users, boolean allowQuery, boolean allowQueryPreview, long rowLimit, String sourceLogo) throws AtlanException {
        return ((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Asset.AssetBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)((Connection.ConnectionBuilder)Connection.creator(client, connectionName, connectionType, roles, groups, users).allowQuery(allowQuery)).allowQueryPreview(allowQueryPreview)).rowLimit(rowLimit)).defaultCredentialGuid("{{credentialGuid}}")).sourceLogo(sourceLogo)).isDiscoverable(true)).isEditable(false)).build();
    }

    static Map<String, List<String>> buildHierarchicalFilter(Map<String, List<String>> rawFilter) {
        HashMap<String, List<String>> toInclude = new HashMap<String, List<String>>();
        if (rawFilter != null) {
            for (Map.Entry<String, List<String>> entry : rawFilter.entrySet()) {
                String dbName = entry.getKey();
                List<String> schemas = entry.getValue();
                ArrayList<CallSite> exactSchemas = new ArrayList<CallSite>();
                for (String schema : schemas) {
                    exactSchemas.add((CallSite)((Object)("^" + schema + "$")));
                }
                toInclude.put("^" + dbName + "$", exactSchemas);
            }
        }
        return toInclude;
    }

    static Map<String, Map<String, String>> buildFlatFilter(List<String> rawFilter) {
        HashMap<String, Map<String, String>> toInclude = new HashMap<String, Map<String, String>>();
        if (rawFilter != null) {
            for (String entry : rawFilter) {
                toInclude.put(entry, Collections.emptyMap());
            }
        }
        return toInclude;
    }

    static Map<String, Map<String, Map<String, String>>> buildDbtCloudFilter(Map<String, List<String>> rawFilter) {
        HashMap<String, Map<String, Map<String, String>>> toInclude = new HashMap<String, Map<String, Map<String, String>>>();
        if (rawFilter != null) {
            for (Map.Entry<String, List<String>> entry : rawFilter.entrySet()) {
                String accountId = entry.getKey();
                if (!toInclude.containsKey(accountId)) {
                    toInclude.put(accountId, new HashMap());
                }
                List<String> projects = entry.getValue();
                for (String projectId : projects) {
                    ((Map)toInclude.get(accountId)).put(projectId, Collections.emptyMap());
                }
            }
        }
        return toInclude;
    }

    @Generated
    protected AbstractCrawler(AbstractCrawlerBuilder<?, ?> b) {
        super(b);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractCrawler)) {
            return false;
        }
        AbstractCrawler other = (AbstractCrawler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractCrawler;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AbstractCrawler(super=" + super.toString() + ")";
    }

    public static abstract class AbstractCrawlerBuilder<C extends AbstractCrawler, B extends AbstractCrawlerBuilder<C, B>>
    extends AbstractPackage.AbstractPackageBuilder<C, B> {
        protected AtlanClient client;
        protected Connection connection;
        protected final Credential.CredentialBuilder<?, ?> localCreds = Credential.builder();

        B setup(String prefix, String name, AtlanClient client, Connection connection) {
            this.client = client;
            this.connection = connection;
            this.epoch = Connection.getEpochFromQualifiedName(connection.getQualifiedName());
            return (B)((AbstractCrawlerBuilder)((AbstractCrawlerBuilder)((AbstractCrawlerBuilder)((AbstractCrawlerBuilder)this._prefix(prefix))._name(name))._runName(prefix + "-" + this.epoch)).metadata());
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AbstractCrawlerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AbstractCrawler instance, AbstractCrawlerBuilder<?, ?> b) {
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AbstractCrawler.AbstractCrawlerBuilder(super=" + super.toString() + ")";
        }
    }
}

