/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.packages;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.admin.Credential;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.AtlanPackageType;
import com.atlan.model.packages.AbstractCrawler;
import com.atlan.serde.Serde;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class SQLServerCrawler
extends AbstractCrawler {
    public static final String PREFIX = AtlanPackageType.MSSQL.getValue();

    public static SQLServerCrawlerBuilder<?, ?> creator(AtlanClient client, String connectionName) throws AtlanException {
        return SQLServerCrawler.creator(client, connectionName, List.of(client.getRoleCache().getIdForName("$admin")), null, null, true, true, 10000L);
    }

    public static SQLServerCrawlerBuilder<?, ?> creator(AtlanClient client, String connectionName, List<String> adminRoles, List<String> adminGroups, List<String> adminUsers, boolean allowQuery, boolean allowSamples, long rowLimit) throws AtlanException {
        return ((SQLServerCrawlerBuilder)((SQLServerCrawlerBuilder)SQLServerCrawler._internal().setup(PREFIX, "@atlan/mssql", client, SQLServerCrawler.getConnection(client, connectionName, AtlanConnectorType.MSSQL, adminRoles, adminGroups, adminUsers, allowQuery, allowSamples, rowLimit, "https://user-images.githubusercontent.com/4249331/52232852-e2c4f780-28bd-11e9-835d-1e3cf3e43888.png"))).include(null)).exclude((Map<String, List<String>>)null);
    }

    @Generated
    protected SQLServerCrawler(SQLServerCrawlerBuilder<?, ?> b) {
        super((AbstractCrawler.AbstractCrawlerBuilder<?, ?>)b);
    }

    @Generated
    public static SQLServerCrawlerBuilder<?, ?> _internal() {
        return new SQLServerCrawlerBuilderImpl();
    }

    @Generated
    public SQLServerCrawlerBuilder<?, ?> toBuilder() {
        return new SQLServerCrawlerBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SQLServerCrawler)) {
            return false;
        }
        SQLServerCrawler other = (SQLServerCrawler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SQLServerCrawler;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SQLServerCrawler(super=" + super.toString() + ")";
    }

    public static abstract class SQLServerCrawlerBuilder<C extends SQLServerCrawler, B extends SQLServerCrawlerBuilder<C, B>>
    extends AbstractCrawler.AbstractCrawlerBuilder<C, B> {
        public B direct(String hostname, String database) {
            ((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)this.localCreds.name("default-mssql-" + this.epoch + "-0")).host(hostname)).port(1433)).extra("database", database)).connectorConfigName("atlan-connectors-mssql");
            return (B)((SQLServerCrawlerBuilder)((SQLServerCrawlerBuilder)this._parameter("extraction-method", "direct"))._credential(this.localCreds));
        }

        public B basicAuth(String username, String password) {
            ((Credential.CredentialBuilder)((Credential.CredentialBuilder)this.localCreds.authType("basic")).username(username)).password(password);
            return (B)((SQLServerCrawlerBuilder)this._credential(this.localCreds));
        }

        public B include(Map<String, List<String>> assets) throws InvalidRequestException {
            Map<String, List<String>> toInclude = AbstractCrawler.buildHierarchicalFilter(assets);
            try {
                return (B)((SQLServerCrawlerBuilder)this._parameter("include-filter", Serde.allInclusiveMapper.writeValueAsString(toInclude)));
            }
            catch (JsonProcessingException e) {
                throw new InvalidRequestException(ErrorCode.UNABLE_TO_TRANSLATE_FILTERS, (Throwable)e);
            }
        }

        public B exclude(Map<String, List<String>> assets) throws InvalidRequestException {
            Map<String, List<String>> toExclude = AbstractCrawler.buildHierarchicalFilter(assets);
            try {
                return (B)((SQLServerCrawlerBuilder)this._parameter("exclude-filter", Serde.allInclusiveMapper.writeValueAsString(toExclude)));
            }
            catch (JsonProcessingException e) {
                throw new InvalidRequestException(ErrorCode.UNABLE_TO_TRANSLATE_FILTERS, (Throwable)e);
            }
        }

        public B exclude(String regex) {
            return (B)((SQLServerCrawlerBuilder)this._parameter("temp-table-regex", regex));
        }

        @Override
        protected B metadata() {
            return (B)((SQLServerCrawlerBuilder)((SQLServerCrawlerBuilder)((SQLServerCrawlerBuilder)((SQLServerCrawlerBuilder)((SQLServerCrawlerBuilder)((SQLServerCrawlerBuilder)((SQLServerCrawlerBuilder)((SQLServerCrawlerBuilder)((SQLServerCrawlerBuilder)((SQLServerCrawlerBuilder)((SQLServerCrawlerBuilder)((SQLServerCrawlerBuilder)((SQLServerCrawlerBuilder)((SQLServerCrawlerBuilder)((SQLServerCrawlerBuilder)((SQLServerCrawlerBuilder)((SQLServerCrawlerBuilder)((SQLServerCrawlerBuilder)((SQLServerCrawlerBuilder)((SQLServerCrawlerBuilder)((SQLServerCrawlerBuilder)((SQLServerCrawlerBuilder)((SQLServerCrawlerBuilder)((SQLServerCrawlerBuilder)((SQLServerCrawlerBuilder)((SQLServerCrawlerBuilder)((SQLServerCrawlerBuilder)((SQLServerCrawlerBuilder)this._label("orchestration.atlan.com/certified", "true"))._label("orchestration.atlan.com/source", "mssql"))._label("orchestration.atlan.com/sourceCategory", "warehouse"))._label("orchestration.atlan.com/type", "connector"))._label("orchestration.atlan.com/verified", "true"))._label("package.argoproj.io/installer", "argopm"))._label("package.argoproj.io/name", "a-t-ratlans-l-a-s-hmssql"))._label("package.argoproj.io/registry", "httpsc-o-l-o-ns-l-a-s-hs-l-a-s-hpackages.atlan.com"))._label("orchestration.atlan.com/default-mssql-" + this.epoch, "true"))._label("orchestration.atlan.com/atlan-ui", "true"))._annotation("orchestration.atlan.com/allowSchedule", "true"))._annotation("orchestration.atlan.com/categories", "mssql,crawler"))._annotation("orchestration.atlan.com/dependentPackage", ""))._annotation("orchestration.atlan.com/emoji", "\ud83d\ude80"))._annotation("orchestration.atlan.com/icon", "https://user-images.githubusercontent.com/4249331/52232852-e2c4f780-28bd-11e9-835d-1e3cf3e43888.png"))._annotation("orchestration.atlan.com/logo", "https://user-images.githubusercontent.com/4249331/52232852-e2c4f780-28bd-11e9-835d-1e3cf3e43888.png"))._annotation("orchestration.atlan.com/marketplaceLink", "https://packages.atlan.com/-/web/detail/@atlan/mssql"))._annotation("orchestration.atlan.com/name", "SQL Server Assets"))._annotation("package.argoproj.io/author", "Atlan"))._annotation("package.argoproj.io/description", "Package to crawl Microsoft SQL Server assets and publish to Atlan for discovery"))._annotation("package.argoproj.io/homepage", "https://packages.atlan.com/-/web/detail/@atlan/mssql"))._annotation("package.argoproj.io/keywords", "[\"mssql\",\"database\",\"sql\",\"connector\",\"crawler\"]"))._annotation("package.argoproj.io/name", "@atlan/mssql"))._annotation("package.argoproj.io/registry", "https://packages.atlan.com"))._annotation("package.argoproj.io/repository", "git+https://github.com/atlanhq/marketplace-packages.git"))._annotation("package.argoproj.io/support", "support@atlan.com"))._annotation("orchestration.atlan.com/atlanName", PREFIX + "-default-mssql-" + this.epoch))._parameters(Map.ofEntries(Map.entry("credential-guid", "{{credentialGuid}}"), Map.entry("publish-mode", "production"), Map.entry("atlas-auth-type", "internal"), Map.entry("connection", this.connection.toJson(this.client)), Map.entry("credentials-fetch-strategy", "credential_guid"))));
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SQLServerCrawlerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SQLServerCrawler instance, SQLServerCrawlerBuilder<?, ?> b) {
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SQLServerCrawler.SQLServerCrawlerBuilder(super=" + super.toString() + ")";
        }
    }

    @Generated
    private static final class SQLServerCrawlerBuilderImpl
    extends SQLServerCrawlerBuilder<SQLServerCrawler, SQLServerCrawlerBuilderImpl> {
        @Generated
        private SQLServerCrawlerBuilderImpl() {
        }

        @Override
        @Generated
        protected SQLServerCrawlerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SQLServerCrawler build() {
            return new SQLServerCrawler(this);
        }
    }
}

