/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.search;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.search.AggregationResult;
import com.atlan.model.search.IndexSearchDSL;
import com.atlan.model.search.SearchLogEntry;
import com.atlan.model.search.SearchLogRequest;
import com.atlan.net.ApiResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchLogResponse
extends ApiResource
implements Iterable<SearchLogEntry> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchLogResponse.class);
    private static final long serialVersionUID = 2L;
    private static final int CHARACTERISTICS = 17744;
    @JsonIgnore
    AtlanClient client;
    SearchLogRequest searchParameters;
    @JsonProperty(value="logs")
    List<SearchLogEntry> logEntries;
    Long approximateCount;
    Map<String, AggregationResult> aggregations;

    @JsonIgnore
    public SearchLogResponse getNextPage() throws AtlanException {
        AtlanObject dsl = this.getSearchParameters().getDsl();
        int from = dsl.getFrom() == null ? 0 : dsl.getFrom();
        int page = dsl.getSize() == null ? 10 : dsl.getSize();
        dsl = ((IndexSearchDSL.IndexSearchDSLBuilder)dsl.toBuilder().from(from + page)).build();
        SearchLogRequest.SearchLogRequestBuilder<?, ?> next = SearchLogRequest.builder(dsl);
        return ((SearchLogRequest)next.build()).search(this.client);
    }

    @JsonIgnore
    public List<SearchLogEntry> getSpecificPage(int offset, int pageSize) throws AtlanException {
        AtlanObject dsl = ((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)this.getSearchParameters().getDsl().toBuilder().from(offset)).size(pageSize)).build();
        SearchLogRequest.SearchLogRequestBuilder<?, ?> next = SearchLogRequest.builder((IndexSearchDSL)dsl);
        SearchLogResponse response = ((SearchLogRequest)next.build()).search(this.client);
        if (response != null && response.getLogEntries() != null) {
            return response.getLogEntries();
        }
        return Collections.emptyList();
    }

    @Override
    public Iterator<SearchLogEntry> iterator() {
        return new SearchLogResponseIterator(this);
    }

    @Override
    public Spliterator<SearchLogEntry> spliterator() {
        Integer pageSize = this.getSearchParameters().getDsl().getSize();
        if (pageSize == null) {
            pageSize = 50;
        }
        SearchLogResponseSpliterator spliterator = new SearchLogResponseSpliterator(this, 0L, this.getApproximateCount(), pageSize.intValue());
        List<Object> entries = this.getLogEntries() == null ? Collections.emptyList() : this.getLogEntries();
        spliterator.firstPage = entries.spliterator();
        return spliterator;
    }

    public Stream<SearchLogEntry> stream() {
        return StreamSupport.stream(Spliterators.spliterator(this.iterator(), (long)this.approximateCount, 17744), false);
    }

    public Stream<SearchLogEntry> parallelStream() {
        return StreamSupport.stream(this::spliterator, 17744, true);
    }

    @Generated
    public AtlanClient getClient() {
        return this.client;
    }

    @Generated
    public SearchLogRequest getSearchParameters() {
        return this.searchParameters;
    }

    @Generated
    public List<SearchLogEntry> getLogEntries() {
        return this.logEntries;
    }

    @Generated
    public Long getApproximateCount() {
        return this.approximateCount;
    }

    @Generated
    public Map<String, AggregationResult> getAggregations() {
        return this.aggregations;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchLogResponse)) {
            return false;
        }
        SearchLogResponse other = (SearchLogResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$approximateCount = this.getApproximateCount();
        Long other$approximateCount = other.getApproximateCount();
        if (this$approximateCount == null ? other$approximateCount != null : !((Object)this$approximateCount).equals(other$approximateCount)) {
            return false;
        }
        AtlanClient this$client = this.getClient();
        AtlanClient other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        SearchLogRequest this$searchParameters = this.getSearchParameters();
        SearchLogRequest other$searchParameters = other.getSearchParameters();
        if (this$searchParameters == null ? other$searchParameters != null : !((Object)this$searchParameters).equals(other$searchParameters)) {
            return false;
        }
        List<SearchLogEntry> this$logEntries = this.getLogEntries();
        List<SearchLogEntry> other$logEntries = other.getLogEntries();
        if (this$logEntries == null ? other$logEntries != null : !((Object)this$logEntries).equals(other$logEntries)) {
            return false;
        }
        Map<String, AggregationResult> this$aggregations = this.getAggregations();
        Map<String, AggregationResult> other$aggregations = other.getAggregations();
        return !(this$aggregations == null ? other$aggregations != null : !((Object)this$aggregations).equals(other$aggregations));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SearchLogResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $approximateCount = this.getApproximateCount();
        result = result * 59 + ($approximateCount == null ? 43 : ((Object)$approximateCount).hashCode());
        AtlanClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        SearchLogRequest $searchParameters = this.getSearchParameters();
        result = result * 59 + ($searchParameters == null ? 43 : ((Object)$searchParameters).hashCode());
        List<SearchLogEntry> $logEntries = this.getLogEntries();
        result = result * 59 + ($logEntries == null ? 43 : ((Object)$logEntries).hashCode());
        Map<String, AggregationResult> $aggregations = this.getAggregations();
        result = result * 59 + ($aggregations == null ? 43 : ((Object)$aggregations).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SearchLogResponse(super=" + super.toString() + ", client=" + this.getClient() + ", searchParameters=" + this.getSearchParameters() + ", logEntries=" + this.getLogEntries() + ", approximateCount=" + this.getApproximateCount() + ", aggregations=" + this.getAggregations() + ")";
    }

    @JsonIgnore
    @Generated
    public void setClient(AtlanClient client) {
        this.client = client;
    }

    private static class SearchLogResponseIterator
    implements Iterator<SearchLogEntry> {
        private SearchLogResponse response;
        private int i;

        public SearchLogResponseIterator(SearchLogResponse response) {
            this.response = response;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.response.getLogEntries() != null && this.response.getLogEntries().size() > this.i) {
                return true;
            }
            try {
                this.response = this.response.getNextPage();
                this.i = 0;
                return this.response.getLogEntries() != null && this.response.getLogEntries().size() > this.i;
            }
            catch (AtlanException e) {
                throw new RuntimeException("Unable to iterate through all pages of search results.", e);
            }
        }

        @Override
        public SearchLogEntry next() {
            return this.response.getLogEntries().get(this.i++);
        }
    }

    private static class SearchLogResponseSpliterator
    implements Spliterator<SearchLogEntry> {
        private final SearchLogResponse response;
        private long start;
        private final long end;
        private final long pageSize;
        private Spliterator<SearchLogEntry> firstPage;
        private Spliterator<SearchLogEntry> currentPage;

        SearchLogResponseSpliterator(SearchLogResponse response, long start, long end, long pageSize) {
            this.response = response;
            this.start = start;
            this.end = end;
            this.pageSize = pageSize;
        }

        @Override
        public boolean tryAdvance(Consumer<? super SearchLogEntry> action) {
            while (!this.ensurePage().tryAdvance(action)) {
                if (this.start >= this.end) {
                    return false;
                }
                this.currentPage = null;
            }
            return true;
        }

        @Override
        public void forEachRemaining(Consumer<? super SearchLogEntry> action) {
            do {
                this.ensurePage().forEachRemaining(action);
                this.currentPage = null;
            } while (this.start < this.end);
        }

        @Override
        public Spliterator<SearchLogEntry> trySplit() {
            if (this.firstPage != null) {
                Spliterator<SearchLogEntry> fp = this.firstPage;
                this.firstPage = null;
                this.start = fp.getExactSizeIfKnown();
                return fp;
            }
            if (this.currentPage != null) {
                return this.currentPage.trySplit();
            }
            if (this.end - this.start > this.pageSize) {
                long mid = this.start + this.end >>> 1;
                if ((mid = mid / this.pageSize * this.pageSize) == this.start) {
                    mid += this.pageSize;
                }
                this.start = mid;
                return new SearchLogResponseSpliterator(this.response, this.start, this.start, this.pageSize);
            }
            return this.ensurePage().trySplit();
        }

        private Spliterator<SearchLogEntry> ensurePage() {
            if (this.firstPage != null) {
                Spliterator<SearchLogEntry> fp = this.firstPage;
                this.firstPage = null;
                this.currentPage = fp;
                this.start = fp.getExactSizeIfKnown();
                return fp;
            }
            Spliterator<SearchLogEntry> sp = this.currentPage;
            if (sp == null) {
                List<SearchLogEntry> entries;
                if (this.start >= this.end) {
                    return Spliterators.emptySpliterator();
                }
                try {
                    entries = this.response.getSpecificPage((int)this.start, (int)Math.min(this.end - this.start, this.pageSize));
                }
                catch (AtlanException e) {
                    log.warn("Unable to fetch the specific page from {} to {}", new Object[]{this.start, Math.min(this.end - this.start, this.pageSize), e});
                    entries = Collections.emptyList();
                }
                sp = entries.spliterator();
                this.start = sp.getExactSizeIfKnown() > 0L ? (this.start += sp.getExactSizeIfKnown()) : (this.start += this.pageSize);
                this.currentPage = sp;
            }
            return sp;
        }

        @Override
        public long estimateSize() {
            if (this.currentPage != null) {
                return this.currentPage.estimateSize();
            }
            return this.end - this.start;
        }

        @Override
        public int characteristics() {
            return 17744;
        }
    }
}

