/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.search;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.core.AssetMutationResponse;
import com.atlan.model.core.AtlanTag;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.search.AggregationBucketDetails;
import com.atlan.model.search.AggregationBucketResult;
import com.atlan.model.search.AggregationResult;
import com.atlan.model.search.CompoundQuery;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.search.IndexSearchRequest;
import com.atlan.model.search.IndexSearchResponse;
import com.atlan.model.search.SuggestionResponse;
import com.atlan.util.ParallelBatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;

public class Suggestions {
    private static final String AGG_DESCRIPTION = "group_by_description";
    private static final String AGG_USER_DESCRIPTION = "group_by_userDescription";
    private static final String AGG_OWNER_USERS = "group_by_ownerUsers";
    private static final String AGG_OWNER_GROUPS = "group_by_ownerGroups";
    private static final String AGG_ATLAN_TAGS = "group_by_tags";
    private static final String AGG_TERMS = "group_by_terms";
    AtlanClient client;
    Asset asset;
    Boolean includeArchived;
    Collection<TYPE> includes;
    Integer maxSuggestions;
    Collection<String> withOtherTypes;
    Collection<Query> wheres;
    Collection<Query> whereNots;

    public static SuggestionsBuilder finder(Asset asset) {
        return Suggestions.finder(Atlan.getDefaultClient(), asset);
    }

    public static SuggestionsBuilder finder(AtlanClient client, Asset asset) {
        return Suggestions._internal().client(client).asset(asset).includeArchived(false).maxSuggestions(5);
    }

    @Nullable
    private static String getDescriptionToApply(SuggestionResponse response) {
        long maxDescriptionCount = 0L;
        String descriptionToApply = null;
        if (response.getUserDescriptions() != null && !response.getUserDescriptions().isEmpty()) {
            maxDescriptionCount = response.getUserDescriptions().get(0).getCount();
            descriptionToApply = response.getUserDescriptions().get(0).getValue();
        }
        if (response.getSystemDescriptions() != null && !response.getSystemDescriptions().isEmpty() && response.getSystemDescriptions().get(0).getCount() > maxDescriptionCount) {
            descriptionToApply = response.getSystemDescriptions().get(0).getValue();
        }
        return descriptionToApply;
    }

    @Generated
    Suggestions(AtlanClient client, Asset asset, Boolean includeArchived, Collection<TYPE> includes, Integer maxSuggestions, Collection<String> withOtherTypes, Collection<Query> wheres, Collection<Query> whereNots) {
        this.client = client;
        this.asset = asset;
        this.includeArchived = includeArchived;
        this.includes = includes;
        this.maxSuggestions = maxSuggestions;
        this.withOtherTypes = withOtherTypes;
        this.wheres = wheres;
        this.whereNots = whereNots;
    }

    @Generated
    public static SuggestionsBuilder _internal() {
        return new SuggestionsBuilder();
    }

    public static class SuggestionsBuilder {
        @Generated
        private AtlanClient client;
        @Generated
        private Asset asset;
        @Generated
        private Boolean includeArchived;
        @Generated
        private ArrayList<TYPE> includes;
        @Generated
        private Integer maxSuggestions;
        @Generated
        private ArrayList<String> withOtherTypes;
        @Generated
        private ArrayList<Query> wheres;
        @Generated
        private ArrayList<Query> whereNots;

        public SuggestionResponse get() throws AtlanException {
            ArrayList<String> allTypes = new ArrayList<String>();
            allTypes.add(this.asset.getTypeName());
            if (this.withOtherTypes != null && !this.withOtherTypes.isEmpty()) {
                allTypes.addAll(this.withOtherTypes);
            }
            FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)((CompoundQuery.CompoundQueryBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)this.client.assets.select(this.includeArchived).where(Asset.TYPE_NAME.in(allTypes))).where(Asset.NAME.eq(this.asset.getName()))).pageSize(0)).minSomes(1);
            if (this.wheres != null && !this.wheres.isEmpty()) {
                for (Query condition : this.wheres) {
                    builder.where(condition);
                }
            }
            if (this.whereNots != null && !this.whereNots.isEmpty()) {
                for (Query condition : this.whereNots) {
                    builder.whereNot(condition);
                }
            }
            for (TYPE include : this.includes) {
                switch (include) {
                    case SystemDescription: {
                        ((FluentSearch.FluentSearchBuilder)builder.whereSome(Asset.DESCRIPTION.hasAnyValue())).aggregate(Suggestions.AGG_DESCRIPTION, Asset.DESCRIPTION.bucketBy(this.maxSuggestions, true));
                        break;
                    }
                    case UserDescription: {
                        ((FluentSearch.FluentSearchBuilder)builder.whereSome(Asset.USER_DESCRIPTION.hasAnyValue())).aggregate(Suggestions.AGG_USER_DESCRIPTION, Asset.USER_DESCRIPTION.bucketBy(this.maxSuggestions, true));
                        break;
                    }
                    case IndividualOwners: {
                        ((FluentSearch.FluentSearchBuilder)builder.whereSome(Asset.OWNER_USERS.hasAnyValue())).aggregate(Suggestions.AGG_OWNER_USERS, Asset.OWNER_USERS.bucketBy(this.maxSuggestions));
                        break;
                    }
                    case GroupOwners: {
                        ((FluentSearch.FluentSearchBuilder)builder.whereSome(Asset.OWNER_GROUPS.hasAnyValue())).aggregate(Suggestions.AGG_OWNER_GROUPS, Asset.OWNER_GROUPS.bucketBy(this.maxSuggestions));
                        break;
                    }
                    case Tags: {
                        ((FluentSearch.FluentSearchBuilder)builder.whereSome(Asset.ATLAN_TAGS.hasAnyValue())).aggregate(Suggestions.AGG_ATLAN_TAGS, Asset.ATLAN_TAGS.bucketBy(this.maxSuggestions));
                        break;
                    }
                    case Terms: {
                        ((FluentSearch.FluentSearchBuilder)builder.whereSome(Asset.ASSIGNED_TERMS.hasAnyValue())).aggregate(Suggestions.AGG_TERMS, Asset.ASSIGNED_TERMS.bucketBy(this.maxSuggestions));
                        break;
                    }
                }
            }
            IndexSearchRequest request = builder.toRequest();
            IndexSearchResponse response = request.search(this.client);
            Map<String, AggregationResult> aggregations = response.getAggregations();
            SuggestionResponse.SuggestionResponseBuilder responseBuilder = SuggestionResponse.builder();
            for (TYPE include : this.includes) {
                switch (include) {
                    case SystemDescription: {
                        responseBuilder.systemDescriptions(SuggestionsBuilder.getDescriptions(aggregations.get(Suggestions.AGG_DESCRIPTION), Asset.DESCRIPTION));
                        break;
                    }
                    case UserDescription: {
                        responseBuilder.userDescriptions(SuggestionsBuilder.getDescriptions(aggregations.get(Suggestions.AGG_USER_DESCRIPTION), Asset.USER_DESCRIPTION));
                        break;
                    }
                    case IndividualOwners: {
                        responseBuilder.ownerUsers(SuggestionsBuilder.getOthers(aggregations.get(Suggestions.AGG_OWNER_USERS)));
                        break;
                    }
                    case GroupOwners: {
                        responseBuilder.ownerGroups(SuggestionsBuilder.getOthers(aggregations.get(Suggestions.AGG_OWNER_GROUPS)));
                        break;
                    }
                    case Tags: {
                        responseBuilder.atlanTags(SuggestionsBuilder.getTags(this.client, aggregations.get(Suggestions.AGG_ATLAN_TAGS)));
                        break;
                    }
                    case Terms: {
                        responseBuilder.assignedTerms(SuggestionsBuilder.getTerms(aggregations.get(Suggestions.AGG_TERMS)));
                    }
                }
            }
            return responseBuilder.build();
        }

        public AssetMutationResponse apply() throws AtlanException {
            return this.apply(false);
        }

        public AssetMutationResponse apply(boolean allowMultiple) throws AtlanException {
            Apply result = this._apply(allowMultiple);
            return result.getAsset().save(result.getIncludesTags());
        }

        public AssetMutationResponse apply(ParallelBatch batch) throws AtlanException {
            return this.apply(batch, false);
        }

        public AssetMutationResponse apply(ParallelBatch batch, boolean allowMultiple) throws AtlanException {
            return batch.add(this._apply(allowMultiple).getAsset());
        }

        private Apply _apply(boolean allowMultiple) throws AtlanException {
            SuggestionResponse response = this.get();
            Asset.AssetBuilder<?, ?> builder = this.asset.trimToRequired();
            String descriptionToApply = Suggestions.getDescriptionToApply(response);
            builder.userDescription(descriptionToApply);
            if (response.getOwnerGroups() != null && !response.getOwnerGroups().isEmpty()) {
                if (allowMultiple) {
                    builder.ownerGroups(response.getOwnerGroups().stream().map(SuggestionResponse.SuggestedItem::getValue).collect(Collectors.toSet()));
                } else {
                    builder.ownerGroup(response.getOwnerGroups().get(0).getValue());
                }
            }
            if (response.getOwnerUsers() != null && !response.getOwnerUsers().isEmpty()) {
                if (allowMultiple) {
                    builder.ownerUsers(response.getOwnerUsers().stream().map(SuggestionResponse.SuggestedItem::getValue).collect(Collectors.toSet()));
                } else {
                    builder.ownerUser(response.getOwnerUsers().get(0).getValue());
                }
            }
            boolean includesTags = false;
            if (response.getAtlanTags() != null && !response.getAtlanTags().isEmpty()) {
                includesTags = true;
                if (allowMultiple) {
                    builder.atlanTags(response.getAtlanTags().stream().map(t -> ((AtlanTag.AtlanTagBuilder)((AtlanTag.AtlanTagBuilder)AtlanTag.builder().typeName(t.getValue())).propagate(false)).build()).collect(Collectors.toSet()));
                } else {
                    builder.atlanTag((AtlanTag)((AtlanTag.AtlanTagBuilder)((AtlanTag.AtlanTagBuilder)AtlanTag.builder().typeName(response.getAtlanTags().get(0).getValue())).propagate(false)).build());
                }
            }
            if (response.getAssignedTerms() != null && !response.getAssignedTerms().isEmpty()) {
                if (allowMultiple) {
                    builder.assignedTerms(response.getAssignedTerms().stream().map(SuggestionResponse.SuggestedTerm::getValue).collect(Collectors.toSet()));
                } else {
                    builder.assignedTerm(response.getAssignedTerms().get(0).getValue());
                }
            }
            return new Apply((Asset)builder.build(), includesTags);
        }

        private static List<SuggestionResponse.SuggestedItem> getDescriptions(AggregationResult res, AtlanField field) {
            ArrayList<SuggestionResponse.SuggestedItem> results = new ArrayList<SuggestionResponse.SuggestedItem>();
            if (res instanceof AggregationBucketResult) {
                AggregationBucketResult result = (AggregationBucketResult)res;
                for (AggregationBucketDetails bucket : result.getBuckets()) {
                    long count = bucket.getDocCount();
                    String value = bucket.getSourceValue(field).toString();
                    if (value.isBlank()) continue;
                    results.add(new SuggestionResponse.SuggestedItem(count, value));
                }
            }
            return results;
        }

        private static List<SuggestionResponse.SuggestedTerm> getTerms(AggregationResult res) {
            ArrayList<SuggestionResponse.SuggestedTerm> results = new ArrayList<SuggestionResponse.SuggestedTerm>();
            if (res instanceof AggregationBucketResult) {
                AggregationBucketResult result = (AggregationBucketResult)res;
                for (AggregationBucketDetails bucket : result.getBuckets()) {
                    long count = bucket.getDocCount();
                    String value = bucket.getKey().toString();
                    if (value.isBlank()) continue;
                    results.add(new SuggestionResponse.SuggestedTerm(count, value));
                }
            }
            return results;
        }

        private static List<SuggestionResponse.SuggestedItem> getTags(AtlanClient client, AggregationResult res) throws AtlanException {
            ArrayList<SuggestionResponse.SuggestedItem> results = new ArrayList<SuggestionResponse.SuggestedItem>();
            if (res instanceof AggregationBucketResult) {
                AggregationBucketResult result = (AggregationBucketResult)res;
                for (AggregationBucketDetails bucket : result.getBuckets()) {
                    String name;
                    long count = bucket.getDocCount();
                    String value = bucket.getKey().toString();
                    if (value.isBlank()) continue;
                    try {
                        name = client.getAtlanTagCache().getNameForId(value);
                    }
                    catch (NotFoundException e) {
                        name = "(DELETED)";
                    }
                    results.add(new SuggestionResponse.SuggestedItem(count, name));
                }
            }
            return results;
        }

        private static List<SuggestionResponse.SuggestedItem> getOthers(AggregationResult res) {
            ArrayList<SuggestionResponse.SuggestedItem> results = new ArrayList<SuggestionResponse.SuggestedItem>();
            if (res instanceof AggregationBucketResult) {
                AggregationBucketResult result = (AggregationBucketResult)res;
                for (AggregationBucketDetails bucket : result.getBuckets()) {
                    long count = bucket.getDocCount();
                    String value = bucket.getKey().toString();
                    if (value.isBlank()) continue;
                    results.add(new SuggestionResponse.SuggestedItem(count, value));
                }
            }
            return results;
        }

        @Generated
        SuggestionsBuilder() {
        }

        @Generated
        public SuggestionsBuilder client(AtlanClient client) {
            this.client = client;
            return this;
        }

        @Generated
        public SuggestionsBuilder asset(Asset asset) {
            this.asset = asset;
            return this;
        }

        @Generated
        public SuggestionsBuilder includeArchived(Boolean includeArchived) {
            this.includeArchived = includeArchived;
            return this;
        }

        @Generated
        public SuggestionsBuilder include(TYPE include) {
            if (this.includes == null) {
                this.includes = new ArrayList();
            }
            this.includes.add(include);
            return this;
        }

        @Generated
        public SuggestionsBuilder includes(Collection<? extends TYPE> includes) {
            if (includes == null) {
                throw new NullPointerException("includes cannot be null");
            }
            if (this.includes == null) {
                this.includes = new ArrayList();
            }
            this.includes.addAll(includes);
            return this;
        }

        @Generated
        public SuggestionsBuilder clearIncludes() {
            if (this.includes != null) {
                this.includes.clear();
            }
            return this;
        }

        @Generated
        public SuggestionsBuilder maxSuggestions(Integer maxSuggestions) {
            this.maxSuggestions = maxSuggestions;
            return this;
        }

        @Generated
        public SuggestionsBuilder withOtherType(String withOtherType) {
            if (this.withOtherTypes == null) {
                this.withOtherTypes = new ArrayList();
            }
            this.withOtherTypes.add(withOtherType);
            return this;
        }

        @Generated
        public SuggestionsBuilder withOtherTypes(Collection<? extends String> withOtherTypes) {
            if (withOtherTypes == null) {
                throw new NullPointerException("withOtherTypes cannot be null");
            }
            if (this.withOtherTypes == null) {
                this.withOtherTypes = new ArrayList();
            }
            this.withOtherTypes.addAll(withOtherTypes);
            return this;
        }

        @Generated
        public SuggestionsBuilder clearWithOtherTypes() {
            if (this.withOtherTypes != null) {
                this.withOtherTypes.clear();
            }
            return this;
        }

        @Generated
        public SuggestionsBuilder where(Query where) {
            if (this.wheres == null) {
                this.wheres = new ArrayList();
            }
            this.wheres.add(where);
            return this;
        }

        @Generated
        public SuggestionsBuilder wheres(Collection<? extends Query> wheres) {
            if (wheres == null) {
                throw new NullPointerException("wheres cannot be null");
            }
            if (this.wheres == null) {
                this.wheres = new ArrayList();
            }
            this.wheres.addAll(wheres);
            return this;
        }

        @Generated
        public SuggestionsBuilder clearWheres() {
            if (this.wheres != null) {
                this.wheres.clear();
            }
            return this;
        }

        @Generated
        public SuggestionsBuilder whereNot(Query whereNot) {
            if (this.whereNots == null) {
                this.whereNots = new ArrayList();
            }
            this.whereNots.add(whereNot);
            return this;
        }

        @Generated
        public SuggestionsBuilder whereNots(Collection<? extends Query> whereNots) {
            if (whereNots == null) {
                throw new NullPointerException("whereNots cannot be null");
            }
            if (this.whereNots == null) {
                this.whereNots = new ArrayList();
            }
            this.whereNots.addAll(whereNots);
            return this;
        }

        @Generated
        public SuggestionsBuilder clearWhereNots() {
            if (this.whereNots != null) {
                this.whereNots.clear();
            }
            return this;
        }

        @Generated
        public Suggestions build() {
            return new Suggestions(this.client, this.asset, this.includeArchived, switch (this.includes == null ? 0 : this.includes.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.includes.get(0));
                default -> Collections.unmodifiableList(new ArrayList<TYPE>(this.includes));
            }, this.maxSuggestions, switch (this.withOtherTypes == null ? 0 : this.withOtherTypes.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.withOtherTypes.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(this.withOtherTypes));
            }, switch (this.wheres == null ? 0 : this.wheres.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.wheres.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Query>(this.wheres));
            }, switch (this.whereNots == null ? 0 : this.whereNots.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.whereNots.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Query>(this.whereNots));
            });
        }

        @Generated
        public String toString() {
            return "Suggestions.SuggestionsBuilder(client=" + this.client + ", asset=" + this.asset + ", includeArchived=" + this.includeArchived + ", includes=" + this.includes + ", maxSuggestions=" + this.maxSuggestions + ", withOtherTypes=" + this.withOtherTypes + ", wheres=" + this.wheres + ", whereNots=" + this.whereNots + ")";
        }
    }

    private static class Apply {
        boolean includesTags;
        Asset asset;

        private Apply(Asset asset, boolean includesTags) {
            this.asset = asset;
            this.includesTags = includesTags;
        }

        @Generated
        public boolean getIncludesTags() {
            return this.includesTags;
        }

        @Generated
        public Asset getAsset() {
            return this.asset;
        }
    }

    public static enum TYPE {
        SystemDescription,
        UserDescription,
        IndividualOwners,
        GroupOwners,
        Tags,
        Terms;

    }
}

