/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.tasks;

import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.search.IndexSearchDSL;
import com.atlan.model.tasks.AtlanTask;
import com.atlan.model.tasks.TaskSearchRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;

public class FluentTasks {
    AtlanClient client;
    List<SortOptions> sorts;
    Map<String, Aggregation> aggregations;
    Integer pageSize;
    private List<Query> wheres;
    private List<Query> whereNots;
    private List<Query> whereSomes;
    private int minSomes;

    public static FluentTasksBuilder builder(AtlanClient client) {
        return FluentTasks._internal().client(client);
    }

    public Query toQuery() {
        BoolQuery.Builder builder = new BoolQuery.Builder();
        if (this.wheres != null && !this.wheres.isEmpty()) {
            builder.filter(this.wheres);
        }
        if (this.whereNots != null && !this.whereNots.isEmpty()) {
            builder.mustNot(this.whereNots);
        }
        if (this.whereSomes != null && !this.whereSomes.isEmpty()) {
            builder.should(this.whereSomes).minimumShouldMatch("" + this.minSomes);
        }
        return builder.build()._toQuery();
    }

    public TaskSearchRequest toRequest() {
        return this._requestBuilder().build();
    }

    public long count() throws AtlanException {
        if (this.client == null) {
            throw new InvalidRequestException(ErrorCode.NO_ATLAN_CLIENT);
        }
        AtlanObject request = TaskSearchRequest.builder((IndexSearchDSL)((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)this._dsl().size(1)).clearAggregations()).build()).build();
        return ((TaskSearchRequest)request).search(this.client).getApproximateCount();
    }

    public Stream<AtlanTask> stream() throws AtlanException {
        return this.stream(false);
    }

    public Stream<AtlanTask> stream(boolean parallel) throws AtlanException {
        if (this.client == null) {
            throw new InvalidRequestException(ErrorCode.NO_ATLAN_CLIENT);
        }
        TaskSearchRequest request = this.toRequest();
        if (parallel) {
            return request.search(this.client).parallelStream();
        }
        return request.search(this.client).stream();
    }

    protected IndexSearchDSL.IndexSearchDSLBuilder<?, ?> _dsl() {
        return IndexSearchDSL.builder(this.toQuery());
    }

    protected TaskSearchRequest.TaskSearchRequestBuilder<?, ?> _requestBuilder() {
        IndexSearchDSL.IndexSearchDSLBuilder<?, ?> dsl = this._dsl();
        if (this.pageSize != null) {
            dsl.size(this.pageSize);
        }
        if (this.sorts != null) {
            dsl.sort(this.sorts);
        }
        if (this.aggregations != null) {
            dsl.aggregations(this.aggregations);
        }
        return TaskSearchRequest.builder((IndexSearchDSL)dsl.build());
    }

    @Generated
    private static int $default$minSomes() {
        return 1;
    }

    @Generated
    FluentTasks(AtlanClient client, List<SortOptions> sorts, Map<String, Aggregation> aggregations, Integer pageSize, List<Query> wheres, List<Query> whereNots, List<Query> whereSomes, int minSomes) {
        this.client = client;
        this.sorts = sorts;
        this.aggregations = aggregations;
        this.pageSize = pageSize;
        this.wheres = wheres;
        this.whereNots = whereNots;
        this.whereSomes = whereSomes;
        this.minSomes = minSomes;
    }

    @Generated
    public static FluentTasksBuilder _internal() {
        return new FluentTasksBuilder();
    }

    public static class FluentTasksBuilder {
        @Generated
        private AtlanClient client;
        @Generated
        private ArrayList<SortOptions> sorts;
        @Generated
        private ArrayList<String> aggregations$key;
        @Generated
        private ArrayList<Aggregation> aggregations$value;
        @Generated
        private Integer pageSize;
        @Generated
        private ArrayList<Query> wheres;
        @Generated
        private ArrayList<Query> whereNots;
        @Generated
        private ArrayList<Query> whereSomes;
        @Generated
        private boolean minSomes$set;
        @Generated
        private int minSomes$value;

        public TaskSearchRequest.TaskSearchRequestBuilder<?, ?> toRequestBuilder() {
            return this.build()._requestBuilder();
        }

        public TaskSearchRequest toRequest() {
            return this.build().toRequest();
        }

        public long count() throws AtlanException {
            return this.build().count();
        }

        public Stream<AtlanTask> stream() throws AtlanException {
            return this.build().stream();
        }

        public Stream<AtlanTask> stream(boolean parallel) throws AtlanException {
            return this.build().stream(parallel);
        }

        @Generated
        FluentTasksBuilder() {
        }

        @Generated
        public FluentTasksBuilder client(AtlanClient client) {
            this.client = client;
            return this;
        }

        @Generated
        public FluentTasksBuilder sort(SortOptions sort) {
            if (this.sorts == null) {
                this.sorts = new ArrayList();
            }
            this.sorts.add(sort);
            return this;
        }

        @Generated
        public FluentTasksBuilder sorts(Collection<? extends SortOptions> sorts) {
            if (sorts == null) {
                throw new NullPointerException("sorts cannot be null");
            }
            if (this.sorts == null) {
                this.sorts = new ArrayList();
            }
            this.sorts.addAll(sorts);
            return this;
        }

        @Generated
        public FluentTasksBuilder clearSorts() {
            if (this.sorts != null) {
                this.sorts.clear();
            }
            return this;
        }

        @Generated
        public FluentTasksBuilder aggregate(String aggregateKey, Aggregation aggregateValue) {
            if (this.aggregations$key == null) {
                this.aggregations$key = new ArrayList();
                this.aggregations$value = new ArrayList();
            }
            this.aggregations$key.add(aggregateKey);
            this.aggregations$value.add(aggregateValue);
            return this;
        }

        @Generated
        public FluentTasksBuilder aggregations(Map<? extends String, ? extends Aggregation> aggregations) {
            if (aggregations == null) {
                throw new NullPointerException("aggregations cannot be null");
            }
            if (this.aggregations$key == null) {
                this.aggregations$key = new ArrayList();
                this.aggregations$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Aggregation> $lombokEntry : aggregations.entrySet()) {
                this.aggregations$key.add($lombokEntry.getKey());
                this.aggregations$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public FluentTasksBuilder clearAggregations() {
            if (this.aggregations$key != null) {
                this.aggregations$key.clear();
                this.aggregations$value.clear();
            }
            return this;
        }

        @Generated
        public FluentTasksBuilder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @Generated
        public FluentTasksBuilder where(Query where) {
            if (this.wheres == null) {
                this.wheres = new ArrayList();
            }
            this.wheres.add(where);
            return this;
        }

        @Generated
        public FluentTasksBuilder wheres(Collection<? extends Query> wheres) {
            if (wheres == null) {
                throw new NullPointerException("wheres cannot be null");
            }
            if (this.wheres == null) {
                this.wheres = new ArrayList();
            }
            this.wheres.addAll(wheres);
            return this;
        }

        @Generated
        public FluentTasksBuilder clearWheres() {
            if (this.wheres != null) {
                this.wheres.clear();
            }
            return this;
        }

        @Generated
        public FluentTasksBuilder whereNot(Query whereNot) {
            if (this.whereNots == null) {
                this.whereNots = new ArrayList();
            }
            this.whereNots.add(whereNot);
            return this;
        }

        @Generated
        public FluentTasksBuilder whereNots(Collection<? extends Query> whereNots) {
            if (whereNots == null) {
                throw new NullPointerException("whereNots cannot be null");
            }
            if (this.whereNots == null) {
                this.whereNots = new ArrayList();
            }
            this.whereNots.addAll(whereNots);
            return this;
        }

        @Generated
        public FluentTasksBuilder clearWhereNots() {
            if (this.whereNots != null) {
                this.whereNots.clear();
            }
            return this;
        }

        @Generated
        public FluentTasksBuilder whereSome(Query whereSome) {
            if (this.whereSomes == null) {
                this.whereSomes = new ArrayList();
            }
            this.whereSomes.add(whereSome);
            return this;
        }

        @Generated
        public FluentTasksBuilder whereSomes(Collection<? extends Query> whereSomes) {
            if (whereSomes == null) {
                throw new NullPointerException("whereSomes cannot be null");
            }
            if (this.whereSomes == null) {
                this.whereSomes = new ArrayList();
            }
            this.whereSomes.addAll(whereSomes);
            return this;
        }

        @Generated
        public FluentTasksBuilder clearWhereSomes() {
            if (this.whereSomes != null) {
                this.whereSomes.clear();
            }
            return this;
        }

        @Generated
        public FluentTasksBuilder minSomes(int minSomes) {
            this.minSomes$value = minSomes;
            this.minSomes$set = true;
            return this;
        }

        @Generated
        public FluentTasks build() {
            Map<Object, Object> aggregations;
            List<SortOptions> sorts = switch (this.sorts == null ? 0 : this.sorts.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.sorts.get(0));
                default -> Collections.unmodifiableList(new ArrayList<SortOptions>(this.sorts));
            };
            switch (this.aggregations$key == null ? 0 : this.aggregations$key.size()) {
                case 0: {
                    aggregations = Collections.emptyMap();
                    break;
                }
                case 1: {
                    aggregations = Collections.singletonMap(this.aggregations$key.get(0), this.aggregations$value.get(0));
                    break;
                }
                default: {
                    aggregations = new LinkedHashMap(this.aggregations$key.size() < 0x40000000 ? 1 + this.aggregations$key.size() + (this.aggregations$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.aggregations$key.size(); ++$i) {
                        aggregations.put(this.aggregations$key.get($i), this.aggregations$value.get($i));
                    }
                    aggregations = Collections.unmodifiableMap(aggregations);
                }
            }
            List<Query> wheres = switch (this.wheres == null ? 0 : this.wheres.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.wheres.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Query>(this.wheres));
            };
            List<Query> whereNots = switch (this.whereNots == null ? 0 : this.whereNots.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.whereNots.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Query>(this.whereNots));
            };
            List<Query> whereSomes = switch (this.whereSomes == null ? 0 : this.whereSomes.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.whereSomes.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Query>(this.whereSomes));
            };
            int minSomes$value = this.minSomes$value;
            if (!this.minSomes$set) {
                minSomes$value = FluentTasks.$default$minSomes();
            }
            return new FluentTasks(this.client, sorts, aggregations, this.pageSize, wheres, whereNots, whereSomes, minSomes$value);
        }

        @Generated
        public String toString() {
            return "FluentTasks.FluentTasksBuilder(client=" + this.client + ", sorts=" + this.sorts + ", aggregations$key=" + this.aggregations$key + ", aggregations$value=" + this.aggregations$value + ", pageSize=" + this.pageSize + ", wheres=" + this.wheres + ", whereNots=" + this.whereNots + ", whereSomes=" + this.whereSomes + ", minSomes$value=" + this.minSomes$value + ")";
        }
    }
}

