/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.net;

import com.atlan.net.HttpContent;
import com.atlan.net.KeyValuePair;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

public final class FormEncoder {
    public static HttpContent createHttpContent(Map<String, Object> params) throws IOException {
        if (params == null) {
            return HttpContent.buildFormURLEncodedContent(new ArrayList<KeyValuePair<String, String>>());
        }
        ArrayList<KeyValuePair<String, String>> kvp = new ArrayList<KeyValuePair<String, String>>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            kvp.add(new KeyValuePair<String, String>(entry.getKey(), entry.getValue().toString()));
        }
        return HttpContent.buildFormURLEncodedContent(kvp);
    }

    public static String createQueryString(Collection<KeyValuePair<String, String>> nameValueCollection) {
        if (nameValueCollection == null) {
            return "";
        }
        String result = String.join((CharSequence)"&", nameValueCollection.stream().map(kvp -> String.format("%s=%s", FormEncoder.urlEncode((String)kvp.getKey()), FormEncoder.urlEncode((String)kvp.getValue()))).collect(Collectors.toList()));
        return result;
    }

    private static String urlEncode(String value) {
        if (value == null) {
            return null;
        }
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 is unknown");
        }
    }
}

