/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.serde;

import com.atlan.model.structs.AtlanStruct;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.util.JsonParserSequence;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;

public class StructDeserializer
extends StdDeserializer<AtlanStruct>
implements ResolvableDeserializer {
    private static final long serialVersionUID = 2L;
    private final JsonDeserializer<?> defaultDeserializer;

    public StructDeserializer(JsonDeserializer<?> defaultDeserializer) {
        super(AtlanStruct.class);
        this.defaultDeserializer = defaultDeserializer;
    }

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(p, ctxt);
    }

    public AtlanStruct deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode root = (JsonNode)parser.readValueAsTree();
        AtlanStruct struct = null;
        if (root != null) {
            JsonNode attributes = root.get("attributes");
            if (attributes != null && attributes.isObject()) {
                try (JsonParser nested = attributes.traverse(parser.getCodec());){
                    struct = this.deserializeNested(nested, context);
                    struct.setRawJsonObject(root);
                }
            } else {
                JsonParserSequence restart = JsonParserSequence.createFlattened((boolean)true, (JsonParser)root.traverse(parser.getCodec()), (JsonParser)parser);
                struct = this.deserializeNested((JsonParser)restart, context);
                struct.setRawJsonObject(root);
            }
        }
        return struct;
    }

    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        ((ResolvableDeserializer)this.defaultDeserializer).resolve(ctxt);
    }

    private AtlanStruct deserializeNested(JsonParser nested, DeserializationContext context) throws IOException {
        nested.nextToken();
        return (AtlanStruct)this.defaultDeserializer.deserialize(nested, context);
    }
}

