/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.util;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.assets.Asset;
import com.atlan.model.core.AssetMutationResponse;
import com.atlan.model.enums.AssetCreationHandling;
import com.atlan.util.AssetBatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public class ParallelBatch {
    private AtlanClient client;
    private int maxSize;
    private boolean replaceAtlanTags;
    private AssetBatch.CustomMetadataHandling customMetadataHandling;
    private boolean captureFailures;
    private boolean track;
    private boolean updateOnly;
    private boolean caseSensitive;
    private AssetCreationHandling creationHandling;
    private boolean tableViewAgnostic;
    private final Map<Long, AssetBatch> batchMap = new ConcurrentHashMap<Long, AssetBatch>();
    private final List<Asset> created = new ArrayList<Asset>();
    private final List<Asset> updated = new ArrayList<Asset>();
    private final List<Asset> restored = new ArrayList<Asset>();
    private final List<AssetBatch.FailedBatch> failures = new ArrayList<AssetBatch.FailedBatch>();
    private final List<Asset> skipped = new ArrayList<Asset>();
    private final Map<String, String> resolvedGuids = new HashMap<String, String>();
    private final Map<AssetBatch.AssetIdentity, String> resolvedQualifiedNames = new HashMap<AssetBatch.AssetIdentity, String>();

    public ParallelBatch(AtlanClient client, int maxSize) {
        this(client, maxSize, false, AssetBatch.CustomMetadataHandling.IGNORE);
    }

    public ParallelBatch(AtlanClient client, int maxSize, boolean replaceAtlanTags, AssetBatch.CustomMetadataHandling customMetadataHandling) {
        this(client, maxSize, replaceAtlanTags, customMetadataHandling, false);
    }

    public ParallelBatch(AtlanClient client, int maxSize, boolean replaceAtlanTags, AssetBatch.CustomMetadataHandling customMetadataHandling, boolean captureFailures) {
        this(client, maxSize, replaceAtlanTags, customMetadataHandling, captureFailures, false);
    }

    public ParallelBatch(AtlanClient client, int maxSize, boolean replaceAtlanTags, AssetBatch.CustomMetadataHandling customMetadataHandling, boolean captureFailures, boolean updateOnly) {
        this(client, maxSize, replaceAtlanTags, customMetadataHandling, captureFailures, updateOnly, true);
    }

    public ParallelBatch(AtlanClient client, int maxSize, boolean replaceAtlanTags, AssetBatch.CustomMetadataHandling customMetadataHandling, boolean captureFailures, boolean updateOnly, boolean track) {
        this(client, maxSize, replaceAtlanTags, customMetadataHandling, captureFailures, updateOnly, track, true);
    }

    public ParallelBatch(AtlanClient client, int maxSize, boolean replaceAtlanTags, AssetBatch.CustomMetadataHandling customMetadataHandling, boolean captureFailures, boolean updateOnly, boolean track, boolean caseSensitive) {
        this(client, maxSize, replaceAtlanTags, customMetadataHandling, captureFailures, updateOnly, track, caseSensitive, AssetCreationHandling.FULL);
    }

    public ParallelBatch(AtlanClient client, int maxSize, boolean replaceAtlanTags, AssetBatch.CustomMetadataHandling customMetadataHandling, boolean captureFailures, boolean updateOnly, boolean track, boolean caseSensitive, AssetCreationHandling creationHandling) {
        this(client, maxSize, replaceAtlanTags, customMetadataHandling, captureFailures, updateOnly, track, caseSensitive, creationHandling, false);
    }

    public ParallelBatch(AtlanClient client, int maxSize, boolean replaceAtlanTags, AssetBatch.CustomMetadataHandling customMetadataHandling, boolean captureFailures, boolean updateOnly, boolean track, boolean caseSensitive, AssetCreationHandling creationHandling, boolean tableViewAgnostic) {
        this.client = client;
        this.maxSize = maxSize;
        this.replaceAtlanTags = replaceAtlanTags;
        this.customMetadataHandling = customMetadataHandling;
        this.captureFailures = captureFailures;
        this.track = track;
        this.updateOnly = updateOnly;
        this.caseSensitive = caseSensitive;
        this.creationHandling = creationHandling;
        this.tableViewAgnostic = tableViewAgnostic;
    }

    public AssetMutationResponse add(Asset single) throws AtlanException {
        long id = Thread.currentThread().getId();
        if (!this.batchMap.containsKey(id)) {
            this.batchMap.put(id, new AssetBatch(this.client, this.maxSize, this.replaceAtlanTags, this.customMetadataHandling, this.captureFailures, this.updateOnly, this.track, !this.caseSensitive, this.creationHandling, this.tableViewAgnostic));
        }
        return this.batchMap.get(id).add(single);
    }

    public void flush() throws AtlanException {
        this.batchMap.values().parallelStream().forEach(batch -> {
            try {
                batch.flush();
            }
            catch (AtlanException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public long getNumCreated() {
        long count = 0L;
        for (AssetBatch batch : this.batchMap.values()) {
            count += batch.getNumCreated().get();
        }
        return count;
    }

    public long getNumUpdated() {
        long count = 0L;
        for (AssetBatch batch : this.batchMap.values()) {
            count += batch.getNumUpdated().get();
        }
        return count;
    }

    public long getNumRestored() {
        long count = 0L;
        for (AssetBatch batch : this.batchMap.values()) {
            count += batch.getNumRestored().get();
        }
        return count;
    }

    public List<Asset> getCreated() {
        if (!this.track) {
            return null;
        }
        if (this.created.isEmpty()) {
            for (AssetBatch batch : this.batchMap.values()) {
                this.created.addAll(batch.getCreated());
            }
        }
        return this.created;
    }

    public List<Asset> getUpdated() {
        if (!this.track) {
            return null;
        }
        if (this.updated.isEmpty()) {
            for (AssetBatch batch : this.batchMap.values()) {
                this.updated.addAll(batch.getUpdated());
            }
        }
        return this.updated;
    }

    public List<Asset> getRestored() {
        if (!this.track) {
            return null;
        }
        if (this.restored.isEmpty()) {
            for (AssetBatch batch : this.batchMap.values()) {
                this.restored.addAll(batch.getRestored());
            }
        }
        return this.restored;
    }

    public List<AssetBatch.FailedBatch> getFailures() {
        if (this.failures.isEmpty()) {
            for (AssetBatch batch : this.batchMap.values()) {
                this.failures.addAll(batch.getFailures());
            }
        }
        return this.failures;
    }

    public List<Asset> getSkipped() {
        if (this.skipped.isEmpty()) {
            for (AssetBatch batch : this.batchMap.values()) {
                this.skipped.addAll(batch.getSkipped());
            }
        }
        return this.skipped;
    }

    public Map<String, String> getResolvedGuids() {
        if (this.resolvedGuids.isEmpty()) {
            for (AssetBatch batch : this.batchMap.values()) {
                this.resolvedGuids.putAll(batch.getResolvedGuids());
            }
        }
        return this.resolvedGuids;
    }

    public Map<AssetBatch.AssetIdentity, String> getResolvedQualifiedNames() {
        if (this.resolvedQualifiedNames.isEmpty()) {
            for (AssetBatch batch : this.batchMap.values()) {
                this.resolvedQualifiedNames.putAll(batch.getResolvedQualifiedNames());
            }
        }
        return this.resolvedQualifiedNames;
    }

    @Generated
    private static int $default$maxSize() {
        return 20;
    }

    @Generated
    private static boolean $default$replaceAtlanTags() {
        return false;
    }

    @Generated
    private static AssetBatch.CustomMetadataHandling $default$customMetadataHandling() {
        return AssetBatch.CustomMetadataHandling.IGNORE;
    }

    @Generated
    private static boolean $default$captureFailures() {
        return false;
    }

    @Generated
    private static boolean $default$track() {
        return true;
    }

    @Generated
    private static boolean $default$updateOnly() {
        return false;
    }

    @Generated
    private static boolean $default$caseSensitive() {
        return true;
    }

    @Generated
    private static AssetCreationHandling $default$creationHandling() {
        return AssetCreationHandling.FULL;
    }

    @Generated
    private static boolean $default$tableViewAgnostic() {
        return false;
    }

    @Generated
    public static ParallelBatchBuilder builder() {
        return new ParallelBatchBuilder();
    }

    @Generated
    public static class ParallelBatchBuilder {
        @Generated
        private AtlanClient client;
        @Generated
        private boolean maxSize$set;
        @Generated
        private int maxSize$value;
        @Generated
        private boolean replaceAtlanTags$set;
        @Generated
        private boolean replaceAtlanTags$value;
        @Generated
        private boolean customMetadataHandling$set;
        @Generated
        private AssetBatch.CustomMetadataHandling customMetadataHandling$value;
        @Generated
        private boolean captureFailures$set;
        @Generated
        private boolean captureFailures$value;
        @Generated
        private boolean track$set;
        @Generated
        private boolean track$value;
        @Generated
        private boolean updateOnly$set;
        @Generated
        private boolean updateOnly$value;
        @Generated
        private boolean caseSensitive$set;
        @Generated
        private boolean caseSensitive$value;
        @Generated
        private boolean creationHandling$set;
        @Generated
        private AssetCreationHandling creationHandling$value;
        @Generated
        private boolean tableViewAgnostic$set;
        @Generated
        private boolean tableViewAgnostic$value;

        @Generated
        ParallelBatchBuilder() {
        }

        @Generated
        public ParallelBatchBuilder client(AtlanClient client) {
            this.client = client;
            return this;
        }

        @Generated
        public ParallelBatchBuilder maxSize(int maxSize) {
            this.maxSize$value = maxSize;
            this.maxSize$set = true;
            return this;
        }

        @Generated
        public ParallelBatchBuilder replaceAtlanTags(boolean replaceAtlanTags) {
            this.replaceAtlanTags$value = replaceAtlanTags;
            this.replaceAtlanTags$set = true;
            return this;
        }

        @Generated
        public ParallelBatchBuilder customMetadataHandling(AssetBatch.CustomMetadataHandling customMetadataHandling) {
            this.customMetadataHandling$value = customMetadataHandling;
            this.customMetadataHandling$set = true;
            return this;
        }

        @Generated
        public ParallelBatchBuilder captureFailures(boolean captureFailures) {
            this.captureFailures$value = captureFailures;
            this.captureFailures$set = true;
            return this;
        }

        @Generated
        public ParallelBatchBuilder track(boolean track) {
            this.track$value = track;
            this.track$set = true;
            return this;
        }

        @Generated
        public ParallelBatchBuilder updateOnly(boolean updateOnly) {
            this.updateOnly$value = updateOnly;
            this.updateOnly$set = true;
            return this;
        }

        @Generated
        public ParallelBatchBuilder caseSensitive(boolean caseSensitive) {
            this.caseSensitive$value = caseSensitive;
            this.caseSensitive$set = true;
            return this;
        }

        @Generated
        public ParallelBatchBuilder creationHandling(AssetCreationHandling creationHandling) {
            this.creationHandling$value = creationHandling;
            this.creationHandling$set = true;
            return this;
        }

        @Generated
        public ParallelBatchBuilder tableViewAgnostic(boolean tableViewAgnostic) {
            this.tableViewAgnostic$value = tableViewAgnostic;
            this.tableViewAgnostic$set = true;
            return this;
        }

        @Generated
        public ParallelBatch build() {
            int maxSize$value = this.maxSize$value;
            if (!this.maxSize$set) {
                maxSize$value = ParallelBatch.$default$maxSize();
            }
            boolean replaceAtlanTags$value = this.replaceAtlanTags$value;
            if (!this.replaceAtlanTags$set) {
                replaceAtlanTags$value = ParallelBatch.$default$replaceAtlanTags();
            }
            AssetBatch.CustomMetadataHandling customMetadataHandling$value = this.customMetadataHandling$value;
            if (!this.customMetadataHandling$set) {
                customMetadataHandling$value = ParallelBatch.$default$customMetadataHandling();
            }
            boolean captureFailures$value = this.captureFailures$value;
            if (!this.captureFailures$set) {
                captureFailures$value = ParallelBatch.$default$captureFailures();
            }
            boolean track$value = this.track$value;
            if (!this.track$set) {
                track$value = ParallelBatch.$default$track();
            }
            boolean updateOnly$value = this.updateOnly$value;
            if (!this.updateOnly$set) {
                updateOnly$value = ParallelBatch.$default$updateOnly();
            }
            boolean caseSensitive$value = this.caseSensitive$value;
            if (!this.caseSensitive$set) {
                caseSensitive$value = ParallelBatch.$default$caseSensitive();
            }
            AssetCreationHandling creationHandling$value = this.creationHandling$value;
            if (!this.creationHandling$set) {
                creationHandling$value = ParallelBatch.$default$creationHandling();
            }
            boolean tableViewAgnostic$value = this.tableViewAgnostic$value;
            if (!this.tableViewAgnostic$set) {
                tableViewAgnostic$value = ParallelBatch.$default$tableViewAgnostic();
            }
            return new ParallelBatch(this.client, maxSize$value, replaceAtlanTags$value, customMetadataHandling$value, captureFailures$value, track$value, updateOnly$value, caseSensitive$value, creationHandling$value, tableViewAgnostic$value);
        }

        @Generated
        public String toString() {
            return "ParallelBatch.ParallelBatchBuilder(client=" + this.client + ", maxSize$value=" + this.maxSize$value + ", replaceAtlanTags$value=" + this.replaceAtlanTags$value + ", customMetadataHandling$value=" + this.customMetadataHandling$value + ", captureFailures$value=" + this.captureFailures$value + ", track$value=" + this.track$value + ", updateOnly$value=" + this.updateOnly$value + ", caseSensitive$value=" + this.caseSensitive$value + ", creationHandling$value=" + this.creationHandling$value + ", tableViewAgnostic$value=" + this.tableViewAgnostic$value + ")";
        }
    }
}

