/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.util;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtils {
    private static final Pattern whitespacePattern = Pattern.compile("\\s");
    private static final Pattern connectionQNPrefix = Pattern.compile("(default/[a-z0-9-]+/[0-9]{10})/.*");
    private static final Pattern domainQNPrefix = Pattern.compile("(default/domain/[a-zA-Z0-9-]+/super)/.*");
    private static final Pattern uuidPattern = Pattern.compile("^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$");

    public static boolean containsWhitespace(String str) {
        Objects.requireNonNull(str);
        return whitespacePattern.matcher(str).find();
    }

    public static boolean secureCompare(String a, String b) {
        byte[] digesta = a.getBytes(StandardCharsets.UTF_8);
        byte[] digestb = b.getBytes(StandardCharsets.UTF_8);
        return MessageDigest.isEqual(digesta, digestb);
    }

    public static String getFieldNameFromMethodName(String methodName) {
        if (methodName.length() > 3 && (methodName.startsWith("set") || methodName.startsWith("get"))) {
            StringBuilder sb = new StringBuilder(methodName);
            sb.delete(0, 3);
            sb.replace(0, 1, sb.substring(0, 1).toLowerCase(Locale.ROOT));
            return sb.toString();
        }
        return null;
    }

    public static String encodeContent(String decoded) {
        return decoded == null ? null : URLEncoder.encode(decoded, StandardCharsets.UTF_8).replace("+", "%20");
    }

    public static String decodeContent(String encoded) {
        return encoded == null ? null : URLDecoder.decode(encoded.replace("%20", "+"), StandardCharsets.UTF_8);
    }

    public static String getConnectionQualifiedName(String qualifiedName) {
        Matcher m;
        if (qualifiedName != null && (m = connectionQNPrefix.matcher(qualifiedName)).find() && m.groupCount() > 0) {
            return m.group(1);
        }
        return null;
    }

    public static String getSuperDomainQualifiedName(String domainQualifiedName) {
        if (domainQualifiedName != null) {
            Matcher m = domainQNPrefix.matcher(domainQualifiedName);
            if (m.find() && m.groupCount() > 0) {
                return m.group(1);
            }
            if (domainQualifiedName.startsWith("default/domain/")) {
                return domainQualifiedName;
            }
        }
        return null;
    }

    public static String getNameFromQualifiedName(String qualifiedName) {
        return StringUtils.getNameFromQualifiedName(qualifiedName, "/");
    }

    public static String getNameFromQualifiedName(String qualifiedName, String delimiter) {
        if (qualifiedName == null) {
            return null;
        }
        if (qualifiedName.indexOf(delimiter) > 0) {
            return qualifiedName.substring(qualifiedName.lastIndexOf(delimiter) + 1);
        }
        String connectionQN = StringUtils.getConnectionQualifiedName(qualifiedName);
        return qualifiedName.substring(connectionQN.length() + 1);
    }

    public static String getParentQualifiedNameFromQualifiedName(String qualifiedName) {
        return StringUtils.getParentQualifiedNameFromQualifiedName(qualifiedName, "/");
    }

    public static String getParentQualifiedNameFromQualifiedName(String qualifiedName, String delimiter) {
        if (qualifiedName != null && qualifiedName.indexOf(delimiter) > 0) {
            return qualifiedName.substring(0, qualifiedName.lastIndexOf(delimiter));
        }
        return null;
    }

    public static String trimPathDelimiters(String toTrim) {
        if (toTrim == null) {
            return "";
        }
        if (toTrim.startsWith("/")) {
            toTrim = toTrim.substring(1);
        }
        if (toTrim.endsWith("/")) {
            toTrim = toTrim.substring(0, toTrim.length() - 1);
        }
        return toTrim;
    }

    public static boolean isUUID(String str) {
        return str != null && uuidPattern.matcher(str).find();
    }

    public static String getUpperCamelCase(String text) {
        String[] words = text.split("[\\W_]+");
        StringBuilder builder = new StringBuilder();
        for (String s : words) {
            String word = s;
            word = word.isEmpty() ? word : Character.toUpperCase(word.charAt(0)) + word.substring(1);
            builder.append(word);
        }
        return builder.toString();
    }

    public static String getLowerCamelCase(String text) {
        String[] words = text.split("[\\W_]+");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            Object word = words[i];
            word = i == 0 ? (((String)word).isEmpty() ? word : Character.toLowerCase(((String)word).charAt(0)) + ((String)word).substring(1)) : (((String)word).isEmpty() ? word : Character.toUpperCase(((String)word).charAt(0)) + ((String)word).substring(1));
            builder.append((String)word);
        }
        return builder.toString();
    }

    public static String getLowerCamelCaseAggressive(String text) {
        String[] words = text.split("[\\W_]+");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            Object word = words[i];
            word = i == 0 ? (((String)word).isEmpty() ? word : Character.toLowerCase(((String)word).charAt(0)) + ((String)word).substring(1).toLowerCase(Locale.ROOT)) : (((String)word).isEmpty() ? word : Character.toUpperCase(((String)word).charAt(0)) + ((String)word).substring(1).toLowerCase(Locale.ROOT));
            builder.append((String)word);
        }
        return builder.toString();
    }

    public static String getUpperSnakeCase(String text) {
        return StringUtils.getSnakeCase(text).toUpperCase(Locale.ROOT);
    }

    public static String getLowerSnakeCase(String text) {
        return StringUtils.getSnakeCase(text).toLowerCase(Locale.ROOT);
    }

    private static String getSnakeCase(String text) {
        return text.replaceAll("_", "").replaceAll("([A-Z]+)([A-Z][a-z])", "$1_$2").replaceAll("([a-z])([A-Z])", "$1_$2");
    }

    public static String getTitleCase(String text) {
        StringBuilder titleCase = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char currentChar = text.charAt(i);
            if (i > 0 && Character.isUpperCase(currentChar)) {
                titleCase.append(" ");
            }
            titleCase.append(i == 0 ? Character.toUpperCase(currentChar) : currentChar);
        }
        return titleCase.toString();
    }
}

