// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.api;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.assets.Asset;
import com.atlan.model.core.AtlanObject;
import com.atlan.net.ApiResource;
import com.atlan.net.RequestOptions;

/**
 * API endpoints for data contract-specific operations.
 */
public class ContractsEndpoint extends HeraclesEndpoint {
    private static final String endpoint = "/contracts";
    private static final String endpoint_init = endpoint + "/init";

    public ContractsEndpoint(AtlanClient client) {
        super(client);
    }

    /**
     * Generate an initial contract spec for the provided asset.
     * The asset must have at least its qualifiedName (and type) populated.
     *
     * @param asset for which to generate the initial contract spec
     * @return the YAML for the initial contract spec for the provided asset
     * @throws AtlanException on any issue interacting with the API
     */
    public String generateInitialSpec(Asset asset) throws AtlanException {
        return generateInitialSpec(asset, null);
    }

    /**
     * Generate an initial contract spec for the provided asset.
     * The asset must have at least its qualifiedName (and type) populated.
     *
     * @param asset for which to generate the initial contract spec
     * @param options to override default client settings
     * @return the YAML for the initial contract spec for the provided asset
     * @throws AtlanException on any issue interacting with the API
     */
    public String generateInitialSpec(Asset asset, RequestOptions options) throws AtlanException {
        InitRequest request = new InitRequest(asset);
        String url = String.format("%s%s", getBaseUrl(), endpoint_init);
        InitResponse response = ApiResource.request(client, ApiResource.RequestMethod.POST, url, request, InitResponse.class, options);
        return response.getContract();
    }


    private static final class InitRequest extends AtlanObject {
        private static final long serialVersionUID = 2L;
        String assetType;
        String assetQualifiedName;

        public InitRequest(String assetType, String assetQualifiedName) {
            this.assetType = assetType;
            this.assetQualifiedName = assetQualifiedName;
        }

        public InitRequest(Asset asset) {
            this(asset.getTypeName(), asset.getQualifiedName());
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getAssetType() {
            return this.assetType;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getAssetQualifiedName() {
            return this.assetQualifiedName;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof ContractsEndpoint.InitRequest)) return false;
            final ContractsEndpoint.InitRequest other = (ContractsEndpoint.InitRequest) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$assetType = this.getAssetType();
            final java.lang.Object other$assetType = other.getAssetType();
            if (this$assetType == null ? other$assetType != null : !this$assetType.equals(other$assetType)) return false;
            final java.lang.Object this$assetQualifiedName = this.getAssetQualifiedName();
            final java.lang.Object other$assetQualifiedName = other.getAssetQualifiedName();
            if (this$assetQualifiedName == null ? other$assetQualifiedName != null : !this$assetQualifiedName.equals(other$assetQualifiedName)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof ContractsEndpoint.InitRequest;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $assetType = this.getAssetType();
            result = result * PRIME + ($assetType == null ? 43 : $assetType.hashCode());
            final java.lang.Object $assetQualifiedName = this.getAssetQualifiedName();
            result = result * PRIME + ($assetQualifiedName == null ? 43 : $assetQualifiedName.hashCode());
            return result;
        }
    }


    private static final class InitResponse extends ApiResource {
        private static final long serialVersionUID = 2L;
        String contract;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getContract() {
            return this.contract;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof ContractsEndpoint.InitResponse)) return false;
            final ContractsEndpoint.InitResponse other = (ContractsEndpoint.InitResponse) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$contract = this.getContract();
            final java.lang.Object other$contract = other.getContract();
            if (this$contract == null ? other$contract != null : !this$contract.equals(other$contract)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof ContractsEndpoint.InitResponse;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $contract = this.getContract();
            result = result * PRIME + ($contract == null ? 43 : $contract.hashCode());
            return result;
        }
    }
}
