// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2023 Atlan Pte. Ltd. */
package com.atlan.api;

import com.atlan.AtlanClient;
import com.atlan.exception.*;
import com.atlan.net.ApiResource;
import com.atlan.net.RequestOptions;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/**
 * API endpoints for impersonating users as part of Atlan automations (if desired).
 * Note: this will only work when run as part of Atlan's packaged workflow ecosystem
 * (running in the cluster back-end).
 */
public class ImpersonationEndpoint extends AbstractEndpoint {
    private static final String SERVICE = "http://keycloak-http.keycloak.svc.cluster.local";
    private static final String endpoint = "/auth/realms/default/protocol/openid-connect/token";

    public ImpersonationEndpoint(AtlanClient client) {
        super(client);
    }

    protected String getBaseUrl() throws ApiConnectionException {
        if (!client.isInternal()) {
            throw new ApiConnectionException(ErrorCode.INTERNAL_ONLY);
        }
        return SERVICE;
    }

    /**
     * Escalate to a privileged user on a short-term basis.
     * Note: this is only possible from within the Atlan tenant, and only when given the appropriate credentials.
     *
     * @return a short-lived bearer token with escalated privileges
     * @throws AtlanException on any API communication or permission issue
     */
    public String escalate() throws AtlanException {
        return escalate(null);
    }

    /**
     * Escalate to a privileged user on a short-term basis.
     * Note: this is only possible from within the Atlan tenant, and only when given the appropriate credentials.
     *
     * @param options to override default client settings
     * @return a short-lived bearer token with escalated privileges
     * @throws AtlanException on any API communication or permission issue
     */
    public String escalate(RequestOptions options) throws AtlanException {
        String tokenUrl = String.format("%s%s", getBaseUrl(), endpoint);
        String clientId = System.getenv("CLIENT_ID");
        String clientSecret = System.getenv("CLIENT_SECRET");
        if (clientId == null || clientId.isEmpty() || clientSecret == null || clientSecret.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_CREDENTIALS);
        }
        Map<String, Object> argoMap = Map.of("grant_type", "client_credentials", "client_id", clientId, "client_secret", clientSecret, "scope", "openid");
        try {
            AccessTokenResponse clientToken = ApiResource.request(client, ApiResource.RequestMethod.POST, tokenUrl, argoMap, AccessTokenResponse.class, options);
            return clientToken.getAccessToken();
        } catch (AtlanException e) {
            throw new PermissionException(ErrorCode.UNABLE_TO_ESCALATE, e);
        }
    }

    /**
     * Retrieves a bearer token that impersonates the provided user.
     *
     * @param userId unique identifier of the user to impersonate
     * @return a bearer token that impersonates the provided user
     * @throws AtlanException on any API communication issue
     */
    public String user(String userId) throws AtlanException {
        return user(userId, null);
    }

    /**
     * Retrieves a bearer token that impersonates the provided user.
     *
     * @param userId unique identifier of the user to impersonate
     * @param options to override default client settings
     * @return a bearer token that impersonates the provided user
     * @throws AtlanException on any API communication issue
     */
    public String user(String userId, RequestOptions options) throws AtlanException {
        String tokenUrl = String.format("%s/auth/realms/default/protocol/openid-connect/token", getBaseUrl());
        String clientId = System.getenv("CLIENT_ID");
        String clientSecret = System.getenv("CLIENT_SECRET");
        if (clientId == null || clientId.isEmpty() || clientSecret == null || clientSecret.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_CREDENTIALS);
        }
        Map<String, Object> argoMap = Map.of("grant_type", "client_credentials", "client_id", clientId, "client_secret", clientSecret);
        String argoToken;
        try {
            AccessTokenResponse clientToken = ApiResource.request(client, ApiResource.RequestMethod.POST, tokenUrl, argoMap, AccessTokenResponse.class, options);
            argoToken = clientToken.getAccessToken();
        } catch (AtlanException e) {
            throw new PermissionException(ErrorCode.UNABLE_TO_ESCALATE, e);
        }
        Map<String, Object> userMap = Map.of("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange", "client_id", clientId, "client_secret", clientSecret, "subject_token", argoToken, "requested_subject", userId);
        try {
            AccessTokenResponse userToken = ApiResource.request(client, ApiResource.RequestMethod.POST, tokenUrl, userMap, AccessTokenResponse.class, options);
            return userToken.getAccessToken();
        } catch (AtlanException e) {
            throw new PermissionException(ErrorCode.UNABLE_TO_IMPERSONATE, e);
        }
    }


    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = ImpersonationEndpoint.AccessTokenResponse.AccessTokenResponseBuilder.class)
    private static final class AccessTokenResponse extends ApiResource {
        private static final long serialVersionUID = 2L;
        /** Bearer token that can be used to impersonate a user. */
        @JsonProperty("access_token")
        String accessToken;
        /** When the bearer token will expire (in seconds). */
        @JsonProperty("expires_in")
        Long expiresIn;
        /** When the ability to refresh the token will expire (in seconds). */
        @JsonProperty("refresh_expires_in")
        Long refreshExpiresIn;
        /** Token that can be used to refresh the bearer token. */
        @JsonProperty("refresh_token")
        String refreshToken;
        /** Type of token (should be "Bearer"). */
        @JsonProperty("token_type")
        String tokenType;
        /** TBC */
        @JsonProperty("not-before-policy")
        Long notBeforePolicy;
        /** TBC */
        @JsonProperty("session_state")
        String sessionState;
        /** TBC */
        String scope;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        AccessTokenResponse(final String accessToken, final Long expiresIn, final Long refreshExpiresIn, final String refreshToken, final String tokenType, final Long notBeforePolicy, final String sessionState, final String scope) {
            this.accessToken = accessToken;
            this.expiresIn = expiresIn;
            this.refreshExpiresIn = refreshExpiresIn;
            this.refreshToken = refreshToken;
            this.tokenType = tokenType;
            this.notBeforePolicy = notBeforePolicy;
            this.sessionState = sessionState;
            this.scope = scope;
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
        public static class AccessTokenResponseBuilder {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String accessToken;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Long expiresIn;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Long refreshExpiresIn;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String refreshToken;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String tokenType;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Long notBeforePolicy;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String sessionState;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String scope;

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            AccessTokenResponseBuilder() {
            }

            /**
             * @return {@code this}.
             */
            @JsonProperty("access_token")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ImpersonationEndpoint.AccessTokenResponse.AccessTokenResponseBuilder accessToken(final String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            /**
             * @return {@code this}.
             */
            @JsonProperty("expires_in")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ImpersonationEndpoint.AccessTokenResponse.AccessTokenResponseBuilder expiresIn(final Long expiresIn) {
                this.expiresIn = expiresIn;
                return this;
            }

            /**
             * @return {@code this}.
             */
            @JsonProperty("refresh_expires_in")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ImpersonationEndpoint.AccessTokenResponse.AccessTokenResponseBuilder refreshExpiresIn(final Long refreshExpiresIn) {
                this.refreshExpiresIn = refreshExpiresIn;
                return this;
            }

            /**
             * @return {@code this}.
             */
            @JsonProperty("refresh_token")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ImpersonationEndpoint.AccessTokenResponse.AccessTokenResponseBuilder refreshToken(final String refreshToken) {
                this.refreshToken = refreshToken;
                return this;
            }

            /**
             * @return {@code this}.
             */
            @JsonProperty("token_type")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ImpersonationEndpoint.AccessTokenResponse.AccessTokenResponseBuilder tokenType(final String tokenType) {
                this.tokenType = tokenType;
                return this;
            }

            /**
             * @return {@code this}.
             */
            @JsonProperty("not-before-policy")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ImpersonationEndpoint.AccessTokenResponse.AccessTokenResponseBuilder notBeforePolicy(final Long notBeforePolicy) {
                this.notBeforePolicy = notBeforePolicy;
                return this;
            }

            /**
             * @return {@code this}.
             */
            @JsonProperty("session_state")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ImpersonationEndpoint.AccessTokenResponse.AccessTokenResponseBuilder sessionState(final String sessionState) {
                this.sessionState = sessionState;
                return this;
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ImpersonationEndpoint.AccessTokenResponse.AccessTokenResponseBuilder scope(final String scope) {
                this.scope = scope;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ImpersonationEndpoint.AccessTokenResponse build() {
                return new ImpersonationEndpoint.AccessTokenResponse(this.accessToken, this.expiresIn, this.refreshExpiresIn, this.refreshToken, this.tokenType, this.notBeforePolicy, this.sessionState, this.scope);
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public java.lang.String toString() {
                return "ImpersonationEndpoint.AccessTokenResponse.AccessTokenResponseBuilder(accessToken=" + this.accessToken + ", expiresIn=" + this.expiresIn + ", refreshExpiresIn=" + this.refreshExpiresIn + ", refreshToken=" + this.refreshToken + ", tokenType=" + this.tokenType + ", notBeforePolicy=" + this.notBeforePolicy + ", sessionState=" + this.sessionState + ", scope=" + this.scope + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static ImpersonationEndpoint.AccessTokenResponse.AccessTokenResponseBuilder builder() {
            return new ImpersonationEndpoint.AccessTokenResponse.AccessTokenResponseBuilder();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ImpersonationEndpoint.AccessTokenResponse.AccessTokenResponseBuilder toBuilder() {
            return new ImpersonationEndpoint.AccessTokenResponse.AccessTokenResponseBuilder().accessToken(this.accessToken).expiresIn(this.expiresIn).refreshExpiresIn(this.refreshExpiresIn).refreshToken(this.refreshToken).tokenType(this.tokenType).notBeforePolicy(this.notBeforePolicy).sessionState(this.sessionState).scope(this.scope);
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getAccessToken() {
            return this.accessToken;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Long getExpiresIn() {
            return this.expiresIn;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Long getRefreshExpiresIn() {
            return this.refreshExpiresIn;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getRefreshToken() {
            return this.refreshToken;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getTokenType() {
            return this.tokenType;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Long getNotBeforePolicy() {
            return this.notBeforePolicy;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getSessionState() {
            return this.sessionState;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getScope() {
            return this.scope;
        }
    }
}
