// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.api;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ConflictException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.enums.AtlanTypeCategory;
import com.atlan.model.typedefs.*;
import com.atlan.model.typedefs.TypeDefResponse;
import com.atlan.net.ApiResource;
import com.atlan.net.RequestOptions;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Set;

/**
 * API endpoints for operating on Atlan's type definitions (in simple terms the underlying metadata model).
 */
public class TypeDefsEndpoint extends AtlasEndpoint {
    public static final Set<String> RESERVED_SERVICE_TYPES = Set.of("atlas_core", "atlan", "aws", "azure", "gcp", "google");
    private static final String endpoint = "/types/typedefs";
    private static final String endpoint_singular = "/types/typedef";
    private static final String endpoint_by_name = "/types/typedef/name";

    public TypeDefsEndpoint(AtlanClient client) {
        super(client);
    }

    /**
     * Retrieves a list of the type definitions in Atlan.
     *
     * @param category of type definitions to retrieve
     * @return the requested list of type definitions
     * @throws AtlanException on any API communication issue
     */
    public TypeDefResponse list(AtlanTypeCategory category) throws AtlanException {
        return list(category, null);
    }

    /**
     * Retrieves a list of the type definitions in Atlan.
     *
     * @param category of type definitions to retrieve
     * @param options to override default client settings
     * @return the requested list of type definitions
     * @throws AtlanException on any API communication issue
     */
    public TypeDefResponse list(AtlanTypeCategory category, RequestOptions options) throws AtlanException {
        return list(List.of(category), options);
    }

    /**
     * Retrieves a list of the type definitions in Atlan.
     *
     * @param categories of type definitions to retrieve
     * @return the requested list of type definitions
     * @throws AtlanException on any API communication issue
     */
    public TypeDefResponse list(List<AtlanTypeCategory> categories) throws AtlanException {
        return list(categories, null);
    }

    /**
     * Retrieves a list of the type definitions in Atlan.
     *
     * @param categories of type definitions to retrieve
     * @param options to override default client settings
     * @return the requested list of type definitions
     * @throws AtlanException on any API communication issue
     */
    public TypeDefResponse list(List<AtlanTypeCategory> categories, RequestOptions options) throws AtlanException {
        StringBuilder url = new StringBuilder(String.format("%s%s", getBaseUrl(), String.format("%s", endpoint)));
        for (int i = 0; i < categories.size(); i++) {
            AtlanTypeCategory category = categories.get(i);
            if (i == 0) {
                url.append("?");
            } else {
                url.append("&");
            }
            url.append(String.format("type=%s", category.getValue().toLowerCase(Locale.ROOT)));
        }
        return ApiResource.request(client, ApiResource.RequestMethod.GET, url.toString(), "", TypeDefResponse.class, options);
    }

    /**
     * Retrieves a specific type definition from Atlan.
     *
     * @param internalName the internal (hashed-string, if used) name of the type definition
     * @return details of that specific type definition
     * @throws AtlanException on any API communication issue
     */
    public TypeDef get(String internalName) throws AtlanException {
        return get(internalName, null);
    }

    /**
     * Retrieves a specific type definition from Atlan.
     *
     * @param internalName the internal (hashed-string, if used) name of the type definition
     * @param options to override default client settings
     * @return details of that specific type definition
     * @throws AtlanException on any API communication issue
     */
    public TypeDef get(String internalName, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s/%s", getBaseUrl(), endpoint_by_name, internalName);
        WrappedTypeDef response = ApiResource.request(client, ApiResource.RequestMethod.GET, url, "", WrappedTypeDef.class, options);
        TypeDef typeDef = response.getTypeDef();
        typeDef.setRawJsonObject(response.getRawJsonObject());
        return typeDef;
    }

    /**
     * Create a new type definition in Atlan.
     * Note: only custom metadata, enumerations, and Atlan tag type definitions are currently supported.
     * Furthermore, if any of these are created their respective cache will be force-refreshed.
     *
     * @param typeDef to create
     * @return the resulting type definition that was created
     * @throws AtlanException on any API communication issue
     */
    public synchronized TypeDefResponse create(TypeDef typeDef) throws AtlanException {
        return create(typeDef, null);
    }

    /**
     * Create a new type definition in Atlan.
     * Note: only custom metadata, enumerations, and Atlan tag type definitions are currently supported.
     * Furthermore, if any of these are created their respective cache will be force-refreshed.
     *
     * @param typeDef to create
     * @param options to override default client settings
     * @return the resulting type definition that was created
     * @throws AtlanException on any API communication issue
     */
    public synchronized TypeDefResponse create(TypeDef typeDef, RequestOptions options) throws AtlanException {
        return create(List.of(typeDef), options);
    }

    /**
     * Create new type definitions in Atlan.
     * Note: only custom metadata, enumerations, and Atlan tag type definitions are currently supported.
     * Furthermore, if any of these are created their respective cache will be force-refreshed.
     *
     * @param typeDefs to create
     * @return the resulting type definition that was created
     * @throws AtlanException on any API communication issue
     */
    public synchronized TypeDefResponse create(List<TypeDef> typeDefs) throws AtlanException {
        return create(typeDefs, null);
    }

    /**
     * Create new type definitions in Atlan.
     * Note: only custom metadata, enumerations, and Atlan tag type definitions are currently supported.
     * Furthermore, if any of these are created their respective cache will be force-refreshed.
     *
     * @param typeDefs to create
     * @param options to override default client settings
     * @return the resulting type definition that was created
     * @throws AtlanException on any API communication issue
     */
    public synchronized TypeDefResponse create(List<TypeDef> typeDefs, RequestOptions options) throws AtlanException {
        TypeDefResponse response = null;
        if (typeDefs != null) {
            for (TypeDef typeDef : typeDefs) {
                switch (typeDef.getCategory()) {
                case ATLAN_TAG: 
                case CUSTOM_METADATA: 
                case ENUM: 
                    // All good, skip to the next one
                    break;
                default: 
                    throw new InvalidRequestException(ErrorCode.UNABLE_TO_CREATE_TYPEDEF_CATEGORY, typeDef.getCategory().getValue());
                }
            }
            response = _create(typeDefs, options);
        }
        return response;
    }

    /**
     * Create a new type definition in Atlan.
     * NOTE: INTERNAL USE ONLY. This will NOT work without specially-configured policies - use createTypeDef instead.
     * Furthermore, if any of Atlan tag, enum or custom metadata is created their respective cache will be force-refreshed.
     *
     * @param typeDef to create
     * @return the resulting type definition that was created
     * @throws AtlanException on any API communication issue
     * @see #create(TypeDef)
     */
    public synchronized TypeDefResponse _create(TypeDef typeDef) throws AtlanException {
        return _create(typeDef, null);
    }

    /**
     * Create a new type definition in Atlan.
     * NOTE: INTERNAL USE ONLY. This will NOT work without specially-configured policies - use createTypeDef instead.
     * Furthermore, if any of Atlan tag, enum or custom metadata is created their respective cache will be force-refreshed.
     *
     * @param typeDef to create
     * @param options to override default client settings
     * @return the resulting type definition that was created
     * @throws AtlanException on any API communication issue
     * @see #create(TypeDef)
     */
    public synchronized TypeDefResponse _create(TypeDef typeDef, RequestOptions options) throws AtlanException {
        return _create(List.of(typeDef), options);
    }

    /**
     * Create new type definitions in Atlan.
     * NOTE: INTERNAL USE ONLY. This will NOT work without specially-configured policies - use createTypeDef instead.
     * Furthermore, if any of Atlan tag, enum or custom metadata is created their respective cache will be force-refreshed.
     *
     * @param typeDefs to create
     * @return the resulting type definition that was created
     * @throws AtlanException on any API communication issue
     * @see #create(TypeDef)
     */
    public synchronized TypeDefResponse _create(List<TypeDef> typeDefs) throws AtlanException {
        return _create(typeDefs, null);
    }

    /**
     * Create new type definitions in Atlan.
     * NOTE: INTERNAL USE ONLY. This will NOT work without specially-configured policies - use createTypeDef instead.
     * Furthermore, if any of Atlan tag, enum or custom metadata is created their respective cache will be force-refreshed.
     *
     * @param typeDefs to create
     * @param options to override default client settings
     * @return the resulting type definition that was created
     * @throws AtlanException on any API communication issue
     * @see #create(TypeDef)
     */
    public synchronized TypeDefResponse _create(List<TypeDef> typeDefs, RequestOptions options) throws AtlanException {
        TypeDefResponse.TypeDefResponseBuilder builder = TypeDefResponse.builder();
        if (typeDefs != null) {
            for (TypeDef typeDef : typeDefs) {
                String serviceType = typeDef.getServiceType();
                if (serviceType != null && RESERVED_SERVICE_TYPES.contains(serviceType)) {
                    throw new ConflictException(ErrorCode.RESERVED_SERVICE_TYPE, serviceType);
                }
                switch (typeDef.getCategory()) {
                case ATLAN_TAG: 
                    builder.atlanTagDef((AtlanTagDef) typeDef);
                    break;
                case CUSTOM_METADATA: 
                    builder.customMetadataDef((CustomMetadataDef) typeDef);
                    break;
                case ENUM: 
                    builder.enumDef((EnumDef) typeDef);
                    break;
                case STRUCT: 
                    builder.structDef((StructDef) typeDef);
                    break;
                case ENTITY: 
                    builder.entityDef((EntityDef) typeDef);
                    break;
                case RELATIONSHIP: 
                    builder.relationshipDef((RelationshipDef) typeDef);
                    break;
                }
            }
            TypeDefResponse response = _create(builder, options);
            if (response != null) {
                if (!response.getAtlanTagDefs().isEmpty()) {
                    client.getAtlanTagCache().refresh();
                }
                if (!response.getCustomMetadataDefs().isEmpty()) {
                    client.getCustomMetadataCache().refresh();
                }
                if (!response.getEnumDefs().isEmpty()) {
                    client.getEnumCache().refreshCache();
                }
                return response;
            }
        }
        // If there was no typedef provided, just return an empty response (noop)
        return builder.build();
    }

    private synchronized TypeDefResponse _create(TypeDefResponse.TypeDefResponseBuilder builder, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", getBaseUrl(), endpoint);
        return ApiResource.request(client, ApiResource.RequestMethod.POST, url, builder.build(), TypeDefResponse.class, options);
    }

    /**
     * Update an existing type definition in Atlan.
     * Note: only custom metadata and Atlan tag type definitions are currently supported.
     * Furthermore, if any of these are updated their respective cache will be force-refreshed.
     *
     * @param typeDef to update
     * @return the resulting type definition that was updated
     * @throws AtlanException on any API communication issue
     */
    public synchronized TypeDefResponse update(TypeDef typeDef) throws AtlanException {
        return update(typeDef, null);
    }

    /**
     * Update an existing type definition in Atlan.
     * Note: only custom metadata and Atlan tag type definitions are currently supported.
     * Furthermore, if any of these are updated their respective cache will be force-refreshed.
     *
     * @param typeDef to update
     * @param options to override default client settings
     * @return the resulting type definition that was updated
     * @throws AtlanException on any API communication issue
     */
    public synchronized TypeDefResponse update(TypeDef typeDef, RequestOptions options) throws AtlanException {
        TypeDefResponse response = null;
        if (typeDef != null) {
            switch (typeDef.getCategory()) {
            case ATLAN_TAG: 
            case CUSTOM_METADATA: 
            case ENUM: 
                response = _update(typeDef, options);
                break;
            default: 
                throw new InvalidRequestException(ErrorCode.UNABLE_TO_UPDATE_TYPEDEF_CATEGORY, typeDef.getCategory().getValue());
            }
        }
        return response;
    }

    /**
     * Update an existing type definition in Atlan.
     * Note: only custom metadata and Atlan tag type definitions are currently supported.
     * Furthermore, if any Atlan tag, enum or custom metadata is updated their respective cache will be force-refreshed.
     *
     * @param typeDef to update
     * @return the resulting type definition that was updated
     * @throws AtlanException on any API communication issue
     */
    public synchronized TypeDefResponse _update(TypeDef typeDef) throws AtlanException {
        return _update(typeDef, null);
    }

    /**
     * Update an existing type definition in Atlan.
     * Note: only custom metadata and Atlan tag type definitions are currently supported.
     * Furthermore, if any Atlan tag, enum or custom metadata is updated their respective cache will be force-refreshed.
     *
     * @param typeDef to update
     * @param options to override default client settings
     * @return the resulting type definition that was updated
     * @throws AtlanException on any API communication issue
     */
    public synchronized TypeDefResponse _update(TypeDef typeDef, RequestOptions options) throws AtlanException {
        TypeDefResponse.TypeDefResponseBuilder builder = TypeDefResponse.builder();
        if (typeDef != null) {
            String serviceType = typeDef.getServiceType();
            if (serviceType != null && RESERVED_SERVICE_TYPES.contains(serviceType)) {
                throw new ConflictException(ErrorCode.RESERVED_SERVICE_TYPE, serviceType);
            }
            switch (typeDef.getCategory()) {
            case ATLAN_TAG: 
                builder.atlanTagDefs(List.of((AtlanTagDef) typeDef));
                break;
            case CUSTOM_METADATA: 
                builder.customMetadataDefs(List.of((CustomMetadataDef) typeDef));
                break;
            case ENUM: 
                builder.enumDefs(List.of((EnumDef) typeDef));
                break;
            case STRUCT: 
                builder.structDefs(List.of((StructDef) typeDef));
                break;
            case ENTITY: 
                builder.entityDefs(List.of((EntityDef) typeDef));
                break;
            case RELATIONSHIP: 
                builder.relationshipDefs(List.of((RelationshipDef) typeDef));
                break;
            }
            TypeDefResponse response = _update(builder, options);
            if (response != null) {
                if (!response.getAtlanTagDefs().isEmpty()) {
                    client.getAtlanTagCache().refresh();
                }
                if (!response.getCustomMetadataDefs().isEmpty()) {
                    client.getCustomMetadataCache().refresh();
                }
                if (!response.getEnumDefs().isEmpty()) {
                    client.getEnumCache().refreshCache();
                }
            }
        }
        // If there was no typedef provided, just return an empty response (noop)
        return builder.build();
    }

    private synchronized TypeDefResponse _update(TypeDefResponse.TypeDefResponseBuilder builder, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", getBaseUrl(), endpoint);
        return ApiResource.request(client, ApiResource.RequestMethod.PUT, url, builder.build(), TypeDefResponse.class, options);
    }

    /**
     * Delete the type definition.
     * Furthermore, if an Atlan tag, enum or custom metadata is deleted their respective cache will be force-refreshed
     *
     * @param internalName the internal hashed-string name of the type definition
     * @throws AtlanException on any API communication issue
     */
    public synchronized void purge(String internalName) throws AtlanException {
        purge(internalName, null);
    }

    /**
     * Delete the type definition.
     * Furthermore, if an Atlan tag, enum or custom metadata is deleted their respective cache will be force-refreshed
     *
     * @param internalName the internal hashed-string name of the type definition
     * @param options to override default client settings
     * @throws AtlanException on any API communication issue
     */
    public synchronized void purge(String internalName, RequestOptions options) throws AtlanException {
        TypeDef typeDef = get(internalName);
        String serviceType = typeDef.getServiceType();
        if (serviceType != null && RESERVED_SERVICE_TYPES.contains(serviceType)) {
            throw new ConflictException(ErrorCode.RESERVED_SERVICE_TYPE, serviceType);
        }
        String url = String.format("%s%s", getBaseUrl(), String.format("%s/name/%s", endpoint_singular, StringUtils.encodeContent(internalName)));
        ApiResource.request(client, ApiResource.RequestMethod.DELETE, url, "", null, options);
        switch (typeDef.getCategory()) {
        case ATLAN_TAG: 
            client.getAtlanTagCache().refresh();
            break;
        case ENUM: 
            client.getEnumCache().refreshCache();
            break;
        case CUSTOM_METADATA: 
            client.getCustomMetadataCache().refresh();
            break;
        default: 
            // Do nothing, no other typedefs are cached
            break;
        }
    }


    /**
     * Necessary for having a typedef object that extends ApiResource for API interactions.
     */
    @JsonSerialize(using = WrappedTypeDefSerializer.class)
    @JsonDeserialize(using = WrappedTypeDefDeserializer.class)
    private static final class WrappedTypeDef extends ApiResource {
        private static final long serialVersionUID = 2L;
        TypeDef typeDef;

        public WrappedTypeDef(TypeDef typeDef) {
            this.typeDef = typeDef;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public TypeDef getTypeDef() {
            return this.typeDef;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof TypeDefsEndpoint.WrappedTypeDef)) return false;
            final TypeDefsEndpoint.WrappedTypeDef other = (TypeDefsEndpoint.WrappedTypeDef) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$typeDef = this.getTypeDef();
            final java.lang.Object other$typeDef = other.getTypeDef();
            if (this$typeDef == null ? other$typeDef != null : !this$typeDef.equals(other$typeDef)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof TypeDefsEndpoint.WrappedTypeDef;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $typeDef = this.getTypeDef();
            result = result * PRIME + ($typeDef == null ? 43 : $typeDef.hashCode());
            return result;
        }
    }


    private static class WrappedTypeDefDeserializer extends StdDeserializer<WrappedTypeDef> {
        private static final long serialVersionUID = 2L;

        public WrappedTypeDefDeserializer() {
            this(null);
        }

        public WrappedTypeDefDeserializer(Class<?> t) {
            super(t);
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public WrappedTypeDef deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            TypeDef typeDef = parser.getCodec().readValue(parser, new TypeReference<>() {
            });
            return new WrappedTypeDef(typeDef);
        }
    }


    private static class WrappedTypeDefSerializer extends StdSerializer<WrappedTypeDef> {
        private static final long serialVersionUID = 2L;
        private final AtlanClient client;

        @SuppressWarnings("UnusedMethod")
        public WrappedTypeDefSerializer(AtlanClient client) {
            this(WrappedTypeDef.class, client);
        }

        public WrappedTypeDefSerializer(Class<WrappedTypeDef> t, AtlanClient client) {
            super(t);
            this.client = client;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public void serialize(WrappedTypeDef wrappedTypeDef, JsonGenerator gen, SerializerProvider sp) throws IOException, JsonProcessingException {
            TypeDef typeDef = wrappedTypeDef.getTypeDef();
            client.writeValue(gen, typeDef);
        }
    }
}
