// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.cache;

import com.atlan.api.RolesEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.model.admin.AtlanRole;
import com.atlan.model.admin.RoleResponse;
import java.util.*;

/**
 * Lazily-loaded cache for translating Atlan-internal roles into their various IDs.
 */
public class RoleCache extends AbstractMassCache<AtlanRole> {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(RoleCache.class);
    private final RolesEndpoint rolesEndpoint;

    public RoleCache(RolesEndpoint rolesEndpoint) {
        this.rolesEndpoint = rolesEndpoint;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void refreshCache() throws AtlanException {
        log.debug("Refreshing cache of roles...");
        // Note: we will only retrieve and cache the workspace-level roles, which all
        // start with '$'
        RoleResponse response = rolesEndpoint.list("{\"name\":{\"$ilike\":\"$%\"}}");
        cacheResponse(response);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void lookupById(String id) throws AtlanException {
        RoleResponse response = rolesEndpoint.list("{\"id\":\"" + id + "\"}");
        cacheResponse(response);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void lookupByName(String name) throws AtlanException {
        RoleResponse response = rolesEndpoint.list("{\"name\":\"" + name + "\"}");
        cacheResponse(response);
    }

    private void cacheResponse(RoleResponse response) {
        List<AtlanRole> roles;
        if (response != null) {
            roles = response.getRecords();
        } else {
            roles = Collections.emptyList();
        }
        for (AtlanRole role : roles) {
            cache(role.getId(), role.getName(), role);
        }
    }
}
