// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.exception;

import java.text.MessageFormat;

/**
 * Class to capture the details of individual error messages.
 */
public class ExceptionMessageDefinition {
    /**
     * HTTP response code for the error.
     */
    private final int httpErrorCode;
    /**
     * Unique, language-independent code for the error.
     */
    private final String errorId;
    /**
     * Message for the error, with optional formatting placeholders.
     */
    private final String errorMessage;
    /**
     * Recommended action for the user to take upon observing this error.
     */
    private final String userAction;

    /**
     * Retrieve the formatted, parameterized error message.
     *
     * @param params the values to inject into the formatting placeholders of the message
     * @return the formatted error message
     */
    public String getErrorMessage(String... params) {
        StringBuilder sb = new StringBuilder();
        if (params != null) {
            MessageFormat mf = new MessageFormat(errorMessage);
            sb.append(mf.format(params));
        } else {
            sb.append(errorMessage);
        }
        sb.append(" Suggestion: ").append(userAction);
        return sb.toString();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    ExceptionMessageDefinition(final int httpErrorCode, final String errorId, final String errorMessage, final String userAction) {
        this.httpErrorCode = httpErrorCode;
        this.errorId = errorId;
        this.errorMessage = errorMessage;
        this.userAction = userAction;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static class ExceptionMessageDefinitionBuilder {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private int httpErrorCode;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String errorId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String errorMessage;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String userAction;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        ExceptionMessageDefinitionBuilder() {
        }

        /**
         * HTTP response code for the error.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ExceptionMessageDefinition.ExceptionMessageDefinitionBuilder httpErrorCode(final int httpErrorCode) {
            this.httpErrorCode = httpErrorCode;
            return this;
        }

        /**
         * Unique, language-independent code for the error.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ExceptionMessageDefinition.ExceptionMessageDefinitionBuilder errorId(final String errorId) {
            this.errorId = errorId;
            return this;
        }

        /**
         * Message for the error, with optional formatting placeholders.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ExceptionMessageDefinition.ExceptionMessageDefinitionBuilder errorMessage(final String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        /**
         * Recommended action for the user to take upon observing this error.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ExceptionMessageDefinition.ExceptionMessageDefinitionBuilder userAction(final String userAction) {
            this.userAction = userAction;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ExceptionMessageDefinition build() {
            return new ExceptionMessageDefinition(this.httpErrorCode, this.errorId, this.errorMessage, this.userAction);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ExceptionMessageDefinition.ExceptionMessageDefinitionBuilder(httpErrorCode=" + this.httpErrorCode + ", errorId=" + this.errorId + ", errorMessage=" + this.errorMessage + ", userAction=" + this.userAction + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static ExceptionMessageDefinition.ExceptionMessageDefinitionBuilder builder() {
        return new ExceptionMessageDefinition.ExceptionMessageDefinitionBuilder();
    }

    /**
     * HTTP response code for the error.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getHttpErrorCode() {
        return this.httpErrorCode;
    }

    /**
     * Unique, language-independent code for the error.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getErrorId() {
        return this.errorId;
    }

    /**
     * Recommended action for the user to take upon observing this error.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUserAction() {
        return this.userAction;
    }
}
