// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2023 Atlan Pte. Ltd. */
package com.atlan.generators;

import com.atlan.model.typedefs.AttributeDef;
import com.atlan.util.StringUtils;

public class AttributeGenerator extends TypeGenerator {
    private MappedType type;
    private String renamed;
    private String snakeCaseRenamed;
    private boolean retyped = false;

    protected AttributeGenerator(GeneratorConfig cfg) {
        super(cfg);
    }

    public AttributeGenerator(String className, AttributeDef attributeDef, GeneratorConfig cfg) {
        super(cfg);
        super.className = className;
        this.originalName = attributeDef.getDisplayName() == null ? attributeDef.getName() : attributeDef.getDisplayName();
        this.description = cache.getAttributeDescription(className, originalName);
        resolveName();
        resolveType(attributeDef);
    }

    @Override
    protected void resolveClassName() {
        // Nothing to do, already set by constructor
    }

    protected void resolveName() {
        this.renamed = StringUtils.getLowerCamelCase(getOriginalName());
        this.snakeCaseRenamed = StringUtils.getLowerSnakeCase(getOriginalName());
    }

    protected void resolveType(AttributeDef attributeDef) {
        this.type = getMappedType(attributeDef.getTypeName());
    }

    public String getFullType() {
        String fullType;
        String container = type.getContainer();
        if (container != null) {
            long nestingCount = container.chars().filter(c -> c == '<').count();
            fullType = container + type.getName() + ">".repeat((int) nestingCount);
        } else {
            fullType = type.getName();
        }
        return fullType;
    }

    public String getReferenceType() {
        String refType;
        String container = type.getContainer();
        String baseName = type.getName();
        if (type.getType() == MappedType.Type.ASSET) {
            baseName = "I" + baseName;
        }
        if (container != null) {
            long nestingCount = container.chars().filter(c -> c == '<').count();
            refType = container + baseName + ">".repeat((int) nestingCount);
        } else {
            refType = baseName;
        }
        return refType;
    }

    public String getSingular() {
        if (getType().getContainer() != null) {
            return cfg.resolveSingular(getOriginalName());
        }
        return null;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MappedType getType() {
        return this.type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRenamed() {
        return this.renamed;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSnakeCaseRenamed() {
        return this.snakeCaseRenamed;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean getRetyped() {
        return this.retyped;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    void setType(final MappedType type) {
        this.type = type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    void setRenamed(final String renamed) {
        this.renamed = renamed;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    void setSnakeCaseRenamed(final String snakeCaseRenamed) {
        this.snakeCaseRenamed = snakeCaseRenamed;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    void setRetyped(final boolean retyped) {
        this.retyped = retyped;
    }
}
