// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2023 Atlan Pte. Ltd. */
package com.atlan.generators;

import com.atlan.model.typedefs.EnumDef;
import java.util.ArrayList;
import java.util.List;

public class EnumGenerator extends TypeGenerator {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(EnumGenerator.class);
    public static final String DIRECTORY = "enums";
    private final EnumDef enumDef;
    private List<ValidValue> values;

    public EnumGenerator(EnumDef enumDef, GeneratorConfig cfg) {
        super(enumDef, cfg);
        this.enumDef = enumDef;
        resolveClassName();
        super.description = cache.getTypeDescription(className);
        resolveValues();
    }

    @Override
    protected void resolveClassName() {
        super.className = cfg.resolveClassName(getOriginalName());
    }

    private void resolveValues() {
        values = new ArrayList<>();
        for (EnumDef.ElementDef elementDef : enumDef.getElementDefs()) {
            values.add(new ValidValue(elementDef.getValue()));
        }
    }


    public final class ValidValue {
        private final String actualValue;
        private final String enumeratedValue;

        public ValidValue(String actualValue) {
            this.actualValue = actualValue;
            this.enumeratedValue = getEnumName(actualValue);
        }

        private String getEnumName(String text) {
            return cfg.resolveEnumValue(text);
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getActualValue() {
            return this.actualValue;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getEnumeratedValue() {
            return this.enumeratedValue;
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public EnumDef getEnumDef() {
        return this.enumDef;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<ValidValue> getValues() {
        return this.values;
    }
}
