// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2023 Atlan Pte. Ltd. */
package com.atlan.generators;

import com.atlan.api.TypeDefsEndpoint;
import com.atlan.model.typedefs.TypeDef;
import com.atlan.util.StringUtils;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Class to encapsulate configuration for the generators.
 */
@SuppressWarnings("cast")
public class GeneratorConfig {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(GeneratorConfig.class);
    private static final Pattern WORD_FINDER = Pattern.compile("(([A-Z]?[a-z0-9]+)|([A-Z0-9]))");
    private static final Map<String, String> DEFAULT_CLASS_RENAMES = Map.ofEntries(Map.entry("google_datastudio_asset_type", "GoogleDataStudioAssetType"), Map.entry("powerbi_endorsement", "PowerBIEndorsementType"), Map.entry("Referenceable", "Asset"), Map.entry("Process", "LineageProcess"), Map.entry("Collection", "AtlanCollection"), Map.entry("Query", "AtlanQuery"), Map.entry("AtlasGlossary", "Glossary"), Map.entry("AtlasGlossaryCategory", "GlossaryCategory"), Map.entry("AtlasGlossaryTerm", "GlossaryTerm"), Map.entry("AtlasGlossaryAntonym", "GlossaryAntonym"), Map.entry("AtlasGlossarySynonym", "GlossarySynonym"), Map.entry("AtlasGlossaryIsARelationship", "GlossaryIsA"), Map.entry("AtlasGlossaryPreferredTerm", "GlossaryPreferredTerm"), Map.entry("AtlasGlossaryRelatedTerm", "GlossaryRelatedTerm"), Map.entry("AtlasGlossaryReplacementTerm", "GlossaryReplacementTerm"), Map.entry("AtlasGlossarySemanticAssignment", "GlossarySemanticAssignment"), Map.entry("AtlasGlossaryTermCategorization", "GlossaryTermCategorization"), Map.entry("AtlasGlossaryTranslation", "GlossaryTranslation"), Map.entry("AtlasGlossaryValidValue", "GlossaryValidValue"), Map.entry("MaterialisedView", "MaterializedView"));
    private static final Map<String, String> DEFAULT_SINGULARS = Map.ofEntries(Map.entry("seeAlso", "seeAlsoOne"), Map.entry("replacedByTerm", "replacedByTerm"), Map.entry("validValuesFor", "validValueFor"), Map.entry("isA", "isATerm"), Map.entry("replacedBy", "replacedByTerm"), Map.entry("childrenCategories", "childCategory"), Map.entry("queryUserMap", "putQueryUserMap"), Map.entry("queryPreviewConfig", "putQueryPreviewConfig"), Map.entry("reportType", "putReportType"), Map.entry("projectHierarchy", "addProjectHierarchy"), Map.entry("certifier", "putCertifier"), Map.entry("presetChartFormData", "putPresetChartFormData"), Map.entry("resourceMetadata", "putResourceMetadata"), Map.entry("adlsObjectMetadata", "putAdlsObjectMetadata"), Map.entry("foreignKeyTo", "addForeignKeyTo"), Map.entry("quickSightFolderHierarchy", "addQuickSightFolderHierarchy"), Map.entry("columnMaxs", "addColumnMax"), Map.entry("columnMins", "addColumnMin"), Map.entry("redashQuerySchedule", "putRedashQuerySchedule"), Map.entry("policyValiditySchedule", "addPolicyValiditySchedule"), Map.entry("authServiceConfig", "putAuthServiceConfig"), Map.entry("microStrategyLocation", "putMicroStrategyLocation"), Map.entry("starredBy", "addStarredBy"), Map.entry("matillionComponentLinkedJob", "putMatillionComponentLinkedJob"), Map.entry("matillionVersions", "addMatillionVersion"), Map.entry("cogniteTimeseries", "addCogniteTimeseries"), Map.entry("exceptionsForBusinessPolicy", "exceptionForBusinessPolicy"), Map.entry("supersetChartFormData", "putSupersetChartFormData"), Map.entry("columnHierarchy", "putColumnHierarchy"));
    private static final Map<String, String> DEFAULT_ATTRIBUTE_RENAMES = Map.ofEntries(Map.entry("connectorName", "connectorType"), Map.entry("__hasLineage", "hasLineage"), Map.entry("viewsCount", "viewCount"), Map.entry("materialisedView", "materializedView"), Map.entry("materialisedViews", "materializedViews"), Map.entry("atlanSchema", "schema"), Map.entry("sourceQueryComputeCostList", "sourceQueryComputeCosts"), Map.entry("sourceReadTopUserList", "sourceReadTopUsers"), Map.entry("sourceReadRecentUserList", "sourceReadRecentUsers"), Map.entry("sourceReadRecentUserRecordList", "sourceReadRecentUserRecords"), Map.entry("sourceReadTopUserRecordList", "sourceReadTopUserRecords"), Map.entry("sourceReadPopularQueryRecordList", "sourceReadPopularQueryRecords"), Map.entry("sourceReadExpensiveQueryRecordList", "sourceReadExpensiveQueryRecords"), Map.entry("sourceReadSlowQueryRecordList", "sourceReadSlowQueryRecords"), Map.entry("sourceQueryComputeCostRecordList", "sourceQueryComputeCostRecords"), Map.entry("meanings", "assignedTerms"), Map.entry("sqlAsset", "primarySqlAsset"), Map.entry("mappedClassificationName", "mappedAtlanTagName"), Map.entry("purposeClassifications", "purposeAtlanTags"), Map.entry("starredDetailsList", "starredDetails"), Map.entry("sourceTagValue", "sourceTagValues"), Map.entry("userDefRelationshipFrom", "userDefRelationshipFroms"), Map.entry("userDefRelationshipTo", "userDefRelationshipTos"));
    private static final Map<String, String> DEFAULT_ATTRIBUTE_ENUMS = Map.ofEntries(Map.entry("announcementType", "AtlanAnnouncementType"), Map.entry("connectorName", "AtlanConnectorType"), Map.entry("category", "AtlanConnectionCategory"), Map.entry("policyCategory", "AuthPolicyCategory"), Map.entry("policyResourceCategory", "AuthPolicyResourceCategory"), Map.entry("policyActions", "AtlanPolicyAction"), Map.entry("denyAssetTabs", "AssetSidebarTab"), Map.entry("denyAssetFilters", "AssetFilterGroup"), Map.entry("policyMaskType", "DataMaskingType"), Map.entry("assetIcon", "AtlanIcon"));
    private static final Map<String, Map<String, String>> DEFAULT_TYPE_OVERRIDES = Map.of("TableauDatasource", Map.of("fields", "TableauField"));
    private static final Map<String, String> DEFAULT_SEARCHABLE_RELATIONSHIPS = Map.of("readme", "asset_readme", "links", "asset_links");
    // These are built-in structs, with no serviceType defined
    static final Set<String> BUILT_IN_STRUCTS = Set.of("Histogram", "ColumnValueFrequencyMap");
    // These are built-in enums, self-managed (not persisted in Atlas)
    static final Set<String> BUILT_IN_ENUMS = Set.of("AtlanAnnouncementType", "AtlanConnectionCategory", "AtlanConnectorType", "AtlanDeleteType", "AtlanIcon", "AtlanStatus", "AtlanPolicyAction", "PersonaMetadataAction", "PersonaGlossaryAction", "PurposeMetadataAction", "DataAction", "CertificateStatus");
    private Configuration freemarkerConfig;
    private String packageRoot;
    private String packagePath;
    private String testPath;
    private String generatorName;
    private boolean preferTypeDefDescriptions;
    /**
     * Type definition serviceTypes for which to generate model POJOs.
     */
    private Set<String> serviceTypes;
    /**
     * Mapping of classes that should be renamed, either to overcome language
     * keywords (reserved words) or for consistency.
     */
    private Map<String, String> renameClasses;
    /**
     * Enumeration values that should be renamed, usually to avoid excessive
     * underscores when the value is already mostly capital letters.
     */
    private Map<String, String> renameEnumValues;
    /**
     * Assets ƒor which a model POJO should not be generated.
     */
    private Set<String> doNotGenerateAssets;
    /**
     * Assets that have subtypes, but should themselves also be treated as concrete
     * models (POJOs) and not as abstract classes.
     */
    private Set<String> forceNonAbstractAssets;
    /**
     * Mapping of attributes that need an explicit singular form (word), when it
     * cannot automatically be inferred by Lombok.
     */
    private Map<String, String> singularForAttributes;
    /**
     * Mapping of attributes that should be renamed, either to overcome language keywords
     * (reserved words) or for consistency.
     */
    private Map<String, String> renameAttributes;
    /**
     * Mapping of attributes that should have an enumerated type rather than a primitive type
     * (typically String). This is usually used to set a manually-maintained enumeration that
     * overrides such primitive types found in the typedef itself.
     */
    private Map<String, String> attributeToEnums;
    /**
     * Mapping of type to attribute to new type to use for that attribute. This is used to override
     * where the same attribute may be overloaded in the typedef (from being inherited from multiple
     * parents with different types from each). Usually this is used to manually-maintain a super-interface
     * that can cover both inherited types.
     */
    private Map<String, Map<String, String>> retypeAttributes;
    /**
     * Mapping of relationships that can be searched via ElasticSearch.
     * Keyed by the name of the relationship attribute in Atlan, with the value being the name of the
     * type of relationship that attribute captures (as it will be referred to in ElasticSearch).
     */
    private Map<String, String> searchableRelationships;

    /**
     * Configuration for generating using embedded templates in a jar file.
     *
     * @param generatorClass top-level class that is used to generate the code
     * @param packageRoot root Java package location for the generated models
     * @throws IOException if there is any problem configuring the templates through the classloader
     */
    public static GeneratorConfigBuilder creator(Class<?> generatorClass, String packageRoot) throws IOException {
        return creator(generatorClass, null, packageRoot);
    }

    /**
     * Configuration for generating using local directory for templates.
     *
     * @param generatorClass top-level class that is used to generate the code
     * @param directoryForTemplateLoading directory containing the Freemarker templates
     * @param packageRoot root Java package location for the generated models
     * @throws IOException if the directory cannot be accessed
     */
    public static GeneratorConfigBuilder creator(Class<?> generatorClass, File directoryForTemplateLoading, String packageRoot) throws IOException {
        return creator(generatorClass, directoryForTemplateLoading, packageRoot, null);
    }

    /**
     * Configuration for generating using local directory for templates.
     *
     * @param generatorClass top-level class that is used to generate the code
     * @param directoryForTemplateLoading directory containing the Freemarker templates
     * @param packageRoot root Java package location for the generated models
     * @param projectName (optional) project name for multi-project builds
     * @throws IOException if the directory cannot be accessed
     */
    public static GeneratorConfigBuilder creator(Class<?> generatorClass, File directoryForTemplateLoading, String packageRoot, String projectName) throws IOException {
        return GeneratorConfig.builder().generatorName(generatorClass.getCanonicalName()).packageRoot(packageRoot).freemarkerConfig(createConfig(directoryForTemplateLoading)).packagePath(createPackagePath(packageRoot, projectName)).testPath(createTestPath(packageRoot, projectName)).renameClasses(DEFAULT_CLASS_RENAMES).singularForAttributes(DEFAULT_SINGULARS).renameAttributes(DEFAULT_ATTRIBUTE_RENAMES).attributeToEnums(DEFAULT_ATTRIBUTE_ENUMS).retypeAttributes(DEFAULT_TYPE_OVERRIDES).searchableRelationships(DEFAULT_SEARCHABLE_RELATIONSHIPS);
    }

    /**
     * Get the default configuration for the out-of-the-box Atlan model and SDK.
     *
     * @param generatorClass top-level class that is used to generate the code
     * @return default configuration
     * @throws IOException if there is any problem configuring the templates through the classloader
     */
    public static GeneratorConfigBuilder getDefault(Class<?> generatorClass) throws IOException {
        return getDefault(generatorClass, null);
    }

    /**
     * Get the default configuration for the out-of-the-box Atlan model and SDK.
     *
     * @param generatorClass top-level class that is used to generate the code
     * @param projectName (optional) project name, for multi-project builds
     * @return default configuration
     * @throws IOException if there is any problem configuring the templates through the classloader
     */
    public static GeneratorConfigBuilder getDefault(Class<?> generatorClass, String projectName) throws IOException {
        return GeneratorConfig.creator(generatorClass, null, "com.atlan.model", projectName).serviceTypes(TypeDefsEndpoint.RESERVED_SERVICE_TYPES).preferTypeDefDescriptions(false).renameClasses(DEFAULT_CLASS_RENAMES).singularForAttributes(DEFAULT_SINGULARS).renameAttributes(DEFAULT_ATTRIBUTE_RENAMES).attributeToEnums(DEFAULT_ATTRIBUTE_ENUMS).retypeAttributes(DEFAULT_TYPE_OVERRIDES).searchableRelationships(DEFAULT_SEARCHABLE_RELATIONSHIPS).renameEnumValue("ResolvingDNS", "RESOLVING_DNS").renameEnumValue("RA-GRS", "RA_GRS").doNotGenerateAsset("Referenceable").doNotGenerateAsset("AtlasServer").doNotGenerateAsset("DataSet").doNotGenerateAsset("Infrastructure").doNotGenerateAsset("ProcessExecution").doNotGenerateAsset("__AtlasAuditEntry").doNotGenerateAsset("__AtlasUserProfile").doNotGenerateAsset("__AtlasUserSavedSearch").doNotGenerateAsset("__ExportImportAuditEntry").doNotGenerateAsset("__internal").forceNonAbstractAsset("Process").forceNonAbstractAsset("ColumnProcess").forceNonAbstractAsset("QlikSpace").forceNonAbstractAsset("KafkaTopic").forceNonAbstractAsset("KafkaConsumerGroup").forceNonAbstractAsset("Table").forceNonAbstractAsset("Database").forceNonAbstractAsset("MongoDBDatabase").forceNonAbstractAsset("MongoDBCollection").forceNonAbstractAsset("Persona");
    }

    /**
     * Whether to generate information for the given type definition.
     *
     * @param typeDef type definition to consider for inclusion
     * @return true if information should be generated for this typedef, otherwise false
     */
    public boolean includeTypedef(TypeDef typeDef) {
        if (typeDef == null || typeDef.getServiceType() == null) {
            return false;
        } else {
            return serviceTypes.contains(typeDef.getServiceType()) && !doNotGenerateAssets.contains(typeDef.getName());
        }
    }

    /**
     * Resolve the provided name to a class name, renaming it if configured and otherwise
     * just UpperCamelCasing the name.
     *
     * @param originalName unmodified name of the type definition
     * @return the resolved name for the POJO class for the type's model
     */
    public String resolveClassName(String originalName) {
        return renameClasses.getOrDefault(originalName, StringUtils.getUpperCamelCase(originalName));
    }

    /**
     * Whether to force the creation of a concrete (non-abstract) POJO class for the
     * given type definition.
     *
     * @param originalName unmodified name of the type definition
     * @return true if a concrete (non-abstract) POJO should be generated for the type definition
     */
    public boolean forceNonAbstract(String originalName) {
        return forceNonAbstractAssets.contains(originalName);
    }

    /**
     * Resolve the provided name to an attribute name, renaming it if configured and otherwise
     * just lowerCamelCasing the name.
     *
     * @param originalName unmodified name of the attribute definition
     * @return the resolved name for the attribute in the POJO
     */
    public String resolveAttributeName(String originalName) {
        return renameAttributes.getOrDefault(originalName, StringUtils.getLowerCamelCase(originalName));
    }

    /**
     * Resolve the type of the attribute to a manually-maintained enumeration, if configured,
     * or return null if there is no enumeration for this attribute.
     *
     * @param originalName unmodified name of the attribute definition
     * @return the resolved enumeration name for the attribute in the POJO, or null if not referring to an enumeration
     */
    public String resolveAttributeToEnumeration(String originalName) {
        return attributeToEnums.getOrDefault(originalName, null);
    }

    /**
     * Resolve the type of the attribute to an overridden type, if configured, or return null
     * if there is no type override for this attribute.
     *
     * @param typeName unmodified name of the type
     * @param attributeName unmodified name of the attribute definition
     * @return the resolved type override for the POJO, or null if no override
     */
    public String resolveAttributeToTypeOverride(String typeName, String attributeName) {
        if (retypeAttributes.containsKey(typeName)) {
            return retypeAttributes.get(typeName).getOrDefault(attributeName, null);
        }
        return null;
    }

    /**
     * Resolve the attribute to a singular form of it for use with builders (Lombok).
     *
     * @param originalName unmodified name of the attribute definition
     * @return the resolved singular form of the word, or an empty string if Lombok can auto-singularize it
     */
    public String resolveSingular(String originalName) {
        return singularForAttributes.getOrDefault(originalName, "");
    }

    /**
     * Resolve the enumeration value to an all-caps underscored form to meet Java conventions.
     *
     * @param value unmodified value of the enumeration
     * @return the unique name for the enumeration matching Java conventions
     */
    public String resolveEnumValue(String value) {
        if (renameEnumValues.containsKey(value)) {
            return renameEnumValues.get(value);
        } else if (value.toUpperCase(Locale.ROOT).equals(value) && !value.contains(" ") && !value.contains("-")) {
            return value;
        }
        String[] words = value.split("[-\\s]");
        if (words.length == 1) {
            List<String> camelCaseWords = new ArrayList<>();
            Matcher matcher = WORD_FINDER.matcher(value);
            while (matcher.find()) {
                camelCaseWords.add(matcher.group(0));
            }
            words = camelCaseWords.toArray(new String[0]);
        }
        StringBuilder builder = new StringBuilder();
        for (String word : words) {
            word = word.isEmpty() ? word : word.toUpperCase(Locale.ROOT);
            builder.append(word).append("_");
        }
        String built = builder.toString();
        return built.endsWith("_") ? built.substring(0, built.length() - 1) : built;
    }

    /**
     * Retrieve the relationship type name for any searchable relationship (will be a limited
     * set of the overall relationships).
     *
     * @param field name of the relationship attribute in Atlan
     * @return the relationship type name, if the attribute is searchable, otherwise null
     */
    public String getSearchableRelationship(String field) {
        return searchableRelationships.getOrDefault(field, null);
    }

    private static Configuration createConfig(File directoryForTemplateLoading) throws IOException {
        Configuration cfg = createConfigBase();
        ClassTemplateLoader ctl = new ClassTemplateLoader(GeneratorConfig.class.getClassLoader(), "templates");
        FileTemplateLoader ftl = null;
        if (directoryForTemplateLoading != null && directoryForTemplateLoading.exists()) {
            ftl = new FileTemplateLoader(directoryForTemplateLoading);
        }
        if (ftl != null) {
            // If a directory has been provided, configure it as a fallback location in which to
            // look for templates, but still use the classloader as the first place to go for
            // the templates
            MultiTemplateLoader mtl = new MultiTemplateLoader(new TemplateLoader[] {ctl, ftl});
            cfg.setTemplateLoader(mtl);
        } else {
            cfg.setTemplateLoader(ctl);
        }
        return cfg;
    }

    private static Configuration createConfigBase() {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_32);
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setWrapUncheckedExceptions(true);
        cfg.setFallbackOnNullLoopVariable(false);
        cfg.setSQLDateAndTimeTimeZone(TimeZone.getDefault());
        return cfg;
    }

    private static String createPackagePath(String packageRoot, String projectName) {
        return projectName == null ? createPath("src" + File.separator + "main" + File.separator + "java" + File.separator, packageRoot) : createPath(projectName + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator, packageRoot);
    }

    private static String createTestPath(String packageRoot, String projectName) {
        return projectName == null ? createPath("src" + File.separator + "test" + File.separator + "java" + File.separator, packageRoot) : createPath(projectName + File.separator + "src" + File.separator + "test" + File.separator + "java" + File.separator, packageRoot);
    }

    private static String createPath(String prefix, String packageRoot) {
        return prefix + File.separator + packageRoot.replaceAll("\\.", File.separator);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static boolean $default$preferTypeDefDescriptions() {
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    GeneratorConfig(final Configuration freemarkerConfig, final String packageRoot, final String packagePath, final String testPath, final String generatorName, final boolean preferTypeDefDescriptions, final Set<String> serviceTypes, final Map<String, String> renameClasses, final Map<String, String> renameEnumValues, final Set<String> doNotGenerateAssets, final Set<String> forceNonAbstractAssets, final Map<String, String> singularForAttributes, final Map<String, String> renameAttributes, final Map<String, String> attributeToEnums, final Map<String, Map<String, String>> retypeAttributes, final Map<String, String> searchableRelationships) {
        this.freemarkerConfig = freemarkerConfig;
        this.packageRoot = packageRoot;
        this.packagePath = packagePath;
        this.testPath = testPath;
        this.generatorName = generatorName;
        this.preferTypeDefDescriptions = preferTypeDefDescriptions;
        this.serviceTypes = serviceTypes;
        this.renameClasses = renameClasses;
        this.renameEnumValues = renameEnumValues;
        this.doNotGenerateAssets = doNotGenerateAssets;
        this.forceNonAbstractAssets = forceNonAbstractAssets;
        this.singularForAttributes = singularForAttributes;
        this.renameAttributes = renameAttributes;
        this.attributeToEnums = attributeToEnums;
        this.retypeAttributes = retypeAttributes;
        this.searchableRelationships = searchableRelationships;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static class GeneratorConfigBuilder {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Configuration freemarkerConfig;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String packageRoot;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String packagePath;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String testPath;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String generatorName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean preferTypeDefDescriptions$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean preferTypeDefDescriptions$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> serviceTypes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> renameClasses$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> renameClasses$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> renameEnumValues$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> renameEnumValues$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> doNotGenerateAssets;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> forceNonAbstractAssets;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> singularForAttributes$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> singularForAttributes$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> renameAttributes$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> renameAttributes$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> attributeToEnums$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> attributeToEnums$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> retypeAttributes$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Map<String, String>> retypeAttributes$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> searchableRelationships$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> searchableRelationships$value;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        GeneratorConfigBuilder() {
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder freemarkerConfig(final Configuration freemarkerConfig) {
            this.freemarkerConfig = freemarkerConfig;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder packageRoot(final String packageRoot) {
            this.packageRoot = packageRoot;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder packagePath(final String packagePath) {
            this.packagePath = packagePath;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder testPath(final String testPath) {
            this.testPath = testPath;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder generatorName(final String generatorName) {
            this.generatorName = generatorName;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder preferTypeDefDescriptions(final boolean preferTypeDefDescriptions) {
            this.preferTypeDefDescriptions$value = preferTypeDefDescriptions;
            preferTypeDefDescriptions$set = true;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder serviceType(final String serviceType) {
            if (this.serviceTypes == null) this.serviceTypes = new java.util.ArrayList<String>();
            this.serviceTypes.add(serviceType);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder serviceTypes(final java.util.Collection<? extends String> serviceTypes) {
            if (serviceTypes == null) {
                throw new java.lang.NullPointerException("serviceTypes cannot be null");
            }
            if (this.serviceTypes == null) this.serviceTypes = new java.util.ArrayList<String>();
            this.serviceTypes.addAll(serviceTypes);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder clearServiceTypes() {
            if (this.serviceTypes != null) this.serviceTypes.clear();
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder renameClass(final String renameClassKey, final String renameClassValue) {
            if (this.renameClasses$key == null) {
                this.renameClasses$key = new java.util.ArrayList<String>();
                this.renameClasses$value = new java.util.ArrayList<String>();
            }
            this.renameClasses$key.add(renameClassKey);
            this.renameClasses$value.add(renameClassValue);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder renameClasses(final java.util.Map<? extends String, ? extends String> renameClasses) {
            if (renameClasses == null) {
                throw new java.lang.NullPointerException("renameClasses cannot be null");
            }
            if (this.renameClasses$key == null) {
                this.renameClasses$key = new java.util.ArrayList<String>();
                this.renameClasses$value = new java.util.ArrayList<String>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends String> $lombokEntry : renameClasses.entrySet()) {
                this.renameClasses$key.add($lombokEntry.getKey());
                this.renameClasses$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder clearRenameClasses() {
            if (this.renameClasses$key != null) {
                this.renameClasses$key.clear();
                this.renameClasses$value.clear();
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder renameEnumValue(final String renameEnumValueKey, final String renameEnumValueValue) {
            if (this.renameEnumValues$key == null) {
                this.renameEnumValues$key = new java.util.ArrayList<String>();
                this.renameEnumValues$value = new java.util.ArrayList<String>();
            }
            this.renameEnumValues$key.add(renameEnumValueKey);
            this.renameEnumValues$value.add(renameEnumValueValue);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder renameEnumValues(final java.util.Map<? extends String, ? extends String> renameEnumValues) {
            if (renameEnumValues == null) {
                throw new java.lang.NullPointerException("renameEnumValues cannot be null");
            }
            if (this.renameEnumValues$key == null) {
                this.renameEnumValues$key = new java.util.ArrayList<String>();
                this.renameEnumValues$value = new java.util.ArrayList<String>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends String> $lombokEntry : renameEnumValues.entrySet()) {
                this.renameEnumValues$key.add($lombokEntry.getKey());
                this.renameEnumValues$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder clearRenameEnumValues() {
            if (this.renameEnumValues$key != null) {
                this.renameEnumValues$key.clear();
                this.renameEnumValues$value.clear();
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder doNotGenerateAsset(final String doNotGenerateAsset) {
            if (this.doNotGenerateAssets == null) this.doNotGenerateAssets = new java.util.ArrayList<String>();
            this.doNotGenerateAssets.add(doNotGenerateAsset);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder doNotGenerateAssets(final java.util.Collection<? extends String> doNotGenerateAssets) {
            if (doNotGenerateAssets == null) {
                throw new java.lang.NullPointerException("doNotGenerateAssets cannot be null");
            }
            if (this.doNotGenerateAssets == null) this.doNotGenerateAssets = new java.util.ArrayList<String>();
            this.doNotGenerateAssets.addAll(doNotGenerateAssets);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder clearDoNotGenerateAssets() {
            if (this.doNotGenerateAssets != null) this.doNotGenerateAssets.clear();
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder forceNonAbstractAsset(final String forceNonAbstractAsset) {
            if (this.forceNonAbstractAssets == null) this.forceNonAbstractAssets = new java.util.ArrayList<String>();
            this.forceNonAbstractAssets.add(forceNonAbstractAsset);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder forceNonAbstractAssets(final java.util.Collection<? extends String> forceNonAbstractAssets) {
            if (forceNonAbstractAssets == null) {
                throw new java.lang.NullPointerException("forceNonAbstractAssets cannot be null");
            }
            if (this.forceNonAbstractAssets == null) this.forceNonAbstractAssets = new java.util.ArrayList<String>();
            this.forceNonAbstractAssets.addAll(forceNonAbstractAssets);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder clearForceNonAbstractAssets() {
            if (this.forceNonAbstractAssets != null) this.forceNonAbstractAssets.clear();
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder singularForAttribute(final String singularForAttributeKey, final String singularForAttributeValue) {
            if (this.singularForAttributes$key == null) {
                this.singularForAttributes$key = new java.util.ArrayList<String>();
                this.singularForAttributes$value = new java.util.ArrayList<String>();
            }
            this.singularForAttributes$key.add(singularForAttributeKey);
            this.singularForAttributes$value.add(singularForAttributeValue);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder singularForAttributes(final java.util.Map<? extends String, ? extends String> singularForAttributes) {
            if (singularForAttributes == null) {
                throw new java.lang.NullPointerException("singularForAttributes cannot be null");
            }
            if (this.singularForAttributes$key == null) {
                this.singularForAttributes$key = new java.util.ArrayList<String>();
                this.singularForAttributes$value = new java.util.ArrayList<String>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends String> $lombokEntry : singularForAttributes.entrySet()) {
                this.singularForAttributes$key.add($lombokEntry.getKey());
                this.singularForAttributes$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder clearSingularForAttributes() {
            if (this.singularForAttributes$key != null) {
                this.singularForAttributes$key.clear();
                this.singularForAttributes$value.clear();
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder renameAttribute(final String renameAttributeKey, final String renameAttributeValue) {
            if (this.renameAttributes$key == null) {
                this.renameAttributes$key = new java.util.ArrayList<String>();
                this.renameAttributes$value = new java.util.ArrayList<String>();
            }
            this.renameAttributes$key.add(renameAttributeKey);
            this.renameAttributes$value.add(renameAttributeValue);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder renameAttributes(final java.util.Map<? extends String, ? extends String> renameAttributes) {
            if (renameAttributes == null) {
                throw new java.lang.NullPointerException("renameAttributes cannot be null");
            }
            if (this.renameAttributes$key == null) {
                this.renameAttributes$key = new java.util.ArrayList<String>();
                this.renameAttributes$value = new java.util.ArrayList<String>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends String> $lombokEntry : renameAttributes.entrySet()) {
                this.renameAttributes$key.add($lombokEntry.getKey());
                this.renameAttributes$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder clearRenameAttributes() {
            if (this.renameAttributes$key != null) {
                this.renameAttributes$key.clear();
                this.renameAttributes$value.clear();
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder attributeToEnum(final String attributeToEnumKey, final String attributeToEnumValue) {
            if (this.attributeToEnums$key == null) {
                this.attributeToEnums$key = new java.util.ArrayList<String>();
                this.attributeToEnums$value = new java.util.ArrayList<String>();
            }
            this.attributeToEnums$key.add(attributeToEnumKey);
            this.attributeToEnums$value.add(attributeToEnumValue);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder attributeToEnums(final java.util.Map<? extends String, ? extends String> attributeToEnums) {
            if (attributeToEnums == null) {
                throw new java.lang.NullPointerException("attributeToEnums cannot be null");
            }
            if (this.attributeToEnums$key == null) {
                this.attributeToEnums$key = new java.util.ArrayList<String>();
                this.attributeToEnums$value = new java.util.ArrayList<String>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends String> $lombokEntry : attributeToEnums.entrySet()) {
                this.attributeToEnums$key.add($lombokEntry.getKey());
                this.attributeToEnums$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder clearAttributeToEnums() {
            if (this.attributeToEnums$key != null) {
                this.attributeToEnums$key.clear();
                this.attributeToEnums$value.clear();
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder retypeAttribute(final String retypeAttributeKey, final Map<String, String> retypeAttributeValue) {
            if (this.retypeAttributes$key == null) {
                this.retypeAttributes$key = new java.util.ArrayList<String>();
                this.retypeAttributes$value = new java.util.ArrayList<Map<String, String>>();
            }
            this.retypeAttributes$key.add(retypeAttributeKey);
            this.retypeAttributes$value.add(retypeAttributeValue);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder retypeAttributes(final java.util.Map<? extends String, ? extends Map<String, String>> retypeAttributes) {
            if (retypeAttributes == null) {
                throw new java.lang.NullPointerException("retypeAttributes cannot be null");
            }
            if (this.retypeAttributes$key == null) {
                this.retypeAttributes$key = new java.util.ArrayList<String>();
                this.retypeAttributes$value = new java.util.ArrayList<Map<String, String>>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends Map<String, String>> $lombokEntry : retypeAttributes.entrySet()) {
                this.retypeAttributes$key.add($lombokEntry.getKey());
                this.retypeAttributes$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder clearRetypeAttributes() {
            if (this.retypeAttributes$key != null) {
                this.retypeAttributes$key.clear();
                this.retypeAttributes$value.clear();
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder searchableRelationship(final String searchableRelationshipKey, final String searchableRelationshipValue) {
            if (this.searchableRelationships$key == null) {
                this.searchableRelationships$key = new java.util.ArrayList<String>();
                this.searchableRelationships$value = new java.util.ArrayList<String>();
            }
            this.searchableRelationships$key.add(searchableRelationshipKey);
            this.searchableRelationships$value.add(searchableRelationshipValue);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder searchableRelationships(final java.util.Map<? extends String, ? extends String> searchableRelationships) {
            if (searchableRelationships == null) {
                throw new java.lang.NullPointerException("searchableRelationships cannot be null");
            }
            if (this.searchableRelationships$key == null) {
                this.searchableRelationships$key = new java.util.ArrayList<String>();
                this.searchableRelationships$value = new java.util.ArrayList<String>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends String> $lombokEntry : searchableRelationships.entrySet()) {
                this.searchableRelationships$key.add($lombokEntry.getKey());
                this.searchableRelationships$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig.GeneratorConfigBuilder clearSearchableRelationships() {
            if (this.searchableRelationships$key != null) {
                this.searchableRelationships$key.clear();
                this.searchableRelationships$value.clear();
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GeneratorConfig build() {
            java.util.Set<String> serviceTypes;
            switch (this.serviceTypes == null ? 0 : this.serviceTypes.size()) {
            case 0: 
                serviceTypes = java.util.Collections.emptySet();
                break;
            case 1: 
                serviceTypes = java.util.Collections.singleton(this.serviceTypes.get(0));
                break;
            default: 
                serviceTypes = new java.util.LinkedHashSet<String>(this.serviceTypes.size() < 1073741824 ? 1 + this.serviceTypes.size() + (this.serviceTypes.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
                serviceTypes.addAll(this.serviceTypes);
                serviceTypes = java.util.Collections.unmodifiableSet(serviceTypes);
            }
            java.util.Map<String, String> renameClasses;
            switch (this.renameClasses$key == null ? 0 : this.renameClasses$key.size()) {
            case 0: 
                renameClasses = java.util.Collections.emptyMap();
                break;
            case 1: 
                renameClasses = java.util.Collections.singletonMap(this.renameClasses$key.get(0), this.renameClasses$value.get(0));
                break;
            default: 
                renameClasses = new java.util.LinkedHashMap<String, String>(this.renameClasses$key.size() < 1073741824 ? 1 + this.renameClasses$key.size() + (this.renameClasses$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
                for (int $i = 0; $i < this.renameClasses$key.size(); $i++) renameClasses.put(this.renameClasses$key.get($i), (String) this.renameClasses$value.get($i));
                renameClasses = java.util.Collections.unmodifiableMap(renameClasses);
            }
            java.util.Map<String, String> renameEnumValues;
            switch (this.renameEnumValues$key == null ? 0 : this.renameEnumValues$key.size()) {
            case 0: 
                renameEnumValues = java.util.Collections.emptyMap();
                break;
            case 1: 
                renameEnumValues = java.util.Collections.singletonMap(this.renameEnumValues$key.get(0), this.renameEnumValues$value.get(0));
                break;
            default: 
                renameEnumValues = new java.util.LinkedHashMap<String, String>(this.renameEnumValues$key.size() < 1073741824 ? 1 + this.renameEnumValues$key.size() + (this.renameEnumValues$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
                for (int $i = 0; $i < this.renameEnumValues$key.size(); $i++) renameEnumValues.put(this.renameEnumValues$key.get($i), (String) this.renameEnumValues$value.get($i));
                renameEnumValues = java.util.Collections.unmodifiableMap(renameEnumValues);
            }
            java.util.Set<String> doNotGenerateAssets;
            switch (this.doNotGenerateAssets == null ? 0 : this.doNotGenerateAssets.size()) {
            case 0: 
                doNotGenerateAssets = java.util.Collections.emptySet();
                break;
            case 1: 
                doNotGenerateAssets = java.util.Collections.singleton(this.doNotGenerateAssets.get(0));
                break;
            default: 
                doNotGenerateAssets = new java.util.LinkedHashSet<String>(this.doNotGenerateAssets.size() < 1073741824 ? 1 + this.doNotGenerateAssets.size() + (this.doNotGenerateAssets.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
                doNotGenerateAssets.addAll(this.doNotGenerateAssets);
                doNotGenerateAssets = java.util.Collections.unmodifiableSet(doNotGenerateAssets);
            }
            java.util.Set<String> forceNonAbstractAssets;
            switch (this.forceNonAbstractAssets == null ? 0 : this.forceNonAbstractAssets.size()) {
            case 0: 
                forceNonAbstractAssets = java.util.Collections.emptySet();
                break;
            case 1: 
                forceNonAbstractAssets = java.util.Collections.singleton(this.forceNonAbstractAssets.get(0));
                break;
            default: 
                forceNonAbstractAssets = new java.util.LinkedHashSet<String>(this.forceNonAbstractAssets.size() < 1073741824 ? 1 + this.forceNonAbstractAssets.size() + (this.forceNonAbstractAssets.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
                forceNonAbstractAssets.addAll(this.forceNonAbstractAssets);
                forceNonAbstractAssets = java.util.Collections.unmodifiableSet(forceNonAbstractAssets);
            }
            java.util.Map<String, String> singularForAttributes;
            switch (this.singularForAttributes$key == null ? 0 : this.singularForAttributes$key.size()) {
            case 0: 
                singularForAttributes = java.util.Collections.emptyMap();
                break;
            case 1: 
                singularForAttributes = java.util.Collections.singletonMap(this.singularForAttributes$key.get(0), this.singularForAttributes$value.get(0));
                break;
            default: 
                singularForAttributes = new java.util.LinkedHashMap<String, String>(this.singularForAttributes$key.size() < 1073741824 ? 1 + this.singularForAttributes$key.size() + (this.singularForAttributes$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
                for (int $i = 0; $i < this.singularForAttributes$key.size(); $i++) singularForAttributes.put(this.singularForAttributes$key.get($i), (String) this.singularForAttributes$value.get($i));
                singularForAttributes = java.util.Collections.unmodifiableMap(singularForAttributes);
            }
            java.util.Map<String, String> renameAttributes;
            switch (this.renameAttributes$key == null ? 0 : this.renameAttributes$key.size()) {
            case 0: 
                renameAttributes = java.util.Collections.emptyMap();
                break;
            case 1: 
                renameAttributes = java.util.Collections.singletonMap(this.renameAttributes$key.get(0), this.renameAttributes$value.get(0));
                break;
            default: 
                renameAttributes = new java.util.LinkedHashMap<String, String>(this.renameAttributes$key.size() < 1073741824 ? 1 + this.renameAttributes$key.size() + (this.renameAttributes$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
                for (int $i = 0; $i < this.renameAttributes$key.size(); $i++) renameAttributes.put(this.renameAttributes$key.get($i), (String) this.renameAttributes$value.get($i));
                renameAttributes = java.util.Collections.unmodifiableMap(renameAttributes);
            }
            java.util.Map<String, String> attributeToEnums;
            switch (this.attributeToEnums$key == null ? 0 : this.attributeToEnums$key.size()) {
            case 0: 
                attributeToEnums = java.util.Collections.emptyMap();
                break;
            case 1: 
                attributeToEnums = java.util.Collections.singletonMap(this.attributeToEnums$key.get(0), this.attributeToEnums$value.get(0));
                break;
            default: 
                attributeToEnums = new java.util.LinkedHashMap<String, String>(this.attributeToEnums$key.size() < 1073741824 ? 1 + this.attributeToEnums$key.size() + (this.attributeToEnums$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
                for (int $i = 0; $i < this.attributeToEnums$key.size(); $i++) attributeToEnums.put(this.attributeToEnums$key.get($i), (String) this.attributeToEnums$value.get($i));
                attributeToEnums = java.util.Collections.unmodifiableMap(attributeToEnums);
            }
            java.util.Map<String, Map<String, String>> retypeAttributes;
            switch (this.retypeAttributes$key == null ? 0 : this.retypeAttributes$key.size()) {
            case 0: 
                retypeAttributes = java.util.Collections.emptyMap();
                break;
            case 1: 
                retypeAttributes = java.util.Collections.singletonMap(this.retypeAttributes$key.get(0), this.retypeAttributes$value.get(0));
                break;
            default: 
                retypeAttributes = new java.util.LinkedHashMap<String, Map<String, String>>(this.retypeAttributes$key.size() < 1073741824 ? 1 + this.retypeAttributes$key.size() + (this.retypeAttributes$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
                for (int $i = 0; $i < this.retypeAttributes$key.size(); $i++) retypeAttributes.put(this.retypeAttributes$key.get($i), (Map<String, String>) this.retypeAttributes$value.get($i));
                retypeAttributes = java.util.Collections.unmodifiableMap(retypeAttributes);
            }
            java.util.Map<String, String> searchableRelationships;
            switch (this.searchableRelationships$key == null ? 0 : this.searchableRelationships$key.size()) {
            case 0: 
                searchableRelationships = java.util.Collections.emptyMap();
                break;
            case 1: 
                searchableRelationships = java.util.Collections.singletonMap(this.searchableRelationships$key.get(0), this.searchableRelationships$value.get(0));
                break;
            default: 
                searchableRelationships = new java.util.LinkedHashMap<String, String>(this.searchableRelationships$key.size() < 1073741824 ? 1 + this.searchableRelationships$key.size() + (this.searchableRelationships$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
                for (int $i = 0; $i < this.searchableRelationships$key.size(); $i++) searchableRelationships.put(this.searchableRelationships$key.get($i), (String) this.searchableRelationships$value.get($i));
                searchableRelationships = java.util.Collections.unmodifiableMap(searchableRelationships);
            }
            boolean preferTypeDefDescriptions$value = this.preferTypeDefDescriptions$value;
            if (!this.preferTypeDefDescriptions$set) preferTypeDefDescriptions$value = GeneratorConfig.$default$preferTypeDefDescriptions();
            return new GeneratorConfig(this.freemarkerConfig, this.packageRoot, this.packagePath, this.testPath, this.generatorName, preferTypeDefDescriptions$value, serviceTypes, renameClasses, renameEnumValues, doNotGenerateAssets, forceNonAbstractAssets, singularForAttributes, renameAttributes, attributeToEnums, retypeAttributes, searchableRelationships);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "GeneratorConfig.GeneratorConfigBuilder(freemarkerConfig=" + this.freemarkerConfig + ", packageRoot=" + this.packageRoot + ", packagePath=" + this.packagePath + ", testPath=" + this.testPath + ", generatorName=" + this.generatorName + ", preferTypeDefDescriptions$value=" + this.preferTypeDefDescriptions$value + ", serviceTypes=" + this.serviceTypes + ", renameClasses$key=" + this.renameClasses$key + ", renameClasses$value=" + this.renameClasses$value + ", renameEnumValues$key=" + this.renameEnumValues$key + ", renameEnumValues$value=" + this.renameEnumValues$value + ", doNotGenerateAssets=" + this.doNotGenerateAssets + ", forceNonAbstractAssets=" + this.forceNonAbstractAssets + ", singularForAttributes$key=" + this.singularForAttributes$key + ", singularForAttributes$value=" + this.singularForAttributes$value + ", renameAttributes$key=" + this.renameAttributes$key + ", renameAttributes$value=" + this.renameAttributes$value + ", attributeToEnums$key=" + this.attributeToEnums$key + ", attributeToEnums$value=" + this.attributeToEnums$value + ", retypeAttributes$key=" + this.retypeAttributes$key + ", retypeAttributes$value=" + this.retypeAttributes$value + ", searchableRelationships$key=" + this.searchableRelationships$key + ", searchableRelationships$value=" + this.searchableRelationships$value + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static GeneratorConfig.GeneratorConfigBuilder builder() {
        return new GeneratorConfig.GeneratorConfigBuilder();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Configuration getFreemarkerConfig() {
        return this.freemarkerConfig;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPackageRoot() {
        return this.packageRoot;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPackagePath() {
        return this.packagePath;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTestPath() {
        return this.testPath;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getGeneratorName() {
        return this.generatorName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean getPreferTypeDefDescriptions() {
        return this.preferTypeDefDescriptions;
    }
}
