// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2023 Atlan Pte. Ltd. */
package com.atlan.generators;

import com.atlan.model.typedefs.AttributeDef;
import com.atlan.model.typedefs.StructDef;
import com.atlan.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class StructGenerator extends TypeGenerator {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(StructGenerator.class);
    public static final String DIRECTORY = "structs";
    private final StructDef structDef;
    private List<Attribute> attributes;
    private List<String> mapContainers = null;

    public StructGenerator(StructDef structDef, GeneratorConfig cfg) {
        super(structDef, cfg);
        this.structDef = structDef;
        resolveClassName();
        super.description = cache.getTypeDescription(originalName);
        resolveAttributes();
    }

    @Override
    protected void resolveClassName() {
        super.className = cfg.resolveClassName(getOriginalName());
    }

    private void resolveAttributes() {
        attributes = new ArrayList<>();
        for (AttributeDef attributeDef : structDef.getAttributeDefs()) {
            Attribute attribute = new Attribute(className, attributeDef, cfg);
            if (className.equals("BadgeCondition") && attribute.getRenamed().equals("badgeConditionOperator")) {
                attribute.setType(MappedType.builder().type(MappedType.Type.ENUM).name("BadgeComparisonOperator").build());
            }
            attributes.add(attribute);
            checkAndAddMapContainer(attribute);
        }
    }

    private void checkAndAddMapContainer(Attribute attribute) {
        if (attribute.getType().getContainer() != null && attribute.getType().getContainer().contains("Map")) {
            if (mapContainers == null) {
                mapContainers = new ArrayList<>();
            }
            mapContainers.add(attribute.getRenamed());
        }
    }


    public static final class Attribute extends AttributeGenerator {
        public Attribute(String className, AttributeDef attributeDef, GeneratorConfig cfg) {
            super(className, attributeDef, cfg);
        }

        @Override
        protected void resolveName() {
            super.resolveName();
            setRenamed(cfg.resolveAttributeName(getOriginalName()));
            setSnakeCaseRenamed(StringUtils.getLowerSnakeCase(getRenamed()));
        }

        @Override
        protected void resolveType(AttributeDef attributeDef) {
            super.resolveType(attributeDef);
            if (attributeDef.getTypeName().startsWith("array<")) {
                // Always use lists in structs, not sorted sets
                setType(getType().toBuilder().container("List<").build());
            }
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public StructDef getStructDef() {
        return this.structDef;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getMapContainers() {
        return this.mapContainers;
    }
}
