// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2023 Atlan Pte. Ltd. */
package com.atlan.generators;

import com.atlan.api.TypeDefsEndpoint;
import com.atlan.model.typedefs.AttributeDef;
import com.atlan.model.typedefs.EntityDef;
import com.atlan.model.typedefs.EnumDef;
import com.atlan.model.typedefs.StructDef;
import com.atlan.model.typedefs.TypeDef;
import freemarker.template.TemplateNotFoundException;
import java.io.IOException;
import java.util.Map;

public abstract class TypeGenerator {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(TypeGenerator.class);
    protected static final Map<String, String> PRIMITIVE_MAPPINGS = Map.ofEntries(Map.entry("string", "String"), Map.entry("boolean", "Boolean"), Map.entry("int", "Integer"), Map.entry("long", "Long"), Map.entry("date", "Long"), Map.entry("float", "Double"), Map.entry("string,string", "String, String"), Map.entry("string,long", "String, Long"));
    protected String generatorName;
    protected String packageRoot;
    protected String originalName;
    protected String className;
    protected String description;
    protected GeneratorConfig cfg;
    protected ModelCache cache;

    protected TypeGenerator(GeneratorConfig cfg) {
        this.cfg = cfg;
        this.cache = ModelCache.getInstance();
        this.packageRoot = cfg.getPackageRoot();
        this.generatorName = cfg.getGeneratorName();
    }

    protected TypeGenerator(TypeDef typeDef, GeneratorConfig cfg) {
        this.originalName = typeDef.getDisplayName() == null ? typeDef.getName() : typeDef.getDisplayName();
        this.cfg = cfg;
        this.cache = ModelCache.getInstance();
        this.packageRoot = cfg.getPackageRoot();
        this.generatorName = cfg.getGeneratorName();
    }

    protected abstract void resolveClassName();

    protected MappedType getMappedType(String type) {
        // First look for contained types...
        String baseType = AttributeDef.getBasicType(type);
        String container = AttributeDef.getContainerType(type);
        MappedType.MappedTypeBuilder builder = MappedType.builder().originalBase(baseType);
        // First try to map a primitive type
        String primitiveName = PRIMITIVE_MAPPINGS.getOrDefault(baseType, null);
        if (primitiveName != null) {
            builder.type(MappedType.Type.PRIMITIVE).name(primitiveName);
        } else {
            // Failing that, attempt to map to a cached type (enum, struct, etc)
            MappedType mappedType = cache.getCachedType(baseType);
            if (mappedType == null) {
                // Failing that, fall-back to just the name of the object
                builder.type(MappedType.Type.ASSET).name(baseType);
            } else {
                MappedType.Type baseTypeOfMapped = mappedType.getType();
                builder.type(baseTypeOfMapped).name(mappedType.getName());
                if (baseTypeOfMapped == MappedType.Type.STRUCT && container != null) {
                    // If the referred object is a struct, change the container to a list rather
                    // than a set
                    container = "List<";
                }
            }
        }
        if (container != null) {
            builder.container(container);
        }
        return builder.build();
    }

    public String getClassTemplateFile() {
        try {
            return cfg.getFreemarkerConfig().getTemplate(className + ".ftl").getSourceName();
        } catch (TemplateNotFoundException e) {
        } catch (
        // Do nothing - no template to load or otherwise handle
        IOException e) {
            log.error("Error reading template: {}.ftl", className, e);
        }
        return null;
    }

    public boolean isBuiltIn(String orgName, String reTyped) {
        if (orgName != null) {
            EntityDef entity = cache.getEntityDefCache().get(orgName);
            if (entity != null) {
                return (entity.getServiceType() != null && TypeDefsEndpoint.RESERVED_SERVICE_TYPES.contains(entity.getServiceType()));
            } else {
                StructDef struct = cache.getStructDefCache().get(orgName);
                if (struct != null) {
                    return (struct.getServiceType() != null && TypeDefsEndpoint.RESERVED_SERVICE_TYPES.contains(struct.getServiceType())) || GeneratorConfig.BUILT_IN_STRUCTS.contains(orgName);
                } else {
                    EnumDef enumDef = cache.getEnumDefCache().get(orgName);
                    return (enumDef != null && enumDef.getServiceType() != null && TypeDefsEndpoint.RESERVED_SERVICE_TYPES.contains(enumDef.getServiceType())) || GeneratorConfig.BUILT_IN_ENUMS.contains(orgName) || (orgName.equals("string") && GeneratorConfig.BUILT_IN_ENUMS.contains(reTyped));
                }
            }
        }
        return false;
    }


    public static final class MappedType {

        public enum Type {
            PRIMITIVE, ENUM, STRUCT, ASSET;
        }

        private String originalBase;
        private String name;
        private String container;
        private Type type;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        MappedType(final String originalBase, final String name, final String container, final Type type) {
            this.originalBase = originalBase;
            this.name = name;
            this.container = container;
            this.type = type;
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static class MappedTypeBuilder {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String originalBase;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String name;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String container;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Type type;

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            MappedTypeBuilder() {
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public TypeGenerator.MappedType.MappedTypeBuilder originalBase(final String originalBase) {
                this.originalBase = originalBase;
                return this;
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public TypeGenerator.MappedType.MappedTypeBuilder name(final String name) {
                this.name = name;
                return this;
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public TypeGenerator.MappedType.MappedTypeBuilder container(final String container) {
                this.container = container;
                return this;
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public TypeGenerator.MappedType.MappedTypeBuilder type(final Type type) {
                this.type = type;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public TypeGenerator.MappedType build() {
                return new TypeGenerator.MappedType(this.originalBase, this.name, this.container, this.type);
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public java.lang.String toString() {
                return "TypeGenerator.MappedType.MappedTypeBuilder(originalBase=" + this.originalBase + ", name=" + this.name + ", container=" + this.container + ", type=" + this.type + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static TypeGenerator.MappedType.MappedTypeBuilder builder() {
            return new TypeGenerator.MappedType.MappedTypeBuilder();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public TypeGenerator.MappedType.MappedTypeBuilder toBuilder() {
            return new TypeGenerator.MappedType.MappedTypeBuilder().originalBase(this.originalBase).name(this.name).container(this.container).type(this.type);
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getOriginalBase() {
            return this.originalBase;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getName() {
            return this.name;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getContainer() {
            return this.container;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Type getType() {
            return this.type;
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getGeneratorName() {
        return this.generatorName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPackageRoot() {
        return this.packageRoot;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getOriginalName() {
        return this.originalName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getClassName() {
        return this.className;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDescription() {
        return this.description;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public GeneratorConfig getCfg() {
        return this.cfg;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ModelCache getCache() {
        return this.cache;
    }
}
