// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.admin;

import com.atlan.model.core.AtlanObject;
import java.util.Comparator;

public abstract class AbstractPolicy extends AtlanObject implements Comparable<AbstractPolicy> {
    private static final long serialVersionUID = 2L;
    // Sort policies in a set based first on their name (mandatory and required to be unique)
    private static final Comparator<String> stringComparator = Comparator.nullsFirst(String::compareTo);
    private static final Comparator<AbstractPolicy> policyComparator = Comparator.comparing(AbstractPolicy::getName, stringComparator);
    /**
     * Unique identifier (GUID) of the policy.
     */
    final String id;
    /**
     * Name of the policy.
     */
    String name;
    /**
     * Explanation of the policy.
     */
    String description;
    /**
     * Whether the actions are granted (true) or explicitly denied (false).
     */
    Boolean allow;
    /**
     * Time (epoch) at which this policy was created, in milliseconds.
     */
    final Long createdAt;
    /**
     * Username of the user who created this policy.
     */
    final String createdBy;
    /**
     * Time (epoch) at which this policy was updated, in milliseconds.
     */
    final Long updatedAt;
    /**
     * Username of the user who updated this policy.
     */
    final String updatedBy;

    /**
     * {@inheritDoc}
     */
    @Override
    public int compareTo(AbstractPolicy o) {
        return policyComparator.compare(this, o);
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class AbstractPolicyBuilder<C extends AbstractPolicy, B extends AbstractPolicy.AbstractPolicyBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String id;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String name;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String description;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean allow;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long createdAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String createdBy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long updatedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String updatedBy;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            AbstractPolicy.AbstractPolicyBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final AbstractPolicy instance, final AbstractPolicy.AbstractPolicyBuilder<?, ?> b) {
            b.id(instance.id);
            b.name(instance.name);
            b.description(instance.description);
            b.allow(instance.allow);
            b.createdAt(instance.createdAt);
            b.createdBy(instance.createdBy);
            b.updatedAt(instance.updatedAt);
            b.updatedBy(instance.updatedBy);
        }

        /**
         * Unique identifier (GUID) of the policy.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B id(final String id) {
            this.id = id;
            return self();
        }

        /**
         * Name of the policy.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B name(final String name) {
            this.name = name;
            return self();
        }

        /**
         * Explanation of the policy.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B description(final String description) {
            this.description = description;
            return self();
        }

        /**
         * Whether the actions are granted (true) or explicitly denied (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B allow(final Boolean allow) {
            this.allow = allow;
            return self();
        }

        /**
         * Time (epoch) at which this policy was created, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B createdAt(final Long createdAt) {
            this.createdAt = createdAt;
            return self();
        }

        /**
         * Username of the user who created this policy.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B createdBy(final String createdBy) {
            this.createdBy = createdBy;
            return self();
        }

        /**
         * Time (epoch) at which this policy was updated, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B updatedAt(final Long updatedAt) {
            this.updatedAt = updatedAt;
            return self();
        }

        /**
         * Username of the user who updated this policy.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B updatedBy(final String updatedBy) {
            this.updatedBy = updatedBy;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AbstractPolicy.AbstractPolicyBuilder(super=" + super.toString() + ", id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", allow=" + this.allow + ", createdAt=" + this.createdAt + ", createdBy=" + this.createdBy + ", updatedAt=" + this.updatedAt + ", updatedBy=" + this.updatedBy + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected AbstractPolicy(final AbstractPolicy.AbstractPolicyBuilder<?, ?> b) {
        super(b);
        this.id = b.id;
        this.name = b.name;
        this.description = b.description;
        this.allow = b.allow;
        this.createdAt = b.createdAt;
        this.createdBy = b.createdBy;
        this.updatedAt = b.updatedAt;
        this.updatedBy = b.updatedBy;
    }

    /**
     * Unique identifier (GUID) of the policy.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getId() {
        return this.id;
    }

    /**
     * Name of the policy.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
        return this.name;
    }

    /**
     * Explanation of the policy.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Whether the actions are granted (true) or explicitly denied (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getAllow() {
        return this.allow;
    }

    /**
     * Time (epoch) at which this policy was created, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCreatedAt() {
        return this.createdAt;
    }

    /**
     * Username of the user who created this policy.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    /**
     * Time (epoch) at which this policy was updated, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    /**
     * Username of the user who updated this policy.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AbstractPolicy)) return false;
        final AbstractPolicy other = (AbstractPolicy) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$allow = this.getAllow();
        final java.lang.Object other$allow = other.getAllow();
        if (this$allow == null ? other$allow != null : !this$allow.equals(other$allow)) return false;
        final java.lang.Object this$createdAt = this.getCreatedAt();
        final java.lang.Object other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !this$createdAt.equals(other$createdAt)) return false;
        final java.lang.Object this$updatedAt = this.getUpdatedAt();
        final java.lang.Object other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !this$updatedAt.equals(other$updatedAt)) return false;
        final java.lang.Object this$id = this.getId();
        final java.lang.Object other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$description = this.getDescription();
        final java.lang.Object other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
        final java.lang.Object this$createdBy = this.getCreatedBy();
        final java.lang.Object other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) return false;
        final java.lang.Object this$updatedBy = this.getUpdatedBy();
        final java.lang.Object other$updatedBy = other.getUpdatedBy();
        if (this$updatedBy == null ? other$updatedBy != null : !this$updatedBy.equals(other$updatedBy)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AbstractPolicy;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $allow = this.getAllow();
        result = result * PRIME + ($allow == null ? 43 : $allow.hashCode());
        final java.lang.Object $createdAt = this.getCreatedAt();
        result = result * PRIME + ($createdAt == null ? 43 : $createdAt.hashCode());
        final java.lang.Object $updatedAt = this.getUpdatedAt();
        result = result * PRIME + ($updatedAt == null ? 43 : $updatedAt.hashCode());
        final java.lang.Object $id = this.getId();
        result = result * PRIME + ($id == null ? 43 : $id.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $description = this.getDescription();
        result = result * PRIME + ($description == null ? 43 : $description.hashCode());
        final java.lang.Object $createdBy = this.getCreatedBy();
        result = result * PRIME + ($createdBy == null ? 43 : $createdBy.hashCode());
        final java.lang.Object $updatedBy = this.getUpdatedBy();
        result = result * PRIME + ($updatedBy == null ? 43 : $updatedBy.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "AbstractPolicy(super=" + super.toString() + ", id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", allow=" + this.getAllow() + ", createdAt=" + this.getCreatedAt() + ", createdBy=" + this.getCreatedBy() + ", updatedAt=" + this.getUpdatedAt() + ", updatedBy=" + this.getUpdatedBy() + ")";
    }
}
