// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2023 Atlan Pte. Ltd. */
package com.atlan.model.admin;

import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.AdminOperationType;
import com.atlan.model.enums.AdminResourceType;

@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = AdminEvent.AdminEventBuilderImpl.class)
public class AdminEvent extends AtlanObject {
    private static final long serialVersionUID = 2L;
    /**
     * Type of admin operation that occurred.
     */
    AdminOperationType operationType;
    /**
     * Unique identifier of the realm in which the event occurred (usually {@code default}).
     */
    String realmId;
    /**
     * Detailed resource that was created or changed as a result of the operation.
     */
    String representation;
    /**
     * Location of the resource that was created or changed as a result of the operation.
     */
    String resourcePath;
    /**
     * Type of resource for the admin operation that occurred.
     */
    AdminResourceType resourceType;
    /**
     * Time (epoch) when the admin operation occurred, in milliseconds.
     */
    Long time;
    /**
     * Details of who carried out the operation.
     */
    AuthDetails authDetails;


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class AdminEventBuilder<C extends AdminEvent, B extends AdminEvent.AdminEventBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AdminOperationType operationType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String realmId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String representation;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String resourcePath;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AdminResourceType resourceType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long time;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AuthDetails authDetails;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            AdminEvent.AdminEventBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final AdminEvent instance, final AdminEvent.AdminEventBuilder<?, ?> b) {
            b.operationType(instance.operationType);
            b.realmId(instance.realmId);
            b.representation(instance.representation);
            b.resourcePath(instance.resourcePath);
            b.resourceType(instance.resourceType);
            b.time(instance.time);
            b.authDetails(instance.authDetails);
        }

        /**
         * Type of admin operation that occurred.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B operationType(final AdminOperationType operationType) {
            this.operationType = operationType;
            return self();
        }

        /**
         * Unique identifier of the realm in which the event occurred (usually {@code default}).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B realmId(final String realmId) {
            this.realmId = realmId;
            return self();
        }

        /**
         * Detailed resource that was created or changed as a result of the operation.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B representation(final String representation) {
            this.representation = representation;
            return self();
        }

        /**
         * Location of the resource that was created or changed as a result of the operation.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B resourcePath(final String resourcePath) {
            this.resourcePath = resourcePath;
            return self();
        }

        /**
         * Type of resource for the admin operation that occurred.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B resourceType(final AdminResourceType resourceType) {
            this.resourceType = resourceType;
            return self();
        }

        /**
         * Time (epoch) when the admin operation occurred, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B time(final Long time) {
            this.time = time;
            return self();
        }

        /**
         * Details of who carried out the operation.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B authDetails(final AuthDetails authDetails) {
            this.authDetails = authDetails;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AdminEvent.AdminEventBuilder(super=" + super.toString() + ", operationType=" + this.operationType + ", realmId=" + this.realmId + ", representation=" + this.representation + ", resourcePath=" + this.resourcePath + ", resourceType=" + this.resourceType + ", time=" + this.time + ", authDetails=" + this.authDetails + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    static final class AdminEventBuilderImpl extends AdminEvent.AdminEventBuilder<AdminEvent, AdminEvent.AdminEventBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AdminEventBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected AdminEvent.AdminEventBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AdminEvent build() {
            return new AdminEvent(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected AdminEvent(final AdminEvent.AdminEventBuilder<?, ?> b) {
        super(b);
        this.operationType = b.operationType;
        this.realmId = b.realmId;
        this.representation = b.representation;
        this.resourcePath = b.resourcePath;
        this.resourceType = b.resourceType;
        this.time = b.time;
        this.authDetails = b.authDetails;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static AdminEvent.AdminEventBuilder<?, ?> builder() {
        return new AdminEvent.AdminEventBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AdminEvent.AdminEventBuilder<?, ?> toBuilder() {
        return new AdminEvent.AdminEventBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Type of admin operation that occurred.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AdminOperationType getOperationType() {
        return this.operationType;
    }

    /**
     * Unique identifier of the realm in which the event occurred (usually {@code default}).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRealmId() {
        return this.realmId;
    }

    /**
     * Detailed resource that was created or changed as a result of the operation.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRepresentation() {
        return this.representation;
    }

    /**
     * Location of the resource that was created or changed as a result of the operation.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getResourcePath() {
        return this.resourcePath;
    }

    /**
     * Type of resource for the admin operation that occurred.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AdminResourceType getResourceType() {
        return this.resourceType;
    }

    /**
     * Time (epoch) when the admin operation occurred, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getTime() {
        return this.time;
    }

    /**
     * Details of who carried out the operation.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AuthDetails getAuthDetails() {
        return this.authDetails;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AdminEvent)) return false;
        final AdminEvent other = (AdminEvent) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$time = this.getTime();
        final java.lang.Object other$time = other.getTime();
        if (this$time == null ? other$time != null : !this$time.equals(other$time)) return false;
        final java.lang.Object this$operationType = this.getOperationType();
        final java.lang.Object other$operationType = other.getOperationType();
        if (this$operationType == null ? other$operationType != null : !this$operationType.equals(other$operationType)) return false;
        final java.lang.Object this$realmId = this.getRealmId();
        final java.lang.Object other$realmId = other.getRealmId();
        if (this$realmId == null ? other$realmId != null : !this$realmId.equals(other$realmId)) return false;
        final java.lang.Object this$representation = this.getRepresentation();
        final java.lang.Object other$representation = other.getRepresentation();
        if (this$representation == null ? other$representation != null : !this$representation.equals(other$representation)) return false;
        final java.lang.Object this$resourcePath = this.getResourcePath();
        final java.lang.Object other$resourcePath = other.getResourcePath();
        if (this$resourcePath == null ? other$resourcePath != null : !this$resourcePath.equals(other$resourcePath)) return false;
        final java.lang.Object this$resourceType = this.getResourceType();
        final java.lang.Object other$resourceType = other.getResourceType();
        if (this$resourceType == null ? other$resourceType != null : !this$resourceType.equals(other$resourceType)) return false;
        final java.lang.Object this$authDetails = this.getAuthDetails();
        final java.lang.Object other$authDetails = other.getAuthDetails();
        if (this$authDetails == null ? other$authDetails != null : !this$authDetails.equals(other$authDetails)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AdminEvent;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $time = this.getTime();
        result = result * PRIME + ($time == null ? 43 : $time.hashCode());
        final java.lang.Object $operationType = this.getOperationType();
        result = result * PRIME + ($operationType == null ? 43 : $operationType.hashCode());
        final java.lang.Object $realmId = this.getRealmId();
        result = result * PRIME + ($realmId == null ? 43 : $realmId.hashCode());
        final java.lang.Object $representation = this.getRepresentation();
        result = result * PRIME + ($representation == null ? 43 : $representation.hashCode());
        final java.lang.Object $resourcePath = this.getResourcePath();
        result = result * PRIME + ($resourcePath == null ? 43 : $resourcePath.hashCode());
        final java.lang.Object $resourceType = this.getResourceType();
        result = result * PRIME + ($resourceType == null ? 43 : $resourceType.hashCode());
        final java.lang.Object $authDetails = this.getAuthDetails();
        result = result * PRIME + ($authDetails == null ? 43 : $authDetails.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "AdminEvent(super=" + super.toString() + ", operationType=" + this.getOperationType() + ", realmId=" + this.getRealmId() + ", representation=" + this.getRepresentation() + ", resourcePath=" + this.getResourcePath() + ", resourceType=" + this.getResourceType() + ", time=" + this.getTime() + ", authDetails=" + this.getAuthDetails() + ")";
    }
}
