// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2023 Atlan Pte. Ltd. */
package com.atlan.model.admin;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.AdminOperationType;
import com.atlan.model.enums.AdminResourceType;
import java.util.List;
import lombok.*;

public class AdminEventRequest extends AtlanObject {
    private static final long serialVersionUID = 2L;
    /**
     * Unique identifier (GUID) of the client that carried out the operation.
     */
    String clientId;
    /**
     * IP address from which the operation was carried out.
     */
    String ipAddress;
    /**
     * Unique name of the realm from which the operation was carried out.
     */
    String realmId;
    /**
     * Unique identifier (GUID) of the user who carried out the operation.
     */
    String userId;
    /**
     * Earliest date from which to include events (format: yyyy-MM-dd).
     */
    String dateFrom;
    /**
     * Latest date up to which to include events (format: yyyy-MM-dd).
     */
    String dateTo;
    /**
     * Starting point for the events (for paging).
     */
    int offset;
    /**
     * Maximum number of events to retrieve (per page).
     */
    int size;
    /**
     * Include events only with the supplied types of operations.
     */
    List<AdminOperationType> operationTypes;
    /**
     * Include events only against the supplied resource.
     */
    String resourcePath;
    /**
     * Include events only against the supplied types of resources.
     */
    List<AdminResourceType> resourceTypes;

    /**
     * Search for admin events using the filters specified in this request object.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the admin events
     * @return the filtered admin events
     * @throws AtlanException on any issues interacting with the APIs
     */
    public AdminEventResponse search(AtlanClient client) throws AtlanException {
        return client.logs.getAdminEvents(this);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static int $default$offset() {
        return 0;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static int $default$size() {
        return 100;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class AdminEventRequestBuilder<C extends AdminEventRequest, B extends AdminEventRequest.AdminEventRequestBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String clientId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String ipAddress;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String realmId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String userId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dateFrom;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dateTo;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean offset$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private int offset$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean size$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private int size$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<AdminOperationType> operationTypes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String resourcePath;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<AdminResourceType> resourceTypes;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            AdminEventRequest.AdminEventRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final AdminEventRequest instance, final AdminEventRequest.AdminEventRequestBuilder<?, ?> b) {
            b.clientId(instance.clientId);
            b.ipAddress(instance.ipAddress);
            b.realmId(instance.realmId);
            b.userId(instance.userId);
            b.dateFrom(instance.dateFrom);
            b.dateTo(instance.dateTo);
            b.offset(instance.offset);
            b.size(instance.size);
            b.operationTypes(instance.operationTypes == null ? java.util.Collections.<AdminOperationType>emptyList() : instance.operationTypes);
            b.resourcePath(instance.resourcePath);
            b.resourceTypes(instance.resourceTypes == null ? java.util.Collections.<AdminResourceType>emptyList() : instance.resourceTypes);
        }

        /**
         * Unique identifier (GUID) of the client that carried out the operation.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clientId(final String clientId) {
            this.clientId = clientId;
            return self();
        }

        /**
         * IP address from which the operation was carried out.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B ipAddress(final String ipAddress) {
            this.ipAddress = ipAddress;
            return self();
        }

        /**
         * Unique name of the realm from which the operation was carried out.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B realmId(final String realmId) {
            this.realmId = realmId;
            return self();
        }

        /**
         * Unique identifier (GUID) of the user who carried out the operation.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B userId(final String userId) {
            this.userId = userId;
            return self();
        }

        /**
         * Earliest date from which to include events (format: yyyy-MM-dd).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dateFrom(final String dateFrom) {
            this.dateFrom = dateFrom;
            return self();
        }

        /**
         * Latest date up to which to include events (format: yyyy-MM-dd).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dateTo(final String dateTo) {
            this.dateTo = dateTo;
            return self();
        }

        /**
         * Starting point for the events (for paging).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B offset(final int offset) {
            this.offset$value = offset;
            offset$set = true;
            return self();
        }

        /**
         * Maximum number of events to retrieve (per page).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B size(final int size) {
            this.size$value = size;
            size$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B operationType(final AdminOperationType operationType) {
            if (this.operationTypes == null) this.operationTypes = new java.util.ArrayList<AdminOperationType>();
            this.operationTypes.add(operationType);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B operationTypes(final java.util.Collection<? extends AdminOperationType> operationTypes) {
            if (operationTypes == null) {
                throw new java.lang.NullPointerException("operationTypes cannot be null");
            }
            if (this.operationTypes == null) this.operationTypes = new java.util.ArrayList<AdminOperationType>();
            this.operationTypes.addAll(operationTypes);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOperationTypes() {
            if (this.operationTypes != null) this.operationTypes.clear();
            return self();
        }

        /**
         * Include events only against the supplied resource.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B resourcePath(final String resourcePath) {
            this.resourcePath = resourcePath;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B resourceType(final AdminResourceType resourceType) {
            if (this.resourceTypes == null) this.resourceTypes = new java.util.ArrayList<AdminResourceType>();
            this.resourceTypes.add(resourceType);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B resourceTypes(final java.util.Collection<? extends AdminResourceType> resourceTypes) {
            if (resourceTypes == null) {
                throw new java.lang.NullPointerException("resourceTypes cannot be null");
            }
            if (this.resourceTypes == null) this.resourceTypes = new java.util.ArrayList<AdminResourceType>();
            this.resourceTypes.addAll(resourceTypes);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearResourceTypes() {
            if (this.resourceTypes != null) this.resourceTypes.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AdminEventRequest.AdminEventRequestBuilder(super=" + super.toString() + ", clientId=" + this.clientId + ", ipAddress=" + this.ipAddress + ", realmId=" + this.realmId + ", userId=" + this.userId + ", dateFrom=" + this.dateFrom + ", dateTo=" + this.dateTo + ", offset$value=" + this.offset$value + ", size$value=" + this.size$value + ", operationTypes=" + this.operationTypes + ", resourcePath=" + this.resourcePath + ", resourceTypes=" + this.resourceTypes + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class AdminEventRequestBuilderImpl extends AdminEventRequest.AdminEventRequestBuilder<AdminEventRequest, AdminEventRequest.AdminEventRequestBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AdminEventRequestBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected AdminEventRequest.AdminEventRequestBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AdminEventRequest build() {
            return new AdminEventRequest(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected AdminEventRequest(final AdminEventRequest.AdminEventRequestBuilder<?, ?> b) {
        super(b);
        this.clientId = b.clientId;
        this.ipAddress = b.ipAddress;
        this.realmId = b.realmId;
        this.userId = b.userId;
        this.dateFrom = b.dateFrom;
        this.dateTo = b.dateTo;
        if (b.offset$set) this.offset = b.offset$value;
         else this.offset = AdminEventRequest.$default$offset();
        if (b.size$set) this.size = b.size$value;
         else this.size = AdminEventRequest.$default$size();
        java.util.List<AdminOperationType> operationTypes;
        switch (b.operationTypes == null ? 0 : b.operationTypes.size()) {
        case 0: 
            operationTypes = java.util.Collections.emptyList();
            break;
        case 1: 
            operationTypes = java.util.Collections.singletonList(b.operationTypes.get(0));
            break;
        default: 
            operationTypes = java.util.Collections.unmodifiableList(new java.util.ArrayList<AdminOperationType>(b.operationTypes));
        }
        this.operationTypes = operationTypes;
        this.resourcePath = b.resourcePath;
        java.util.List<AdminResourceType> resourceTypes;
        switch (b.resourceTypes == null ? 0 : b.resourceTypes.size()) {
        case 0: 
            resourceTypes = java.util.Collections.emptyList();
            break;
        case 1: 
            resourceTypes = java.util.Collections.singletonList(b.resourceTypes.get(0));
            break;
        default: 
            resourceTypes = java.util.Collections.unmodifiableList(new java.util.ArrayList<AdminResourceType>(b.resourceTypes));
        }
        this.resourceTypes = resourceTypes;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static AdminEventRequest.AdminEventRequestBuilder<?, ?> builder() {
        return new AdminEventRequest.AdminEventRequestBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AdminEventRequest.AdminEventRequestBuilder<?, ?> toBuilder() {
        return new AdminEventRequest.AdminEventRequestBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Unique identifier (GUID) of the client that carried out the operation.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getClientId() {
        return this.clientId;
    }

    /**
     * IP address from which the operation was carried out.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getIpAddress() {
        return this.ipAddress;
    }

    /**
     * Unique name of the realm from which the operation was carried out.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRealmId() {
        return this.realmId;
    }

    /**
     * Unique identifier (GUID) of the user who carried out the operation.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUserId() {
        return this.userId;
    }

    /**
     * Earliest date from which to include events (format: yyyy-MM-dd).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDateFrom() {
        return this.dateFrom;
    }

    /**
     * Latest date up to which to include events (format: yyyy-MM-dd).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDateTo() {
        return this.dateTo;
    }

    /**
     * Starting point for the events (for paging).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getOffset() {
        return this.offset;
    }

    /**
     * Maximum number of events to retrieve (per page).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getSize() {
        return this.size;
    }

    /**
     * Include events only with the supplied types of operations.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<AdminOperationType> getOperationTypes() {
        return this.operationTypes;
    }

    /**
     * Include events only against the supplied resource.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getResourcePath() {
        return this.resourcePath;
    }

    /**
     * Include events only against the supplied types of resources.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<AdminResourceType> getResourceTypes() {
        return this.resourceTypes;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AdminEventRequest)) return false;
        final AdminEventRequest other = (AdminEventRequest) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        if (this.getOffset() != other.getOffset()) return false;
        if (this.getSize() != other.getSize()) return false;
        final java.lang.Object this$clientId = this.getClientId();
        final java.lang.Object other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) return false;
        final java.lang.Object this$ipAddress = this.getIpAddress();
        final java.lang.Object other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) return false;
        final java.lang.Object this$realmId = this.getRealmId();
        final java.lang.Object other$realmId = other.getRealmId();
        if (this$realmId == null ? other$realmId != null : !this$realmId.equals(other$realmId)) return false;
        final java.lang.Object this$userId = this.getUserId();
        final java.lang.Object other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) return false;
        final java.lang.Object this$dateFrom = this.getDateFrom();
        final java.lang.Object other$dateFrom = other.getDateFrom();
        if (this$dateFrom == null ? other$dateFrom != null : !this$dateFrom.equals(other$dateFrom)) return false;
        final java.lang.Object this$dateTo = this.getDateTo();
        final java.lang.Object other$dateTo = other.getDateTo();
        if (this$dateTo == null ? other$dateTo != null : !this$dateTo.equals(other$dateTo)) return false;
        final java.lang.Object this$operationTypes = this.getOperationTypes();
        final java.lang.Object other$operationTypes = other.getOperationTypes();
        if (this$operationTypes == null ? other$operationTypes != null : !this$operationTypes.equals(other$operationTypes)) return false;
        final java.lang.Object this$resourcePath = this.getResourcePath();
        final java.lang.Object other$resourcePath = other.getResourcePath();
        if (this$resourcePath == null ? other$resourcePath != null : !this$resourcePath.equals(other$resourcePath)) return false;
        final java.lang.Object this$resourceTypes = this.getResourceTypes();
        final java.lang.Object other$resourceTypes = other.getResourceTypes();
        if (this$resourceTypes == null ? other$resourceTypes != null : !this$resourceTypes.equals(other$resourceTypes)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AdminEventRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result = result * PRIME + this.getOffset();
        result = result * PRIME + this.getSize();
        final java.lang.Object $clientId = this.getClientId();
        result = result * PRIME + ($clientId == null ? 43 : $clientId.hashCode());
        final java.lang.Object $ipAddress = this.getIpAddress();
        result = result * PRIME + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        final java.lang.Object $realmId = this.getRealmId();
        result = result * PRIME + ($realmId == null ? 43 : $realmId.hashCode());
        final java.lang.Object $userId = this.getUserId();
        result = result * PRIME + ($userId == null ? 43 : $userId.hashCode());
        final java.lang.Object $dateFrom = this.getDateFrom();
        result = result * PRIME + ($dateFrom == null ? 43 : $dateFrom.hashCode());
        final java.lang.Object $dateTo = this.getDateTo();
        result = result * PRIME + ($dateTo == null ? 43 : $dateTo.hashCode());
        final java.lang.Object $operationTypes = this.getOperationTypes();
        result = result * PRIME + ($operationTypes == null ? 43 : $operationTypes.hashCode());
        final java.lang.Object $resourcePath = this.getResourcePath();
        result = result * PRIME + ($resourcePath == null ? 43 : $resourcePath.hashCode());
        final java.lang.Object $resourceTypes = this.getResourceTypes();
        result = result * PRIME + ($resourceTypes == null ? 43 : $resourceTypes.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "AdminEventRequest(super=" + super.toString() + ", clientId=" + this.getClientId() + ", ipAddress=" + this.getIpAddress() + ", realmId=" + this.getRealmId() + ", userId=" + this.getUserId() + ", dateFrom=" + this.getDateFrom() + ", dateTo=" + this.getDateTo() + ", offset=" + this.getOffset() + ", size=" + this.getSize() + ", operationTypes=" + this.getOperationTypes() + ", resourcePath=" + this.getResourcePath() + ", resourceTypes=" + this.getResourceTypes() + ")";
    }
}
