// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2023 Atlan Pte. Ltd. */
package com.atlan.model.admin;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.core.AtlanObject;
import com.atlan.serde.StringToSetDeserializer;
import com.atlan.util.JacksonUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.*;
import lombok.*;

@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = ApiToken.ApiTokenBuilderImpl.class)
public class ApiToken extends AtlanObject {
    private static final long serialVersionUID = 2L;
    public static final String API_USERNAME_PREFIX = "service-account-";
    /**
     * Unique identifier (GUID) of the API token.
     */
    String id;
    /**
     * Unique client identifier (GUID) of the API token.
     */
    String clientId;
    /**
     * Human-readable name provided when creating the token.
     */
    String displayName;
    /**
     * Detailed characteristics of the API token.
     */
    ApiTokenAttributes attributes;

    public String getClientId() {
        if (clientId != null) {
            return clientId;
        } else if (attributes != null) {
            return attributes.getClientId();
        }
        return null;
    }

    public String getDisplayName() {
        if (displayName != null) {
            return displayName;
        } else if (attributes != null) {
            return attributes.getDisplayName();
        }
        return null;
    }

    /**
     * Retrieve the username that represents this API token.
     * This name can be used to assign the token as a user to objects that require a user,
     * such as policies.
     *
     * @return a username for this API token
     */
    @JsonIgnore
    public String getApiTokenUsername() {
        return API_USERNAME_PREFIX + getClientId();
    }

    /**
     * Create a new API token that never expires and is not assigned to any personas.
     *
     * @param displayName readable name for the API token
     * @return the API token details
     * @throws AtlanException on any API communication issues
     */
    public static ApiToken create(String displayName) throws AtlanException {
        return create(Atlan.getDefaultClient(), displayName);
    }

    /**
     * Create a new API token that never expires and is not assigned to any personas.
     *
     * @param client connectivity to the Atlan tenant on which to create the new API token
     * @param displayName readable name for the API token
     * @return the API token details
     * @throws AtlanException on any API communication issues
     */
    public static ApiToken create(AtlanClient client, String displayName) throws AtlanException {
        return create(client, displayName, null, null, -1L);
    }

    /**
     * Create a new API token with the provided details.
     *
     * @param displayName readable name for the API token
     * @param description explanation of the API token
     * @param personas unique names (qualifiedNames) of personas that should be linked to the token
     * @param validity time in seconds after which the token should expire (negative numbers are treated as a token should never expire)
     * @return the API token details
     * @throws AtlanException on any API communication issues
     */
    public static ApiToken create(String displayName, String description, Set<String> personas, Long validity) throws AtlanException {
        return create(Atlan.getDefaultClient(), displayName, description, personas, validity);
    }

    /**
     * Create a new API token with the provided details.
     *
     * @param client connectivity to the Atlan tenant on which to create the new API token
     * @param displayName readable name for the API token
     * @param description explanation of the API token
     * @param personas unique names (qualifiedNames) of personas that should be linked to the token
     * @param validity time in seconds after which the token should expire (negative numbers are treated as a token should never expire)
     * @return the API token details
     * @throws AtlanException on any API communication issues
     */
    public static ApiToken create(AtlanClient client, String displayName, String description, Set<String> personas, Long validity) throws AtlanException {
        return client.apiTokens.create(displayName, description, personas, validity);
    }

    /**
     * Retrieves the API token with a name that exactly matches the provided string.
     *
     * @param displayName name (as it appears in the UI) by which to retrieve the API token
     * @return the API token whose name (in the UI) contains the provided string, or null if there is none
     * @throws AtlanException on any error during API invocation
     */
    public static ApiToken retrieveByName(String displayName) throws AtlanException {
        return retrieveByName(Atlan.getDefaultClient(), displayName);
    }

    /**
     * Retrieves the API token with a name that exactly matches the provided string.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the API token
     * @param displayName name (as it appears in the UI) by which to retrieve the API token
     * @return the API token whose name (in the UI) contains the provided string, or null if there is none
     * @throws AtlanException on any error during API invocation
     */
    public static ApiToken retrieveByName(AtlanClient client, String displayName) throws AtlanException {
        return client.apiTokens.get(displayName);
    }

    /**
     * Sends this API token to Atlan to update it in Atlan.
     *
     * @return the updated API token
     * @throws AtlanException on any error during API invocation
     */
    public ApiToken update() throws AtlanException {
        return update(Atlan.getDefaultClient());
    }

    /**
     * Sends this API token to Atlan to update it in Atlan.
     *
     * @param client connectivity to the Atlan tenant on which to update the API token
     * @return the updated API token
     * @throws AtlanException on any error during API invocation
     */
    public ApiToken update(AtlanClient client) throws AtlanException {
        if (this.id == null || this.id.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_TOKEN_ID);
        }
        if (this.displayName == null || this.displayName.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_TOKEN_NAME);
        }
        String description = null;
        Set<String> personas = null;
        if (attributes != null) {
            description = attributes.getDescription();
            if (attributes.getPersonas() != null) {
                personas = new HashSet<>();
                for (ApiTokenPersona persona : attributes.getPersonas()) {
                    personas.add(persona.getPersonaQualifiedName());
                }
            }
        }
        return client.apiTokens.update(this.id, this.displayName, description, personas);
    }

    /**
     * Delete (purge) the API token with the provided GUID.
     *
     * @param guid unique identifier (GUID) of the API token to hard-delete
     * @throws AtlanException on any API communication issues
     */
    public static void delete(String guid) throws AtlanException {
        delete(Atlan.getDefaultClient(), guid);
    }

    /**
     * Delete (purge) the API token with the provided GUID.
     *
     * @param client connectivity to the Atlan tenant from which to remove the API token
     * @param guid unique identifier (GUID) of the API token to hard-delete
     * @throws AtlanException on any API communication issues
     */
    public static void delete(AtlanClient client, String guid) throws AtlanException {
        client.apiTokens.purge(guid);
    }


    @JsonSerialize(using = ApiTokenAttributesSerializer.class)
    @JsonDeserialize(using = ApiTokenAttributesDeserializer.class)
    public static final class ApiTokenAttributes extends AtlanObject {
        private static final long serialVersionUID = 2L;
        /**
         * Time, in seconds, from createdAt after which the token will expire.
         */
        @JsonProperty("access.token.lifespan")
        Long accessTokenLifespan;
        /**
         * The actual API token that can be used as a bearer token.
         */
        final String accessToken;
        /**
         * Unique client identifier (GUID) of the API token.
         */
        String clientId;
        /**
         * Epoch time, in milliseconds, at which the API token was created.
         */
        Long createdAt;
        /**
         * User who created the API token.
         */
        String createdBy;
        /**
         * Explanation of the API token.
         */
        String description;
        /**
         * Human-readable name provided when creating the token.
         */
        String displayName;
        /**
         * Personas associated with the API token.
         */
        @JsonProperty("personaQualifiedName")
        SortedSet<ApiTokenPersona> personas;
        /**
         * This was a possible future placeholder for purposes associated with the token,
         * but no longer exists on payloads. It is left here purely for any existing code
         * that may have referenced it, but should be removed from that code as it will be
         * removed in the next major release from this object.
         */
        @JsonIgnore
        @Deprecated
        String purposes;
        /**
         * Detailed permissions given to the API token.
         */
        SortedSet<String> workspacePermissions;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        ApiTokenAttributes(final Long accessTokenLifespan, final String accessToken, final String clientId, final Long createdAt, final String createdBy, final String description, final String displayName, final SortedSet<ApiTokenPersona> personas, final String purposes, final SortedSet<String> workspacePermissions) {
            this.accessTokenLifespan = accessTokenLifespan;
            this.accessToken = accessToken;
            this.clientId = clientId;
            this.createdAt = createdAt;
            this.createdBy = createdBy;
            this.description = description;
            this.displayName = displayName;
            this.personas = personas;
            this.purposes = purposes;
            this.workspacePermissions = workspacePermissions;
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static class ApiTokenAttributesBuilder {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Long accessTokenLifespan;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String accessToken;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String clientId;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Long createdAt;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String createdBy;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String description;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String displayName;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private java.util.ArrayList<ApiTokenPersona> personas;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String purposes;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private java.util.ArrayList<String> workspacePermissions;

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            ApiTokenAttributesBuilder() {
            }

            /**
             * Time, in seconds, from createdAt after which the token will expire.
             * @return {@code this}.
             */
            @JsonProperty("access.token.lifespan")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ApiToken.ApiTokenAttributes.ApiTokenAttributesBuilder accessTokenLifespan(final Long accessTokenLifespan) {
                this.accessTokenLifespan = accessTokenLifespan;
                return this;
            }

            /**
             * The actual API token that can be used as a bearer token.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ApiToken.ApiTokenAttributes.ApiTokenAttributesBuilder accessToken(final String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            /**
             * Unique client identifier (GUID) of the API token.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ApiToken.ApiTokenAttributes.ApiTokenAttributesBuilder clientId(final String clientId) {
                this.clientId = clientId;
                return this;
            }

            /**
             * Epoch time, in milliseconds, at which the API token was created.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ApiToken.ApiTokenAttributes.ApiTokenAttributesBuilder createdAt(final Long createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            /**
             * User who created the API token.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ApiToken.ApiTokenAttributes.ApiTokenAttributesBuilder createdBy(final String createdBy) {
                this.createdBy = createdBy;
                return this;
            }

            /**
             * Explanation of the API token.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ApiToken.ApiTokenAttributes.ApiTokenAttributesBuilder description(final String description) {
                this.description = description;
                return this;
            }

            /**
             * Human-readable name provided when creating the token.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ApiToken.ApiTokenAttributes.ApiTokenAttributesBuilder displayName(final String displayName) {
                this.displayName = displayName;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ApiToken.ApiTokenAttributes.ApiTokenAttributesBuilder persona(final ApiTokenPersona persona) {
                if (this.personas == null) this.personas = new java.util.ArrayList<ApiTokenPersona>();
                this.personas.add(persona);
                return this;
            }

            @JsonProperty("personaQualifiedName")
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ApiToken.ApiTokenAttributes.ApiTokenAttributesBuilder personas(final java.util.Collection<? extends ApiTokenPersona> personas) {
                if (personas == null) {
                    throw new java.lang.NullPointerException("personas cannot be null");
                }
                if (this.personas == null) this.personas = new java.util.ArrayList<ApiTokenPersona>();
                this.personas.addAll(personas);
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ApiToken.ApiTokenAttributes.ApiTokenAttributesBuilder clearPersonas() {
                if (this.personas != null) this.personas.clear();
                return this;
            }

            /**
             * This was a possible future placeholder for purposes associated with the token,
             * but no longer exists on payloads. It is left here purely for any existing code
             * that may have referenced it, but should be removed from that code as it will be
             * removed in the next major release from this object.
             * @return {@code this}.
             */
            @java.lang.Deprecated
            @JsonIgnore
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ApiToken.ApiTokenAttributes.ApiTokenAttributesBuilder purposes(final String purposes) {
                this.purposes = purposes;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ApiToken.ApiTokenAttributes.ApiTokenAttributesBuilder workspacePermission(final String workspacePermission) {
                if (this.workspacePermissions == null) this.workspacePermissions = new java.util.ArrayList<String>();
                this.workspacePermissions.add(workspacePermission);
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ApiToken.ApiTokenAttributes.ApiTokenAttributesBuilder workspacePermissions(final java.util.Collection<? extends String> workspacePermissions) {
                if (workspacePermissions == null) {
                    throw new java.lang.NullPointerException("workspacePermissions cannot be null");
                }
                if (this.workspacePermissions == null) this.workspacePermissions = new java.util.ArrayList<String>();
                this.workspacePermissions.addAll(workspacePermissions);
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ApiToken.ApiTokenAttributes.ApiTokenAttributesBuilder clearWorkspacePermissions() {
                if (this.workspacePermissions != null) this.workspacePermissions.clear();
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ApiToken.ApiTokenAttributes build() {
                java.util.SortedSet<ApiTokenPersona> personas = new java.util.TreeSet<ApiTokenPersona>();
                if (this.personas != null) personas.addAll(this.personas);
                personas = java.util.Collections.unmodifiableSortedSet(personas);
                java.util.SortedSet<String> workspacePermissions = new java.util.TreeSet<String>();
                if (this.workspacePermissions != null) workspacePermissions.addAll(this.workspacePermissions);
                workspacePermissions = java.util.Collections.unmodifiableSortedSet(workspacePermissions);
                return new ApiToken.ApiTokenAttributes(this.accessTokenLifespan, this.accessToken, this.clientId, this.createdAt, this.createdBy, this.description, this.displayName, personas, this.purposes, workspacePermissions);
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public java.lang.String toString() {
                return "ApiToken.ApiTokenAttributes.ApiTokenAttributesBuilder(accessTokenLifespan=" + this.accessTokenLifespan + ", accessToken=" + this.accessToken + ", clientId=" + this.clientId + ", createdAt=" + this.createdAt + ", createdBy=" + this.createdBy + ", description=" + this.description + ", displayName=" + this.displayName + ", personas=" + this.personas + ", purposes=" + this.purposes + ", workspacePermissions=" + this.workspacePermissions + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static ApiToken.ApiTokenAttributes.ApiTokenAttributesBuilder builder() {
            return new ApiToken.ApiTokenAttributes.ApiTokenAttributesBuilder();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ApiToken.ApiTokenAttributes.ApiTokenAttributesBuilder toBuilder() {
            final ApiToken.ApiTokenAttributes.ApiTokenAttributesBuilder builder = new ApiToken.ApiTokenAttributes.ApiTokenAttributesBuilder().accessTokenLifespan(this.accessTokenLifespan).accessToken(this.accessToken).clientId(this.clientId).createdAt(this.createdAt).createdBy(this.createdBy).description(this.description).displayName(this.displayName).purposes(this.purposes);
            if (this.personas != null) builder.personas(this.personas);
            if (this.workspacePermissions != null) builder.workspacePermissions(this.workspacePermissions);
            return builder;
        }

        /**
         * Time, in seconds, from createdAt after which the token will expire.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Long getAccessTokenLifespan() {
            return this.accessTokenLifespan;
        }

        /**
         * The actual API token that can be used as a bearer token.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getAccessToken() {
            return this.accessToken;
        }

        /**
         * Unique client identifier (GUID) of the API token.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getClientId() {
            return this.clientId;
        }

        /**
         * Epoch time, in milliseconds, at which the API token was created.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Long getCreatedAt() {
            return this.createdAt;
        }

        /**
         * User who created the API token.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getCreatedBy() {
            return this.createdBy;
        }

        /**
         * Explanation of the API token.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getDescription() {
            return this.description;
        }

        /**
         * Human-readable name provided when creating the token.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getDisplayName() {
            return this.displayName;
        }

        /**
         * Personas associated with the API token.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SortedSet<ApiTokenPersona> getPersonas() {
            return this.personas;
        }

        /**
         * This was a possible future placeholder for purposes associated with the token,
         * but no longer exists on payloads. It is left here purely for any existing code
         * that may have referenced it, but should be removed from that code as it will be
         * removed in the next major release from this object.
         */
        @java.lang.Deprecated
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getPurposes() {
            return this.purposes;
        }

        /**
         * Detailed permissions given to the API token.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SortedSet<String> getWorkspacePermissions() {
            return this.workspacePermissions;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof ApiToken.ApiTokenAttributes)) return false;
            final ApiToken.ApiTokenAttributes other = (ApiToken.ApiTokenAttributes) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            if (!super.equals(o)) return false;
            final java.lang.Object this$accessTokenLifespan = this.getAccessTokenLifespan();
            final java.lang.Object other$accessTokenLifespan = other.getAccessTokenLifespan();
            if (this$accessTokenLifespan == null ? other$accessTokenLifespan != null : !this$accessTokenLifespan.equals(other$accessTokenLifespan)) return false;
            final java.lang.Object this$createdAt = this.getCreatedAt();
            final java.lang.Object other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !this$createdAt.equals(other$createdAt)) return false;
            final java.lang.Object this$accessToken = this.getAccessToken();
            final java.lang.Object other$accessToken = other.getAccessToken();
            if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) return false;
            final java.lang.Object this$clientId = this.getClientId();
            final java.lang.Object other$clientId = other.getClientId();
            if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) return false;
            final java.lang.Object this$createdBy = this.getCreatedBy();
            final java.lang.Object other$createdBy = other.getCreatedBy();
            if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) return false;
            final java.lang.Object this$description = this.getDescription();
            final java.lang.Object other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
            final java.lang.Object this$displayName = this.getDisplayName();
            final java.lang.Object other$displayName = other.getDisplayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) return false;
            final java.lang.Object this$personas = this.getPersonas();
            final java.lang.Object other$personas = other.getPersonas();
            if (this$personas == null ? other$personas != null : !this$personas.equals(other$personas)) return false;
            final java.lang.Object this$purposes = this.getPurposes();
            final java.lang.Object other$purposes = other.getPurposes();
            if (this$purposes == null ? other$purposes != null : !this$purposes.equals(other$purposes)) return false;
            final java.lang.Object this$workspacePermissions = this.getWorkspacePermissions();
            final java.lang.Object other$workspacePermissions = other.getWorkspacePermissions();
            if (this$workspacePermissions == null ? other$workspacePermissions != null : !this$workspacePermissions.equals(other$workspacePermissions)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof ApiToken.ApiTokenAttributes;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = super.hashCode();
            final java.lang.Object $accessTokenLifespan = this.getAccessTokenLifespan();
            result = result * PRIME + ($accessTokenLifespan == null ? 43 : $accessTokenLifespan.hashCode());
            final java.lang.Object $createdAt = this.getCreatedAt();
            result = result * PRIME + ($createdAt == null ? 43 : $createdAt.hashCode());
            final java.lang.Object $accessToken = this.getAccessToken();
            result = result * PRIME + ($accessToken == null ? 43 : $accessToken.hashCode());
            final java.lang.Object $clientId = this.getClientId();
            result = result * PRIME + ($clientId == null ? 43 : $clientId.hashCode());
            final java.lang.Object $createdBy = this.getCreatedBy();
            result = result * PRIME + ($createdBy == null ? 43 : $createdBy.hashCode());
            final java.lang.Object $description = this.getDescription();
            result = result * PRIME + ($description == null ? 43 : $description.hashCode());
            final java.lang.Object $displayName = this.getDisplayName();
            result = result * PRIME + ($displayName == null ? 43 : $displayName.hashCode());
            final java.lang.Object $personas = this.getPersonas();
            result = result * PRIME + ($personas == null ? 43 : $personas.hashCode());
            final java.lang.Object $purposes = this.getPurposes();
            result = result * PRIME + ($purposes == null ? 43 : $purposes.hashCode());
            final java.lang.Object $workspacePermissions = this.getWorkspacePermissions();
            result = result * PRIME + ($workspacePermissions == null ? 43 : $workspacePermissions.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ApiToken.ApiTokenAttributes(super=" + super.toString() + ", accessTokenLifespan=" + this.getAccessTokenLifespan() + ", accessToken=" + this.getAccessToken() + ", clientId=" + this.getClientId() + ", createdAt=" + this.getCreatedAt() + ", createdBy=" + this.getCreatedBy() + ", description=" + this.getDescription() + ", displayName=" + this.getDisplayName() + ", personas=" + this.getPersonas() + ", purposes=" + this.getPurposes() + ", workspacePermissions=" + this.getWorkspacePermissions() + ")";
        }
    }


    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = ApiToken.ApiTokenPersona.ApiTokenPersonaBuilder.class)
    public static final class ApiTokenPersona extends AtlanObject implements Comparable<ApiTokenPersona> {
        private static final long serialVersionUID = 2L;
        private static final Comparator<String> stringComparator = Comparator.nullsFirst(String::compareTo);
        private static final Comparator<ApiTokenPersona> personaComparator = Comparator.comparing(ApiTokenPersona::getId, stringComparator).thenComparing(ApiTokenPersona::getPersona, stringComparator).thenComparing(ApiTokenPersona::getPersonaQualifiedName, stringComparator);
        /**
         * Unique identifier (GUID) of the linked persona.
         */
        String id;
        /**
         * Unique name of the linked persona.
         */
        String persona;
        /**
         * Unique name (qualifiedName) of the linked persona.
         */
        String personaQualifiedName;

        public static ApiTokenPersona of(String id, String persona, String personaQualifiedName) {
            return ApiTokenPersona.builder().id(id).persona(persona).personaQualifiedName(personaQualifiedName).build();
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int compareTo(ApiTokenPersona o) {
            return personaComparator.compare(this, o);
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        ApiTokenPersona(final String id, final String persona, final String personaQualifiedName) {
            this.id = id;
            this.persona = persona;
            this.personaQualifiedName = personaQualifiedName;
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
        public static class ApiTokenPersonaBuilder {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String id;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String persona;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String personaQualifiedName;

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            ApiTokenPersonaBuilder() {
            }

            /**
             * Unique identifier (GUID) of the linked persona.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ApiToken.ApiTokenPersona.ApiTokenPersonaBuilder id(final String id) {
                this.id = id;
                return this;
            }

            /**
             * Unique name of the linked persona.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ApiToken.ApiTokenPersona.ApiTokenPersonaBuilder persona(final String persona) {
                this.persona = persona;
                return this;
            }

            /**
             * Unique name (qualifiedName) of the linked persona.
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ApiToken.ApiTokenPersona.ApiTokenPersonaBuilder personaQualifiedName(final String personaQualifiedName) {
                this.personaQualifiedName = personaQualifiedName;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ApiToken.ApiTokenPersona build() {
                return new ApiToken.ApiTokenPersona(this.id, this.persona, this.personaQualifiedName);
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public java.lang.String toString() {
                return "ApiToken.ApiTokenPersona.ApiTokenPersonaBuilder(id=" + this.id + ", persona=" + this.persona + ", personaQualifiedName=" + this.personaQualifiedName + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static ApiToken.ApiTokenPersona.ApiTokenPersonaBuilder builder() {
            return new ApiToken.ApiTokenPersona.ApiTokenPersonaBuilder();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ApiToken.ApiTokenPersona.ApiTokenPersonaBuilder toBuilder() {
            return new ApiToken.ApiTokenPersona.ApiTokenPersonaBuilder().id(this.id).persona(this.persona).personaQualifiedName(this.personaQualifiedName);
        }

        /**
         * Unique identifier (GUID) of the linked persona.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getId() {
            return this.id;
        }

        /**
         * Unique name of the linked persona.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getPersona() {
            return this.persona;
        }

        /**
         * Unique name (qualifiedName) of the linked persona.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getPersonaQualifiedName() {
            return this.personaQualifiedName;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof ApiToken.ApiTokenPersona)) return false;
            final ApiToken.ApiTokenPersona other = (ApiToken.ApiTokenPersona) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            if (!super.equals(o)) return false;
            final java.lang.Object this$id = this.getId();
            final java.lang.Object other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
            final java.lang.Object this$persona = this.getPersona();
            final java.lang.Object other$persona = other.getPersona();
            if (this$persona == null ? other$persona != null : !this$persona.equals(other$persona)) return false;
            final java.lang.Object this$personaQualifiedName = this.getPersonaQualifiedName();
            final java.lang.Object other$personaQualifiedName = other.getPersonaQualifiedName();
            if (this$personaQualifiedName == null ? other$personaQualifiedName != null : !this$personaQualifiedName.equals(other$personaQualifiedName)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof ApiToken.ApiTokenPersona;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = super.hashCode();
            final java.lang.Object $id = this.getId();
            result = result * PRIME + ($id == null ? 43 : $id.hashCode());
            final java.lang.Object $persona = this.getPersona();
            result = result * PRIME + ($persona == null ? 43 : $persona.hashCode());
            final java.lang.Object $personaQualifiedName = this.getPersonaQualifiedName();
            result = result * PRIME + ($personaQualifiedName == null ? 43 : $personaQualifiedName.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ApiToken.ApiTokenPersona(super=" + super.toString() + ", id=" + this.getId() + ", persona=" + this.getPersona() + ", personaQualifiedName=" + this.getPersonaQualifiedName() + ")";
        }
    }


    /**
     * Custom serialization of {@link ApiTokenAttributes} objects.
     * In particular, this translates string-based numeric values into strings.
     */
    static class ApiTokenAttributesSerializer extends StdSerializer<ApiTokenAttributes> {
        private static final long serialVersionUID = 2L;

        public ApiTokenAttributesSerializer() {
            this(null);
        }

        public ApiTokenAttributesSerializer(Class<ApiTokenAttributes> t) {
            super(t);
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public void serializeWithType(ApiTokenAttributes value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            serialize(value, gen, serializers);
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public void serialize(ApiTokenAttributes ata, JsonGenerator gen, SerializerProvider sp) throws IOException, JsonProcessingException {
            gen.writeStartObject();
            JacksonUtils.serializeString(gen, "access.token.lifespan", "" + ata.getAccessTokenLifespan());
            JacksonUtils.serializeString(gen, "accessToken", ata.getAccessToken());
            JacksonUtils.serializeString(gen, "clientId", ata.getClientId());
            JacksonUtils.serializeString(gen, "createdAt", "" + ata.getCreatedAt());
            JacksonUtils.serializeString(gen, "createdBy", ata.getCreatedBy());
            JacksonUtils.serializeString(gen, "description", ata.getDescription());
            JacksonUtils.serializeString(gen, "displayName", ata.getDisplayName());
            JacksonUtils.serializeObject(gen, "personaQualifiedName", ata.getPersonas());
            JacksonUtils.serializeObject(gen, "workspacePermissions", ata.getWorkspacePermissions());
            gen.writeEndObject();
        }
    }


    /**
     * Custom deserialization of {@link ApiTokenAttributes} objects.
     * In particular, this translates from endpoints that represent lists as strings as well as those
     * that represent lists as actual lists.
     */
    static class ApiTokenAttributesDeserializer extends StdDeserializer<ApiTokenAttributes> {
        private static final long serialVersionUID = 2L;
        private final AtlanClient client;

        public ApiTokenAttributesDeserializer(AtlanClient client) {
            super(ApiToken.class);
            this.client = client;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public Object deserializeWithType(JsonParser parser, DeserializationContext context, TypeDeserializer typeDeserializer) throws IOException {
            return deserialize(parser, context);
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public ApiTokenAttributes deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            JsonNode root = parser.getCodec().readTree(parser);
            Set<ApiTokenPersona> personas = new TreeSet<>();
            JsonNode personasJson = root.get("personaQualifiedName");
            if (personasJson.isTextual()) {
                Set<String> personaNames = StringToSetDeserializer.deserialize(client, personasJson.asText());
                for (String name : personaNames) {
                    personas.add(ApiTokenPersona.of(null, name, null));
                }
            } else if (personasJson.isArray()) {
                personas = JacksonUtils.deserializeObject(client, root, "personaQualifiedName", new TypeReference<>() {
                });
            }
            Set<String> workspacePermissions = new TreeSet<>();
            JsonNode workspacePermissionsJson = root.get("workspacePermissions");
            if (workspacePermissionsJson.isTextual()) {
                workspacePermissions = StringToSetDeserializer.deserialize(client, workspacePermissionsJson.asText());
            } else if (workspacePermissionsJson.isArray()) {
                workspacePermissions = JacksonUtils.deserializeObject(client, root, "workspacePermissions", new TypeReference<>() {
                });
            }
            ApiTokenAttributes result = ApiTokenAttributes.builder().accessTokenLifespan(JacksonUtils.deserializeLong(root, "access.token.lifespan")).accessToken(JacksonUtils.deserializeString(root, "accessToken")).clientId(JacksonUtils.deserializeString(root, "clientId")).createdAt(JacksonUtils.deserializeLong(root, "createdAt")).createdBy(JacksonUtils.deserializeString(root, "createdBy")).description(JacksonUtils.deserializeString(root, "description")).displayName(JacksonUtils.deserializeString(root, "displayName")).personas(personas).workspacePermissions(workspacePermissions).build();
            result.setRawJsonObject(root);
            return result;
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class ApiTokenBuilder<C extends ApiToken, B extends ApiToken.ApiTokenBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String id;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String clientId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String displayName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ApiTokenAttributes attributes;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            ApiToken.ApiTokenBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final ApiToken instance, final ApiToken.ApiTokenBuilder<?, ?> b) {
            b.id(instance.id);
            b.clientId(instance.clientId);
            b.displayName(instance.displayName);
            b.attributes(instance.attributes);
        }

        /**
         * Unique identifier (GUID) of the API token.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B id(final String id) {
            this.id = id;
            return self();
        }

        /**
         * Unique client identifier (GUID) of the API token.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clientId(final String clientId) {
            this.clientId = clientId;
            return self();
        }

        /**
         * Human-readable name provided when creating the token.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B displayName(final String displayName) {
            this.displayName = displayName;
            return self();
        }

        /**
         * Detailed characteristics of the API token.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B attributes(final ApiTokenAttributes attributes) {
            this.attributes = attributes;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ApiToken.ApiTokenBuilder(super=" + super.toString() + ", id=" + this.id + ", clientId=" + this.clientId + ", displayName=" + this.displayName + ", attributes=" + this.attributes + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    static final class ApiTokenBuilderImpl extends ApiToken.ApiTokenBuilder<ApiToken, ApiToken.ApiTokenBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ApiTokenBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected ApiToken.ApiTokenBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ApiToken build() {
            return new ApiToken(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected ApiToken(final ApiToken.ApiTokenBuilder<?, ?> b) {
        super(b);
        this.id = b.id;
        this.clientId = b.clientId;
        this.displayName = b.displayName;
        this.attributes = b.attributes;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static ApiToken.ApiTokenBuilder<?, ?> builder() {
        return new ApiToken.ApiTokenBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ApiToken.ApiTokenBuilder<?, ?> toBuilder() {
        return new ApiToken.ApiTokenBuilderImpl().$fillValuesFrom(this);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ApiToken)) return false;
        final ApiToken other = (ApiToken) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$id = this.getId();
        final java.lang.Object other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
        final java.lang.Object this$clientId = this.getClientId();
        final java.lang.Object other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) return false;
        final java.lang.Object this$displayName = this.getDisplayName();
        final java.lang.Object other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) return false;
        final java.lang.Object this$attributes = this.getAttributes();
        final java.lang.Object other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !this$attributes.equals(other$attributes)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ApiToken;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $id = this.getId();
        result = result * PRIME + ($id == null ? 43 : $id.hashCode());
        final java.lang.Object $clientId = this.getClientId();
        result = result * PRIME + ($clientId == null ? 43 : $clientId.hashCode());
        final java.lang.Object $displayName = this.getDisplayName();
        result = result * PRIME + ($displayName == null ? 43 : $displayName.hashCode());
        final java.lang.Object $attributes = this.getAttributes();
        result = result * PRIME + ($attributes == null ? 43 : $attributes.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ApiToken(super=" + super.toString() + ", id=" + this.getId() + ", clientId=" + this.getClientId() + ", displayName=" + this.getDisplayName() + ", attributes=" + this.getAttributes() + ")";
    }

    /**
     * Unique identifier (GUID) of the API token.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getId() {
        return this.id;
    }

    /**
     * Detailed characteristics of the API token.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ApiTokenAttributes getAttributes() {
        return this.attributes;
    }
}
